/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcNativeProperties;
import com.adventnet.sym.adsm.common.server.layout.FcSharedMailboxMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcManager;
import com.adventnet.sym.adsm.common.server.metrack.METrackerUtil;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtListener;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class FcSharedMailboxCreationListener
extends FcADMgmtListener {
    String userName = null;
    String ouName = null;
    ArrayList groupList = null;
    Hashtable auditLogProps = new Hashtable();
    Properties nativeStatusProps = new Properties();
    String upn = "";
    String distinguishedName = "";
    String searchString = "";
    String archiveDB = null;
    String archiveDomain = null;
    ArrayList<Hashtable> customList;
    String customScriptResult = "";
    boolean isAutomapping = false;

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.creationId = creationId;
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.customScriptResult = "";
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.createSharedMailbox();
    }

    public void createSharedMailbox() {
        try {
            Properties customScriptProps;
            mgmtLog.log(Level.INFO, " Fc Shared Mailbox creation Started ");
            FcSharedMailboxMgmtHandler.getInstance().updateFieldsTableName(this.fromClientData);
            FcSharedMailboxMgmtHandler.getInstance().initDataObjForFieldsToAttributes();
            FcSharedMailboxMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
            FcSharedMailboxMgmtHandler.getInstance().updateFieldsActionId(this.fromClientData);
            FcSharedMailboxMgmtHandler.getInstance().updateDefaultComponentId(this.fromClientData);
            FcSharedMailboxMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
            FcNativeProperties fcNativeProperties = this.fcNativeProperties;
            this.customList = this.updateCustomAttributeProperties(this.fromClientData);
            this.addAttributeToNativeProps(this.fromClientData, fcNativeProperties);
            Properties props = fcNativeProperties.getProps();
            this.userName = props.getProperty("userName");
            this.ouName = props.getProperty("OUName");
            if (!HelpdeskUtil.isAuthorizedOU((String)this.domainName, (Long)this.loginId, (String)this.ouName)) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), this.ouName));
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), this.ouName));
                return;
            }
            this.groupList = fcNativeProperties.getGroupList();
            String escapedUserName = CommonUtil.escapeString((String)this.userName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
            String mailBoxStore = null;
            String mailBoxServer = null;
            String mailAlias = null;
            Integer exchVersion = 0;
            Properties exchangeServerDetails = new Properties();
            ArrayList nonExchPropList = new ArrayList();
            ArrayList mailBoxRights = new ArrayList();
            if (props.get("mailAlias") != null) {
                mailAlias = props.getProperty("mailAlias");
            }
            if (props.get("upn") != null) {
                this.upn = props.getProperty("upn");
            }
            if (props.get("homeMDB") != null) {
                mailBoxStore = props.getProperty("homeMDB");
            }
            if (props.get("msExchHomeServerName") != null) {
                mailBoxServer = props.getProperty("msExchHomeServerName");
            }
            if (props.get("fullPermission") != null) {
                mailBoxRights = this.setFullPermissionToNative((ArrayList)props.get("fullPermission"), true);
            }
            if ((Properties)this.permissionProps.get("mailBox") != null && ((Properties)this.permissionProps.get("mailBox")).get("folderPermissions") != null) {
                ArrayList permissionPropsList = (ArrayList)((Properties)this.permissionProps.get("mailBox")).get("folderPermissions");
                for (Properties permissionProp : permissionPropsList) {
                    Properties prop = new Properties();
                    String dn = permissionProp.get("DN").toString();
                    prop.put("DN", UserHandler.getSIDFromDN((String)dn, (String)this.domainName));
                    prop.put("ACCESS_MASK", (Object)Long.parseLong(permissionProp.get("ACCESS_MASK").toString()));
                    prop.put("INHERIT_TYPE_FLAG", (Object)0L);
                    prop.put("ACE_TYPE", (Object)Long.parseLong(permissionProp.get("ACE_TYPE").toString()));
                    mailBoxRights.add(prop);
                }
            }
            if (props.get("msExchArchiveDatabaseLink") != null) {
                this.archiveDB = props.getProperty("msExchArchiveDatabaseLink");
            }
            if (props.get("msExchArchiveAddress") != null) {
                this.archiveDomain = props.getProperty("msExchArchiveAddress");
            }
            if (props.get("autoMapping") != null) {
                this.isAutomapping = Boolean.parseBoolean(props.getProperty("autoMapping"));
            }
            mgmtLog.log(Level.INFO, " Shared Mailbox Creation : domainName " + this.domainName);
            mgmtLog.log(Level.INFO, " LoginId  " + this.loginId);
            mgmtLog.log(Level.INFO, " OU Name :" + this.ouName);
            mgmtLog.log(Level.INFO, " User Name :" + this.userName);
            mgmtLog.log(Level.INFO, " getPropsList " + fcNativeProperties.getPropList());
            mgmtLog.log(Level.INFO, " nonExchPropList " + nonExchPropList);
            mgmtLog.log(Level.INFO, " modifyList " + fcNativeProperties.getModifyList());
            mgmtLog.log(Level.INFO, " GroupsList " + this.groupList);
            mgmtLog.log(Level.INFO, " customList " + this.customList);
            mgmtLog.log(Level.INFO, " UM Policy Details" + (Properties)props.get("msExchUMMailBoxPolicy"));
            mgmtLog.log(Level.INFO, " Retention Policy Details" + props.get("msExchMailboxTemplateLink"));
            mgmtLog.log(Level.INFO, " CustomScriptDetails: " + (Properties)props.get("customScriptDetails"));
            mgmtLog.log(Level.INFO, " msExchArchiveDatabaseLink " + this.archiveDB);
            mgmtLog.log(Level.INFO, " msExchArchiveAddress " + this.archiveDomain);
            mgmtLog.log(Level.INFO, " mailBoxRights " + mailBoxRights);
            mgmtLog.log(Level.INFO, " Auto-Mapping FullAccess" + this.isAutomapping);
            this.auditLogProps.put("domainName", this.domainName);
            this.auditLogProps.put("userName", this.userName);
            this.auditLogProps.put("propList", fcNativeProperties.getPropList());
            this.auditLogProps.put("modifyList", fcNativeProperties.getModifyList());
            this.auditLogProps.put("nonExchPropList", nonExchPropList);
            this.auditLogProps.put("groupList", this.groupList);
            this.auditLogProps.put("mailBoxRights", mailBoxRights);
            this.auditLogProps.put("customList", this.customList);
            this.auditLogProps.put("Auto-Mapping FullAccess", this.isAutomapping);
            if (props.get("msExchUMMailBoxPolicy") != null) {
                this.auditLogProps.put("UM Policy Details", (Properties)props.get("msExchUMMailBoxPolicy"));
            }
            if (props.get("msExchMailboxTemplateLink") != null) {
                this.auditLogProps.put("Retention Policy Details", props.get("msExchMailboxTemplateLink"));
            }
            if (props.get("customScriptDetails") != null) {
                this.auditLogProps.put("CustomScriptDetails", (Properties)props.get("customScriptDetails"));
            }
            String info = new String();
            if (this.isADSelected) {
                exchVersion = ExchangeUtil.getExchangeServerType((String)mailBoxServer);
                exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)mailBoxServer);
                this.upn = props.getProperty("mailAttribtueValue");
                info = ADHandler.createSharedMailBox((String)this.domainName, (long)this.loginId, (String)this.userName, (String)this.upn, (String)this.ouName, (String)mailAlias, (String)mailBoxStore, (Properties)exchangeServerDetails, (ArrayList)mailBoxRights, (boolean)this.isAutomapping);
            }
            if (!this.isADSelected) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "NO_AD");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", "");
                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
            } else if (info.length() != 0) {
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.shared_mailbox_error"), this.rb.getString(info)));
                hash.put("NATIVE_ERROR_MESSAGE", "");
                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", "");
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            } else {
                MgmtUtil.updateMailServer(fcNativeProperties.getPropList(), exchangeServerDetails);
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.reports.common.status_msg.successfully_created"));
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                this.searchString = "(&(objectClass=user)(objectCategory=user)(name=" + this.userName + "))";
                NativeError exchPropError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)this.searchString, null, null, (ArrayList)fcNativeProperties.getPropList(), new ArrayList(), new ArrayList(), new ArrayList(), (ArrayList)this.groupList, (boolean)false);
                this.nativeStatusProps = this.getSingleSMErrorMessage(exchPropError);
            }
            String CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!(CREATION_STATUS.equalsIgnoreCase("SEVERE") || CREATION_STATUS.equalsIgnoreCase("NO_AD") || this.customList.isEmpty())) {
                NativeError customError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)this.searchString, null, null, this.customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                if (!this.isBulkMgmt) {
                    AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)this.searchString);
                } else {
                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)this.searchString);
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !CREATION_STATUS.equalsIgnoreCase("NO_AD")) {
                String exchangeServerName;
                String hideFromAddrListErr;
                this.distinguishedName = "CN=" + escapedUserName + "," + this.ouName;
                if (props.get("sendAs") != null) {
                    Hashtable sendAsResultHash = new Hashtable();
                    String sendAsErrorMsg = "";
                    ArrayList sendAsSidList = (ArrayList)props.get("sendAs");
                    sendAsResultHash = this.updateSendAsAttribute(sendAsSidList, this.distinguishedName, "add");
                    sendAsErrorMsg = this.getErrorStringForSendAs(sendAsResultHash, sendAsErrorMsg);
                    if (sendAsErrorMsg.trim().length() > 0) {
                        this.setSingleUserErrorMessage(sendAsErrorMsg);
                    }
                }
                if (props.get("msExchHideFromAddressLists") != null && props.getProperty("msExchHideFromAddressLists").equalsIgnoreCase("true") && (hideFromAddrListErr = ADHandler.setExchangeAttribute((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)"mailBox", (String)"true", (Properties)exchangeServerDetails)).trim().length() > 0) {
                    ArrayList messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
                    if (messageList == null) {
                        messageList = new ArrayList();
                    }
                    Hashtable<String, String> errorHash = new Hashtable<String, String>();
                    errorHash.put("ERROR_MESSAGE", hideFromAddrListErr);
                    messageList.add(errorHash);
                    this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
                    this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                }
                if (props.get("msExchUMMailBoxPolicy") != null) {
                    int index;
                    Properties umPolicyDetails = (Properties)props.get("msExchUMMailBoxPolicy");
                    mgmtLog.log(Level.INFO, " umPolicyDetails " + umPolicyDetails);
                    if (mailBoxServer != null && (index = mailBoxServer.lastIndexOf("cn=")) != -1 && mailBoxServer.trim().length() > index + 3) {
                        exchangeServerName = mailBoxServer.substring(index + 3);
                        String umPolicyResult = ADHandler.enableUMMailbox((String)this.domainName, (long)this.loginId, (String)exchangeServerName, (String)this.distinguishedName, (String)((String)umPolicyDetails.get("policyName")), (String)((String)umPolicyDetails.get("extension")), (String)((String)umPolicyDetails.get("pin")), (String)((String)umPolicyDetails.get("resetPin")), (String)((String)umPolicyDetails.get("SIPResourceIdentifier")), (Properties)exchangeServerDetails);
                        if (umPolicyResult.trim().length() > 0) {
                            if (!this.isBulkMgmt) {
                                this.setSingleUserErrorMessage(umPolicyResult);
                            } else {
                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString(umPolicyResult));
                            }
                        }
                    }
                }
                if (!(this.archiveDB == null || this.archiveDomain == null || this.archiveDB.equals("") && this.archiveDomain.equals(""))) {
                    if (exchVersion >= 2010) {
                        boolean isRemote = false;
                        if (!this.archiveDomain.equals("")) {
                            isRemote = true;
                        }
                        String msg = "";
                        msg = ADHandler.enableArchiveMailbox((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)this.archiveDB, (String)this.archiveDomain, (Properties)exchangeServerDetails, (boolean)isRemote);
                        if (msg.trim().length() > 0) {
                            if (!this.isBulkMgmt) {
                                this.rusMessage = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString(msg)) + this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot");
                            } else {
                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString(msg)));
                            }
                        }
                    } else {
                        this.rusMessage = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString("")) + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_archive_mail"), this.rb.getString(mailBoxStore)) + this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot");
                    }
                }
                if (props.get("msExchMailboxTemplateLink") != null) {
                    int index;
                    String retentionPolicy = props.getProperty("msExchMailboxTemplateLink");
                    if (mailBoxServer != null && (index = mailBoxServer.lastIndexOf("cn=")) != -1 && mailBoxServer.trim().length() > index + 3) {
                        exchangeServerName = mailBoxServer.substring(index + 3);
                        String retentionPolicyResult = ADHandler.applyRetentionPolicy((String)this.domainName, (long)this.loginId, (String)exchangeServerName, (String)this.distinguishedName, (String)retentionPolicy, (Properties)exchangeServerDetails);
                        if (retentionPolicyResult.trim().length() > 0) {
                            if (!this.isBulkMgmt) {
                                this.setSingleUserErrorMessage(retentionPolicyResult);
                            } else {
                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString(retentionPolicyResult));
                            }
                        }
                    }
                }
            }
            if ((customScriptProps = (Properties)props.get("customScriptDetails")) != null) {
                boolean ignoreWarning = (Boolean)customScriptProps.get("IGNORE_WARNING");
                if (CREATION_STATUS.equalsIgnoreCase("SUCCESS") || ignoreWarning && CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                    this.customScriptResult = this.customScriptExecution(customScriptProps);
                }
            }
            mgmtLog.log(Level.INFO, " FcSharedMailboxCreationListener Listener finished ");
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void addAttributeToNativeProps(FcFormDataContainer fromClientData, FcNativeProperties fcNativeProperties) throws Exception {
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcSharedMailboxMgmtHandler.getInstance().getLdapVsValues(fromClientData, prop);
        this.getProperties(false, fromClientData, fcNativeProperties, ldapVsValueProps, "user");
    }

    private ArrayList<Hashtable> updateCustomAttributeProperties(FcFormDataContainer fromClientData) {
        ArrayList<Hashtable> customListTemp = new ArrayList<Hashtable>();
        try {
            FcFormDataContainer customFieldsContainer = new FcFormDataContainer();
            Properties prop = new Properties();
            prop.put("domainName", this.domainName);
            Properties ldapVsValueProps = FcSharedMailboxMgmtHandler.getInstance().getLdapVsValues(fromClientData, prop);
            customFieldsContainer.splitCustomFields(fromClientData);
            FcSharedMailboxMgmtHandler.getInstance().updateFieldsAttributes(customFieldsContainer);
            FcSharedMailboxMgmtHandler.getInstance().updateFieldValuesToAttributes(customFieldsContainer);
            customListTemp = this.getCustomAttribsProperties(customFieldsContainer, false, ldapVsValueProps, "user");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return customListTemp;
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
        request.setAttribute("userName", (Object)this.userName);
        request.setAttribute("rusMessage", (Object)this.rusMessage);
        request.setAttribute("customScriptResult", (Object)this.customScriptResult);
        try {
            String status = this.nativeStatusProps.getProperty("CREATION_STATUS");
            ArrayList<String> objectOUList = new ArrayList<String>();
            if (!status.equalsIgnoreCase("SEVERE") && !status.equalsIgnoreCase("NO_AD")) {
                DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"CONTACT"});
            }
            String hostId = request.getRemoteHost();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)10000, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)this.userName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            ArrayList<Properties> propList = this.fcNativeProperties.getPropList();
            Properties props = this.fcNativeProperties.getProps();
            if (this.isADSelected) {
                Properties dbValueProp;
                ArrayList dbValuesList;
                String criteriaColumn;
                String[] requiredColumns;
                String[] tableArray;
                ArrayList remainingSIDs;
                ArrayList<String> dNList;
                ArrayList sIDList;
                if (this.groupList != null && !this.groupList.isEmpty()) {
                    Properties grpList = new Properties();
                    grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                    grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                    grpList.put("ATTRIB_VALUE", this.groupList);
                    propList.add(grpList);
                }
                if (props.get("fullPermission") != null) {
                    sIDList = (ArrayList)props.get("fullPermission");
                    dNList = new ArrayList<String>();
                    remainingSIDs = (ArrayList)sIDList.clone();
                    tableArray = new String[]{"ADSMUserGeneralDetails", "ADSMGroupGeneralDetails"};
                    requiredColumns = new String[]{"DISTINGUISHED_NAME", "SID_STRING"};
                    criteriaColumn = "SID_STRING";
                    dbValuesList = FcLayoutUtil.getValuesFromTable((String[])tableArray, (String[])requiredColumns, (String)criteriaColumn, (ArrayList)sIDList);
                    for (int i = 0; i < dbValuesList.size(); ++i) {
                        dbValueProp = (Properties)dbValuesList.get(i);
                        dNList.add(dbValueProp.getProperty("DISTINGUISHED_NAME"));
                        remainingSIDs.remove(dbValueProp.getProperty("SID_STRING"));
                    }
                    if (!remainingSIDs.isEmpty()) {
                        dNList.addAll(remainingSIDs);
                    }
                    Properties fullPermission = new Properties();
                    fullPermission.put("ATTRIB_LDAP_NAME", "FullAccessRights");
                    fullPermission.put("ATTRIB_VALUE_COUNT", (Object)1L);
                    fullPermission.put("ATTRIB_VALUE", dNList);
                    propList.add(fullPermission);
                    Properties autoMapping = new Properties();
                    autoMapping.put("ATTRIB_LDAP_NAME", "AutoMapping");
                    autoMapping.put("ATTRIB_VALUE_COUNT", (Object)1L);
                    autoMapping.put("ATTRIB_VALUE", (Object)this.isAutomapping);
                    propList.add(autoMapping);
                }
                if ((Properties)this.permissionProps.get("mailBox") != null && ((Properties)this.permissionProps.get("mailBox")).get("folderPermissions") != null) {
                    ArrayList propsList = (ArrayList)((Properties)this.permissionProps.get("mailBox")).get("folderPermissions");
                    ArrayList<String> objectNames = new ArrayList<String>();
                    for (Properties prop : propsList) {
                        objectNames.add(prop.get("OBJECT_NAME").toString() + ":" + this.getStringFromMaskIDs(prop.get("ACCESS_MASK").toString()));
                    }
                    Properties permission = new Properties();
                    permission.put("ATTRIB_LDAP_NAME", "Permissions");
                    permission.put("ATTRIB_VALUE_COUNT", (Object)1L);
                    permission.put("ATTRIB_VALUE", objectNames);
                    propList.add(permission);
                }
                if (props.get("msExchMailboxTemplateLink") != null) {
                    Properties retentionPolicy = new Properties();
                    retentionPolicy.put("ATTRIB_LDAP_NAME", "msExchMailboxTemplateLink");
                    retentionPolicy.put("ATTRIB_VALUE_COUNT", (Object)1L);
                    retentionPolicy.put("ATTRIB_VALUE", (String)props.get("msExchMailboxTemplateLink"));
                    propList.add(retentionPolicy);
                }
                if (props.get("sendAs") != null) {
                    sIDList = (ArrayList)props.get("sendAs");
                    dNList = new ArrayList();
                    remainingSIDs = (ArrayList)sIDList.clone();
                    tableArray = new String[]{"ADSMUserGeneralDetails", "ADSMGroupGeneralDetails"};
                    requiredColumns = new String[]{"DISTINGUISHED_NAME", "SID_STRING"};
                    criteriaColumn = "SID_STRING";
                    dbValuesList = FcLayoutUtil.getValuesFromTable((String[])tableArray, (String[])requiredColumns, (String)criteriaColumn, (ArrayList)sIDList);
                    for (int i = 0; i < dbValuesList.size(); ++i) {
                        dbValueProp = (Properties)dbValuesList.get(i);
                        dNList.add(dbValueProp.getProperty("DISTINGUISHED_NAME"));
                        remainingSIDs.remove(dbValueProp.getProperty("SID_STRING"));
                    }
                    if (!remainingSIDs.isEmpty()) {
                        dNList.addAll(remainingSIDs);
                    }
                    Properties sendAsProps = new Properties();
                    sendAsProps.put("ATTRIB_LDAP_NAME", "sendAs");
                    sendAsProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.send_as"));
                    sendAsProps.put("ATTRIB_VALUE", dNList);
                    propList.add(sendAsProps);
                }
                if (this.ouName != null) {
                    Properties ouProp = new Properties();
                    ouProp.put("ATTRIB_LDAP_NAME", "ouName");
                    ouProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                    ouProp.put("ATTRIB_VALUE", this.ouName);
                    propList.add(ouProp);
                    objectOUList.add(this.ouName);
                }
                if (props.get("customScriptDetails") != null) {
                    Properties customScriptDetails = (Properties)props.get("customScriptDetails");
                    Properties customScript = new Properties();
                    customScript.put("ATTRIB_LDAP_NAME", "CustomScript");
                    customScript.put("ATTRIB_VALUE_COUNT", (Object)1L);
                    customScript.put("ATTRIB_VALUE", customScriptDetails.getProperty("SCRIPT_COMMAND"));
                    propList.add(customScript);
                }
                if (props.getProperty("mailAttribtueValue") != null) {
                    Properties emailProp = new Properties();
                    emailProp.put("ATTRIB_LDAP_NAME", "mail");
                    emailProp.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.e_mail_address"));
                    emailProp.put("ATTRIB_VALUE", props.getProperty("mailAttribtueValue"));
                    propList.add(emailProp);
                }
                for (int ijk = 0; ijk < this.customList.size(); ++ijk) {
                    Hashtable customHash = this.customList.get(ijk);
                    Properties customProp = new Properties();
                    customProp.put("ATTRIB_LDAP_NAME", customHash.get("ATTRIB_LDAP_NAME"));
                    customProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                    customProp.put("ATTRIB_VALUE", customHash.get("ATTRIB_VALUE"));
                    propList.add(customProp);
                }
            } else {
                METrackerUtil.updateMETrackerCount((Long)this.loginId, (String)"create_single_o365_shared_mb", (Long)1L);
                propList = new ArrayList<Properties>();
                Properties auditProp = new Properties();
                auditProp.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.common.attrib_disp_name.display_name"));
                auditProp.put("ATTRIB_VALUE", this.userName);
                propList.add(auditProp);
                if (props.get("mailAlias") != null) {
                    auditProp = new Properties();
                    auditProp.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.common.attrib_disp_name.mail_alias"));
                    auditProp.put("ATTRIB_VALUE", props.get("mailAlias"));
                    propList.add(auditProp);
                }
            }
            if (props.get("o365FullPermission") != null) {
                Properties auditProp = new Properties();
                auditProp.put("ATTRIB_LDAP_NAME", "o365FullPermission");
                auditProp.put("ATTRIB_VALUE", O365MgmtHandler.getDisplayNameForAudit((ArrayList)((ArrayList)props.get("o365FullPermission"))));
                propList.add(auditProp);
            }
            if (props.get("o365SendOnBehalf") != null) {
                Properties auditProp = new Properties();
                auditProp.put("ATTRIB_LDAP_NAME", "o365SendOnBehalf");
                auditProp.put("ATTRIB_VALUE", O365MgmtHandler.getDisplayNameForAudit((ArrayList)((ArrayList)props.get("o365SendOnBehalf"))));
                propList.add(auditProp);
            }
            if (props.get("o365SendAs") != null) {
                Properties auditProp = new Properties();
                auditProp.put("ATTRIB_LDAP_NAME", "o365SendAs");
                auditProp.put("ATTRIB_VALUE", O365MgmtHandler.getDisplayNameForAudit((ArrayList)((ArrayList)props.get("o365SendAs"))));
                propList.add(auditProp);
            }
            Long tid = new Long(request.getParameter("templateId"));
            Properties propToAudit = new Properties();
            propToAudit.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.cre_template.text_template_name"));
            propToAudit.put("ATTRIB_VALUE", FcLayoutViewHandler.getLayoutName((Long)tid, (AdventNetResourceBundle)this.rb));
            propList.add(propToAudit);
            String creationStatus = this.nativeStatusProps.getProperty("STATUS_MESSAGE");
            ArrayList creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
            if (creationMsg != null && !creationMsg.isEmpty()) {
                if (creationStatus != null && creationStatus.trim().length() > 0) {
                    creationStatus = creationStatus + this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text_but_follng_error_occured");
                }
                for (int i = 0; i < creationMsg.size(); ++i) {
                    Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                    String errorCode = (String)creationMessage.get("ERROR_CODE");
                    creationStatus = creationStatus + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE"));
                    if (creationMessage.get("NATIVE_ERROR_MESSAGE") != null) {
                        creationStatus = creationStatus + creationMessage.get("NATIVE_ERROR_MESSAGE");
                    }
                    if (errorCode == null || errorCode.equalsIgnoreCase("0")) continue;
                    creationStatus = creationStatus + " - " + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + creationMessage.get("ERROR_CODE");
                }
            }
            if (!this.rusMessage.equals("")) {
                creationStatus = creationStatus + this.rusMessage;
            }
            TechAuditAPI.getInstance().auditSharedMailboxModification(this.loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.cre_single_shared_mailbox"), this.userName, this.domainName, propList, this.fcNativeProperties.getModifyList(), creationStatus, object_id, auditDataObj, this.rb);
            String statusMessage = "";
            statusMessage = this.nativeStatusProps.get("CREATION_MESSAGE") == null && status.equalsIgnoreCase("NO_AD") ? this.rb.getString("admp.mgmt.office365.shared_mailbox_created_successfully") : (this.nativeStatusProps.get("CREATION_MESSAGE") == null ? this.rb.getString("admp.mgmt.user_mgmt.cre_single.statmsg.success_created_sm") : creationStatus);
            audit_info.put("error_msg", statusMessage);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (!this.isBulkMgmt && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("SEVERE")) {
                Integer userObjectId = 1;
                String manager = "";
                FcLayoutField field = this.userData.get((Object)FcExecuteActionConstants.SHARED_MAILBOX_CREATION_MANAGER_FIELD_ID) != null ? (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.SHARED_MAILBOX_CREATION_MANAGER_FIELD_ID) : (FcLayoutField)this.fromClientData.get((Object)FcExecuteActionConstants.SHARED_MAILBOX_CREATION_MANAGER_FIELD_ID);
                if (field != null) {
                    FcManager fcManager = (FcManager)field.getIComponent();
                    manager = fcManager.getUserName() != null ? fcManager.getUserName() : "";
                }
                this.viewId = FcExecuteActionConstants.SMB_LAYOUT_VIEW_ID;
                this.triggerNotifiation(audit_id, object_id, this.userName, manager, null, userObjectId, ReportsUtil.SINGLE_SMB_CREATION_REPORT_ID, this.domainName, this.rb, objectOUList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setIsCreationSuccess() {
        if (this.nativeStatusProps != null) {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                this.setIsCreationSuccess(true);
            }
        } else {
            this.setIsCreationSuccess(false);
        }
    }

    public Properties getSingleSMErrorMessage(NativeError statusObject) {
        String statusMessage = this.rb.getString("admp.mgmt.user_mgmt.cre_single.statmsg.success_created_sm");
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        String errorSeverity = null;
        if (statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.domainName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.domainName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.distinguishedName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.distinguishedName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.distinguishedName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.searchString, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.searchString);
            errorSeverity = statusObject.getSeverityLevel((Object)this.searchString);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) == null || (errorList = statusObject.getErrorList(object)).isEmpty()) continue;
            for (Hashtable hashtable : errorList) {
                messageList.add(hashtable);
            }
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("STATUS_MESSAGE", statusMessage);
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public void setFieldValueList(Properties fieldValue) {
    }

    public Properties getNativeStatusProps() {
        return null;
    }

    public void setSingleUserErrorMessage(String errorMessage) {
        ArrayList messageList = new ArrayList();
        messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
        if (messageList == null) {
            messageList = new ArrayList();
        }
        Hashtable<String, String> errorHash = new Hashtable<String, String>();
        errorHash.put("ERROR_MESSAGE", errorMessage);
        if (!this.isADSelected) {
            errorHash.put("NATIVE_ERROR_MESSAGE", "");
            this.nativeStatusProps.put("CREATION_STATUS", "SEVERE");
        }
        messageList.add(errorHash);
        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
    }
}

