/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationMacro;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTemplateHandler;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApp;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutBulkViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcNativeProperties;
import com.adventnet.sym.adsm.common.server.layout.FcUserCreationMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcManager;
import com.adventnet.sym.adsm.common.server.powershell.PowerShellCommand;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPhotoMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteNamingFormat;
import com.adventnet.sym.adsm.common.webclient.layout.FcMgmtListener;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class FcUserCreationListener
extends FcADMgmtListener {
    String userName = "";
    String ouName = null;
    String samAccountName = "";
    String password = "";
    String passwordType = "";
    String customScriptResult = "";
    String displayName = "";
    DataObject auditDataObject = null;
    ArrayList groupList = null;
    Hashtable<String, ArrayList<Properties>> otherDomainGroupList = null;
    Properties nativeStatusProps = new Properties();
    Hashtable auditLogProps = new Hashtable();

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.creationId = creationId;
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.createUser();
    }

    @Override
    public void reInit() {
        super.reInit();
        this.userName = "";
        this.ouName = null;
        this.samAccountName = "";
        this.password = "";
        this.customScriptResult = "";
        this.rusMessage = "";
        this.groupList = null;
        this.otherDomainGroupList = null;
        this.nativeStatusProps = new Properties();
        this.auditLogProps = new Hashtable();
        this.displayName = "";
    }

    @Override
    public Long getCreationId() {
        return this.creationId;
    }

    @Override
    public Long createRequest(String domainName, JSONObject wfCreateRequestJson, FcFormDataContainer fromClientData, FcFormDataContainer userData, Long loginId, Long layoutId, FcLayout executeFormLayout, Long templateCategoryId) {
        boolean isRequestCreated = false;
        Long requestId = -1L;
        try {
            this.domainName = domainName;
            this.fromClientData = fromClientData;
            this.userData = userData;
            this.loginId = loginId;
            Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
            if (!LicenseMgr.getInstance().isTrailEdition() && !errorId.booleanValue()) {
                return -1L;
            }
            this.preMgmtActions();
            Long objectCreationId = FcExecuteFormFlow.getNewObjectCreationId();
            Long objectIndexId = FcExecuteFormFlow.getNewObjectIndexId(objectCreationId, layoutId);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            this.creationId = objectCreationId;
            this.objectIndexId = objectIndexId;
            FcUserCreationMgmtHandler.getInstance().updateFieldsAttributes(fromClientData);
            FcUserCreationMgmtHandler.getInstance().updateFieldValuesToAttributes(fromClientData);
            FcUserCreationMgmtHandler.getInstance().updateFieldsAttributes(this.customFieldsContainer);
            FcUserCreationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.customFieldsContainer);
            FcUserCreationMgmtHandler.getInstance().updateFieldsAttributes(userData);
            FcUserCreationMgmtHandler.getInstance().updateFieldValuesToAttributes(userData);
            fromClientData.updatePwdString(userData);
            JSONArray selectedIamAppsJsonArray = executeFormLayout.getSelectedIamAppsJsonArray();
            FcLayoutBulkViewHandler.addSelectedIamAppsRow((DataObject)dataObj, (Long)objectIndexId, (int)FcExecuteActionConstants.resultDataId, (JSONArray)selectedIamAppsJsonArray, (Long)templateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.userDataId, userData, FcExecuteActionConstants.userCreationTemplateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.resultDataId, fromClientData, FcExecuteActionConstants.userCreationTemplateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.resultDataId, this.customFieldsContainer, FcExecuteActionConstants.userCreationTemplateCategoryId);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            String containerName = FcLayoutUtil.getOUNameFromContainer((FcFormDataContainer)fromClientData);
            ArrayList ouList = WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId);
            if (ouList.size() > 0 && !ouList.contains(containerName)) {
                boolean isExcludeChildOu = WFRequesterUtil.isExcludeChildOu((String)domainName, (Long)loginId);
                Criteria c = null;
                c = isExcludeChildOu ? OUUtil.getOUCriteriaWithEquals((String)"ADSMOUDetails", (ArrayList)ouList) : OUUtil.getOUCriteriaWithEndsWITH((String)"ADSMOUDetails", (ArrayList)ouList);
                ouList = OUUtil.getOUList((String)domainName, (Criteria)c);
                if (!ouList.contains(containerName)) {
                    return -2L;
                }
            }
            FcLayoutUpdateHandler.updateObjectCreationIdDetails((Long)objectCreationId, (String)domainName, (String)containerName, (Long)layoutId);
            requestId = FcExecuteFormFlow.createWorkFlowRequest(objectCreationId, FcExecuteActionConstants.userCreationTemplateCategoryId, loginId, domainName, wfCreateRequestJson, this.rb, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return requestId;
    }

    @Override
    public boolean importCSVDetailsForAutomation(Long objectCreationId, DataObject dataObj, JSONObject errorDetailsObj, Vector headerVector, ArrayList<Vector> list, Long loginId, AdventNetResourceBundle rb, String domainName, Long selectedLayoutId, boolean isTemplateHeaderAvailable, int templateHeaderIndex) {
        boolean status = FcBulkExecuteFormFlow.addObjectDetails(objectCreationId, null, dataObj, errorDetailsObj, headerVector, list, FcExecuteActionConstants.userCreationTemplateCategoryId, loginId, rb, domainName, isTemplateHeaderAvailable, templateHeaderIndex, selectedLayoutId, false, FcLayoutUtil.getDPValues((Long)loginId, (String)domainName, (AdventNetResourceBundle)rb));
        return status;
    }

    public void preMgmtActions() throws Exception {
        FcUserCreationMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
        FcUserCreationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcUserCreationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop);
        this.customFieldsContainer = new FcFormDataContainer();
        this.customFieldsContainer.splitCustomFields(this.fromClientData);
        FcUserCreationMgmtHandler.getInstance().updateFieldsAttributes(this.customFieldsContainer);
        FcUserCreationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.customFieldsContainer);
        FcNativeProperties fcNativeProperties = this.fcNativeProperties;
        this.addAttributeToNativeProps(this.fromClientData, fcNativeProperties, ldapVsValueProps, "user");
        Properties props = fcNativeProperties.getProps();
        this.userName = props.getProperty("userName");
        this.ouName = props.getProperty("OUName");
        this.displayName = props.getProperty("displayName");
        if (props.get("samAccountName") != null) {
            this.samAccountName = props.getProperty("samAccountName");
        }
        if (props.get("password") != null) {
            this.password = props.getProperty("password");
        }
        if (props.get("passwordType") != null) {
            this.passwordType = props.getProperty("passwordType");
        }
        ArrayList modifyList = fcNativeProperties.getModifyList();
        boolean uacValuePresent = false;
        int modifyListCount = modifyList.size();
        for (int ind1 = 0; ind1 < modifyListCount; ++ind1) {
            Hashtable currModValueHash = (Hashtable)modifyList.get(ind1);
            if (!((String)currModValueHash.get("ATTRIB_LDAP_NAME")).equalsIgnoreCase("userAccountControl")) continue;
            uacValuePresent = true;
            break;
        }
        if (!uacValuePresent) {
            int nandValue = 32;
            int uacValue = 512;
            Hashtable<String, Object> uacHash = new Hashtable<String, Object>();
            uacHash.put("ATTRIB_AND_VALUE", new Integer(~(nandValue |= 2)).toString());
            uacHash.put("ATTRIB_LDAP_NAME", "userAccountControl");
            uacHash.put("ATTRIB_VALUE", new Integer(uacValue).toString());
            uacHash.put("ATTRIB_VALUE_COUNT", new Long(1L));
            uacHash.put("DATA_HANDLER_TYPE", new Long(7L));
            modifyList.add(uacHash);
        }
    }

    private void sendSysLogs(String taskName, String status, Hashtable auditLogProps) {
        try {
            Properties props;
            ArrayList customList;
            ArrayList nonExchPropList;
            ArrayList tsList;
            ArrayList winNTAttributeList;
            ArrayList modifyList;
            JSONObject syslogMessage = new JSONObject();
            syslogMessage.put("ACTION", (Object)this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.mgmtname.user_management"));
            syslogMessage.put(this.rb.getString("admp.mgmt.common.text.task"), (Object)taskName);
            syslogMessage.put(this.rb.getString("admp.common.attrib_disp_name.user_name"), auditLogProps.get(this.rb.getString("admp.common.attrib_disp_name.user_name")));
            syslogMessage.put(this.rb.getString("admp.common.attrib_disp_name.dn_domain_name"), auditLogProps.get(this.rb.getString("admp.common.attrib_disp_name.dn_domain_name")));
            syslogMessage.put(this.rb.getString("admp.common.attrib_disp_name.container_name"), auditLogProps.get(this.rb.getString("admp.common.attrib_disp_name.container_name")));
            syslogMessage.put(this.rb.getString("admp.common.attrib_disp_name.sam_name"), auditLogProps.get(this.rb.getString("admp.common.attrib_disp_name.sam_name")));
            ArrayList groupList = (ArrayList)auditLogProps.get("groupList");
            if (groupList != null && !groupList.isEmpty()) {
                syslogMessage.put("memberOf", (Object)groupList);
            }
            String attribName = "";
            String attribValue = "";
            ArrayList propList = (ArrayList)auditLogProps.get("propList");
            if (propList != null) {
                for (int i = 0; i < propList.size(); ++i) {
                    Hashtable prop = (Hashtable)propList.get(i);
                    attribName = prop.get("ATTRIB_LDAP_NAME").toString();
                    attribValue = prop.get("ATTRIB_VALUE").toString();
                    if (attribName.equalsIgnoreCase("password")) {
                        attribValue = "********";
                    } else if (attribName.equalsIgnoreCase("accountExpires")) {
                        attribValue = !attribValue.equals("0") ? DateTimeUtil.getAccountExpiresDateFromFileTime((Long)Long.parseLong(attribValue), (AdventNetResourceBundle)this.rb, (Long)this.loginId) : this.rb.getString("admp.reports.user.account_exp_date.never_expires");
                    } else {
                        attribValue = CommonUtil.htmlEscapeForAuditReport((String)attribValue);
                        attribValue = CommonUtil.htmlDeEscape((String)attribValue);
                    }
                    syslogMessage.put(attribName, (Object)attribValue);
                }
            }
            if ((modifyList = (ArrayList)auditLogProps.get("modifyList")) != null) {
                for (int i = 0; i < modifyList.size(); ++i) {
                    Hashtable prop = (Hashtable)modifyList.get(i);
                    attribName = prop.get("ATTRIB_LDAP_NAME").toString();
                    attribValue = prop.get("ATTRIB_VALUE").toString();
                    attribValue = CommonUtil.htmlEscapeForAuditReport((String)attribValue);
                    attribValue = CommonUtil.htmlDeEscape((String)attribValue);
                    syslogMessage.put(attribName, (Object)attribValue);
                }
            }
            if ((winNTAttributeList = (ArrayList)auditLogProps.get("winNTAttributeList")) != null) {
                for (int i = 0; i < winNTAttributeList.size(); ++i) {
                    Hashtable prop = (Hashtable)winNTAttributeList.get(i);
                    attribName = prop.get("ATTRIB_LDAP_NAME").toString();
                    attribValue = prop.get("ATTRIB_VALUE").toString();
                    attribValue = CommonUtil.htmlEscapeForAuditReport((String)attribValue);
                    attribValue = CommonUtil.htmlDeEscape((String)attribValue);
                    syslogMessage.put(attribName, (Object)attribValue);
                }
            }
            if ((tsList = (ArrayList)auditLogProps.get(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_properties"))) != null) {
                for (int i = 0; i < tsList.size(); ++i) {
                    Hashtable prop = (Hashtable)tsList.get(i);
                    attribName = prop.get("ATTRIB_LDAP_NAME").toString();
                    attribValue = prop.get("ATTRIB_VALUE").toString();
                    attribValue = CommonUtil.htmlEscapeForAuditReport((String)attribValue);
                    attribValue = CommonUtil.htmlDeEscape((String)attribValue);
                    syslogMessage.put(attribName, (Object)attribValue);
                }
            }
            if ((nonExchPropList = (ArrayList)auditLogProps.get("nonExchPropList")) != null) {
                for (int i = 0; i < nonExchPropList.size(); ++i) {
                    Hashtable prop = (Hashtable)nonExchPropList.get(i);
                    attribName = prop.get("ATTRIB_LDAP_NAME").toString();
                    attribValue = prop.get("ATTRIB_VALUE").toString();
                    attribValue = CommonUtil.htmlEscapeForAuditReport((String)attribValue);
                    attribValue = CommonUtil.htmlDeEscape((String)attribValue);
                    syslogMessage.put(attribName, (Object)attribValue);
                }
            }
            if ((customList = (ArrayList)auditLogProps.get("customList")) != null) {
                for (int i = 0; i < customList.size(); ++i) {
                    Hashtable prop = (Hashtable)customList.get(i);
                    attribName = prop.get("ATTRIB_LDAP_NAME").toString();
                    attribValue = prop.get("ATTRIB_VALUE").toString();
                    attribValue = CommonUtil.htmlEscapeForAuditReport((String)attribValue);
                    attribValue = CommonUtil.htmlDeEscape((String)attribValue);
                    syslogMessage.put(attribName, (Object)attribValue);
                }
            }
            if ((props = this.fcNativeProperties.getProps()).get("password") != null) {
                syslogMessage.put("password", (Object)"********");
            }
            if (auditLogProps.get("UM Policy Details") != null) {
                syslogMessage.put("msExchUMMailBoxPolicy", (Object)((Properties)auditLogProps.get("UM Policy Details")));
            }
            if (auditLogProps.get("Retention Policy Details") != null) {
                syslogMessage.put("msExchMailboxTemplateLink", auditLogProps.get("Retention Policy Details"));
            }
            if (auditLogProps.get("Home MDB") != null) {
                syslogMessage.put("homeMDB", auditLogProps.get("Home MDB"));
            }
            if (auditLogProps.get("msExchArchiveDatabaseLink") != null) {
                syslogMessage.put("msExchArchiveDatabaseLink", auditLogProps.get("msExchArchiveDatabaseLink"));
            }
            if (auditLogProps.get("msExchArchiveAddress") != null) {
                syslogMessage.put("msExchArchiveAddress", auditLogProps.get("msExchArchiveAddress"));
            }
            if (auditLogProps.get(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.dial_in")) != null) {
                syslogMessage.put(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.dial_in"), auditLogProps.get(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.dial_in")));
            }
            if (auditLogProps.get(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_remote_home_dir")) != null) {
                syslogMessage.put(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_remote_home_dir"), auditLogProps.get(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_remote_home_dir")));
            }
            if (auditLogProps.get(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.remote_home_dir")) != null) {
                syslogMessage.put(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.remote_home_dir"), auditLogProps.get(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.remote_home_dir")));
            }
            if (auditLogProps.get(this.rb.getString("admp.ad_explorer.view_props.user.attrib_disp_name.profile_path")) != null) {
                syslogMessage.put(this.rb.getString("admp.ad_explorer.view_props.user.attrib_disp_name.profile_path"), auditLogProps.get(this.rb.getString("admp.ad_explorer.view_props.user.attrib_disp_name.profile_path")));
            }
            if (auditLogProps.get(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_profile_path")) != null) {
                syslogMessage.put(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_profile_path"), auditLogProps.get(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_profile_path")));
            }
            if (auditLogProps.get("customScriptDetails") != null) {
                syslogMessage.put("CustomScriptDetails", (Object)((Properties)auditLogProps.get("customScriptDetails")));
            }
            if (status.contains(this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot"))) {
                status = status.replace(this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot"), "");
            }
            syslogMessage.put(this.rb.getString("admp.common.text.status"), (Object)status);
            if (auditLogProps.get("technicianName") != null) {
                syslogMessage.put("TechnicianName", auditLogProps.get("technicianName"));
            } else {
                syslogMessage.put("TechnicianName", (Object)"");
            }
            LogForwarderAPI.getInstance().sendMessage(syslogMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Properties getO365LicenseProperty(int j, String tenantId, ArrayList selectedSKUList, boolean refresh) {
        Properties licenseProps = null;
        try {
            if (refresh) {
                Long waadDomainId = O365MgmtHandler.getWaadDomainId((String)tenantId);
                String message = O365MgmtHandler.updateDomainData((Long)waadDomainId);
                mgmtLog.log(Level.INFO, message);
            }
            licenseProps = (Properties)O365InfoCache.getInstance().getO365LicenseStatusProps((String)selectedSKUList.get(j));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return licenseProps;
    }

    public void createUser() {
        try {
            Hashtable hash;
            String uniqueOperationId;
            File photoFile;
            Properties customScriptProps;
            boolean isLicenseExceeded;
            this.stopExecution = false;
            mgmtLog.log(Level.INFO, " FcUserCreation Started ");
            this.essentialAttributes.add("displayName");
            this.preMgmtActions();
            if (this.getSourceAction() == null || this.getSourceAction().length() == 0) {
                String sourceAction = this.rb.getString("admp.workflow.layout.createrequest.category_single_user_creation");
                if (this.isBulkMgmt && !this.isSUCWorkflowMode) {
                    sourceAction = this.rb.getString("admp.workflow.layout.createrequest.category_bulk_user_creation");
                }
                this.setSourceAction(sourceAction);
            }
            if (!this.isADSelected) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "NO_AD");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", "");
                if (!this.isBulkMgmt) {
                    this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                } else {
                    this.nativeStatusProps.put("CREATION_MESSAGE", new String());
                }
                return;
            }
            Properties prop = new Properties();
            prop.put("domainName", this.domainName);
            Properties ldapVsValueProps = FcUserCreationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop);
            ArrayList<Hashtable> customList = this.getCustomAttribsProperties(this.customFieldsContainer, false, ldapVsValueProps, "user");
            if (this.stopExecution) {
                if (!this.isBulkMgmt) {
                    ArrayList messageList = new ArrayList();
                    messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
                    if (messageList == null) {
                        messageList = new ArrayList();
                    }
                    Hashtable<String, String> errorHash = new Hashtable<String, String>();
                    errorHash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.fc_layout_error.duplication_occurred"), this.duplicatedAttribute));
                    errorHash.put("ERROR_CODE", "0");
                    messageList.add(errorHash);
                    this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
                } else {
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.fc_layout_error.duplication_occurred"), this.duplicatedAttribute));
                }
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                if (this.userName == null) {
                    if (ldapVsValueProps.getProperty("name") != null) {
                        this.userName = ldapVsValueProps.getProperty("name");
                    } else if (ldapVsValueProps.getProperty("userName") != null) {
                        this.userName = ldapVsValueProps.getProperty("userName");
                    } else if (ldapVsValueProps.getProperty("LogonName") != null) {
                        this.userName = ldapVsValueProps.getProperty("LogonName");
                    } else if (ldapVsValueProps.getProperty("samAccountName") != null) {
                        this.userName = ldapVsValueProps.getProperty("samAccountName");
                    }
                    if (ldapVsValueProps.getProperty("sAMAccountName") != null) {
                        this.samAccountName = ldapVsValueProps.getProperty("sAMAccountName");
                    }
                }
                return;
            }
            Properties props = this.fcNativeProperties.getProps();
            this.userName = props.getProperty("userName");
            this.ouName = props.getProperty("OUName");
            if (this.isBulkMgmt && this.commonContainerName != null && !this.commonContainerName.equals("")) {
                this.ouName = this.commonContainerName;
            }
            if (!HelpdeskUtil.isAuthorizedOU((String)this.domainName, (Long)this.loginId, (String)this.ouName)) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), this.ouName));
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), this.ouName));
                return;
            }
            this.groupList = this.fcNativeProperties.getGroupList();
            this.otherDomainGroupList = this.fcNativeProperties.getOtherDomainGroupList();
            this.userName = CommonUtil.escapeString((String)this.userName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
            String adminGroup = null;
            String mailAlias = null;
            String targetAddress = null;
            String mailBoxServer = null;
            String mailBoxStore = null;
            boolean usePowerShell = false;
            Integer exchVersion = 0;
            String upn = "";
            String dialIn = null;
            String searchString = null;
            String archiveDB = null;
            String exchangePhotoFilePath = null;
            String archiveDomain = null;
            String enableRemoteMailbox = null;
            String remoteRoutingAddress = "";
            boolean enableArchiveMailbox = false;
            boolean waadExchPoliciesExcluded = false;
            ArrayList newProxyAddressList = new ArrayList();
            String distinguishedName = "CN=" + this.userName + "," + this.ouName;
            Properties exchangeServerDetails = null;
            ArrayList nonExchPropList = this.fcNativeProperties.getNonExchAttributeList();
            ArrayList<String> exchAttributes = new ArrayList<String>();
            boolean mailBoxEnabled = false;
            boolean mailEnabled = false;
            String mailType = "";
            if (props.get("adminGroup") != null || props.get("adminGroup") != "") {
                adminGroup = props.getProperty("adminGroup");
            }
            if (props.get("mailAlias") != null) {
                mailAlias = props.getProperty("mailAlias");
            }
            if (props.get("targetAddress") != null) {
                targetAddress = props.getProperty("targetAddress");
            }
            if (props.get("msExchHomeServerName") != null) {
                mailBoxServer = props.getProperty("msExchHomeServerName");
            }
            if (props.get("samAccountName") != null) {
                this.samAccountName = props.getProperty("samAccountName");
            }
            if (props.get("password") != null) {
                this.password = props.getProperty("password");
            }
            if (props.get("passwordType") != null) {
                this.passwordType = props.getProperty("passwordType");
            }
            if (props.get("homeMDB") != null) {
                mailBoxStore = props.getProperty("homeMDB");
            }
            if (props.get("upn") != null) {
                upn = props.getProperty("upn");
            }
            if (props.get("dialIn") != null) {
                dialIn = props.getProperty("dialIn");
            }
            if (props.get("msExchArchiveDatabaseLink") != null) {
                archiveDB = props.getProperty("msExchArchiveDatabaseLink");
            }
            if (props.get("exchangePhoto") != null) {
                Hashtable hash2 = (Hashtable)props.get("exchangePhoto");
                exchangePhotoFilePath = (String)hash2.get("ATTRIB_VALUE");
                if (mailBoxServer == null) {
                    this.photoFileError = this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.exchange_photo_cannot_be_set");
                }
            }
            if (props.get("msExchArchiveAddress") != null) {
                archiveDomain = props.getProperty("msExchArchiveAddress");
            }
            if (props.get("waadRemoteMailbox") != null) {
                enableRemoteMailbox = props.getProperty("waadRemoteMailbox");
            }
            if (props.get("waadRemoteMailboxArchieve") != null) {
                enableArchiveMailbox = true;
            }
            if (props.get("msExchPoliciesExcluded") != null) {
                waadExchPoliciesExcluded = (Boolean)props.get("msExchPoliciesExcluded");
            }
            if (props.get("waadproxyAddresses") != null) {
                newProxyAddressList = (ArrayList)props.get("waadproxyAddresses");
            }
            if (ldapVsValueProps.get("waadRemoteRoutingAddress") != null) {
                remoteRoutingAddress = (String)ldapVsValueProps.get("waadRemoteRoutingAddress");
                remoteRoutingAddress = FcExecuteNamingFormat.getFormatValue(remoteRoutingAddress, null, ldapVsValueProps);
            }
            searchString = "(&(objectClass=user)(objectCategory=user)(sAMAccountName=" + this.samAccountName + "))";
            if (adminGroup != null || enableRemoteMailbox != null && enableRemoteMailbox.equalsIgnoreCase("true")) {
                exchVersion = ExchangeUtil.getAdminGroupType((String)adminGroup, (String)this.domainName);
                usePowerShell = ExchangeUtil.checkExchangeGroup2007((String)adminGroup);
                mailEnabled = true;
                mailType = "mail";
                exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)this.domainName, (String)adminGroup, (Long)this.loginId);
            }
            if (mailBoxServer != null) {
                exchVersion = ExchangeUtil.getExchangeServerType((String)mailBoxServer);
                usePowerShell = ExchangeUtil.checkExchange2007((String)mailBoxServer);
                mailBoxEnabled = true;
                mailType = "mailBox";
                exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)mailBoxServer);
            }
            ArrayList<Hashtable> exchCustomList = new ArrayList<Hashtable>();
            if (usePowerShell) {
                if (mailBoxEnabled || mailEnabled) {
                    for (String string : UserMgmtUtil.exchange2007MailBox) {
                        exchAttributes.add(string);
                    }
                    for (String string : UserMgmtUtil.exchange2007MailEnabled) {
                        exchAttributes.add(string);
                    }
                }
                nonExchPropList.clear();
                int proxyCount = this.fcNativeProperties.getPropList().size();
                for (int ind1 = 0; ind1 < proxyCount; ++ind1) {
                    Hashtable propAttributeHash = (Hashtable)this.fcNativeProperties.getPropList().get(ind1);
                    String attribColumnName = (String)propAttributeHash.get("ATTRIB_COLUMN_NAME");
                    if (attribColumnName == null) continue;
                    if (attribColumnName.equalsIgnoreCase("EMAIL_PROXY_ADDRESSES")) {
                        nonExchPropList.add((Hashtable)propAttributeHash.clone());
                        if (this.msExchPoliciesExcluded) continue;
                        this.fcNativeProperties.getPropList().remove(ind1);
                        --ind1;
                        --proxyCount;
                        continue;
                    }
                    if (exchAttributes.contains(attribColumnName)) continue;
                    nonExchPropList.add((Hashtable)propAttributeHash.clone());
                }
                int count = customList.size();
                for (int i = 0; i < count; ++i) {
                    Hashtable propAttributeHash = customList.get(i);
                    String attribLdapName = (String)propAttributeHash.get("ATTRIB_LDAP_NAME");
                    for (String attrib : UserMgmtUtil.exchCustAttribList) {
                        if (!attrib.equalsIgnoreCase(attribLdapName)) continue;
                        exchCustomList.add(propAttributeHash);
                        customList.remove(i);
                        --i;
                        --count;
                    }
                }
            }
            if (isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"userMgmt")) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                ArrayList errorMessageList = new ArrayList();
                Hashtable<String, String> errorTable = new Hashtable<String, String>();
                errorMessageList.add(errorTable);
                errorTable.put("ERROR_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.could_not_update_more_than_100_objects_license_level_exceeded"));
                if (!this.isBulkMgmt) {
                    this.nativeStatusProps.put("CREATION_MESSAGE", errorMessageList);
                } else {
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.could_not_update_more_than_100_objects_license_level_exceeded"));
                }
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                return;
            }
            boolean licenseLimitExceeded = false;
            ArrayList<String> licenseConsumedSKUList = null;
            ArrayList selectedIamAppIdList = new ArrayList();
            if (!this.isBulkMgmt) {
                JSONArray selectedIamAppJsonArray = this.executeLayout.getSelectedIamAppsJsonArray();
                for (int k = 0; k < selectedIamAppJsonArray.length(); ++k) {
                    FcIamApp fcIamApp = this.fcIamApps.getIamApp(Integer.valueOf(selectedIamAppJsonArray.getInt(k)));
                    selectedIamAppIdList.add(fcIamApp.getIamAppId());
                }
            } else {
                selectedIamAppIdList = FcLayoutBulkViewHandler.getSelectedIamAppIdForObjectIndexId((Long)this.objectIndexId);
            }
            for (int k = 0; k < selectedIamAppIdList.size(); ++k) {
                boolean isLicenseLimitCheckNeeded;
                Properties o365AccProps;
                if (((Integer)selectedIamAppIdList.get(k)).intValue() != FcLayoutConstants.OFFICE_365_APPID.intValue() || (o365AccProps = DomainInfoCache.getInstance().getO356AccountProperties(this.domainName)) == null || !o365AccProps.containsKey("SKU_DETAILS")) continue;
                ArrayList selectedSKUList = (ArrayList)props.get("selectedSKUList");
                boolean bl = isLicenseLimitCheckNeeded = props.get("licenseLimitCheckNeeded") != null ? (Boolean)props.get("licenseLimitCheckNeeded") : false;
                if (selectedSKUList == null || selectedSKUList.size() <= 0 || !isLicenseLimitCheckNeeded) continue;
                for (int j = 0; j < selectedSKUList.size(); ++j) {
                    boolean isConsumed;
                    String tenantId = (String)o365AccProps.get("WAAD_TENANT_ID");
                    Properties licenseProps = this.getO365LicenseProperty(j, tenantId, selectedSKUList, isLicenseLimitCheckNeeded);
                    if (licenseProps == null || licenseProps.get("isConsumed") == null || !(isConsumed = ((Boolean)licenseProps.get("isConsumed")).booleanValue())) continue;
                    licenseLimitExceeded = true;
                    if (licenseConsumedSKUList == null) {
                        licenseConsumedSKUList = new ArrayList<String>();
                    }
                    licenseConsumedSKUList.add(this.rb.getString(O365MgmtHandler.getDispNameForWAADAccountSKU((String)((String)selectedSKUList.get(j)))));
                }
            }
            if (licenseLimitExceeded) {
                String licenses = "";
                if (licenseConsumedSKUList != null) {
                    for (int k = 0; k < licenseConsumedSKUList.size(); ++k) {
                        licenses = licenses + licenseConsumedSKUList.get(k);
                        if (k == licenseConsumedSKUList.size() - 1) continue;
                        licenses = licenses + ",";
                    }
                }
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                ArrayList errorMessageList = new ArrayList();
                Hashtable<String, String> errorTable = new Hashtable<String, String>();
                errorMessageList.add(errorTable);
                errorTable.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("client.users.CSVUserListener.could_not_create_o365_user_license_level_exceeded"), licenses));
                if (!this.isBulkMgmt) {
                    this.nativeStatusProps.put("CREATION_MESSAGE", errorMessageList);
                } else {
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("client.users.CSVUserListener.could_not_create_o365_user_license_level_exceeded"), licenses));
                }
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                return;
            }
            ArrayList<String> fullGroupList = new ArrayList<String>();
            fullGroupList.addAll(this.groupList);
            Enumeration<ArrayList<Properties>> e = this.otherDomainGroupList.elements();
            while (e.hasMoreElements()) {
                ArrayList<Properties> groups = e.nextElement();
                for (Properties otherDomainGroupProps : groups) {
                    fullGroupList.add(otherDomainGroupProps.getProperty("DISTINGUISHED_NAME"));
                }
            }
            mgmtLog.log(Level.INFO, " User Creation : domainName " + this.domainName);
            mgmtLog.log(Level.INFO, " LoginId  " + this.loginId);
            mgmtLog.log(Level.INFO, " Full Name :" + this.userName);
            mgmtLog.log(Level.INFO, " propsList " + this.fcNativeProperties.getPropList());
            mgmtLog.log(Level.INFO, " modifyList " + this.fcNativeProperties.getModifyList());
            mgmtLog.log(Level.INFO, " tsList " + this.fcNativeProperties.getTsList());
            mgmtLog.log(Level.INFO, " winNTAttributeList " + this.fcNativeProperties.getWinNTAttributeList());
            mgmtLog.log(Level.INFO, " nonExchPropList " + this.fcNativeProperties.getNonExchAttributeList());
            mgmtLog.log(Level.INFO, " GroupsList " + fullGroupList);
            mgmtLog.log(Level.INFO, " customList " + customList);
            mgmtLog.log(Level.INFO, " exchCustomList " + exchCustomList);
            mgmtLog.log(Level.INFO, " lyncDetails " + this.lyncDetails);
            mgmtLog.log(Level.INFO, " UM Policy Details" + (Properties)props.get("msExchUMMailBoxPolicy"));
            mgmtLog.log(Level.INFO, " Retention Policy Details" + props.get("msExchMailboxTemplateLink"));
            mgmtLog.log(Level.INFO, " Managed Mailbox Policy Details::" + props.get("msExchMailboxRecipientTemplate"));
            mgmtLog.log(Level.INFO, " Address Policy Details" + props.get("msExchAddressBookPolicyLink"));
            mgmtLog.log(Level.INFO, " CustomScriptDetails: " + (Properties)props.get("customScriptDetails"));
            mgmtLog.log(Level.INFO, " msExchArchiveDatabaseLink " + archiveDB);
            mgmtLog.log(Level.INFO, " msExchArchiveAddress " + archiveDomain);
            if (props.getProperty("homeMDB") != null) {
                mgmtLog.log(Level.INFO, "Home MDB: " + props.getProperty("homeMDB"));
            }
            this.auditLogProps.put(this.rb.getString("admp.common.attrib_disp_name.dn_domain_name"), this.domainName);
            this.auditLogProps.put(this.rb.getString("admp.common.attrib_disp_name.container_name"), this.ouName);
            this.auditLogProps.put(this.rb.getString("admp.common.attrib_disp_name.user_name"), this.userName);
            this.auditLogProps.put(this.rb.getString("admp.common.attrib_disp_name.sam_name"), this.samAccountName);
            this.auditLogProps.put("propList", this.fcNativeProperties.getPropList());
            this.auditLogProps.put("modifyList", this.fcNativeProperties.getModifyList());
            this.auditLogProps.put("winNTAttributeList", this.fcNativeProperties.getWinNTAttributeList());
            this.auditLogProps.put(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_properties"), this.fcNativeProperties.getTsList());
            this.auditLogProps.put("nonExchPropList", this.fcNativeProperties.getNonExchAttributeList());
            this.auditLogProps.put("groupList", fullGroupList);
            ArrayList<Hashtable> customListforLog = new ArrayList<Hashtable>(customList);
            customListforLog.addAll(exchCustomList);
            this.auditLogProps.put("customList", customListforLog);
            if (props.get("msExchUMMailBoxPolicy") != null) {
                this.auditLogProps.put("UM Policy Details", (Properties)props.get("msExchUMMailBoxPolicy"));
            }
            if (props.get("msExchMailboxTemplateLink") != null) {
                this.auditLogProps.put("Retention Policy Details", props.get("msExchMailboxTemplateLink"));
            }
            if (props.getProperty("homeMDB") != null) {
                this.auditLogProps.put("Home MDB", props.getProperty("homeMDB"));
            }
            if (dialIn != null && !dialIn.equals("")) {
                this.auditLogProps.put(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.dial_in"), dialIn);
            }
            if (props.get("customScriptDetails") != null) {
                this.auditLogProps.put("CustomScriptDetails", (Properties)props.get("customScriptDetails"));
            }
            if (props.get("preventDeletion") != null) {
                this.auditLogProps.put("preventDeletion", (String)props.get("preventDeletion"));
            }
            if (archiveDB != null) {
                this.auditLogProps.put("msExchArchiveDatabaseLink", archiveDB);
            }
            if (archiveDomain != null) {
                this.auditLogProps.put("msExchArchiveAddress", archiveDomain);
            }
            if (this.fcNativeProperties.getTsList().size() > 0 && dialIn == null) {
                dialIn = "";
            }
            String CREATION_STATUS = null;
            this.statusObject = usePowerShell ? ADHandler.addUser((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)this.userName, (String)this.samAccountName, (String)this.password, (ArrayList)this.fcNativeProperties.getNonExchAttributeList(), (ArrayList)this.fcNativeProperties.getModifyList(), (ArrayList)this.fcNativeProperties.getTsList(), (ArrayList)this.fcNativeProperties.getWinNTAttributeList(), (ArrayList)this.groupList, (ArrayList)this.fcNativeProperties.getEssentialPropertiesList(), null, (String)dialIn, (String)upn) : ADHandler.addUser((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)this.userName, (String)this.samAccountName, (String)this.password, (ArrayList)this.fcNativeProperties.getPropList(), (ArrayList)this.fcNativeProperties.getModifyList(), (ArrayList)this.fcNativeProperties.getTsList(), (ArrayList)this.fcNativeProperties.getWinNTAttributeList(), (ArrayList)this.groupList, (ArrayList)this.fcNativeProperties.getEssentialPropertiesList(), (String)mailBoxStore, (String)dialIn, (String)upn);
            this.nativeStatusProps = this.isBulkMgmt ? this.getBulkUserErrorMessage(this.statusObject) : this.getSingleUserErrorMessage(this.statusObject);
            CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !customList.isEmpty()) {
                NativeError customError = null;
                customError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, null, customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                if (!this.isBulkMgmt) {
                    AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)searchString);
                } else {
                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)searchString);
                }
            }
            if (props.get("sendAs") != null) {
                Hashtable sendAsResultHash = new Hashtable();
                String sendAsErrorMsg = "";
                ArrayList sendAsSidList = (ArrayList)props.get("sendAs");
                sendAsResultHash = this.updateSendAsAttribute(sendAsSidList, distinguishedName, "add");
                sendAsErrorMsg = this.getErrorStringForSendAs(sendAsResultHash, sendAsErrorMsg);
                if (sendAsErrorMsg.trim().length() > 0) {
                    if (!this.isBulkMgmt) {
                        this.setSingleUserErrorMessage(sendAsErrorMsg);
                    } else {
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString(sendAsErrorMsg));
                    }
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && enableRemoteMailbox != null && enableRemoteMailbox.equalsIgnoreCase("true")) {
                String remoteMbxResult = "";
                if (exchangeServerDetails != null && exchangeServerDetails.size() > 0) {
                    remoteMbxResult = ADHandler.enableRemoteMailbox((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)remoteRoutingAddress, (boolean)enableArchiveMailbox, (Properties)exchangeServerDetails);
                    if (newProxyAddressList.size() != 0 && remoteMbxResult.length() == 0) {
                        PowerShellCommand powerShellCommand = new PowerShellCommand("Set-RemoteMailbox");
                        powerShellCommand.setIdentity(remoteRoutingAddress);
                        powerShellCommand.addParameter("EmailAddresses", newProxyAddressList);
                        if (waadExchPoliciesExcluded) {
                            powerShellCommand.addParameter("EmailAddressPolicyEnabled", false);
                        }
                        remoteMbxResult = ADHandler.executePowershellCMD((String)this.domainName, (Long)this.loginId, (String)distinguishedName, (PowerShellCommand)powerShellCommand, (Properties)exchangeServerDetails);
                    }
                } else {
                    remoteMbxResult = this.rb.getString("admp.mgmt.contact_mgmt.create_contact.input_text.no_exch_admin_grps_available");
                }
                if (remoteMbxResult.length() != 0) {
                    if (!this.isBulkMgmt) {
                        this.rusMessage = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_creating_remote_mailbox"), this.rb.getString(remoteMbxResult)) + this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot");
                    } else {
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_creating_remote_mailbox"), this.rb.getString(remoteMbxResult)));
                    }
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                ArrayList<Hashtable> list;
                if (mailBoxEnabled && exchVersion == 2003) {
                    this.rusMessage = this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.mailboxes_get_reflected_according_update_interval_RUS");
                }
                UserMgmtUtil.setUserCannotChangePass((boolean)this.newCantChangePwdValue, (boolean)this.newCantChangePwdValue, (String)this.domainName, (Long)this.loginId, (String)distinguishedName, (String)new String());
                ArrayList mbrRights = new ArrayList();
                if (this.permissionProps.containsKey("mailBox") && mailBoxEnabled) {
                    Properties mailBoxPermissionProp = (Properties)this.permissionProps.get("mailBox");
                    mbrRights = (ArrayList)mailBoxPermissionProp.get("folderPermissions");
                    for (Object object : mbrRights) {
                        Properties properties = (Properties)object;
                        String objectDN = properties.getProperty("DN");
                        list = UserPermissionsUtil.searchSIDs((String)"DN_STRING", (String)objectDN, (String)this.domainName);
                        if (list.size() > 0) {
                            Properties sidProp = (Properties)list.get(0);
                            String objectSID = sidProp.getProperty("SID_STRING");
                            if (!usePowerShell) continue;
                            properties.put("DN", objectSID);
                            continue;
                        }
                        if (!objectDN.equalsIgnoreCase("%userName%")) continue;
                        properties.remove("DN");
                        properties.put("DN", distinguishedName);
                    }
                }
                String message = "";
                if (usePowerShell) {
                    String hideFromAddrListErr;
                    if (mailBoxEnabled) {
                        String msg;
                        message = ADHandler.createMailBox2007((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)mailAlias, (String)mailBoxStore, (Properties)exchangeServerDetails, (ArrayList)mbrRights);
                        if (message.length() != 0) {
                            if (!this.isBulkMgmt) {
                                this.rusMessage = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.legacy_mailbox_created"), this.rb.getString(message)) + this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot");
                            } else {
                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.legacy_mailbox_created"), this.rb.getString(message)));
                            }
                        }
                        if (!(archiveDB == null || archiveDomain == null || archiveDB.equals("") && archiveDomain.equals(""))) {
                            if (exchVersion >= 2010) {
                                boolean isRemote = false;
                                if (!archiveDomain.equals("")) {
                                    isRemote = true;
                                }
                                msg = "";
                                msg = ADHandler.enableArchiveMailbox((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)archiveDB, (String)archiveDomain, (Properties)exchangeServerDetails, (boolean)isRemote);
                                if (msg.trim().length() > 0) {
                                    if (!this.isBulkMgmt) {
                                        this.rusMessage = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString(msg)) + this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot");
                                    } else {
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString(msg)));
                                    }
                                }
                            } else {
                                this.rusMessage = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString("")) + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_archive_mail"), this.rb.getString(mailBoxStore)) + this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot");
                            }
                        }
                        if (exchangePhotoFilePath != null) {
                            Hashtable hash3;
                            String uniqueOperationId2;
                            File photoFile2;
                            boolean setThumbnailPhoto = false;
                            if (exchVersion > 2010) {
                                msg = "";
                                msg = ADHandler.setExchangePhoto((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)exchangePhotoFilePath, (Properties)exchangeServerDetails);
                                if (msg.trim().length() > 0) {
                                    if (!this.isBulkMgmt) {
                                        this.rusMessage = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exchange_photo"), this.rb.getString(msg));
                                    } else {
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exchange_photo"), this.rb.getString(msg)));
                                    }
                                    setThumbnailPhoto = true;
                                }
                            } else {
                                if (!this.isBulkMgmt) {
                                    this.rusMessage = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exchange_photo"), this.rb.getString("")) + this.rb.getString("admp.mgmt.user_mgmt.create_mailbox.error.user_photo_version");
                                } else {
                                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exchange_photo"), this.rb.getString("")) + this.rb.getString("admp.mgmt.user_mgmt.create_mailbox.error.user_photo_version"));
                                }
                                setThumbnailPhoto = true;
                                setThumbnailPhoto = true;
                            }
                            if (setThumbnailPhoto && (photoFile2 = UserPhotoMgmtUtil.getMatchingFileForExecution((String)exchangePhotoFilePath, (String)"thumbnailPhoto", (String)(uniqueOperationId2 = (String)(hash3 = (Hashtable)props.get("exchangePhoto")).get("UNIQUE_OPERATION_ID")))).exists()) {
                                list = new ArrayList<Hashtable>();
                                UserPhotoMgmtUtil.updateHashWithThumbnailPhotoAttribute((File)photoFile2, (Hashtable)hash3);
                                list.add(hash3);
                                NativeError thumbnailPhotoError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, null, list, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                if (thumbnailPhotoError.getErrorList((Object)searchString).size() == 0) {
                                    if (!this.isBulkMgmt) {
                                        this.rusMessage = this.rusMessage + " " + this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_attrib_updated_successfully") + " " + this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot");
                                    } else {
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_attrib_updated_successfully"));
                                    }
                                }
                            }
                        }
                        if (props.get("msExchMailboxTemplateLink") != null) {
                            int index;
                            String retentionPolicy = props.getProperty("msExchMailboxTemplateLink");
                            if (mailBoxServer != null && (index = mailBoxServer.lastIndexOf("cn=")) != -1 && mailBoxServer.trim().length() > index + 3) {
                                String exchangeServerName = mailBoxServer.substring(index + 3);
                                String retentionPolicyResult = ADHandler.applyRetentionPolicy((String)this.domainName, (long)this.loginId, (String)exchangeServerName, (String)distinguishedName, (String)retentionPolicy, (Properties)exchangeServerDetails);
                                if (retentionPolicyResult.trim().length() > 0) {
                                    if (!this.isBulkMgmt) {
                                        this.setSingleUserErrorMessage(retentionPolicyResult);
                                    } else {
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString(retentionPolicyResult));
                                    }
                                }
                            }
                        }
                        if (props.get("msExchMailboxRecipientTemplate") != null) {
                            int index;
                            String retentionPolicy = props.getProperty("msExchMailboxRecipientTemplate");
                            if (mailBoxServer != null && (index = mailBoxServer.lastIndexOf("cn=")) != -1 && mailBoxServer.trim().length() > index + 3) {
                                String exchangeServerName = mailBoxServer.substring(index + 3);
                                String managedMailboxResult = ADHandler.applyManagedMBPolicy((String)this.domainName, (long)this.loginId, (String)exchangeServerName, (String)distinguishedName, (String)retentionPolicy, (Properties)exchangeServerDetails);
                                if (managedMailboxResult.trim().length() > 0) {
                                    if (!this.isBulkMgmt) {
                                        this.setSingleUserErrorMessage(managedMailboxResult);
                                    } else {
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString(managedMailboxResult));
                                    }
                                }
                            }
                        }
                        MgmtUtil.updateMailServer(this.fcNativeProperties.getPropList(), exchangeServerDetails);
                    } else if (mailEnabled && (message = ADHandler.createMailEnabled2007((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)mailAlias, (String)targetAddress, (Properties)exchangeServerDetails)).length() != 0) {
                        if (!this.isBulkMgmt) {
                            this.rusMessage = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.mail_enabled"), this.rb.getString(message)) + this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot");
                        } else {
                            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.mail_enabled"), this.rb.getString(message)));
                        }
                    }
                    if (message.length() == 0 && props.get("msExchHideFromAddressLists") != null && props.getProperty("msExchHideFromAddressLists").equalsIgnoreCase("true") && (hideFromAddrListErr = ADHandler.setExchangeAttribute((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)mailType, (String)"true", (Properties)exchangeServerDetails)).trim().length() > 0) {
                        if (!this.isBulkMgmt) {
                            this.setSingleUserErrorMessage(hideFromAddrListErr);
                        } else {
                            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString(hideFromAddrListErr));
                        }
                    }
                    NativeError exchPropError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, null, (ArrayList)this.fcNativeProperties.getPropList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                    if (!this.isBulkMgmt) {
                        AddUserErrorHandler.setSingleUserExchangeAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)exchPropError, (String)searchString);
                    } else {
                        AddUserErrorHandler.setBulkUserExchangeAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)exchPropError, (String)searchString);
                    }
                    if (!exchCustomList.isEmpty()) {
                        NativeError customError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, null, exchCustomList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                        if (!this.isBulkMgmt) {
                            AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)searchString);
                        } else {
                            AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)searchString);
                        }
                    }
                    if (mailBoxEnabled && message.length() == 0 && props.get("msExchUMMailBoxPolicy") != null) {
                        int index;
                        Properties umPolicyDetails = (Properties)props.get("msExchUMMailBoxPolicy");
                        mgmtLog.log(Level.INFO, " umPolicyDetails " + umPolicyDetails);
                        if (mailBoxServer != null && (index = mailBoxServer.lastIndexOf("cn=")) != -1 && mailBoxServer.trim().length() > index + 3) {
                            String exchangeServerName = mailBoxServer.substring(index + 3);
                            String umPolicyResult = ADHandler.enableUMMailbox((String)this.domainName, (long)this.loginId, (String)exchangeServerName, (String)distinguishedName, (String)((String)umPolicyDetails.get("policyName")), (String)((String)umPolicyDetails.get("extension")), (String)((String)umPolicyDetails.get("pin")), (String)((String)umPolicyDetails.get("resetPin")), (String)((String)umPolicyDetails.get("SIPResourceIdentifier")), (Properties)exchangeServerDetails);
                            if (umPolicyResult.trim().length() > 0) {
                                if (!this.isBulkMgmt) {
                                    this.setSingleUserErrorMessage(umPolicyResult);
                                } else {
                                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString(umPolicyResult));
                                }
                            }
                        }
                    }
                } else if (mailBoxEnabled) {
                    NativeError nativeError = ADHandler.setMailBoxPermission((String)this.domainName, (Long)this.loginId, (ArrayList)mbrRights, (String)distinguishedName);
                    if (!this.isBulkMgmt) {
                        AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"mailBoxRights");
                    } else {
                        AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"mailBoxRights");
                    }
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                boolean isDomainUserAMember = false;
                boolean isDomainUserPrimaryGrp = false;
                if (props.get("domainUsersGroupAvailable") != null) {
                    isDomainUserAMember = (Boolean)props.get("domainUsersGroupAvailable");
                }
                if (props.get("isDomainUsersPrimaryGroup") != null) {
                    isDomainUserPrimaryGrp = (Boolean)props.get("isDomainUsersPrimaryGroup");
                }
                if (!isDomainUserAMember && !isDomainUserPrimaryGrp && props.get("domainUserGroupSid") != null) {
                    ArrayList<Properties> list = new ArrayList<Properties>();
                    Properties p = new Properties();
                    p.put("ATTRIB_VALUE", distinguishedName);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_LDAP_NAME", "member");
                    p.put("DW_CONTROL_CODE", new Long(4L));
                    list.add(p);
                    try {
                        ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)this.loginId, (String)((String)props.get("domainUserGroupSid")), (String)distinguishedName, list, null);
                    }
                    catch (LocalizedException exp) {
                        String modifyGroupError = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.err_msg_setting_group"), exp.getMessage(this.rb));
                        if (this.isBulkMgmt) {
                            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + modifyGroupError);
                        }
                        this.setSingleUserErrorMessage(modifyGroupError);
                    }
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                if (!this.otherDomainGroupList.isEmpty()) {
                    mgmtLog.log(Level.INFO, " Other Domain Groups " + this.otherDomainGroupList);
                    StringBuilder otherDomainGroupError = new StringBuilder();
                    Enumeration<String> e2 = this.otherDomainGroupList.keys();
                    while (e2.hasMoreElements()) {
                        String groupDomain = e2.nextElement();
                        ArrayList<Properties> otherDomainGroups = this.otherDomainGroupList.get(groupDomain);
                        for (Properties otherDomainGroupProps : otherDomainGroups) {
                            String groupSID = otherDomainGroupProps.getProperty("SID_STRING");
                            ArrayList<Properties> list = new ArrayList<Properties>();
                            Properties p = new Properties();
                            p.put("ATTRIB_VALUE", distinguishedName);
                            p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                            p.put("DATA_HANDLER_TYPE", new Long(3L));
                            p.put("ATTRIB_LDAP_NAME", "member");
                            p.put("DW_CONTROL_CODE", new Long(3L));
                            list.add(p);
                            try {
                                ADHandlerForMgmt.modifyGroup((String)groupDomain, (Long)this.loginId, (String)groupSID, (String)distinguishedName, list, null);
                            }
                            catch (LocalizedException exp) {
                                System.out.println("Error while updating user in other domain groups - Domain : " + groupDomain + ", SID : " + groupSID + " Properties : " + list + " Login ID : " + this.loginId);
                                if (otherDomainGroupError.length() > 0) {
                                    otherDomainGroupError.append(", ");
                                }
                                otherDomainGroupError.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.err_msg_other_domain_groups"), otherDomainGroupProps.get("DISTINGUISHED_NAME"), exp.getErrorMsgList().get(1)));
                            }
                        }
                    }
                    if (otherDomainGroupError.length() > 0) {
                        String otherDomainGroupErrorStr = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.err_msg_other_domain_groups_str"), otherDomainGroupError.toString());
                        if (this.isBulkMgmt) {
                            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + otherDomainGroupErrorStr);
                        }
                    }
                }
                this.setGroupErrorMessage();
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                String tsRemoteHomeDir;
                NativeError nativeError2;
                Properties properties;
                String remoteHomeDir;
                if (this.permissionProps.containsKey("profilePath")) {
                    Properties properties2 = (Properties)this.permissionProps.get("profilePath");
                    long inheritLong = (Boolean)properties2.get("inheritPermissions") != false ? 0x20000000L : 0x80000000L;
                    String profilePath = (String)properties2.get("folderpath");
                    NativeError nativeError = ADHandlerForMgmt.createFolder((String)this.domainName, (Long)this.loginId, (String)profilePath, null, (String)CommonUtil.escapeDN((String)distinguishedName), (ArrayList)((ArrayList)properties2.get("folderPermissions")), (long)inheritLong);
                    this.auditLogProps.put(this.rb.getString("admp.ad_explorer.view_props.user.attrib_disp_name.profile_path"), profilePath);
                    if (!this.isBulkMgmt) {
                        AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"profilePath");
                    } else {
                        AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"profilePath");
                    }
                    String vistaprofile = (String)properties2.get("createVistaProfile");
                    if (vistaprofile.length() > 0) {
                        profilePath = profilePath + "." + (String)properties2.get("createVistaProfile");
                        NativeError nativeError1 = ADHandlerForMgmt.createFolder((String)this.domainName, (Long)this.loginId, (String)profilePath, null, (String)CommonUtil.escapeDN((String)distinguishedName), (ArrayList)((ArrayList)properties2.get("folderPermissions")), (long)inheritLong);
                        if (!this.isBulkMgmt) {
                            AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError1, (String)"vistaprofilePath");
                        } else {
                            AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError1, (String)"vistaprofilePath");
                        }
                    }
                }
                if (this.permissionProps.containsKey("tsProfilePath")) {
                    Properties properties3 = (Properties)this.permissionProps.get("tsProfilePath");
                    long inheritLong = (Boolean)properties3.get("inheritPermissions") != false ? 0x20000000L : 0x80000000L;
                    String profilePath = (String)properties3.get("folderpath");
                    NativeError nativeError = ADHandlerForMgmt.createFolder((String)this.domainName, (Long)this.loginId, (String)profilePath, null, (String)CommonUtil.escapeDN((String)distinguishedName), (ArrayList)((ArrayList)properties3.get("folderPermissions")), (long)inheritLong);
                    this.auditLogProps.put(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_profile_path"), profilePath);
                    if (!this.isBulkMgmt) {
                        AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"tsProfilePath");
                    } else {
                        AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"tsProfilePath");
                    }
                }
                if (this.permissionProps.containsKey("homeFolder") && !(remoteHomeDir = (String)(properties = (Properties)this.permissionProps.get("homeFolder")).get("remoteHomeDir")).equals("") && remoteHomeDir.startsWith("\\")) {
                    long inheritLong = (Boolean)properties.get("inheritPermissions") != false ? 0x20000000L : 0x80000000L;
                    NativeError nativeError = ADHandlerForMgmt.createFolder((String)this.domainName, (Long)this.loginId, (String)remoteHomeDir, null, (String)CommonUtil.escapeDN((String)distinguishedName), (ArrayList)((ArrayList)properties.get("folderPermissions")), (long)inheritLong);
                    this.auditLogProps.put(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.remote_home_dir"), remoteHomeDir);
                    if (!this.isBulkMgmt) {
                        AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"homeDir");
                    } else {
                        AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"homeDir");
                    }
                    if (nativeError.getErrors() == null && ((Boolean)properties.get("createShare")).booleanValue()) {
                        nativeError2 = ADHandler.shareFolder((String)this.domainName, (Long)this.loginId, (String)((String)properties.get("serverName")), (String)((String)properties.get("shareName")), (String)((String)properties.get("localPath")), (ArrayList)((ArrayList)properties.get("sharePermissions")));
                        if (!this.isBulkMgmt) {
                            AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError2, (String)"homeDirShare");
                        } else {
                            AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError2, (String)"homeDirShare");
                        }
                    }
                }
                if (this.permissionProps.containsKey("tsHomeFolder") && !(tsRemoteHomeDir = (String)(properties = (Properties)this.permissionProps.get("tsHomeFolder")).get("remoteHomeDir")).equals("") && tsRemoteHomeDir.startsWith("\\")) {
                    long inheritLong = (Boolean)properties.get("inheritPermissions") != false ? 0x20000000L : 0x80000000L;
                    NativeError nativeError = ADHandlerForMgmt.createFolder((String)this.domainName, (Long)this.loginId, (String)tsRemoteHomeDir, null, (String)CommonUtil.escapeDN((String)distinguishedName), (ArrayList)((ArrayList)properties.get("folderPermissions")), (long)inheritLong);
                    this.auditLogProps.put(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_remote_home_dir"), tsRemoteHomeDir);
                    if (!this.isBulkMgmt) {
                        AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"tsHomeDir");
                    } else {
                        AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"tsHomeDir");
                    }
                    if (nativeError.getErrors() == null && ((Boolean)properties.get("createShare")).booleanValue()) {
                        nativeError2 = ADHandler.shareFolder((String)this.domainName, (Long)this.loginId, (String)((String)properties.get("serverName")), (String)((String)properties.get("shareName")), (String)((String)properties.get("localPath")), (ArrayList)((ArrayList)properties.get("sharePermissions")));
                        if (!this.isBulkMgmt) {
                            AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError2, (String)"tsHomeDirShare");
                        } else {
                            AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError2, (String)"tsHomeDirShare");
                        }
                    }
                }
                if (this.isLyncEnabled) {
                    String referrerPoolName = (String)this.lyncDetails.get("lyncRegistrarPoolName");
                    String primarySIPAddress = (String)this.lyncDetails.get("lyncSipAddress");
                    if (!primarySIPAddress.startsWith("sip:") && !primarySIPAddress.startsWith("SIP:")) {
                        primarySIPAddress = "sip:" + primarySIPAddress;
                    }
                    boolean lyncEnabled = true;
                    String dcFqdn = this.getValidDCForLyncOperations(this.domainName, this.loginId, this.ouName);
                    String errorMessage = ADHandler.enableUserForLync((String)upn, (String)referrerPoolName, (String)primarySIPAddress, (String)this.domainName, (Long)this.loginId, (String)dcFqdn);
                    if (errorMessage.length() != 0) {
                        mgmtLog.log(Level.INFO, " lync_enabling_error " + errorMessage);
                        if (!this.isBulkMgmt) {
                            this.setSingleUserErrorMessage(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.error_str.error_enabling_user") + " - " + this.rb.getString(errorMessage));
                        } else {
                            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.error_str.error_enabling_user") + " " + this.rb.getString(errorMessage));
                        }
                        lyncEnabled = false;
                    }
                    if (lyncEnabled) {
                        String telephonyError;
                        Properties telephonyProp;
                        ArrayList policyList = (ArrayList)this.lyncDetails.get("lyncPolicies");
                        if (policyList != null) {
                            ArrayList policyListForAD = FcLayoutUtil.getPoliciesForAD((ArrayList)policyList);
                            ArrayList grantPolicyErrors = ADHandlerForMgmt.grantPolicyforUser((ArrayList)policyListForAD, (String)upn, (String)this.domainName, (Long)this.loginId, (String)referrerPoolName, (String)dcFqdn);
                            for (int errorIndex = 0; errorIndex < grantPolicyErrors.size(); ++errorIndex) {
                                Properties policyStatusProp = (Properties)grantPolicyErrors.get(errorIndex);
                                String policyError = (String)policyStatusProp.get("IsSuccess");
                                String policyType = this.rb.getString("admp.mgmt.user_mgmt.cre_template.heading_" + (String)policyStatusProp.get("POLICY_TYPE"));
                                if (policyError == null || policyError.length() <= 0 || policyError.equalsIgnoreCase("true")) continue;
                                if (!this.isBulkMgmt) {
                                    this.setSingleUserErrorMessage(this.rb.getString(policyError));
                                    continue;
                                }
                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString(policyError));
                            }
                        }
                        String lineURI = (String)this.lyncDetails.get("lyncLineUri");
                        String lineServerURI = (String)this.lyncDetails.get("lyncLineServerUri");
                        String telephonyType = (String)this.lyncDetails.get("lyncTelephonyType");
                        ArrayList<Properties> telephonyList = new ArrayList<Properties>();
                        if (lineURI != null && lineURI.trim().length() > 0) {
                            telephonyProp = new Properties();
                            telephonyProp.put("PARAMETER", "LineURI");
                            telephonyProp.put("VALUE", lineURI);
                            telephonyList.add(telephonyProp);
                        }
                        if (lineServerURI != null && lineServerURI.trim().length() > 0) {
                            telephonyProp = new Properties();
                            telephonyProp.put("PARAMETER", "LineServerURI");
                            telephonyProp.put("VALUE", lineServerURI);
                            telephonyList.add(telephonyProp);
                        }
                        if (telephonyType != null && telephonyType.trim().length() > 0 && !telephonyType.equalsIgnoreCase("PcToPcOnly")) {
                            if (telephonyType.equalsIgnoreCase("RemoteCallControlOnly")) {
                                Properties telephonyProp1 = new Properties();
                                Properties telephonyProp2 = new Properties();
                                telephonyProp1.put("PARAMETER", "RemoteCallControlTelephonyEnabled");
                                telephonyProp1.put("VALUE", "$true");
                                telephonyProp2.put("PARAMETER", "AudioVideoDisabled");
                                telephonyProp2.put("VALUE", "$true");
                                telephonyList.add(telephonyProp1);
                                telephonyList.add(telephonyProp2);
                            } else {
                                telephonyProp = new Properties();
                                telephonyProp.put("PARAMETER", telephonyType);
                                telephonyProp.put("VALUE", "$true");
                                telephonyList.add(telephonyProp);
                            }
                        }
                        if (telephonyList.size() > 0 && (telephonyError = ADHandlerForMgmt.enableTelephonyOptions((String)upn, telephonyList, (String)this.domainName, (Long)this.loginId, (String)referrerPoolName, (String)dcFqdn)).length() != 0) {
                            mgmtLog.log(Level.INFO, " lync_telephony_error " + telephonyError);
                            if (!this.isBulkMgmt) {
                                this.setSingleUserErrorMessage(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.error_str.error_setting_telephony_options") + " - " + this.rb.getString(telephonyError));
                            } else {
                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.error_str.error_setting_telephony_options") + " " + this.rb.getString(telephonyError));
                            }
                        }
                    }
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && this.removedProxyAddresses.size() > 0) {
                StringBuilder proxyError = new StringBuilder();
                for (int index = 0; index < this.removedProxyAddresses.size(); ++index) {
                    Hashtable hash4 = (Hashtable)this.removedProxyAddresses.get(index);
                    if (index > 0) {
                        proxyError.append(", ");
                    }
                    String proxyAddress = (String)hash4.get("PROXY_ADDRESS");
                    String assignedUserName = (String)hash4.get("USER_NAME");
                    proxyError.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.msg_proxy_already_exist_for_the_user"), proxyAddress, assignedUserName));
                }
                String proxyErrorString = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.error_str.error_removed_proxy_addresses"), proxyError.toString());
                if (this.isBulkMgmt) {
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + proxyErrorString);
                } else {
                    Hashtable<String, String> errorHash = new Hashtable<String, String>();
                    errorHash.put("ERROR_MESSAGE", proxyErrorString);
                    errorHash.put("NATIVE_ERROR_MESSAGE", ".");
                    if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                        ArrayList<Hashtable<String, String>> errorList = new ArrayList<Hashtable<String, String>>();
                        errorList.add(errorHash);
                        this.nativeStatusProps.put("CREATION_MESSAGE", errorList);
                    } else {
                        for (int index = 0; index < this.removedProxyAddresses.size(); ++index) {
                            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(errorHash);
                        }
                    }
                }
                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            }
            ArrayList propList = this.fcNativeProperties.getPropList();
            if (!CREATION_STATUS.equals("SEVERE") && props.get("preventDeletion") != null) {
                String preventDeletion = (String)props.get("preventDeletion");
                if (preventDeletion.equalsIgnoreCase("true")) {
                    this.updatePreventDeletion("CN=" + this.userName + "," + this.ouName, "add");
                    String defaultNamingcontext = DomainUtil.getDefaultNamingContext((String)this.domainName);
                    if (!this.ouName.equalsIgnoreCase(defaultNamingcontext)) {
                        this.updateParent(this.ouName);
                    }
                }
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                grpList.put("ATTRIB_VALUE", (String)props.get("preventDeletion"));
                propList.add(grpList);
            }
            if ((customScriptProps = (Properties)props.get("customScriptDetails")) != null) {
                boolean ignoreWarning = (Boolean)customScriptProps.get("IGNORE_WARNING");
                if (CREATION_STATUS.equalsIgnoreCase("SUCCESS") || ignoreWarning && CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                    this.customScriptResult = this.customScriptExecution(customScriptProps);
                    if (this.isBulkMgmt && this.customScriptResult != null && !this.customScriptResult.equals("")) {
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.customScriptResult);
                    }
                }
            }
            if (exchangePhotoFilePath != null && props.get("msExchHomeServerName") == null && (photoFile = UserPhotoMgmtUtil.getMatchingFileForExecution((String)exchangePhotoFilePath, (String)"thumbnailPhoto", (String)(uniqueOperationId = (String)(hash = (Hashtable)props.get("exchangePhoto")).get("UNIQUE_OPERATION_ID")))).exists()) {
                ArrayList<Hashtable> list = new ArrayList<Hashtable>();
                UserPhotoMgmtUtil.updateHashWithThumbnailPhotoAttribute((File)photoFile, (Hashtable)hash);
                list.add(hash);
                NativeError thumbnailPhotoError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, null, list, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                if (thumbnailPhotoError.getErrorList((Object)searchString).size() == 0) {
                    this.photoFileError = this.photoFileError + " " + this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_attrib_updated_successfully");
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && this.photoFileError.length() > 0) {
                mgmtLog.log(Level.INFO, " photo_file_error ");
                if (!this.isBulkMgmt) {
                    this.setSingleUserErrorMessage(this.photoFileError);
                } else {
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.photoFileError);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            if (this.isBulkMgmt) {
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.internal_error"));
            }
            this.setSingleUserErrorMessage(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.internal_error"));
        }
    }

    public void addAttributeToNativeProps(FcFormDataContainer fromClientData, FcNativeProperties fcNativeProperties, Properties ldapVsValueProps, String objectClass) throws Exception {
        this.getProperties(false, fromClientData, fcNativeProperties, ldapVsValueProps, objectClass);
    }

    public Long updateAuditEntries() {
        return this.updateAuditEntries(null);
    }

    public Long updateAuditEntries(ArrayList<Long> auditObjectIdList) {
        Long audit_id = 0L;
        Long object_id = 0L;
        try {
            boolean savePassword;
            NotificationMacro macro;
            if (!this.isBulkMgmt) {
                Long objectCreationId;
                this.creationId = objectCreationId = FcExecuteFormFlow.getNewObjectCreationId();
                this.objectIndexId = FcExecuteFormFlow.getNewObjectIndexId(objectCreationId, this.executeLayout.getLayoutId());
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                JSONArray selectedIamAppsJsonArray = this.executeLayout.getSelectedIamAppsJsonArray();
                FcLayoutBulkViewHandler.addSelectedIamAppsRow((DataObject)dataObj, (Long)this.objectIndexId, (int)FcExecuteActionConstants.resultDataId, (JSONArray)selectedIamAppsJsonArray, (Long)FcExecuteActionConstants.userCreationTemplateCategoryId);
                FcBulkExecuteFormFlow.fillDataObject(dataObj, this.objectIndexId, FcExecuteActionConstants.resultDataId, this.fromClientData, FcExecuteActionConstants.userCreationTemplateCategoryId);
                FcBulkExecuteFormFlow.fillDataObject(dataObj, this.objectIndexId, FcExecuteActionConstants.resultDataId, this.customFieldsContainer, FcExecuteActionConstants.userCreationTemplateCategoryId);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
                if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                    FcMgmtListener.RefreshAction refreshAction = new FcMgmtListener.RefreshAction(this);
                    refreshAction.start();
                }
            } else if (this.isWorkflowExcution) {
                ArrayList selectedIamAppsList = FcLayoutBulkViewHandler.getSelectedIamAppIdForObjectIndexId((Long)this.objectIndexId);
                JSONArray selectedIamAppsJsonArray = new JSONArray();
                for (Integer iamAppId : selectedIamAppsList) {
                    selectedIamAppsJsonArray.put((Object)iamAppId);
                }
                FcBulkExecuteFormFlow.deleteObjectIndexDetails(new Long[]{this.objectIndexId}, new Integer[]{FcExecuteActionConstants.resultDataId}, FcExecuteActionConstants.userCreationTemplateCategoryId);
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                FcLayoutBulkViewHandler.addSelectedIamAppsRow((DataObject)dataObj, (Long)this.objectIndexId, (int)FcExecuteActionConstants.resultDataId, (JSONArray)selectedIamAppsJsonArray, (Long)FcExecuteActionConstants.userCreationTemplateCategoryId);
                FcBulkExecuteFormFlow.fillDataObject(dataObj, this.objectIndexId, FcExecuteActionConstants.resultDataId, this.fromClientData, FcExecuteActionConstants.userCreationTemplateCategoryId);
                FcBulkExecuteFormFlow.fillDataObject(dataObj, this.objectIndexId, FcExecuteActionConstants.resultDataId, this.customFieldsContainer, FcExecuteActionConstants.userCreationTemplateCategoryId);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            }
            this.updateModifiedFieldValuesinDB(FcExecuteActionConstants.userCreationTemplateCategoryId);
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Integer reportId = ReportsUtil.SINGLE_USER_CREATION_REPORT_ID;
            if (this.isBulkMgmt && !this.isSUCWorkflowMode) {
                reportId = ReportsUtil.BULK_USER_CREATION_REPORT_ID;
            }
            if (this.moduleUsed == null || this.moduleUsed.isEmpty()) {
                this.moduleUsed = this.workFlowType == 2L ? this.rb.getString("admp.workflow.listrequest.request_mode.ssp_api_request") : (this.workFlowType == 1L ? this.rb.getString("admp.auto.automation.heading.automation") : (this.workFlowType == 0L ? this.rb.getString("admp.home.feature.heading.workflow") : ""));
            }
            audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)this.moduleUsed, (Long)this.requestId);
            object_id = this.samAccountName != null && this.samAccountName.length() > 0 ? HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (Long)this.objectIndexId, (Long)FcExecuteActionConstants.userCreationTemplateCategoryId, (String)this.samAccountName, (String)this.domainName, (DataObject)auditDataObj) : HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (Long)this.objectIndexId, (Long)FcExecuteActionConstants.userCreationTemplateCategoryId, (String)this.displayName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            if (auditObjectIdList != null && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE")) {
                auditObjectIdList.add(object_id);
            }
            String status = "";
            if (!this.isBulkMgmt) {
                ArrayList creationMsg;
                String statusMsg = this.nativeStatusProps.getProperty("STATUS_MESSAGE");
                if (statusMsg != null) {
                    status = status + statusMsg;
                }
                if ((creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")) != null && !creationMsg.isEmpty()) {
                    if (status != null && status.trim().length() > 0) {
                        status = status + this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text_but_follng_error_occured");
                    }
                    for (int i = 0; i < creationMsg.size(); ++i) {
                        Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                        String errorCode = (String)creationMessage.get("ERROR_CODE");
                        if (errorCode != null && !errorCode.equalsIgnoreCase("0")) {
                            status = status + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + errorCode + " : ";
                        }
                        status = status + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE"));
                        if (creationMessage.get("NATIVE_ERROR_MESSAGE") == null) continue;
                        status = status + creationMessage.get("NATIVE_ERROR_MESSAGE");
                    }
                }
                if (!this.rusMessage.equals("")) {
                    status = status + " " + this.rusMessage;
                }
            } else {
                status = (String)this.nativeStatusProps.get("CREATION_MESSAGE");
                if (this.rusMessage.trim().length() > 0) {
                    status = status + " " + this.rusMessage;
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", status);
                }
            }
            if (status.contains(this.rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"))) {
                status = status.replace(this.rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"), "");
            }
            audit_info.put("error_msg", status);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            TechAuditAPI.getInstance().auditLogs(this.loginId, this.auditLogProps, status, this.rb.getString("admp.workflow.requesters.modify_requester.user_creation"), this.rb);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("NO_AD")) {
                Properties hdtProp = HelpdeskUtil.getHDTProp((Long)this.loginId, (AdventNetResourceBundle)this.rb);
                String hdtName = hdtProp.getProperty("FULL_NAME");
                this.auditLogProps.put("technicianName", hdtName);
                if (this.isBulkMgmt && !this.isSUCWorkflowMode) {
                    this.sendSysLogs(this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.cre_bulk_user"), status, this.auditLogProps);
                } else {
                    this.sendSysLogs(this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.cre_single_user"), status, this.auditLogProps);
                }
            }
            if (this.workFlowType != 0L && !this.isBulkMgmt && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("SEVERE")) {
                Integer userObjectId = 1;
                String manager = "";
                FcLayoutField field = this.userData.get((Object)FcExecuteActionConstants.USER_CREATION_MANAGER_FIELD_ID) != null ? (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.USER_CREATION_MANAGER_FIELD_ID) : (FcLayoutField)this.fromClientData.get((Object)FcExecuteActionConstants.USER_CREATION_MANAGER_FIELD_ID);
                if (field != null) {
                    FcManager fcManager = (FcManager)field.getIComponent();
                    manager = fcManager.getUserName() != null ? fcManager.getUserName() : "";
                }
                this.viewId = FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID;
                ArrayList<String> objectOUList = new ArrayList<String>();
                objectOUList.add(this.ouName);
                this.triggerNotifiation(audit_id, object_id, this.samAccountName, manager, this.password, userObjectId, ReportsUtil.SINGLE_USER_CREATION_REPORT_ID, this.domainName, this.rb, objectOUList);
            }
            if (this.isWorkflowExcution() && (macro = (NotificationMacro)NotificationTemplateHandler.macroMap.get(this.wfRequestId)) != null && AutomationUtil.isNotifyEnabledAutomation((Long)((Long)macro.getIds().get("automationId")))) {
                if (this.auditDataObject != null) {
                    this.auditDataObject.merge(auditDataObj);
                } else {
                    this.auditDataObject = auditDataObj;
                }
            }
            if (savePassword = PasswordUtil.getSavePasswordValue()) {
                FcLayoutUpdateHandler.updatePwdInUserMgmtAction((Long)this.objectIndexId, (String)this.password);
            } else if (this.isBulkLayoutMgmt || this.workFlowType == 0L || this.workFlowType == 1L) {
                FcLayoutUpdateHandler.updatePwdInUserMgmtAction((Long)this.objectIndexId, (String)this.password);
            } else {
                FcLayoutUpdateHandler.updatePwdInUserMgmtAction((Long)this.objectIndexId, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return audit_id;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HashMap ldapToDisplayMapping() {
        HashMap<Integer, Properties> mapList = new HashMap<Integer, Properties>();
        if (this.isADSelected) {
            try {
                ArrayList columnList = ColumnConfiguration.getColumnList((long)FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID, (int)2);
                Enumeration e = this.fromClientData.elements();
                while (e.hasMoreElements()) {
                    FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                    ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                    for (FcAttributes fcAttribute : fcAttributeList) {
                        Object attributeValue = fcAttribute.getAttribValue();
                        String string = fcAttribute.getAttribColumnName();
                        Properties prop = new Properties();
                        for (int k = 0; k < columnList.size(); ++k) {
                            HashMap map = (HashMap)columnList.get(k);
                            if (!map.containsValue(string)) continue;
                            if (attributeValue == null) {
                                attributeValue = "-";
                            }
                            prop.put(map.get("COLUMN_NAME"), attributeValue);
                            mapList.put(k, prop);
                        }
                    }
                }
                if (this.customFieldsContainer == null) return mapList;
                Properties propLdap = new Properties();
                propLdap.put("domainName", this.domainName);
                Properties ldapVsValueProps = FcUserCreationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, propLdap);
                ArrayList<Hashtable> customList = this.getCustomAttribsProperties(this.customFieldsContainer, false, ldapVsValueProps, "user");
                for (Hashtable customHash : customList) {
                    Object v = customHash.get("ATTRIB_VALUE");
                    Object attribLdapName = customHash.get("ATTRIB_LDAP_NAME");
                    Properties prop = new Properties();
                    for (int k = 0; k < columnList.size(); ++k) {
                        void var9_21;
                        HashMap map = (HashMap)columnList.get(k);
                        if (!map.containsValue(attribLdapName)) continue;
                        if (var9_21 == null) {
                            String string = "-";
                        }
                        prop.put(map.get("COLUMN_NAME"), (Object)var9_21);
                        mapList.put(k, prop);
                    }
                }
                return mapList;
            }
            catch (Exception e) {
                e.printStackTrace();
                return mapList;
            }
        }
        try {
            Enumeration e = this.fromClientData.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                for (FcAttributes fcAttribute : fcAttributeList) {
                    Object attributeValue = fcAttribute.getAttribValue();
                    String columnName = fcAttribute.getAttribColumnName();
                    Properties properties = new Properties();
                    if (attributeValue == null) {
                        attributeValue = "-";
                    }
                    if (columnName.equalsIgnoreCase("PASSWORD")) {
                        properties.put("admp.common.attrib_disp_name.password", attributeValue);
                        mapList.put(1, properties);
                        continue;
                    }
                    if (!columnName.equalsIgnoreCase("DISPLAY_NAME")) continue;
                    properties.put("admp.mgmt.fc_layout.field_name_display_name", attributeValue);
                    mapList.put(0, properties);
                }
            }
            return mapList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapList;
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
        HashMap list = this.ldapToDisplayMapping();
        request.setAttribute("list", (Object)list);
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
        request.setAttribute("passwordType", (Object)this.passwordType);
        request.setAttribute("customScriptResult", (Object)this.customScriptResult);
        request.setAttribute("rusMessage", (Object)this.rusMessage);
        this.updateAuditEntries();
    }

    @Override
    public void setStatusMsgForWorkFlowResponse(HttpServletRequest request, Long requestId) {
        HashMap list = this.ldapToDisplayMapping();
        request.setAttribute("list", (Object)list);
        request.setAttribute("passwordType", (Object)this.passwordType);
        Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
        if (!LicenseMgr.getInstance().isTrailEdition() && !errorId.booleanValue()) {
            this.nativeStatusProps.setProperty("STATUS_MESSAGE", LicenseMgr.getInstance().getlicenseMessage("Workflow", this.rb));
            this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
        } else if (!this.isBulkMgmt) {
            if (requestId.compareTo(-2L) == 0) {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), requestId.toString()));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            } else if (requestId.compareTo(-1L) != 0) {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_success"), requestId.toString()));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
            } else {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_failure"));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            }
        }
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
    }

    public void setIsCreationSuccess() {
        if (this.nativeStatusProps != null) {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                this.setIsCreationSuccess(true);
            }
        } else {
            this.setIsCreationSuccess(false);
        }
    }

    public void setSingleUserErrorMessage(String errorMessage) {
        ArrayList messageList = new ArrayList();
        messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
        if (messageList == null) {
            messageList = new ArrayList();
        }
        Hashtable<String, String> errorHash = new Hashtable<String, String>();
        errorHash.put("ERROR_MESSAGE", errorMessage);
        messageList.add(errorHash);
        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
    }

    public Properties getSingleUserErrorMessage(NativeError statusObject) {
        String statusMessage = this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.success_created_user");
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        String errorSeverity = null;
        String ouName = CommonUtil.escapeDN((String)this.ouName);
        if (statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.domainName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.domainName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            if (errorSeverity != null && !errorSeverity.equalsIgnoreCase("SEVERE")) {
                statusProps.setProperty("STATUS_MESSAGE", statusMessage);
            } else {
                statusProps.setProperty("STATUS_MESSAGE", "");
            }
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)ouName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)ouName);
            errorSeverity = statusObject.getSeverityLevel((Object)ouName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            if (errorSeverity != null && !errorSeverity.equalsIgnoreCase("SEVERE")) {
                statusProps.setProperty("STATUS_MESSAGE", statusMessage);
            } else {
                statusProps.setProperty("STATUS_MESSAGE", "");
            }
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.userName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.userName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.userName);
            if (errorSeverity != null && !errorSeverity.equalsIgnoreCase("SEVERE")) {
                statusProps.setProperty("STATUS_MESSAGE", statusMessage);
            } else {
                statusProps.setProperty("STATUS_MESSAGE", "");
            }
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (!errorList.isEmpty()) {
            for (Hashtable hashtable : errorList) {
                messageList.add(hashtable);
            }
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) == null || (errorList = statusObject.getErrorList(object)).isEmpty()) continue;
            for (Hashtable hashtable : errorList) {
                messageList.add(hashtable);
            }
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("STATUS_MESSAGE", statusMessage);
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    public Properties getBulkUserErrorMessage(NativeError statusObject) {
        Properties statusProps = new Properties();
        StringBuilder messageBuilder = new StringBuilder();
        StringBuilder errCodeBuilder = new StringBuilder();
        String message = null;
        String errorSeverity = null;
        String ouName = CommonUtil.escapeDN((String)this.ouName);
        if (statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.domainName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.domainName);
            errCodeBuilder.append(this.getErrorCodes(this.domainName, statusObject));
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", message);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)ouName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)ouName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)ouName);
            errCodeBuilder.append(this.getErrorCodes(this.domainName, statusObject));
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.setProperty("CREATION_MESSAGE", message);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.userName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.userName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.userName);
            errCodeBuilder.append(this.getErrorCodes(this.userName, statusObject));
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
                return statusProps;
            }
            messageBuilder.append(message);
        }
        if (!this.userName.equals(this.samAccountName) && statusObject.getErrorMessage((Object)this.samAccountName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.samAccountName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.samAccountName);
            errCodeBuilder.append(this.getErrorCodes(this.samAccountName, statusObject));
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
                return statusProps;
            }
            messageBuilder.append(message);
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) != null) {
                messageBuilder.append(statusObject.getErrorMessage(object, this.rb));
            }
            errCodeBuilder.append(this.getErrorCodes(object, statusObject));
        }
        if (messageBuilder.length() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.ad_mgmt.create_user.successfully_created__user_but_following_errors_occured"), messageBuilder.toString()));
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.msg_sucessfully_created_user"));
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
        return statusProps;
    }

    public void setGroupErrorMessage() {
        if (this.invalidGroups.size() == 0) {
            return;
        }
        StringBuilder invalidGroupsStr = new StringBuilder();
        for (int index = 0; index < this.invalidGroups.size(); ++index) {
            if (index > 0) {
                invalidGroupsStr.append(", ");
            }
            invalidGroupsStr.append((String)this.invalidGroups.get(index));
        }
        if (this.isBulkMgmt) {
            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.error_str.error_invalid_groups"), invalidGroupsStr.toString()));
        } else {
            Hashtable<String, String> hash = new Hashtable<String, String>();
            hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.error_str.error_invalid_groups"), invalidGroupsStr.toString()));
            hash.put("NATIVE_ERROR_MESSAGE", ".");
            ArrayList creationMessage = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
            if (creationMessage == null) {
                creationMessage = new ArrayList();
                this.nativeStatusProps.put("CREATION_MESSAGE", creationMessage);
            }
            creationMessage.add(hash);
        }
        this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
    }

    @Override
    public String getErrorCodes(Object key, NativeError errHdlr) {
        StringBuilder errCodeBuilder = new StringBuilder();
        try {
            ArrayList errorList = errHdlr.getErrorList(key);
            if (errorList != null && !errorList.isEmpty()) {
                String errorCode = null;
                for (Hashtable hashtable : errorList) {
                    errorCode = (String)hashtable.get("ERROR_CODE");
                    if (errorCode == null) continue;
                    errCodeBuilder.append(errCodeBuilder.length() > 0 ? "," + errorCode : errorCode);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errCodeBuilder.toString();
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public void setFieldValueList(Properties fieldValue) {
    }

    public Properties getNativeStatusProps() {
        return this.nativeStatusProps;
    }
}

