/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LCSServerHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationMacro;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTemplateHandler;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcGroupMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutBulkViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcNativeProperties;
import com.adventnet.sym.adsm.common.server.layout.FcUserModificationMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcConfigMemberOfWithPG;
import com.adventnet.sym.adsm.common.server.layout.component.FcLogonHours;
import com.adventnet.sym.adsm.common.server.layout.component.FcManager;
import com.adventnet.sym.adsm.common.server.powershell.PowerShellCommand;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPhotoMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DeprovisionUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class FcUserModificationListener
extends FcADMgmtListener {
    String fullName = "";
    String samAccountName = "";
    String distinguishedName = "";
    String guid = "";
    String searchString = "";
    ArrayList authorizedOUList = null;
    ArrayList groupList = null;
    Properties nativeStatusProps = new Properties();
    Hashtable auditLogProps = new Hashtable();
    String legacyExchangeDN = "";
    String mailNickname = null;
    String mailboxDatabase = null;
    boolean isMailBoxEnabledUser = false;
    boolean isMailEnabledUser = false;
    boolean isRTCEnabled = false;
    boolean canConnectToLyncServer = true;
    ArrayList selectedLyncAttributes = null;
    String lyncSIPAddress = null;
    String dcFqdn = null;
    String password = null;
    String passwordType = null;
    String lyncPin = null;
    String mailBoxServer = null;
    String modifiedFullName = null;
    long pwdLastSetValue = 0L;
    ArrayList extendedRightsGuidList = new ArrayList();
    Long msExchVersion = 0L;
    String customScriptResult = "";
    long userFlagsValue = 0L;
    String oldDistinguishedName = null;
    ArrayList<Hashtable> customList;
    ArrayList<String> sendAsSIDList = new ArrayList();
    boolean isSendAsListUpdated = false;
    boolean preventDeletion = false;
    String disablePolicyMessage = "";
    FcLayout executeFormLayout = null;
    Properties fieldValueList = new Properties();
    DataObject auditDataObject = null;
    boolean isOverWriteADValue = true;
    boolean isCopyObjectApplied = false;
    String[] mandatoryFields = new String[]{"userPrincipalName", "sAMAccountName", "name", "distinguishedName", "legacyExchangeDN", "mailNickname", "targetAddress", "homeMDB", "userAccountControl", "msExchHomeServerName", "pwdLastSet", "msExchVersion", "proxyAddresses", "msRTCSIP-PrimaryHomeServer", "msRTCSIP-UserEnabled", "msRTCSIP-PrimaryUserAddress", "msRTCSIP-OptionFlags"};
    String[] lcsFields = new String[]{"msRTCSIP-Line", "msRTCSIP-PrimaryHomeServer", "msRTCSIP-LineServer", "msRTCSIP-InternetAccessEnabled", "msRTCSIP-UserEnabled", "msRTCSIP-OptionFlags", "msRTCSIP-ArchivingEnabled", "msRTCSIP-PrimaryUserAddress", "msRTCSIP-FederationEnabled"};
    private static String[] productLyncLdapNames = new String[]{"lyncMobilityPolicy", "lyncLocationPolicy", "lyncExternalAccessPolicy", "lyncArchivingPolicy", "lyncClientVersionPolicy", "lyncRegistrarPoolName", "lyncVoicePolicy", "lyncConferencePolicy", "lyncTelephonyType", "lyncSipAddress", "lyncDialPlanPolicy", "lyncLineUri", "lyncPinPolicy", "lyncLineServerUri", "lyncClientPolicy", "lyncPIN"};
    private static String[] lyncPowershellAttributeNames = new String[]{"MobilityPolicy", "LocationPolicy", "ExternalAccessPolicy", "ArchivingPolicy", "ClientVersionPolicy", "RegistrarPool", "VoicePolicy", "ConferencingPolicy", "Telephony", "SipAddress", "DialPlan", "LineURI", "PinPolicy", "LineServerURI", "ClientPolicy", "IsPINSet"};
    String[] restrictedFields = new String[]{"msExchHomeServerName", "homeMDB", "msExchAdminGroup", "msRTCSIP-PrimaryHomeServer"};
    public static int NO_MAIL_USER = 0;
    public static int MAIL_BOX_ENABLED_USER = 1;
    public static int MAIL_ENABLED_USER = 2;
    public static int NO_LCSLYNC_USER = 0;
    public static int LCS_ENABLED_USER = 1;
    public static int LYNC_ENABLED_USER = 2;

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId, null);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.creationId = creationId;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.adData = adData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.executeFormLayout = executeLayoutForm;
        this.modifyUser();
    }

    @Override
    public void setisOverWriteADValue(boolean isOverWriteADValue) {
        this.isOverWriteADValue = isOverWriteADValue;
    }

    @Override
    public boolean getisOverWriteADValue() {
        return this.isOverWriteADValue;
    }

    @Override
    public void setisCopyObjectApplied(boolean isCopyObjectApplied) {
        this.isCopyObjectApplied = isCopyObjectApplied;
    }

    @Override
    public boolean getisCopyObjectApplied() {
        return this.isCopyObjectApplied;
    }

    @Override
    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    @Override
    public ArrayList getMandatoryFields() {
        ArrayList ar = new ArrayList();
        Collections.addAll(ar, this.mandatoryFields);
        return ar;
    }

    public void setFieldValueList(Properties fieldValue) {
        this.fieldValueList = fieldValue;
    }

    @Override
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Override
    public void setLoginId(Long loginId) {
        this.loginId = loginId;
    }

    @Override
    public boolean importCSVDetailsForAutomation(Long objectCreationId, DataObject dataObj, JSONObject errorDetailsObj, Vector headerVector, ArrayList<Vector> list, Long loginId, AdventNetResourceBundle rb, String domainName, Long selectedLayoutId, boolean isTemplateHeaderAvailable, int templateHeaderIndex) {
        boolean status = FcBulkExecuteFormFlow.addObjectDetails(objectCreationId, null, dataObj, errorDetailsObj, headerVector, list, FcExecuteActionConstants.userModificationTemplateCategoryId, loginId, rb, domainName, isTemplateHeaderAvailable, templateHeaderIndex, selectedLayoutId, false, FcLayoutUtil.getDPValues((Long)loginId, (String)domainName, (AdventNetResourceBundle)rb));
        return status;
    }

    @Override
    public void setAuthorizedOUList(ArrayList authorizedOUList) {
        this.authorizedOUList = authorizedOUList;
    }

    @Override
    public void restrictFieldsFromEditing(FcFormDataContainer fcLayoutTabFields) {
        Enumeration e = fcLayoutTabFields.elements();
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            ArrayList fcAttributesList = fcLayoutField.getFcAttributeList();
            String ldapName = ((FcAttributes)fcAttributesList.get(0)).getAttribLdapName();
            for (int i = 0; i < this.restrictedFields.length; ++i) {
                if (!this.restrictedFields[i].equalsIgnoreCase(ldapName)) continue;
                fcLayoutField.setIsRestricted(Boolean.valueOf(true));
                fcLayoutField.setIsAuthorized(Boolean.valueOf(false));
            }
        }
    }

    @Override
    public void getADValues(Long templateCategoryId, FcFormDataContainer fcLayoutTabFields, FcFormDataContainer adDataContainer, Long loginId) {
        try {
            ArrayList attribList = FcExecuteFormFlow.getLDAPNames(templateCategoryId, fcLayoutTabFields);
            Properties valuesList = new Properties();
            if (attribList.contains("sendAs")) {
                this.sendAsSIDList = this.getSendAsList(this.distinguishedName);
                this.isSendAsListUpdated = true;
            }
            this.removeLyncAttributes(attribList);
            if (!attribList.isEmpty()) {
                valuesList = FcExecuteFormFlow.getObjectProperties(this.guid, this.domainName, loginId, attribList);
            }
            if (this.isSendAsListUpdated) {
                valuesList.put("sendAs", this.sendAsSIDList);
            }
            if (attribList.contains("AutoReply")) {
                valuesList.put("AutoReply", this.getAutoReplyDetails());
            }
            if (attribList.contains("preventDeletion") && this.distinguishedName != "") {
                this.preventDeletion = ADHandler.getACEsFromDN((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (String)"preventDeletion", (String)"");
                ArrayList<String> temp = new ArrayList<String>();
                temp.add(String.valueOf(this.preventDeletion));
                valuesList.put("preventDeletion", temp);
            }
            this.fillMandatoryFields(valuesList);
            Properties lyncAttribValuesList = this.getLyncAttributeValues();
            if (lyncAttribValuesList != null) {
                valuesList.putAll((Map<?, ?>)lyncAttribValuesList);
            }
            this.fillADValues(fcLayoutTabFields, adDataContainer, valuesList, loginId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Properties getLyncAttributeValues() {
        Properties lyncAttribValuesList = null;
        try {
            if (this.isLyncEnabled && this.selectedLyncAttributes != null) {
                if (this.lyncServerVersion.compareTo(327680L) <= 0) {
                    this.selectedLyncAttributes.remove("MobilityPolicy");
                }
                if (!this.selectedLyncAttributes.isEmpty()) {
                    if (this.dcFqdn == null) {
                        this.dcFqdn = this.getValidDCForLyncOperations(this.domainName, this.loginId, StrUtil.getContainerDNFromDN((String)this.distinguishedName));
                    }
                    String[] mandatoryLyncAttributes = new String[]{"RegistrarPool", "SipAddress"};
                    for (int i = 0; i < mandatoryLyncAttributes.length; ++i) {
                        if (this.selectedLyncAttributes.contains(mandatoryLyncAttributes[i])) continue;
                        this.selectedLyncAttributes.add(mandatoryLyncAttributes[i]);
                    }
                    lyncAttribValuesList = FcExecuteFormFlow.getLyncProperties(this.distinguishedName, this.rtcHomeServer, this.dcFqdn, this.selectedLyncAttributes, this.domainName, this.loginId);
                    if (lyncAttribValuesList == null || lyncAttribValuesList.isEmpty()) {
                        this.canConnectToLyncServer = false;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lyncAttribValuesList;
    }

    @Override
    public Long getLyncServerVersion() {
        return this.lyncServerVersion;
    }

    public ArrayList getAutoReplyDetails() {
        ArrayList<String> dbValuesList = new ArrayList<String>();
        try {
            Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)this.mailBoxServer);
            String message = ADHandler.getAutoReplyList((String)this.domainName, (long)this.loginId, (Properties)exchangeServerDetails, (String)this.distinguishedName);
            if (!message.equals("")) {
                JSONObject jObject = new JSONObject(message);
                dbValuesList.add(jObject.getString("AutoReplyState"));
                dbValuesList.add(jObject.getString("ExternalAudience"));
                dbValuesList.add(jObject.getString("InternalMessage"));
                dbValuesList.add(jObject.getString("ExternalMessage"));
                dbValuesList.add(jObject.getString("StartTime"));
                dbValuesList.add(jObject.getString("EndTime"));
            }
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
        }
        return dbValuesList;
    }

    public void setSendAsList(ArrayList clientDNList) {
        if (!this.isSendAsListUpdated) {
            this.sendAsSIDList = this.getSendAsList(this.distinguishedName);
            this.isSendAsListUpdated = true;
        }
        ArrayList addSIDList = new ArrayList();
        ArrayList removeSIDList = new ArrayList();
        ArrayList sIDListFromAD = (ArrayList)this.sendAsSIDList.clone();
        ArrayList clientDNListCopy = (ArrayList)clientDNList.clone();
        String sIDString = "";
        for (int i = 0; i < clientDNListCopy.size(); ++i) {
            sIDString = (String)clientDNListCopy.get(i);
            if (!sIDListFromAD.contains(sIDString)) continue;
            sIDListFromAD.remove(sIDString);
            clientDNListCopy.remove(sIDString);
            --i;
        }
        Hashtable resultPropAdd = new Hashtable();
        Hashtable resultPropDelete = new Hashtable();
        String errorMsg = "";
        if (!sIDListFromAD.isEmpty()) {
            resultPropDelete = this.updateSendAsAttribute(sIDListFromAD, this.distinguishedName, "delete");
            errorMsg = this.getErrorStringForSendAs(resultPropDelete, errorMsg);
        }
        if (!clientDNListCopy.isEmpty()) {
            resultPropAdd = this.updateSendAsAttribute(clientDNListCopy, this.distinguishedName, "add");
            errorMsg = this.getErrorStringForSendAs(resultPropAdd, errorMsg);
        }
        if (!errorMsg.equals("")) {
            this.setSendAsErrorMsg(errorMsg);
        }
    }

    public void setSendAsErrorMsg(String testString) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("ERROR_MESSAGE", testString);
        if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
            this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
        }
        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
        this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
    }

    @Override
    public void fillADValues(FcFormDataContainer fcFormDataContainer, FcFormDataContainer adDataContainer, Properties valuesList, Long loginId, boolean showADValue) {
        try {
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                Properties prop = new Properties();
                prop.put("domainName", this.domainName);
                prop.put("loginId", loginId);
                prop.put("legacyExchangeDN", this.legacyExchangeDN);
                prop.put("samAccountName", this.samAccountName);
                prop.put("cantChangePwdValue", (Object)this.cantChangePwdValue);
                prop.put("msExchVersion", this.msExchVersion);
                prop.put("groupDetailsTable", this.groupDetailsTable);
                if (valuesList.containsKey("primaryGroupID") && this.memberOfList != null && (fcLayoutField.getComponentId() == 42L || fcLayoutField.getComponentId() == 62L)) {
                    Properties tempProp = new Properties();
                    tempProp.put("memberOf", this.memberOfList);
                    tempProp.put("primaryGroupID", valuesList.get("primaryGroupID"));
                    fcLayoutField.getIComponent().setValuesFromAD(fcLayoutField, adDataContainer, tempProp, prop, showADValue);
                    continue;
                }
                fcLayoutField.getIComponent().setValuesFromAD(fcLayoutField, adDataContainer, valuesList, prop, showADValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillMandatoryFields(Properties valuesList) {
        try {
            ArrayList lyncRegPoolList;
            ArrayList samAccountNameValueList;
            ArrayList pwdLastSetList;
            ArrayList uacValueList;
            ArrayList fullNameValueList;
            ArrayList distinguishedNameValueList;
            ArrayList mailBoxServerVersionList;
            ArrayList mailBoxServerValueList;
            ArrayList mailBoxDatabaseValueList;
            ArrayList mailNicknameValueList;
            ArrayList targetAddressValueList;
            String legacyDN;
            int index;
            ArrayList legacyDNValueList = (ArrayList)valuesList.get("legacyExchangeDN");
            if (legacyDNValueList != null && (index = (legacyDN = (String)legacyDNValueList.get(0)).toLowerCase().lastIndexOf("/cn=recipients/cn=")) != -1) {
                this.legacyExchangeDN = legacyDN.substring(0, index);
            }
            if ((targetAddressValueList = (ArrayList)valuesList.get("targetAddress")) != null) {
                this.existingTargetAddress = (String)targetAddressValueList.get(0);
            }
            if ((mailNicknameValueList = (ArrayList)valuesList.get("mailNickname")) != null) {
                this.mailNickname = (String)mailNicknameValueList.get(0);
            }
            if ((mailBoxDatabaseValueList = (ArrayList)valuesList.get("homeMDB")) != null) {
                this.mailboxDatabase = (String)mailBoxDatabaseValueList.get(0);
            }
            if ((mailBoxServerValueList = (ArrayList)valuesList.get("msExchHomeServerName")) != null) {
                this.mailBoxServer = (String)mailBoxServerValueList.get(0);
            }
            if ((mailBoxServerVersionList = (ArrayList)valuesList.get("msExchVersion")) != null) {
                this.msExchVersion = Long.parseLong((String)mailBoxServerVersionList.get(0));
            }
            if ((distinguishedNameValueList = (ArrayList)valuesList.get("distinguishedName")) != null) {
                this.distinguishedName = (String)distinguishedNameValueList.get(0);
                this.fcNativeProperties.setDN(this.distinguishedName);
            }
            if ((fullNameValueList = (ArrayList)valuesList.get("name")) != null) {
                this.fullName = (String)fullNameValueList.get(0);
            }
            if ((uacValueList = (ArrayList)valuesList.get("userAccountControl")) != null) {
                this.userAccountControlValue = new Long((String)uacValueList.get(0));
            }
            if ((pwdLastSetList = (ArrayList)valuesList.get("pwdLastSet")) != null) {
                this.pwdLastSetValue = Long.parseLong((String)pwdLastSetList.get(0));
                Long uacValue = 0L;
                if (uacValueList != null) {
                    uacValue = new Long((String)uacValueList.get(0));
                }
                this.changePwdAtNextLogonValue = this.pwdLastSetValue == 0L && (uacValue & 0x10000L) != 65536L;
            }
            ArrayList list = (ArrayList)valuesList.get("memberOf");
            ArrayList primaryGrpList = (ArrayList)valuesList.get("primaryGroupID");
            this.setMemberOfValues(list, primaryGrpList);
            ArrayList proxyAddressesValueList = (ArrayList)valuesList.get("proxyAddresses");
            if (proxyAddressesValueList != null) {
                this.existingProxyAddresses = proxyAddressesValueList;
            }
            if ((samAccountNameValueList = (ArrayList)valuesList.get("sAMAccountName")) != null) {
                this.samAccountName = (String)samAccountNameValueList.get(0);
            }
            if (this.mailboxDatabase != null && this.mailNickname != null) {
                this.isMailBoxEnabledUser = true;
            } else if (this.existingTargetAddress != null && this.mailNickname != null) {
                this.isMailEnabledUser = true;
            }
            this.cantChangePwdValue = ADHandler.getUserCantChangePwd((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName);
            ArrayList lyncServerValueList = (ArrayList)valuesList.get("msRTCSIP-PrimaryHomeServer");
            if (lyncServerValueList != null && lyncServerValueList.size() > 0) {
                this.rtcHomeServer = (String)lyncServerValueList.get(0);
                this.lyncServerVersion = LCSServerHandler.getLyncServerVersion((String)this.rtcHomeServer);
                ArrayList lyncEnabledValueList = (ArrayList)valuesList.get("msRTCSIP-UserEnabled");
                if (lyncEnabledValueList != null && lyncEnabledValueList.size() > 0) {
                    String valueString = (String)lyncEnabledValueList.get(0);
                    this.isRTCEnabled = "1".equals(valueString) || "true".equalsIgnoreCase(valueString);
                }
                if (LCSServerHandler.isOcsLcsServer((String)this.rtcHomeServer)) {
                    ArrayList lyncOptionFlagsValueList = (ArrayList)valuesList.get("msRTCSIP-OptionFlags");
                    if (lyncOptionFlagsValueList != null && lyncOptionFlagsValueList.size() > 0) {
                        this.lcsOptionFlagsValue = Long.parseLong((String)lyncOptionFlagsValueList.get(0));
                    }
                    this.isLcsEnabled = this.isRTCEnabled;
                    this.isLyncEnabled = false;
                } else {
                    this.isLyncEnabled = this.isRTCEnabled;
                    this.isLcsEnabled = false;
                }
            }
            if ((lyncRegPoolList = (ArrayList)valuesList.get("lyncRegistrarPoolName")) != null && lyncRegPoolList.size() > 0) {
                this.lyncPoolName = (String)lyncRegPoolList.get(0);
            }
            mgmtLog.log(Level.INFO, " Mail Box Enabled User : " + this.isMailBoxEnabledUser);
            mgmtLog.log(Level.INFO, " Mail Enabled User : " + this.isMailEnabledUser);
            mgmtLog.log(Level.INFO, " LCS/OCS user : " + this.isLcsEnabled);
            mgmtLog.log(Level.INFO, " Lync/SFB user : " + this.isLyncEnabled);
            mgmtLog.log(Level.INFO, " Lync/OCS enabled or not : " + this.isRTCEnabled);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void preMgmtActions() throws Exception {
        FcUserModificationMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
        FcUserModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcGroupMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop);
        FcUserModificationMgmtHandler.getInstance().updateFieldsAttributes(this.customFieldsContainer);
        FcUserModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.customFieldsContainer);
        FcNativeProperties fcNativeProperties = this.fcNativeProperties;
        this.getProperties(true, this.fromClientData, fcNativeProperties, ldapVsValueProps, "user");
        Properties props = fcNativeProperties.getProps();
        this.groupList = fcNativeProperties.getGroupList();
    }

    @Override
    public void setStatusMsgForWorkFlowResponse(HttpServletRequest request, Long requestId) {
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
        request.setAttribute("password", (Object)this.password);
        request.setAttribute("passwordType", (Object)this.passwordType);
        request.setAttribute("lyncPin", (Object)this.lyncPin);
        request.setAttribute("customScriptResult", (Object)this.customScriptResult);
        Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
        if (!LicenseMgr.getInstance().isTrailEdition() && !errorId.booleanValue()) {
            this.nativeStatusProps.setProperty("STATUS_MESSAGE", LicenseMgr.getInstance().getlicenseMessage("Workflow", this.rb));
            this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
        } else if (!this.isBulkMgmt) {
            if (requestId.compareTo(-2L) == 0) {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), requestId.toString()));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            } else if (requestId.compareTo(-1L) != 0) {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.modify_single_user.message_success"), requestId.toString()));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
            } else {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.modify_single_user.message_failure"));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            }
        }
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
    }

    public Long createRequest(String domainName, JSONObject wfCreateRequestJson, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer aDData, Long loginId, Long layoutId, FcLayout executeFormLayout, Long templateCategoryId) {
        boolean isRequestCreated = false;
        Long requestId = -1L;
        try {
            ArrayList ouList;
            this.domainName = domainName;
            this.fromClientData = fromClientData;
            this.userData = userData;
            this.adData = aDData;
            this.loginId = loginId;
            Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
            if (!LicenseMgr.getInstance().isTrailEdition() && !errorId.booleanValue()) {
                return -1L;
            }
            this.customFieldsContainer = new FcFormDataContainer();
            this.customFieldsContainer.splitCustomFields(this.fromClientData);
            Long objectCreationId = FcExecuteFormFlow.getNewObjectCreationId();
            Long objectIndexId = FcExecuteFormFlow.getNewObjectIndexId(objectCreationId, layoutId, this.guid);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            this.creationId = objectCreationId;
            this.objectIndexId = objectIndexId;
            FcUserModificationMgmtHandler.getInstance().updateFieldsAttributes(fromClientData);
            FcUserModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(fromClientData);
            FcUserModificationMgmtHandler.getInstance().updateFieldsAttributes(this.customFieldsContainer);
            FcUserModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.customFieldsContainer);
            FcUserModificationMgmtHandler.getInstance().updateFieldsAttributes(this.userData);
            FcUserModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.userData);
            FcUserModificationMgmtHandler.getInstance().updateFieldsAttributes(this.adData);
            FcUserModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.adData);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.userDataId, userData, FcExecuteActionConstants.userModificationTemplateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.resultDataId, fromClientData, FcExecuteActionConstants.userModificationTemplateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.resultDataId, this.customFieldsContainer, FcExecuteActionConstants.userModificationTemplateCategoryId);
            JSONArray selectedIamAppsJsonArray = executeFormLayout.getSelectedIamAppsJsonArray();
            FcLayoutBulkViewHandler.addSelectedIamAppsRow((DataObject)dataObj, (Long)objectIndexId, (int)FcExecuteActionConstants.resultDataId, (JSONArray)selectedIamAppsJsonArray, (Long)templateCategoryId);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            String containerName = FcLayoutUtil.getOUNameFromContainer((FcFormDataContainer)fromClientData);
            if (containerName.equals("")) {
                containerName = DirectoryObjectUtil.getOUNameFromDN((String)this.distinguishedName);
            }
            if ((ouList = WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId)).size() > 0 && !ouList.contains(containerName)) {
                boolean isExcludeChildOu = WFRequesterUtil.isExcludeChildOu((String)domainName, (Long)loginId);
                Criteria c = null;
                c = isExcludeChildOu ? OUUtil.getOUCriteriaWithEquals((String)"ADSMOUDetails", (ArrayList)ouList) : OUUtil.getOUCriteriaWithEndsWITH((String)"ADSMOUDetails", (ArrayList)ouList);
                ouList = OUUtil.getOUList((String)domainName, (Criteria)c);
                if (!ouList.contains(containerName)) {
                    return -2L;
                }
            }
            FcLayoutUpdateHandler.updateObjectCreationIdDetails((Long)objectCreationId, (String)domainName, (String)containerName, (Long)layoutId);
            requestId = FcExecuteFormFlow.createWorkFlowRequest(objectCreationId, FcExecuteActionConstants.userModificationTemplateCategoryId, loginId, domainName, wfCreateRequestJson, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return requestId;
    }

    public void setMemberOfValues(ArrayList MemberOfList, ArrayList PrimaryGroupList) {
        try {
            if (MemberOfList != null) {
                Hashtable authorizedGroupList = new Hashtable();
                this.memberOfList = new ArrayList();
                String[] columns = new String[]{"DOMAIN_NAME", "OBJECT_GUID", "DISTINGUISHED_NAME", "SID_STRING", "GROUPTYPE", "GROUP_NAME"};
                authorizedGroupList = MemberOfList.size() > 40 ? this.loadMemberOfData(MemberOfList) : GroupHandler.getGroupsPropFromDN((String)this.domainName, (Long)this.loginId, (ArrayList)MemberOfList, (String)"domain", (String[])columns);
                for (String key : authorizedGroupList.keySet()) {
                    Properties properties = (Properties)authorizedGroupList.get(key);
                    this.memberOfList.add((String)properties.get("DISTINGUISHED_NAME"));
                }
                this.groupDetailsTable = authorizedGroupList;
            }
            if (PrimaryGroupList != null) {
                String primaryGroupRID = (String)PrimaryGroupList.get(0);
                Properties defaultprops = GroupHandler.getGroupDetailsFromRID((String)primaryGroupRID, (String)this.domainName);
                if (!this.memberOfList.contains((String)defaultprops.get("Distinguished_Name"))) {
                    this.memberOfList.add((String)defaultprops.get("Distinguished_Name"));
                }
                this.adPrimaryGroupDN = (String)defaultprops.get("Distinguished_Name");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getSelectedSubTab() {
        if (this.isMailBoxEnabledUser) {
            return MAIL_BOX_ENABLED_USER;
        }
        if (this.isMailEnabledUser) {
            return MAIL_ENABLED_USER;
        }
        return NO_MAIL_USER;
    }

    @Override
    public int getLyncSelectedSubTab() {
        if (this.isLcsEnabled) {
            return LCS_ENABLED_USER;
        }
        if (this.isLyncEnabled) {
            return LYNC_ENABLED_USER;
        }
        return NO_LCSLYNC_USER;
    }

    public void modifyUser() {
        try {
            String defaultNamingContext;
            Properties properties;
            boolean dialinModified;
            String CREATION_STATUS;
            String exchangePhotoFilePath;
            String remoteHomeDir;
            String tsRemoteHomeDir;
            Properties props;
            block227: {
                block224: {
                    Object creationMsg;
                    ArrayList<Hashtable> list;
                    ArrayList propList;
                    block226: {
                        Properties exchangeServerDetails;
                        String recipientType;
                        String hideAddressBook;
                        Integer exchType;
                        boolean usePowerShell;
                        Boolean updatePolicy;
                        String policyIncluded;
                        String searchDN;
                        String endtime;
                        String starttime;
                        String autoReplyState;
                        String externalmessage;
                        String internalmessage;
                        String archiveDomain;
                        String archiveDB;
                        FcNativeProperties fcNativeProperties;
                        Properties ldapVsValueProps;
                        block225: {
                            Hashtable<String, String> hash;
                            String exchVersion;
                            FcLayoutField fcLayoutField;
                            FcConfigMemberOfWithPG fcConfigMemberPG;
                            mgmtLog.log(Level.INFO, " FcUser Modification Started ");
                            this.isChangesFound = true;
                            FcFormDataContainer modifiedFieldsContainer = new FcFormDataContainer();
                            FcExecuteFormFlow.fillModifiedFields(FcExecuteActionConstants.userModificationTemplateCategoryId, modifiedFieldsContainer, this.fromClientData, this.adData, this.rb, null, this.loginId, this.guid, this.domainName, this.executeFormLayout, this, this.isOverWriteADValue, this.isCopyObjectApplied);
                            if (this.lyncServerVersion.compareTo(327680L) <= 0) {
                                modifiedFieldsContainer.remove((Object)2718L);
                            }
                            FcFormDataContainer customFieldsContainer = new FcFormDataContainer();
                            customFieldsContainer.splitCustomFields(modifiedFieldsContainer);
                            FcUserModificationMgmtHandler.getInstance().updateFieldsAttributes(modifiedFieldsContainer);
                            FcUserModificationMgmtHandler.getInstance().updateFieldsAttributes(customFieldsContainer);
                            if (this.isFieldModified("memberOf", modifiedFieldsContainer) && !this.isFieldModified("memberOf", this.adData)) {
                                FcLayoutField fcLayoutField2;
                                FcConfigMemberOfWithPG fcConfigMemberPG2;
                                FcFormDataContainer tempModFieldsContainer = new FcFormDataContainer();
                                tempModFieldsContainer.put((Object)2516L, modifiedFieldsContainer.get((Object)2516L));
                                this.getADValues(FcExecuteActionConstants.userModificationTemplateCategoryId, tempModFieldsContainer, this.adData, this.loginId);
                                if (tempModFieldsContainer.get((Object)2516L) != null && this.adData.get((Object)2516L) != null && this.isCopyObjectApplied && !this.isOverWriteADValue && !(fcConfigMemberPG2 = (FcConfigMemberOfWithPG)(fcLayoutField2 = (FcLayoutField)tempModFieldsContainer.get((Object)2516L)).getIComponent()).isRemoveExistingGroup()) {
                                    fcConfigMemberPG2.removeValues((FcLayoutField)this.adData.get((Object)2516L));
                                }
                            }
                            if (modifiedFieldsContainer.get((Object)2516L) != null && this.adData.get((Object)2516L) != null && this.isCopyObjectApplied && this.isOverWriteADValue && !(fcConfigMemberPG = (FcConfigMemberOfWithPG)(fcLayoutField = (FcLayoutField)modifiedFieldsContainer.get((Object)2516L)).getIComponent()).isRemoveExistingGroup()) {
                                fcConfigMemberPG.mergeADValuesAppendGroup((FcLayoutField)this.adData.get((Object)2516L));
                            }
                            FcUserModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(modifiedFieldsContainer);
                            FcUserModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(customFieldsContainer);
                            FcUserModificationMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
                            FcUserModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
                            Properties prop1 = new Properties();
                            prop1.put("domainName", this.domainName);
                            ldapVsValueProps = FcUserModificationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop1);
                            ldapVsValueProps = FcUserModificationMgmtHandler.getInstance().getLdapVsValuesFromAD(this.fieldValueList, ldapVsValueProps);
                            ldapVsValueProps.setProperty("objectGuid", this.getGuid());
                            this.customList = this.getCustomAttribsProperties(customFieldsContainer, true, ldapVsValueProps, "user");
                            propList = this.fcNativeProperties.getPropList();
                            fcNativeProperties = this.fcNativeProperties;
                            this.addAttributeToNativeProps(modifiedFieldsContainer, fcNativeProperties, ldapVsValueProps);
                            props = fcNativeProperties.getProps();
                            this.groupList = fcNativeProperties.getGroupList();
                            if (props.get("password") != null) {
                                this.password = props.getProperty("password");
                            }
                            if (props.get("passwordType") != null) {
                                this.passwordType = props.getProperty("passwordType");
                            }
                            tsRemoteHomeDir = "";
                            if (props.get("tsRemoteHomeDir") != null) {
                                tsRemoteHomeDir = props.getProperty("tsRemoteHomeDir");
                            }
                            remoteHomeDir = "";
                            if (props.get("remoteHomeDir") != null) {
                                remoteHomeDir = props.getProperty("remoteHomeDir");
                            }
                            archiveDB = null;
                            exchangePhotoFilePath = null;
                            archiveDomain = null;
                            internalmessage = null;
                            externalmessage = null;
                            autoReplyState = null;
                            starttime = null;
                            endtime = null;
                            if (props.get("msExchArchiveDatabaseLink") != null) {
                                archiveDB = props.getProperty("msExchArchiveDatabaseLink");
                            }
                            if (props.get("msExchArchiveAddress") != null) {
                                archiveDomain = props.getProperty("msExchArchiveAddress");
                            }
                            if (props.get("internalmessage") != null) {
                                internalmessage = props.getProperty("internalmessage");
                            }
                            if (props.get("externalmessage") != null) {
                                externalmessage = props.getProperty("externalmessage");
                            }
                            if (props.get("autoReplyState") != null) {
                                autoReplyState = props.getProperty("autoReplyState");
                            }
                            if (props.get("sDateValue") != null && props.getProperty("sDateValue").length() > 5) {
                                starttime = props.getProperty("sDateValue");
                            }
                            if (props.get("eDateValue") != null && props.getProperty("eDateValue").length() > 5) {
                                endtime = props.getProperty("eDateValue");
                            }
                            mgmtLog.log(Level.INFO, " User Modification : domainName " + this.domainName);
                            mgmtLog.log(Level.INFO, " LoginId  " + this.loginId);
                            mgmtLog.log(Level.INFO, " Full Name :" + this.fullName);
                            mgmtLog.log(Level.INFO, " propsList " + fcNativeProperties.getPropList());
                            mgmtLog.log(Level.INFO, " modifyList " + fcNativeProperties.getModifyList());
                            mgmtLog.log(Level.INFO, " tsList " + fcNativeProperties.getTsList());
                            mgmtLog.log(Level.INFO, " winNTAttributeList " + fcNativeProperties.getWinNTAttributeList());
                            mgmtLog.log(Level.INFO, " GroupsList " + this.groupList);
                            mgmtLog.log(Level.INFO, " To Be Removed from Group List " + this.toBeRemovedGroupList);
                            mgmtLog.log(Level.INFO, " customList " + this.customList);
                            mgmtLog.log(Level.INFO, " msExchArchiveDatabaseLink " + archiveDB);
                            mgmtLog.log(Level.INFO, " msExchArchiveAddress " + archiveDomain);
                            this.auditLogProps.put("domainName", this.domainName);
                            this.auditLogProps.put("userName", this.fullName);
                            this.auditLogProps.put("propList", fcNativeProperties.getPropList());
                            this.auditLogProps.put("modifyList", fcNativeProperties.getModifyList());
                            this.auditLogProps.put("winNTAttributeList", fcNativeProperties.getWinNTAttributeList());
                            this.auditLogProps.put("groupList", this.groupList);
                            this.auditLogProps.put("toBeRemovedGroupList", this.toBeRemovedGroupList);
                            this.auditLogProps.put("customList", this.customList);
                            if (props.get("customScriptDetails") != null) {
                                this.auditLogProps.put("CustomScriptDetails", (Properties)props.get("customScriptDetails"));
                            }
                            if (props.get("preventDeletion") != null) {
                                this.auditLogProps.put("preventDeletion", (String)props.get("preventDeletion"));
                            }
                            String OUName = props.getProperty("OUName");
                            if (this.isBulkMgmt && this.commonContainerName != null && !this.commonContainerName.equals("")) {
                                OUName = this.commonContainerName;
                            }
                            if (OUName != null) {
                                if (!HelpdeskUtil.isAuthorizedOU((String)this.domainName, (Long)this.loginId, (String)OUName)) {
                                    this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                                    this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), OUName));
                                    return;
                                }
                                String newdistinguishedName = "CN=" + CommonUtil.escapeString((String)this.fullName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS) + "," + OUName;
                                if (!this.distinguishedName.equals(newdistinguishedName)) {
                                    this.oldDistinguishedName = this.distinguishedName;
                                    this.distinguishedName = newdistinguishedName;
                                    try {
                                        ADHandlerForMgmt.moveObject((String)this.domainName, (Long)this.loginId, (String)this.oldDistinguishedName, (String)OUName);
                                        this.distinguishedName = newdistinguishedName;
                                        this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                                        this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.reports.common.status_msg.successfully_updated"));
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                                    }
                                    catch (LocalizedException le) {
                                        le.printStackTrace();
                                        Hashtable<String, String> hash2 = new Hashtable<String, String>();
                                        hash2.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("usermanagement.messages.unable_modify_user"), le.getMessage(this.rb)));
                                        hash2.put("NATIVE_ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_contacts.statmsg.error_moving_user"), le.getMessage(this.rb)));
                                        if (!this.isBulkMgmt) {
                                            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                            }
                                            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash2);
                                        } else if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                            this.nativeStatusProps.put("CREATION_MESSAGE", (String)hash2.get("NATIVE_ERROR_MESSAGE"));
                                        } else {
                                            this.nativeStatusProps.put("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + (String)hash2.get("NATIVE_ERROR_MESSAGE"));
                                        }
                                        this.nativeStatusProps.setProperty("STATUS_MESSAGE", "");
                                        this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                        return;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            searchDN = this.distinguishedName;
                            String updateDN = CommonUtil.escapeSpecialCharacters((String)this.distinguishedName);
                            this.searchString = "(&(objectClass=user)(objectCategory=user)(distinguishedName=" + updateDN + "))";
                            policyIncluded = (String)ldapVsValueProps.get("msExchPoliciesExcluded");
                            CREATION_STATUS = null;
                            dialinModified = false;
                            modifiedFieldsContainer.remove((Object)2616L);
                            if (modifiedFieldsContainer.size() <= 0 && customFieldsContainer.size() <= 0 && props.size() <= 0) break block224;
                            properties = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
                            defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                            updatePolicy = false;
                            if (props.get("msExchHomeServerName") != null) {
                                this.mailBoxServer = (String)props.get("msExchHomeServerName");
                            }
                            if (props.get("exchangePhoto") != null) {
                                Hashtable hash3 = (Hashtable)props.get("exchangePhoto");
                                exchangePhotoFilePath = (String)hash3.get("ATTRIB_VALUE");
                                if (this.mailBoxServer == null) {
                                    this.photoFileError = this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.exchange_photo_cannot_be_set");
                                }
                            }
                            usePowerShell = false;
                            exchType = 0;
                            if (this.mailBoxServer != null && ExchangeUtil.checkExchange2007((String)this.mailBoxServer) || this.legacyExchangeDN != null && ExchangeUtil.checkExchangeGroup2007((String)this.legacyExchangeDN)) {
                                usePowerShell = true;
                            }
                            if (props.get("msExchPoliciesIncluded") != null && props.get("msExchPoliciesIncluded").equals("{26491CFC-9E50-4857-861B-0CB8DF22B5D7}") && usePowerShell) {
                                updatePolicy = true;
                            }
                            hideAddressBook = (String)props.get("msExchHideFromAddressLists");
                            recipientType = this.isMailBoxEnabledUser ? "mailBox" : (this.isMailEnabledUser ? "mail" : "");
                            exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)this.mailBoxServer);
                            if (recipientType != null && recipientType.equals("mail")) {
                                exchVersion = ExchangeUtil.getExchangeVersion((Long)this.msExchVersion);
                                exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)this.domainName, (String)this.legacyExchangeDN, (Long)this.loginId);
                            }
                            if (this.msExchVersion != 0L) {
                                exchVersion = ExchangeUtil.getExchangeVersion((Long)this.msExchVersion);
                                exchType = ExchangeUtil.getExchType((String)exchVersion);
                            }
                            if (props.getProperty("dialIn") != null) {
                                dialinModified = true;
                            }
                            if (this.authorizedOUList != null && this.authorizedOUList.size() != 0) break block225;
                            UserMgmtUtil.setUserCannotChangePass((boolean)this.newCantChangePwdValue, (boolean)this.setCantChangePwdValue, (String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (String)this.samAccountName);
                            this.statusObject = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), (String)this.password, (ArrayList)fcNativeProperties.getPropList(), (ArrayList)fcNativeProperties.getModifyList(), (ArrayList)fcNativeProperties.getTsList(), (ArrayList)fcNativeProperties.getWinNTAttributeList(), (ArrayList)this.groupList, (boolean)false);
                            this.nativeStatusProps = this.isBulkMgmt ? this.getBulkUserErrorMessage(this.statusObject) : this.getSingleUserErrorMessage(this.statusObject);
                            CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
                            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !this.customList.isEmpty()) {
                                NativeError customError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), null, this.customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                if (!this.isBulkMgmt) {
                                    this.setSingleUserErrorMessage(customError, "admp.ad_mgmt.create_user.error_in_setting_values_for_custom_attributes", this.searchString);
                                } else {
                                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)this.searchString);
                                }
                            }
                            if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                                if (!(archiveDB == null || archiveDomain == null || archiveDB.equals("") && archiveDomain.equals(""))) {
                                    if (exchType >= 2010) {
                                        boolean isRemote = false;
                                        if (!archiveDomain.equals("")) {
                                            isRemote = true;
                                        }
                                        String msg = "";
                                        msg = ADHandler.enableArchiveMailbox((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)archiveDB, (String)archiveDomain, (Properties)exchangeServerDetails, (boolean)isRemote);
                                        if (msg.length() > 0) {
                                            Hashtable<String, String> hash4 = new Hashtable<String, String>();
                                            hash4.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString(msg)));
                                            if (!this.isBulkMgmt) {
                                                if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                                    this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                                }
                                                ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash4);
                                            } else {
                                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString(msg)));
                                            }
                                            this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                                            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                                            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                        }
                                    } else {
                                        Hashtable<String, String> hash5 = new Hashtable<String, String>();
                                        hash5.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_archive_mail"), FcLayoutUtil.getDisplayNameFromDN((String)((String)ldapVsValueProps.get("homeMDB")))));
                                        if (!this.isBulkMgmt) {
                                            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                            }
                                            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash5);
                                        } else {
                                            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_archive_mail"), FcLayoutUtil.getDisplayNameFromDN((String)((String)ldapVsValueProps.get("homeMDB")))));
                                        }
                                        this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                    }
                                }
                                if (exchangePhotoFilePath != null) {
                                    Hashtable hash6;
                                    String uniqueOperationId;
                                    File photoFile;
                                    boolean setThumbnailPhoto = false;
                                    if (exchType > 2010) {
                                        boolean isRemote = false;
                                        String msg = "";
                                        msg = ADHandler.setExchangePhoto((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)exchangePhotoFilePath, (Properties)exchangeServerDetails);
                                        if (msg.trim().length() > 0) {
                                            hash = new Hashtable<String, String>();
                                            hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exchange_photo"), this.rb.getString(msg)));
                                            if (!this.isBulkMgmt) {
                                                if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                                    this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                                }
                                                ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                                            } else {
                                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exchange_photo"), this.rb.getString(msg)));
                                            }
                                            this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                                            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                                            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                            setThumbnailPhoto = true;
                                        }
                                    } else {
                                        Hashtable<String, String> hash7 = new Hashtable<String, String>();
                                        hash7.put("ERROR_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.create_mailbox.error.user_photo_version"));
                                        if (!this.isBulkMgmt) {
                                            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                            }
                                            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash7);
                                        } else {
                                            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString("admp.mgmt.user_mgmt.create_mailbox.error.user_photo_version"));
                                        }
                                        this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                        setThumbnailPhoto = true;
                                    }
                                    if (setThumbnailPhoto && (photoFile = UserPhotoMgmtUtil.getMatchingFileForExecution((String)exchangePhotoFilePath, (String)"thumbnailPhoto", (String)(uniqueOperationId = (String)(hash6 = (Hashtable)props.get("exchangePhoto")).get("UNIQUE_OPERATION_ID")))).exists()) {
                                        list = new ArrayList<Hashtable>();
                                        UserPhotoMgmtUtil.updateHashWithThumbnailPhotoAttribute((File)photoFile, (Hashtable)hash6);
                                        list.add(hash6);
                                        NativeError thumbnailPhotoError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), null, list, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                        if (thumbnailPhotoError.getErrorList((Object)this.searchString).size() == 0) {
                                            if (!this.isBulkMgmt) {
                                                Hashtable<String, String> hash1 = new Hashtable<String, String>();
                                                hash1.put("ERROR_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_attrib_updated_successfully"));
                                                ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash1);
                                            } else {
                                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_attrib_updated_successfully"));
                                            }
                                        }
                                    }
                                }
                            }
                            if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE") && autoReplyState != null) {
                                String msg = "";
                                PowerShellCommand powerShellCommand = new PowerShellCommand("Set-MailboxAutoReplyConfiguration");
                                powerShellCommand.setIdentity(this.distinguishedName);
                                Boolean externalMsgState = Boolean.valueOf(props.getProperty("externalMsgState"));
                                if (autoReplyState.equals("Scheduled")) {
                                    powerShellCommand.addParameter("AutoReplyState", "Scheduled");
                                } else if (autoReplyState.equals("Enabled")) {
                                    powerShellCommand.addParameter("AutoReplyState", "Enabled");
                                } else {
                                    powerShellCommand.addParameter("AutoReplyState", "Disabled");
                                }
                                if (starttime != null && endtime != null) {
                                    powerShellCommand.addParameter("StartTime", starttime);
                                    powerShellCommand.addParameter("EndTime", endtime);
                                }
                                if (internalmessage != null) {
                                    internalmessage = internalmessage.replaceAll("(?i)%username%", "%name%");
                                    String val = FormatClientUtil.getFormatValue(internalmessage, new Hashtable(), this.domainName, "");
                                    val = EscapeUtil.powershellEscape((String)val);
                                    powerShellCommand.addParameter("InternalMessage", val);
                                    if (externalMsgState.booleanValue()) {
                                        externalmessage = externalmessage.replaceAll("(?i)%username%", "%name%");
                                        String val1 = FormatClientUtil.getFormatValue(externalmessage, new Hashtable(), this.domainName, "");
                                        powerShellCommand.addParameter("ExternalAudience", "All");
                                        val1 = EscapeUtil.powershellEscape((String)val1);
                                        powerShellCommand.addParameter("ExternalMessage", val1);
                                    } else {
                                        powerShellCommand.addParameter("ExternalAudience", "None");
                                    }
                                }
                                if ((msg = this.rb.getString(ADHandler.executePowershellCMD((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (PowerShellCommand)powerShellCommand, (Properties)exchangeServerDetails))).length() > 0) {
                                    hash = new Hashtable();
                                    hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.auto_reply"), this.rb.getString(msg)));
                                    if (!this.isBulkMgmt) {
                                        if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                            this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                        }
                                        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                                    } else {
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.auto_reply"), this.rb.getString(msg)));
                                    }
                                    this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                                    this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                                    this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                }
                            }
                            if (updatePolicy.booleanValue() && CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                                ADHandler.updateEmailPolicy((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (Properties)exchangeServerDetails);
                            }
                            if ((hideAddressBook == null || !usePowerShell || this.msExchVersion == 0L) && (props.get("msExchPoliciesIncluded") != null || props.get("mailAlias") == null || !policyIncluded.equalsIgnoreCase("true") || !usePowerShell || this.msExchVersion == 0L)) break block226;
                            ADHandler.setExchangeAttribute((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)recipientType, (String)hideAddressBook, (Properties)exchangeServerDetails, (String)((String)props.get("mailAlias")));
                            break block226;
                        }
                        for (int i = 0; i < this.authorizedOUList.size(); ++i) {
                            String dn = ((String)this.authorizedOUList.get(i)).toLowerCase();
                            String s = searchDN.toLowerCase();
                            if (!s.endsWith(dn)) continue;
                            UserMgmtUtil.setUserCannotChangePass((boolean)this.newCantChangePwdValue, (boolean)this.setCantChangePwdValue, (String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (String)this.samAccountName);
                            this.statusObject = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)((String)this.authorizedOUList.get(i)), (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), (String)this.password, (ArrayList)fcNativeProperties.getPropList(), (ArrayList)fcNativeProperties.getModifyList(), (ArrayList)fcNativeProperties.getTsList(), (ArrayList)fcNativeProperties.getWinNTAttributeList(), (ArrayList)this.groupList, (boolean)false);
                            this.nativeStatusProps = this.isBulkMgmt ? this.getBulkUserErrorMessage(this.statusObject) : this.getSingleUserErrorMessage(this.statusObject);
                            CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
                            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !this.customList.isEmpty()) {
                                NativeError customError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)((String)this.authorizedOUList.get(i)), (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), null, this.customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                if (!this.isBulkMgmt) {
                                    this.setSingleUserErrorMessage(customError, "admp.ad_mgmt.create_user.error_in_setting_values_for_custom_attributes", this.searchString);
                                } else {
                                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)this.searchString);
                                }
                            }
                            if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE") && archiveDB != null && archiveDomain != null) {
                                if (exchType >= 2010) {
                                    if (!archiveDB.equals("") || !archiveDomain.equals("")) {
                                        boolean isRemote = false;
                                        if (!archiveDomain.equals("")) {
                                            isRemote = true;
                                        }
                                        String msg = "";
                                        msg = ADHandler.enableArchiveMailbox((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)archiveDB, (String)archiveDomain, (Properties)exchangeServerDetails, (boolean)isRemote);
                                        if (msg.length() > 0) {
                                            Hashtable<String, String> hash = new Hashtable<String, String>();
                                            hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString(msg)));
                                            if (!this.isBulkMgmt) {
                                                if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                                    this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                                }
                                                ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                                            } else {
                                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.archive_mail"), this.rb.getString(msg)));
                                            }
                                            this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                                            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                                            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                        }
                                    }
                                } else {
                                    Hashtable<String, String> hash = new Hashtable<String, String>();
                                    hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_archive_mail"), FcLayoutUtil.getDisplayNameFromDN((String)((String)ldapVsValueProps.get("homeMDB")))));
                                    if (!this.isBulkMgmt) {
                                        if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                            this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                        }
                                        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                                    } else {
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_archive_mail"), FcLayoutUtil.getDisplayNameFromDN((String)((String)ldapVsValueProps.get("homeMDB")))));
                                    }
                                    this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                                    this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                                    this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                }
                            }
                            if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE") && autoReplyState != null) {
                                String msg = "";
                                PowerShellCommand powerShellCommand = new PowerShellCommand("Set-MailboxAutoReplyConfiguration");
                                powerShellCommand.setIdentity(this.distinguishedName);
                                Boolean externalMsgState = Boolean.valueOf(props.getProperty("externalMsgState"));
                                if (autoReplyState.equals("Scheduled")) {
                                    powerShellCommand.addParameter("AutoReplyState", "Scheduled");
                                } else if (autoReplyState.equals("Enabled")) {
                                    powerShellCommand.addParameter("AutoReplyState", "Enabled");
                                } else {
                                    powerShellCommand.addParameter("AutoReplyState", "Disabled");
                                }
                                if (starttime != null && endtime != null) {
                                    powerShellCommand.addParameter("StartTime", starttime);
                                    powerShellCommand.addParameter("EndTime", endtime);
                                }
                                if (internalmessage != null) {
                                    internalmessage = internalmessage.replaceAll("(?i)%username%", "%name%");
                                    String val = FormatClientUtil.getFormatValue(internalmessage, new Hashtable(), this.domainName, "");
                                    val = EscapeUtil.powershellEscape((String)val);
                                    powerShellCommand.addParameter("InternalMessage", val);
                                    if (externalMsgState.booleanValue()) {
                                        externalmessage = externalmessage.replaceAll("(?i)%username%", "%name%");
                                        String val1 = FormatClientUtil.getFormatValue(externalmessage, new Hashtable(), this.domainName, "");
                                        powerShellCommand.addParameter("ExternalAudience", "All");
                                        val1 = EscapeUtil.powershellEscape((String)val1);
                                        powerShellCommand.addParameter("ExternalMessage", val1);
                                    } else {
                                        powerShellCommand.addParameter("ExternalAudience", "None");
                                    }
                                }
                                if ((msg = this.rb.getString(ADHandler.executePowershellCMD((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (PowerShellCommand)powerShellCommand, (Properties)exchangeServerDetails))).length() > 0) {
                                    Hashtable<String, String> hash = new Hashtable<String, String>();
                                    hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.auto_reply"), this.rb.getString(msg)));
                                    if (!this.isBulkMgmt) {
                                        if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                            this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                                        }
                                        ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                                    } else {
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.auto_reply"), this.rb.getString(msg)));
                                    }
                                    this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                                    this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                                    this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                }
                            }
                            if (updatePolicy.booleanValue() && CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                                ADHandler.updateEmailPolicy((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (Properties)exchangeServerDetails);
                            }
                            if (hideAddressBook == null && (props.get("msExchPoliciesIncluded") != null || props.get("mailAlias") == null || !policyIncluded.equalsIgnoreCase("true")) || !usePowerShell || this.msExchVersion == 0L) break;
                            ADHandler.setExchangeAttribute((String)this.domainName, (long)this.loginId, (String)this.distinguishedName, (String)recipientType, (String)hideAddressBook, (Properties)exchangeServerDetails, (String)((String)props.get("mailAlias")));
                            break;
                        }
                    }
                    boolean disableActionError = false;
                    if (!this.isBulkMgmt) {
                        creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
                        if (creationMsg != null) {
                            for (int i = 0; i < ((ArrayList)creationMsg).size(); ++i) {
                                String errorMsg = (String)((Hashtable)((ArrayList)creationMsg).get(i)).get("ERROR_MESSAGE");
                                if (!errorMsg.equals("admp.user_mgmt.native.warning.setting_account_properties")) continue;
                                disableActionError = true;
                                break;
                            }
                        }
                    } else {
                        creationMsg = (String)this.nativeStatusProps.get("CREATION_MESSAGE");
                        if (((String)creationMsg).contains("admp.user_mgmt.native.warning.setting_account_properties")) {
                            disableActionError = true;
                        }
                    }
                    if (this.disableAction && !disableActionError) {
                        HashMap policyMap;
                        String disableMessage;
                        Integer dnId;
                        String samName;
                        Hashtable<Object, String> result = new Hashtable<Object, String>();
                        result.put("OBJECT_GUID", this.guid);
                        mgmtLog.log(Level.INFO, "Executing disable policy for the User : " + this.distinguishedName);
                        String sid = null;
                        sid = this.oldDistinguishedName != null ? UserMgmtUtil.getSIDFromDN((String)this.domainName, (String)this.oldDistinguishedName) : UserMgmtUtil.getSIDFromDN((String)this.domainName, (String)this.distinguishedName);
                        if (sid == null) {
                            try {
                                ArrayList<String> attributeList = new ArrayList<String>();
                                list = new ArrayList<Hashtable>();
                                attributeList.add("objectSid");
                                String searchString = "(&(objectClass=user)(objectCategory=person)(distinguishedName=" + this.distinguishedName + "))";
                                Properties domainDetails = ADHandler.getDomainDetails((String)this.domainName, (Long)this.loginId);
                                list = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, (String)searchString);
                                if (list.size() > 0) {
                                    Properties p = (Properties)list.get(0);
                                    sid = StrUtil.getString((Properties)p, (String)"objectSid");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        mgmtLog.log(Level.INFO, "Executing disable policy for the User Sid  : " + sid);
                        HashMap policyStatusMap = new HashMap();
                        String ou = (String)result.get(1012);
                        if (ou == null || ou.equalsIgnoreCase("null") || ou.equalsIgnoreCase("-") || ou.equals("")) {
                            ou = StrUtil.getContainerDNFromDN((String)this.distinguishedName);
                            result.put(1012, ou);
                        }
                        if ((samName = (String)result.get(1006)) == null || samName.equalsIgnoreCase("null") || samName.equalsIgnoreCase("-") || samName.equals("")) {
                            samName = props.getProperty("samAccountName") != null ? props.getProperty("samAccountName") : (this.samAccountName != null ? this.samAccountName : "");
                            result.put(1006, samName);
                        }
                        if ((dnId = UserMgmtUtil.getAttributeId((String)"distinguishedName")) != null) {
                            result.put(dnId, this.distinguishedName);
                        }
                        this.disablePolicyMessage = DeleteUtil.executeDisablePolicyTasks(this.domainName, this.loginId, this.guid.substring(this.guid.indexOf("{") + 1, this.guid.indexOf("}")), this.distinguishedName, sid, result, this.rb, policyStatusMap);
                        if (policyStatusMap.size() > 0 && policyStatusMap.get(this.rb.getString("admp.admin.custom_settgs.del_policy.text_move_users_to_container")) != null && (disableMessage = (String)policyStatusMap.get(this.rb.getString("admp.admin.custom_settgs.del_policy.text_move_users_to_container"))) != null && disableMessage.equalsIgnoreCase(this.rb.getString("admp.common.text.success")) && Boolean.valueOf((String)(policyMap = DeprovisionUtil.getDisablePolicyMap((String)this.domainName)).get("move_users")).booleanValue()) {
                            String moveUserTo = (String)policyMap.get("move_users_to_ou");
                            this.distinguishedName = "CN=" + CommonUtil.escapeString((String)this.fullName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS) + "," + moveUserTo;
                        }
                    }
                    if (this.removedProxyAddresses.size() > 0) {
                        StringBuilder proxyError = new StringBuilder();
                        for (int index = 0; index < this.removedProxyAddresses.size(); ++index) {
                            Hashtable hash = (Hashtable)this.removedProxyAddresses.get(index);
                            if (index > 0) {
                                proxyError.append(", ");
                            }
                            String proxyAddress = (String)hash.get("PROXY_ADDRESS");
                            String assignedUserName = (String)hash.get("USER_NAME");
                            proxyError.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.msg_proxy_already_exist_for_the_user"), proxyAddress, assignedUserName));
                        }
                        String proxyErrorString = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.error_str.error_removed_proxy_addresses"), proxyError.toString());
                        Hashtable<String, String> errorHash = new Hashtable<String, String>();
                        errorHash.put("ERROR_MESSAGE", proxyErrorString);
                        errorHash.put("NATIVE_ERROR_MESSAGE", ".");
                        if (!this.isBulkMgmt) {
                            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                ArrayList<Hashtable<String, String>> errorList = new ArrayList<Hashtable<String, String>>();
                                errorList.add(errorHash);
                                this.nativeStatusProps.put("CREATION_MESSAGE", errorList);
                            } else {
                                ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(errorHash);
                            }
                        } else {
                            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + proxyErrorString);
                        }
                        this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    }
                    if (props.get("sendAs") != null) {
                        this.setSendAsList((ArrayList)props.get("sendAs"));
                    }
                    if (props.get("preventDeletion") != null) {
                        Properties grpList = new Properties();
                        grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                        grpList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.prevent_deletion"));
                        grpList.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        if (Boolean.valueOf(props.get("preventDeletion").toString()).booleanValue()) {
                            grpList.put("ATTRIB_VALUE", "true");
                            String rootName = StrUtil.getContainerDNFromDN((String)this.distinguishedName);
                            this.updatePreventDeletion(this.distinguishedName, "add");
                            if (!rootName.equalsIgnoreCase(defaultNamingContext)) {
                                this.updateParent(rootName);
                            }
                        } else {
                            grpList.put("ATTRIB_VALUE", "false");
                            this.updatePreventDeletion(this.distinguishedName, "delete");
                        }
                        propList.add(grpList);
                    }
                    break block227;
                }
                mgmtLog.log(Level.INFO, "No value is changed for the User : " + this.distinguishedName);
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.fc_layout_title.text_no_changes_found"));
                if (this.isBulkMgmt) {
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.fc_layout_title.text_no_changes_found"));
                }
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                this.isChangesFound = false;
            }
            if (!(CREATION_STATUS == null || CREATION_STATUS.equalsIgnoreCase("SEVERE") || CREATION_STATUS.equalsIgnoreCase("WARNING") || this.distinguishedName == null || this.toBeRemovedGroupList.isEmpty())) {
                String defaultNamingContext2 = DomainUtil.getDefaultNamingContext((String)this.domainName);
                ArrayList groupList = UserMgmtUtil.getGroupList((Long)this.loginId, (String)defaultNamingContext2);
                ArrayList<Properties> list = new ArrayList<Properties>();
                Properties p = new Properties();
                p.put("ATTRIB_VALUE", this.distinguishedName);
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("DATA_HANDLER_TYPE", new Long(3L));
                p.put("ATTRIB_LDAP_NAME", "member");
                p.put("DW_CONTROL_CODE", new Long(4L));
                list.add(p);
                for (int i = 0; i < this.toBeRemovedGroupList.size(); ++i) {
                    Properties prop = UserMgmtUtil.getPropertiesfromDN((String)((String)this.toBeRemovedGroupList.get(i)), (ArrayList)groupList);
                    String groupSid = null;
                    if (prop != null) {
                        groupSid = UserMgmtUtil.getGroupSIDfromRID((String)((String)prop.get("objectRID")), (ArrayList)groupList);
                    }
                    if (groupSid == null) continue;
                    try {
                        ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)this.loginId, (String)groupSid, (String)this.distinguishedName, list, null);
                        continue;
                    }
                    catch (LocalizedException le) {
                        le.printStackTrace();
                        Hashtable<String, String> hash = new Hashtable<String, String>();
                        hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.fc_layout.error_while_removing_group"), (String)prop.get("Display_Name")));
                        if (!this.isBulkMgmt) {
                            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                            }
                            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                        } else {
                            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.fc_layout.error_while_removing_group"), (String)prop.get("Display_Name")));
                        }
                        this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE") && this.distinguishedName != null) {
                Properties customScriptProps;
                if (dialinModified) {
                    String updatedSamName = props.getProperty("samAccountName") != null ? props.getProperty("samAccountName") : this.samAccountName;
                    NativeError dialInNativeError = ADHandler.updateDialInProps((String)this.domainName, (Long)this.loginId, (String)updatedSamName, (String)this.distinguishedName, (String)props.getProperty("dialIn"));
                    if (!this.isBulkMgmt) {
                        this.setSingleUserErrorMessage(dialInNativeError, "admp.user_mgmt.native.warning.setting_dialin_properties", this.samAccountName);
                    } else {
                        this.setBulkUserErrorMessage(dialInNativeError, "admp.user_mgmt.native.warning.setting_dialin_properties", this.samAccountName);
                    }
                }
                ArrayList<Properties> aceList = new ArrayList<Properties>();
                Properties ps = new Properties();
                ps.put("ACCESS_MASK", new Long(0x1F01FFL));
                ps.put("ACE_TYPE", new Long(0L));
                ps.put("INHERIT_TYPE_FLAG", new Long(3L));
                ps.put("DN", CommonUtil.escapeDN((String)this.distinguishedName));
                aceList.add(ps);
                if (!remoteHomeDir.equals("") && remoteHomeDir.startsWith("\\")) {
                    try {
                        Properties properties2 = (Properties)this.permissionProps.get("homeFolder");
                        String remoteDir = (String)properties2.get("remoteHomeDir");
                        long inheritLong = (Boolean)properties2.get("inheritPermissions") != false ? 0x20000000L : 0x80000000L;
                        NativeError nativeError = ADHandlerForMgmt.createFolder((String)this.domainName, (Long)this.loginId, (String)remoteDir, null, (String)CommonUtil.escapeDN((String)this.distinguishedName), (ArrayList)((ArrayList)properties2.get("folderPermissions")), (long)inheritLong);
                        if (!this.isBulkMgmt) {
                            AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"homeDir");
                        } else {
                            AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"homeDir");
                        }
                        if (nativeError.getErrors() == null && ((Boolean)properties2.get("createShare")).booleanValue()) {
                            NativeError nativeError2 = ADHandler.shareFolder((String)this.domainName, (Long)this.loginId, (String)((String)properties2.get("serverName")), (String)((String)properties2.get("shareName")), (String)((String)properties2.get("localPath")), (ArrayList)((ArrayList)properties2.get("sharePermissions")));
                            if (!this.isBulkMgmt) {
                                AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError2, (String)"homeDir");
                            } else {
                                AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError2, (String)"homeDir");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!tsRemoteHomeDir.equals("") && tsRemoteHomeDir.startsWith("\\")) {
                    try {
                        NativeError nativeError = ADHandlerForMgmt.createFolder((String)this.domainName, (Long)this.loginId, (String)tsRemoteHomeDir, null, (String)this.distinguishedName, aceList, (long)0x20000000L);
                        if (!this.isBulkMgmt) {
                            AddUserErrorHandler.setSingleUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"tsHomeDir");
                        } else {
                            AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)this.nativeStatusProps, (NativeError)nativeError, (String)"tsHomeDir");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((customScriptProps = (Properties)props.get("customScriptDetails")) != null) {
                    boolean ignoreWarning = (Boolean)customScriptProps.get("IGNORE_WARNING");
                    if (CREATION_STATUS.equalsIgnoreCase("SUCCESS") || ignoreWarning && CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                        this.customScriptResult = this.customScriptExecution(customScriptProps);
                    }
                }
                if (props.getProperty("userName") != null && !props.getProperty("userName").equals("")) {
                    this.modifiedFullName = props.getProperty("userName");
                    mgmtLog.log(Level.INFO, "Modifying Name Attribute :" + props.getProperty("userName") + " for the User : " + this.distinguishedName);
                    try {
                        ADHandlerForMgmt.modifyUserFullName((String)this.domainName, (Long)this.loginId, (String)this.distinguishedName, (String)this.modifiedFullName, null);
                        this.distinguishedName = StrUtil.updateFullNameToExistingDN((String)this.distinguishedName, (String)this.modifiedFullName);
                    }
                    catch (LocalizedException le) {
                        le.printStackTrace();
                        Hashtable<String, String> hash = new Hashtable<String, String>();
                        hash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_contacts.statmsg.error_modifying_fullname"), le.getMessage(this.rb)));
                        if (!this.isBulkMgmt) {
                            if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                                this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                            }
                            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                        } else {
                            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_contacts.statmsg.error_modifying_fullname"), le.getMessage(this.rb)));
                        }
                        this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (exchangePhotoFilePath != null && props.get("msExchHomeServerName") == null) {
                properties = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
                defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                Hashtable hash = (Hashtable)props.get("exchangePhoto");
                String uniqueOperationId = (String)hash.get("UNIQUE_OPERATION_ID");
                File photoFile = UserPhotoMgmtUtil.getMatchingFileForExecution((String)exchangePhotoFilePath, (String)"thumbnailPhoto", (String)uniqueOperationId);
                if (photoFile.exists()) {
                    ArrayList<Hashtable> list = new ArrayList<Hashtable>();
                    UserPhotoMgmtUtil.updateHashWithThumbnailPhotoAttribute((File)photoFile, (Hashtable)hash);
                    list.add(hash);
                    NativeError thumbnailPhotoError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)this.searchString, (String)StrUtil.getContainerDNFromDN((String)this.distinguishedName), null, list, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                    if (thumbnailPhotoError.getErrorList((Object)this.searchString).size() == 0) {
                        this.photoFileError = this.photoFileError + " " + this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_attrib_updated_successfully");
                    }
                }
            }
            if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE") && this.photoFileError.length() > 0) {
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put("ERROR_MESSAGE", this.rb.getString(this.photoFileError));
                if (!this.isBulkMgmt) {
                    if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                        this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                    }
                    ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(hash);
                } else {
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString(this.photoFileError));
                }
                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            }
            if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE") && this.distinguishedName != null && this.isLyncEnabled && this.rtcHomeServer != null) {
                String referrerPoolName = null;
                if (this.lyncPoolName != null) {
                    referrerPoolName = this.lyncPoolName;
                } else {
                    Properties lcsServerDetails = LCSServerHandler.getLCSLyncServerProperties((String)this.rtcHomeServer);
                    if (lcsServerDetails != null && lcsServerDetails.get("DNS_HOST_NAME") != null) {
                        referrerPoolName = (String)lcsServerDetails.get("DNS_HOST_NAME");
                    }
                }
                if (referrerPoolName != null) {
                    if (!this.lyncDetails.isEmpty() && !this.canConnectToLyncServer) {
                        if (!this.isBulkMgmt) {
                            this.setSingleUserErrorMessage(this.rb.getString("admp.mgmt.user_mgmt.create_lync.error.unable_to_load_runspace") + " - " + referrerPoolName);
                        } else {
                            this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString("admp.mgmt.user_mgmt.create_lync.error.unable_to_load_runspace") + " - " + referrerPoolName);
                        }
                    } else {
                        String lyncPIN;
                        String telephonyError;
                        String dcFqdn = this.getValidDCForLyncOperations(this.domainName, this.loginId, StrUtil.getContainerDNFromDN((String)this.distinguishedName));
                        ArrayList policyList = (ArrayList)this.lyncDetails.get("lyncPolicies");
                        if (policyList != null) {
                            ArrayList policyListForAD = FcLayoutUtil.getPoliciesForAD((ArrayList)policyList);
                            ArrayList grantPolicyErrors = ADHandlerForMgmt.grantPolicyforUser((ArrayList)policyListForAD, (String)this.distinguishedName, (String)this.domainName, (Long)this.loginId, (String)referrerPoolName, (String)dcFqdn);
                            for (int errorIndex = 0; errorIndex < grantPolicyErrors.size(); ++errorIndex) {
                                Properties policyStatusProp = (Properties)grantPolicyErrors.get(errorIndex);
                                String policyError = (String)policyStatusProp.get("IsSuccess");
                                String policyType = this.rb.getString("admp.mgmt.user_mgmt.cre_template.heading_" + (String)policyStatusProp.get("POLICY_TYPE"));
                                if (policyError == null || policyError.equalsIgnoreCase("true")) continue;
                                if (!this.isBulkMgmt) {
                                    this.setSingleUserErrorMessage(this.rb.getString(policyError));
                                    continue;
                                }
                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString(policyError));
                            }
                        }
                        String lineURI = (String)this.lyncDetails.get("lyncLineUri");
                        String lineServerURI = (String)this.lyncDetails.get("lyncLineServerUri");
                        String telephonyType = (String)this.lyncDetails.get("lyncTelephonyType");
                        String primarySIPAddress = (String)this.lyncDetails.get("lyncSipAddress");
                        ArrayList<Properties> telephonyList = new ArrayList<Properties>();
                        if (primarySIPAddress != null && primarySIPAddress.length() > 0) {
                            if (!primarySIPAddress.startsWith("sip:") && !primarySIPAddress.startsWith("SIP:")) {
                                primarySIPAddress = "sip:" + primarySIPAddress;
                            }
                            Properties telephonyProp = new Properties();
                            telephonyProp.put("PARAMETER", "SipAddress");
                            telephonyProp.put("VALUE", primarySIPAddress);
                            telephonyList.add(telephonyProp);
                        }
                        if (lineURI != null && lineURI.trim().length() > 0) {
                            Properties telephonyProp = new Properties();
                            telephonyProp.put("PARAMETER", "LineURI");
                            telephonyProp.put("VALUE", lineURI);
                            telephonyList.add(telephonyProp);
                        }
                        if (lineServerURI != null && lineServerURI.trim().length() > 0) {
                            Properties telephonyProp = new Properties();
                            telephonyProp.put("PARAMETER", "LineServerURI");
                            telephonyProp.put("VALUE", lineServerURI);
                            telephonyList.add(telephonyProp);
                        }
                        if (telephonyType != null && telephonyType.trim().length() > 0) {
                            Properties audioVideoDisableProps = new Properties();
                            audioVideoDisableProps.put("PARAMETER", "AudioVideoDisabled");
                            audioVideoDisableProps.put("VALUE", "$false");
                            Properties remoteCallControlProps = new Properties();
                            remoteCallControlProps.put("PARAMETER", "RemoteCallControlTelephonyEnabled");
                            remoteCallControlProps.put("VALUE", "$false");
                            Properties enterpriseProps = new Properties();
                            enterpriseProps.put("PARAMETER", "EnterpriseVoiceEnabled");
                            enterpriseProps.put("VALUE", "$false");
                            if (telephonyType.equalsIgnoreCase("EnterpriseVoiceEnabled")) {
                                enterpriseProps.put("VALUE", "$true");
                            } else if (telephonyType.equalsIgnoreCase("AudioVideoDisabled")) {
                                audioVideoDisableProps.put("VALUE", "$true");
                            } else if (telephonyType.equalsIgnoreCase("RemoteCallControlTelephonyEnabled")) {
                                remoteCallControlProps.put("VALUE", "$true");
                            } else if (telephonyType.equalsIgnoreCase("RemoteCallControlOnly")) {
                                remoteCallControlProps.put("VALUE", "$true");
                                audioVideoDisableProps.put("VALUE", "$true");
                            }
                            telephonyList.add(audioVideoDisableProps);
                            telephonyList.add(remoteCallControlProps);
                            telephonyList.add(enterpriseProps);
                        }
                        if (telephonyList.size() > 0 && (telephonyError = ADHandlerForMgmt.enableTelephonyOptions((String)this.distinguishedName, telephonyList, (String)this.domainName, (Long)this.loginId, (String)referrerPoolName, (String)dcFqdn)).length() != 0) {
                            mgmtLog.log(Level.INFO, " lync_telephony_error " + telephonyError);
                            if (!this.isBulkMgmt) {
                                this.setSingleUserErrorMessage(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.error_str.error_setting_lync_attribs") + " - " + this.rb.getString(telephonyError));
                            } else {
                                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.error_str.error_setting_lync_attribs") + " - " + this.rb.getString(telephonyError));
                            }
                        }
                        if ((lyncPIN = (String)this.lyncDetails.get("lyncPIN")) != null) {
                            Properties lyncPINResult = ADHandler.setLyncPIN((String)this.distinguishedName, (String)lyncPIN, (String)this.domainName, (Long)this.loginId, (String)referrerPoolName, (String)dcFqdn);
                            String returnPINValue = "";
                            if (lyncPINResult != null) {
                                if (lyncPINResult.get("pinError") != null) {
                                    String errorMsg = (String)lyncPINResult.get("pinError");
                                    mgmtLog.log(Level.INFO, " lync_pin_error " + errorMsg);
                                    if (!this.isBulkMgmt) {
                                        this.setSingleUserErrorMessage(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.error_str.error_setting_lync_pin") + " - " + this.rb.getString(errorMsg));
                                    } else {
                                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.error_str.error_setting_lync_pin") + " " + this.rb.getString(errorMsg));
                                    }
                                } else if (lyncPINResult.get("pinValue") != null) {
                                    this.lyncPin = (String)lyncPINResult.get("pinValue");
                                } else {
                                    System.out.println("PIN value not populated...");
                                }
                                Properties addProps = new Properties();
                                addProps.put("ATTRIB_LDAP_NAME", "lyncPIN");
                                if (this.lyncPin != null && !this.lyncPin.equals("")) {
                                    addProps.put("ATTRIB_VALUE", this.lyncPin);
                                } else if (lyncPIN.equals("")) {
                                    addProps.put("ATTRIB_VALUE", "automatic");
                                } else {
                                    addProps.put("ATTRIB_VALUE", lyncPIN);
                                }
                                this.lyncAuditPropList.add(addProps);
                            }
                        }
                    }
                }
            }
            String[] wfStatusColumns = new String[]{"displayName", "description", "sAMAccountName", "userPrincipalName", "mail"};
            if ((this.workFlowType == 0L || this.workFlowType == 1L) && this.fcNativeProperties.getPropList() != null && this.fcNativeProperties.getPropList().size() != 0) {
                ArrayList fcNatPropList = this.fcNativeProperties.getPropList();
                int updateColCount = 0;
                UpdateQueryImpl query = new UpdateQueryImpl("FcBulkUserSingleVals");
                Criteria crit = new Criteria(Column.getColumn((String)"FcBulkUserSingleVals", (String)"OBJECT_INDEX_ID"), (Object)this.objectIndexId, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)"FcBulkUserSingleVals", (String)"OBJECT_INDEX_TYPE"), (Object)FcExecuteActionConstants.resultDataId, 0));
                query.setCriteria(crit);
                for (int i = 0; i < fcNatPropList.size() && updateColCount < wfStatusColumns.length; ++i) {
                    Hashtable prop = (Hashtable)fcNatPropList.get(i);
                    String ldapName = (String)prop.get("ATTRIB_LDAP_NAME");
                    if (!Arrays.asList(wfStatusColumns).contains(ldapName)) continue;
                    query.setUpdateColumn((String)prop.get("ATTRIB_COLUMN_NAME"), (Object)((String)prop.get("ATTRIB_VALUE")));
                    ++updateColCount;
                }
                if (updateColCount != 0) {
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)query);
                }
            }
            mgmtLog.log(Level.INFO, " Fc User Modification Listener finished ");
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void addAttributeToNativeProps(FcFormDataContainer modifiedFieldsContainer, FcNativeProperties fcNativeProperties, Properties ldapVsValueProps) throws Exception {
        this.getProperties(true, modifiedFieldsContainer, fcNativeProperties, ldapVsValueProps, "user");
    }

    public void setIsCreationSuccess() {
        if (this.nativeStatusProps != null) {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                this.setIsCreationSuccess(true);
            }
        } else {
            this.setIsCreationSuccess(false);
        }
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
        request.setAttribute("password", (Object)this.password);
        request.setAttribute("passwordType", (Object)this.passwordType);
        request.setAttribute("lyncPin", (Object)this.lyncPin);
        request.setAttribute("customScriptResult", (Object)this.customScriptResult);
        this.hostId = request.getRemoteHost();
        Long tid = new Long(request.getParameter("templateId"));
        Properties toAudit = new Properties();
        toAudit.setProperty("TEMPLATE_NAME", FcLayoutViewHandler.getLayoutName((Long)tid, (AdventNetResourceBundle)this.rb));
        this.updateAuditEntries(null, toAudit);
    }

    public Long updateAuditEntries() {
        return this.updateAuditEntries(null);
    }

    public Long updateAuditEntries(ArrayList<Long> auditObjectIdList) {
        return this.updateAuditEntries(auditObjectIdList, null);
    }

    public Long updateAuditEntries(ArrayList<Long> auditObjectIdList, Properties toAudit) {
        Long audit_id = 0L;
        Long object_id = 0L;
        try {
            boolean savePassword;
            NotificationMacro macro;
            String value;
            Properties props;
            Integer reportId = 6006;
            if (!this.isBulkMgmt) {
                reportId = 6008;
            }
            if (this.isWorkflowExcution && this.workFlowType.compareTo(0L) == 0) {
                reportId = 6008;
            } else if (this.isWorkflowExcution) {
                reportId = 6006;
            }
            if (this.moduleUsed == null || this.moduleUsed.isEmpty()) {
                this.moduleUsed = this.workFlowType == 2L ? this.rb.getString("admp.workflow.listrequest.request_mode.ssp_api_request") : (this.workFlowType == 1L ? this.rb.getString("admp.auto.automation.heading.automation") : (this.workFlowType == 0L ? this.rb.getString("admp.home.feature.heading.workflow") : ""));
            }
            if (!(this.isChangesFound || this.fcNativeProperties.getPropList() != null && this.fcNativeProperties.getPropList().size() != 0 || this.fcNativeProperties.getModifyList() != null && this.fcNativeProperties.getModifyList().size() != 0 || this.fcNativeProperties.getTsList() != null && this.fcNativeProperties.getTsList().size() != 0 || this.fcNativeProperties.getWinNTAttributeList() != null && this.fcNativeProperties.getWinNTAttributeList().size() != 0 || this.groupList != null && this.groupList.size() != 0 || this.customList != null && this.customList.size() != 0)) {
                if (this.isWorkflowExcution()) {
                    NotificationMacro macro2 = (NotificationMacro)NotificationTemplateHandler.macroMap.get(this.wfRequestId);
                    if (macro2 != null && AutomationUtil.isNotifyEnabledAutomation((Long)((Long)macro2.getIds().get("automationId")))) {
                        this.auditDataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                        HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)reportId, (DataObject)this.auditDataObject, (AdventNetResourceBundle)this.rb, (String)this.moduleUsed, (Long)this.requestId, (String)this.actionName, (String)this.actionCategory);
                        HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)this.samAccountName, (String)this.domainName, (DataObject)this.auditDataObject);
                    }
                    return null;
                }
                if (this.moduleUsed.equals("ManageEngine ServiceDesk Plus")) {
                    return null;
                }
            }
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)this.moduleUsed, (Long)this.requestId, (String)this.actionName, (String)this.actionCategory);
            object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)this.samAccountName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            if (auditObjectIdList != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE")) {
                auditObjectIdList.add(object_id);
            }
            ArrayList propList = this.fcNativeProperties.getPropList();
            ArrayList<String> modifiedMemberOfValues = new ArrayList<String>();
            if (this.groupList != null && !this.groupList.isEmpty()) {
                modifiedMemberOfValues.add("<B>" + this.rb.getString("admp.audit.display_text.added") + "</B><br/>");
                for (String addedGroup : this.groupList) {
                    modifiedMemberOfValues.add(addedGroup);
                }
            }
            if (this.toBeRemovedGroupList != null && !this.toBeRemovedGroupList.isEmpty()) {
                String removedHeading = (modifiedMemberOfValues.isEmpty() ? "" : "<BR/>") + "<B>" + this.rb.getString("admp.audit.display_text.removed") + "</B><br/>";
                modifiedMemberOfValues.add(removedHeading);
                for (String removedGroup : this.toBeRemovedGroupList) {
                    modifiedMemberOfValues.add(removedGroup);
                }
            }
            if (!modifiedMemberOfValues.isEmpty()) {
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                grpList.put("ATTRIB_VALUE", modifiedMemberOfValues);
                propList.add(grpList);
            }
            ArrayList<String> moveUserAudit = new ArrayList<String>();
            if (this.oldDistinguishedName != null) {
                String ouname = DirectoryObjectUtil.getOUNameFromDN((String)this.oldDistinguishedName);
                String movedFrom = "<B>" + this.rb.getString("admp.mgmt.common.text.move_from") + "</B><br/>" + ouname;
                ouname = DirectoryObjectUtil.getOUNameFromDN((String)this.distinguishedName);
                String movedTo = "<br/><B>" + this.rb.getString("admp.mgmt.common.text.move_to") + "</B><br/>" + ouname;
                moveUserAudit.add(movedFrom);
                moveUserAudit.add(movedTo);
            }
            if (!moveUserAudit.isEmpty()) {
                Properties movedList = new Properties();
                movedList.put("ATTRIB_LDAP_NAME", "container");
                movedList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                movedList.put("ATTRIB_VALUE", moveUserAudit);
                propList.add(movedList);
            }
            if (this.customList != null && !this.customList.isEmpty()) {
                ArrayList<String> customAttributeList = new ArrayList<String>();
                for (Hashtable customAttribute : this.customList) {
                    String ldapVsValue = (String)customAttribute.get("ATTRIB_LDAP_NAME") + " : " + customAttribute.get("ATTRIB_VALUE").toString() + "<br/>";
                    customAttributeList.add(ldapVsValue);
                }
                Properties customAuditList = new Properties();
                customAuditList.put("ATTRIB_LDAP_NAME", "customAttributes");
                customAuditList.put("ATTRIB_VALUE_COUNT", (Object)customAttributeList.size());
                customAuditList.put("ATTRIB_VALUE", customAttributeList);
                propList.add(customAuditList);
            }
            if (this.modifiedFullName != null) {
                Properties nameList = new Properties();
                nameList.put("ATTRIB_LDAP_NAME", "name");
                nameList.put("ATTRIB_VALUE", this.modifiedFullName);
                propList.add(nameList);
            }
            if (this.password != null) {
                Properties pwdProps = new Properties();
                pwdProps.put("ATTRIB_LDAP_NAME", "password");
                pwdProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.password"));
                pwdProps.put("ATTRIB_VALUE", this.password);
                propList.add(pwdProps);
            }
            if ((props = this.fcNativeProperties.getProps()).getProperty("dialIn") != null) {
                Properties dialInProps = new Properties();
                String value2 = props.getProperty("dialIn");
                if (value2.length() == 0) {
                    value2 = this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.attribname_ctrl_access_remote_policy");
                }
                dialInProps.put("ATTRIB_LDAP_NAME", "msNPAllowDialin");
                dialInProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.allow_dialin"));
                dialInProps.put("ATTRIB_VALUE", value2);
                propList.add(dialInProps);
            }
            if (props.get("sendAs") != null) {
                ArrayList sIDList = (ArrayList)props.get("sendAs");
                ArrayList<String> dNList = new ArrayList<String>();
                ArrayList remainingSIDs = (ArrayList)sIDList.clone();
                String[] tableArray = new String[]{"ADSMUserGeneralDetails", "ADSMGroupGeneralDetails"};
                String[] requiredColumns = new String[]{"DISTINGUISHED_NAME", "SID_STRING"};
                String criteriaColumn = "SID_STRING";
                ArrayList dbValuesList = FcLayoutUtil.getValuesFromTable((String[])tableArray, (String[])requiredColumns, (String)criteriaColumn, (ArrayList)sIDList);
                for (int i = 0; i < dbValuesList.size(); ++i) {
                    Properties dbValueProp = (Properties)dbValuesList.get(i);
                    dNList.add(dbValueProp.getProperty("DISTINGUISHED_NAME"));
                    remainingSIDs.remove(dbValueProp.getProperty("SID_STRING"));
                }
                if (!remainingSIDs.isEmpty()) {
                    dNList.addAll(remainingSIDs);
                }
                Properties sendAsProps = new Properties();
                sendAsProps.put("ATTRIB_LDAP_NAME", "sendAs");
                sendAsProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.send_as"));
                sendAsProps.put("ATTRIB_VALUE", dNList);
                propList.add(sendAsProps);
            }
            Properties autoProps = new Properties();
            String autoReplyState = null;
            String starttime = null;
            String endtime = null;
            String internalmessage = null;
            String externalmessage = null;
            if (props.get("autoReplyState") != null) {
                autoReplyState = props.getProperty("autoReplyState");
            }
            if (autoReplyState != null) {
                Boolean externalMsgState = Boolean.valueOf(props.getProperty("externalMsgState"));
                if (props.get("internalmessage") != null) {
                    internalmessage = props.getProperty("internalmessage");
                }
                if (props.get("externalmessage") != null) {
                    externalmessage = props.getProperty("externalmessage");
                }
                if (props.get("sDateValue") != null && props.getProperty("sDateValue").length() > 5) {
                    starttime = props.getProperty("sDateValue");
                }
                if (props.get("eDateValue") != null && props.getProperty("eDateValue").length() > 5) {
                    endtime = props.getProperty("eDateValue");
                }
                autoProps.put("ATTRIB_LDAP_NAME", "AutoReplyState");
                if (autoReplyState.equalsIgnoreCase("Scheduled")) {
                    autoProps.put("ATTRIB_VALUE", "Scheduled");
                    propList.add(autoProps);
                    if (starttime != null && endtime != null) {
                        autoProps = new Properties();
                        autoProps.put("ATTRIB_LDAP_NAME", "StartTime");
                        autoProps.put("ATTRIB_VALUE", starttime);
                        propList.add(autoProps);
                        autoProps = new Properties();
                        autoProps.put("ATTRIB_LDAP_NAME", "EndTime");
                        autoProps.put("ATTRIB_VALUE", endtime);
                        propList.add(autoProps);
                    }
                } else if (autoReplyState.equalsIgnoreCase("Enabled")) {
                    autoProps.put("ATTRIB_VALUE", "Enabled");
                    propList.add(autoProps);
                } else {
                    autoProps.put("ATTRIB_VALUE", "Disabled");
                    propList.add(autoProps);
                }
                if (internalmessage != null) {
                    internalmessage = internalmessage.replaceAll("(?i)%username%", "%name%");
                    String val = FormatClientUtil.getFormatValue(internalmessage, new Hashtable(), this.domainName, "");
                    autoProps = new Properties();
                    autoProps.put("ATTRIB_LDAP_NAME", "InternalMessage");
                    autoProps.put("ATTRIB_VALUE", val);
                    propList.add(autoProps);
                    if (externalMsgState.booleanValue()) {
                        externalmessage = externalmessage.replaceAll("(?i)%username%", "%name%");
                        String val1 = FormatClientUtil.getFormatValue(externalmessage, new Hashtable(), this.domainName, "");
                        autoProps = new Properties();
                        autoProps.put("ATTRIB_LDAP_NAME", "ExternalMessage");
                        autoProps.put("ATTRIB_VALUE", val1);
                        propList.add(autoProps);
                        autoProps = new Properties();
                        autoProps.put("ATTRIB_LDAP_NAME", "ExternalAudience");
                        autoProps.put("ATTRIB_VALUE", "All");
                        propList.add(autoProps);
                    } else {
                        autoProps = new Properties();
                        autoProps.put("ATTRIB_LDAP_NAME", "ExternalAudience");
                        autoProps.put("ATTRIB_VALUE", "NONE");
                        propList.add(autoProps);
                    }
                }
            }
            if ((value = props.getProperty("msExchArchiveDatabaseLink")) != null && !value.equals("")) {
                Properties localArcProps = new Properties();
                if (value.equals("0")) {
                    value = this.rb.getString("admp.mgmt.user_mgmt.cre_template.auto_select_mailbox");
                }
                localArcProps.put("ATTRIB_LDAP_NAME", "msExchArchiveDatabaseLink");
                localArcProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.mgmt.user_mgmt.create_archive_mailbox.text.archive_database"));
                localArcProps.put("ATTRIB_VALUE", value);
                propList.add(localArcProps);
            }
            if ((value = props.getProperty("msExchArchiveAddress")) != null && !value.equals("")) {
                Properties remoteArcProps = new Properties();
                remoteArcProps.put("ATTRIB_LDAP_NAME", "msExchArchiveAddress");
                remoteArcProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.mgmt.user_mgmt.create_archive_mailbox.text.archive_domain"));
                remoteArcProps.put("ATTRIB_VALUE", value);
                propList.add(remoteArcProps);
            }
            if (toAudit != null) {
                Properties propToAud = new Properties();
                propToAud.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.cre_template.text_template_name"));
                propToAud.put("ATTRIB_VALUE", toAudit.getProperty("TEMPLATE_NAME"));
                propList.add(propToAud);
            }
            if (!this.lyncAuditPropList.isEmpty()) {
                propList.addAll(this.lyncAuditPropList);
            }
            try {
                int propListSize = propList.size();
                for (int i = 0; i < propListSize; ++i) {
                    Hashtable curProp = (Hashtable)propList.get(i);
                    if (!curProp.get("ATTRIB_LDAP_NAME").equals("logonHours")) continue;
                    curProp.put("ATTRIB_VALUE", FcLogonHours.bytesToHex((ArrayList)((ArrayList)curProp.get("ATTRIB_VALUE"))));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String status = "";
            if (!this.isBulkMgmt) {
                ArrayList creationMsg;
                String string = status = this.nativeStatusProps.getProperty("STATUS_MESSAGE") != null ? this.nativeStatusProps.getProperty("STATUS_MESSAGE") : "";
                if (this.disablePolicyMessage.length() > 0) {
                    status = status + " " + this.disablePolicyMessage;
                }
                if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                    this.nativeStatusProps.put("CREATION_MESSAGE", new ArrayList());
                }
                if ((creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")) != null && !creationMsg.isEmpty()) {
                    for (int i = 0; i < creationMsg.size(); ++i) {
                        Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                        String errorCode = (String)creationMessage.get("ERROR_CODE");
                        if (errorCode != null && !errorCode.equalsIgnoreCase("0")) {
                            status = status + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + errorCode + " : ";
                        }
                        status = status + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE"));
                        if (creationMessage.get("NATIVE_ERROR_MESSAGE") == null) continue;
                        status = status + creationMessage.get("NATIVE_ERROR_MESSAGE");
                    }
                }
            } else {
                status = (String)this.nativeStatusProps.get("CREATION_MESSAGE");
                if (this.isWorkflowExcution && this.isBulkMgmt && this.disablePolicyMessage.length() > 0) {
                    status = status + " " + this.disablePolicyMessage;
                }
                if (this.rusMessage.trim().length() > 0) {
                    status = status + " " + this.rusMessage;
                }
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", status);
            }
            TechAuditAPI.getInstance().auditUserModification(this.loginId, this.rb.getString("admp.mgmt.user_mgmt.mod_sing_user.mgmtname.mod_sing_user"), this.samAccountName, this.domainName, propList, this.fcNativeProperties.getModifyList(), this.fcNativeProperties.getWinNTAttributeList(), this.fcNativeProperties.getTsList(), null, status, object_id, auditDataObj, this.rb);
            audit_info.put("error_msg", status);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            if (!this.nativeStatusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE")) {
                DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"User"}, (boolean)false);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            TechAuditAPI.getInstance().auditLogs(this.loginId, this.auditLogProps, status, "Single User Modification ", this.rb);
            if (!this.isBulkMgmt && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("SEVERE")) {
                Integer userObjectId = 1;
                String manager = "";
                FcLayoutField field = this.userData.get((Object)FcExecuteActionConstants.USER_MODIFICATION_MANAGER_FIELD_ID) != null ? (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.USER_MODIFICATION_MANAGER_FIELD_ID) : (FcLayoutField)this.fromClientData.get((Object)FcExecuteActionConstants.USER_MODIFICATION_MANAGER_FIELD_ID);
                if (field != null) {
                    FcManager fcManager = (FcManager)field.getIComponent();
                    manager = fcManager.getUserName() != null ? fcManager.getUserName() : "";
                }
                this.viewId = -1L;
                String ouName = DirectoryObjectUtil.getOUNameFromDN((String)this.distinguishedName);
                ArrayList<String> objectOUList = new ArrayList<String>();
                objectOUList.add(ouName);
                this.triggerNotifiation(audit_id, object_id, this.samAccountName, manager, this.password, userObjectId, ReportsUtil.SINGLE_USER_MODIFICATION_REPORT_ID, this.domainName, this.rb, objectOUList);
            }
            if (this.isWorkflowExcution() && (macro = (NotificationMacro)NotificationTemplateHandler.macroMap.get(this.wfRequestId)) != null && AutomationUtil.isNotifyEnabledAutomation((Long)((Long)macro.getIds().get("automationId")))) {
                if (this.auditDataObject != null) {
                    this.auditDataObject.merge(auditDataObj);
                } else {
                    this.auditDataObject = auditDataObj;
                }
            }
            if (savePassword = PasswordUtil.getSavePasswordValue()) {
                FcLayoutUpdateHandler.updatePwdInUserMgmtAction((Long)this.objectIndexId, (String)this.password);
            } else if (this.isBulkLayoutMgmt || this.workFlowType == 0L || this.workFlowType == 1L) {
                FcLayoutUpdateHandler.updatePwdInUserMgmtAction((Long)this.objectIndexId, (String)this.password);
            } else {
                FcLayoutUpdateHandler.updatePwdInUserMgmtAction((Long)this.objectIndexId, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return audit_id;
    }

    public Properties getSingleUserErrorMessage(NativeError statusObject) {
        String statusMessage = this.rb.getString("admp.reports.common.status_msg.successfully_updated");
        String errStatusMessage = this.rb.getString("admp.mgmt.common.statmsg.updated_with_errors");
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        String errorSeverity = null;
        if (statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.domainName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.domainName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.distinguishedName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.distinguishedName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.distinguishedName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.searchString, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.searchString);
            errorSeverity = statusObject.getSeverityLevel((Object)this.searchString);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        if (!this.searchString.equals(this.samAccountName) && statusObject.getErrorMessage((Object)this.samAccountName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.samAccountName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.samAccountName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) == null || (errorList = statusObject.getErrorList(object)).isEmpty()) continue;
            for (Hashtable hashtable : errorList) {
                messageList.add(hashtable);
            }
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("STATUS_MESSAGE", errStatusMessage);
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    public void setSingleUserErrorMessage(NativeError errHdlr, String errorKey, String searchKey) {
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        if (errHdlr.getErrorMessage((Object)searchKey, this.rb) != null) {
            messageList = (ArrayList<Hashtable>)this.nativeStatusProps.get("CREATION_MESSAGE");
            if (messageList == null) {
                messageList = new ArrayList<Hashtable>();
            }
            errorList = errHdlr.getErrorList((Object)searchKey);
            for (Hashtable hashtable : errorList) {
                String message = this.rb.getString((String)hashtable.get("ERROR_MESSAGE"));
                message = MessageFormat.format(this.rb.getString(errorKey), message);
                hashtable.put("ERROR_MESSAGE", message);
                messageList.add(hashtable);
            }
            this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        }
    }

    public void setBulkUserErrorMessage(NativeError errHdlr, String errorKey, String searchKey) {
        ArrayList messageList = new ArrayList();
        ArrayList errorList = new ArrayList();
        if (errHdlr.getErrorMessage((Object)searchKey, this.rb) != null) {
            errorList = errHdlr.getErrorList((Object)searchKey);
            for (Hashtable hashtable : errorList) {
                String message = this.rb.getString((String)hashtable.get("ERROR_MESSAGE"));
                message = MessageFormat.format(this.rb.getString(errorKey), message);
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + message);
            }
            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        }
    }

    public Properties getBulkUserErrorMessage(NativeError statusObject) {
        String statusMessage = this.rb.getString("admp.ad_mgmt.modify_user.successfully_updated__user");
        Properties statusProps = new Properties();
        StringBuilder messageBuilder = new StringBuilder();
        StringBuilder errCodeBuilder = new StringBuilder();
        String message = null;
        String errorSeverity = null;
        if (statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.domainName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.domainName);
            errCodeBuilder.append(this.getErrorCodes(this.domainName, statusObject));
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", message);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.fullName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.fullName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.fullName);
            errCodeBuilder.append(this.getErrorCodes(this.fullName, statusObject));
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
                return statusProps;
            }
            messageBuilder.append(message);
        } else if (statusObject.getErrorMessage((Object)this.searchString, this.rb) != null && statusObject.getErrorMessage((Object)this.searchString, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.searchString, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.searchString);
            errCodeBuilder.append(this.getErrorCodes(this.searchString, statusObject));
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
                return statusProps;
            }
            messageBuilder.append(message);
        }
        if (!this.fullName.equals(this.samAccountName) && statusObject.getErrorMessage((Object)this.samAccountName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.samAccountName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.samAccountName);
            errCodeBuilder.append(this.getErrorCodes(this.samAccountName, statusObject));
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
                return statusProps;
            }
            messageBuilder.append(message);
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) != null) {
                messageBuilder.append(statusObject.getErrorMessage(object, this.rb));
            }
            errCodeBuilder.append(this.getErrorCodes(object, statusObject));
        }
        if (messageBuilder.length() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.ad_mgmt.modify_user.successfully_updated__user_but_following_errors_occured"), messageBuilder.toString()));
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("CREATION_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
        return statusProps;
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public Properties getNativeStatusProps() {
        return null;
    }

    public void setSingleUserErrorMessage(String errorMessage) {
        ArrayList messageList = new ArrayList();
        messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
        if (messageList == null) {
            messageList = new ArrayList();
        }
        Hashtable<String, String> errorHash = new Hashtable<String, String>();
        errorHash.put("ERROR_MESSAGE", errorMessage);
        messageList.add(errorHash);
        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
    }

    @Override
    public boolean isAuthorizedObject() {
        boolean isAuthorizedObject = false;
        if (this.authorizedOUList == null || this.authorizedOUList.size() == 0 || this.distinguishedName == null) {
            isAuthorizedObject = true;
        } else {
            for (int i = 0; i < this.authorizedOUList.size(); ++i) {
                String dn = ((String)this.authorizedOUList.get(i)).toLowerCase();
                String s = this.distinguishedName.toLowerCase();
                if (!s.endsWith(dn)) continue;
                isAuthorizedObject = true;
            }
        }
        return isAuthorizedObject;
    }

    @Override
    public void removeLyncAttributes(ArrayList attribList) {
        this.selectedLyncAttributes = new ArrayList();
        attribList.remove("IsPINSet");
        for (int i = 0; i < productLyncLdapNames.length; ++i) {
            if (!attribList.remove(productLyncLdapNames[i])) continue;
            if (productLyncLdapNames[i].equalsIgnoreCase("lyncTelephonyType")) {
                this.selectedLyncAttributes.add("EnterpriseVoiceEnabled");
                this.selectedLyncAttributes.add("RemoteCallControlTelephonyEnabled");
                this.selectedLyncAttributes.add("AudioVideoDisabled");
                continue;
            }
            this.selectedLyncAttributes.add(lyncPowershellAttributeNames[i]);
        }
    }
}

