/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.IMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcNamingFormat;
import com.adventnet.sym.adsm.common.server.layout.component.IComponent;
import com.adventnet.sym.adsm.common.server.layout.dataprovider.IDataProvider;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRule;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleField;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleGroup;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleHandler;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcFormatClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class MgmtRuleFlow {
    private static Logger logg = Logger.getLogger("FcLogger");

    public static ArrayList<JSONObject> getConditionFieldsDetails(MgmtRule mgmtRuleObj) {
        ArrayList<JSONObject> fieldDetailsList = new ArrayList<JSONObject>();
        try {
            for (MgmtRuleField mgmtRuleField : mgmtRuleObj.getMgmtRuleFieldList()) {
                if (!mgmtRuleField.getIsRulingField().booleanValue()) continue;
                JSONObject ruleFieldObj = mgmtRuleField.serializeToJsonObject();
                Long fieldId = ruleFieldObj.getLong("fieldId");
                String fieldDetailsStr = FcLayoutViewHandler.getFieldDetails((Long)fieldId);
                JSONObject fieldObj = new JSONObject(fieldDetailsStr);
                String attribDisplayText = fieldObj.getString("attribDisplayText");
                Long defaultComponentId = fieldObj.getLong("defaultComponentId");
                ruleFieldObj.put("attribDisplayText", (Object)attribDisplayText);
                ruleFieldObj.put("defaultComponentId", (Object)defaultComponentId);
                ruleFieldObj.put("isDomainSpecificField", fieldObj.getBoolean("isDomainSpecificField"));
                ruleFieldObj.put("domainSpecificDataProviderClassName", (Object)fieldObj.getString("domainSpecificDataProviderClassName"));
                int processingOrder = ruleFieldObj.getInt("processingOrder");
                boolean index = false;
                if (fieldDetailsList.size() > 0) {
                    boolean added = false;
                    for (int i = 0; i < fieldDetailsList.size(); ++i) {
                        JSONObject ruleFieldObjTemp = fieldDetailsList.get(i);
                        int order = ruleFieldObjTemp.getInt("processingOrder");
                        if (processingOrder >= order) continue;
                        added = true;
                        fieldDetailsList.add(i, ruleFieldObj);
                        break;
                    }
                    if (added) continue;
                    fieldDetailsList.add(ruleFieldObj);
                    continue;
                }
                fieldDetailsList.add(ruleFieldObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldDetailsList;
    }

    public static ArrayList<JSONObject> getResultFieldsDetails(MgmtRule mgmtRuleObj, AdventNetResourceBundle rb, Long loginId, String domainName) {
        ArrayList<JSONObject> fieldDetailsList = new ArrayList<JSONObject>();
        String domainSpecificproviderClassName = "";
        try {
            for (MgmtRuleField mgmtRuleField : mgmtRuleObj.getMgmtRuleFieldList()) {
                if (mgmtRuleField.getIsRulingField().booleanValue()) continue;
                JSONObject ruleFieldObj = mgmtRuleField.serializeToJsonObject();
                Long fieldId = mgmtRuleField.getFieldId();
                String fieldDetailsStr = FcLayoutViewHandler.getFieldDetails((Long)fieldId);
                JSONObject fieldObj = new JSONObject(fieldDetailsStr);
                String fieldName = fieldObj.getString("fieldName");
                Long defaultComponentId = fieldObj.getLong("defaultComponentId");
                String attribDisplayText = fieldObj.getString("attribDisplayText");
                JSONObject componentJsonObj = FcLayoutViewHandler.getComponentDetails((Long)defaultComponentId);
                String providerClassName = componentJsonObj.getString("DATA_PROVIDER_CLASS");
                Class<?> componentProviderClass = Class.forName(providerClassName);
                IComponent iComponent = (IComponent)componentProviderClass.newInstance();
                boolean isDomainSpecificField = fieldObj.getBoolean("isDomainSpecificField");
                if (isDomainSpecificField) {
                    domainSpecificproviderClassName = fieldObj.getString("domainSpecificDataProviderClassName");
                    Class<?> domainSpecificDataProviderClass = Class.forName(domainSpecificproviderClassName);
                    IDataProvider iDataProvider = (IDataProvider)domainSpecificDataProviderClass.newInstance();
                    iDataProvider.setDefaultValue(FcLayoutUtil.getDPValues((Long)loginId, (String)domainName, (AdventNetResourceBundle)rb), iComponent, defaultComponentId.intValue(), domainName, rb, loginId);
                }
                iComponent.fillMgmtRuleValue(ruleFieldObj);
                String commaSeparatedValue = "";
                commaSeparatedValue = defaultComponentId.equals(FcExecuteActionConstants.MEMBEROF_COMPONENT_ID) || defaultComponentId.equals(FcExecuteActionConstants.MEMBEROFWITHPG_COMPONENT_ID) || defaultComponentId.equals(FcExecuteActionConstants.CONFIG_MEMBEROF_COMPONENT_ID) || defaultComponentId.equals(FcExecuteActionConstants.CONFIG_MEMBEROFWITHPG_COMPONENT_ID) ? iComponent.getRuleFieldListDisplayValueWithAppend(rb, true) : iComponent.getRuleFieldListDisplayValue(rb, true);
                JSONObject newRuleFieldObj = new JSONObject();
                newRuleFieldObj.put("fieldName", (Object)fieldName);
                newRuleFieldObj.put("fieldId", (Object)fieldId);
                newRuleFieldObj.put("value", (Object)commaSeparatedValue);
                newRuleFieldObj.put("ruleFieldId", ruleFieldObj.getLong("ruleFieldId"));
                newRuleFieldObj.put("defaultComponentId", (Object)defaultComponentId);
                newRuleFieldObj.put("isDomainSpecificField", isDomainSpecificField);
                newRuleFieldObj.put("domainSpecificDataProviderClassName", (Object)fieldObj.getString("domainSpecificDataProviderClassName"));
                newRuleFieldObj.put("attribDisplayText", (Object)attribDisplayText);
                fieldDetailsList.add(newRuleFieldObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldDetailsList;
    }

    public static String getCriteriaPatternValue(MgmtRule mgmtRuleObj, AdventNetResourceBundle rb) {
        String criteriaPatternValue = "1";
        ArrayList<JSONObject> conditionFieldsDetails = MgmtRuleFlow.getConditionFieldsDetails(mgmtRuleObj);
        try {
            for (int fieldOrder = 1; fieldOrder < conditionFieldsDetails.size(); ++fieldOrder) {
                JSONObject conditionfieldObj = conditionFieldsDetails.get(fieldOrder);
                String processMatchCriteria = conditionfieldObj.getString("processMatchCriteria");
                criteriaPatternValue = processMatchCriteria.equalsIgnoreCase("and") ? criteriaPatternValue + " " + rb.getString("admp.mgmt.fc_layout.component_text.and") : criteriaPatternValue + " " + rb.getString("admp.mgmt.fc_layout.component_text.or");
                criteriaPatternValue = criteriaPatternValue + " " + (fieldOrder + 1);
                criteriaPatternValue = "( " + criteriaPatternValue + " )";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return criteriaPatternValue;
    }

    public static JSONObject getComponentDetails(JSONObject ruleFieldDetailsObj, String domainName, Long loginId, AdventNetResourceBundle rb) {
        IComponent iComponent = null;
        try {
            Long componentId = ruleFieldDetailsObj.getLong("defaultComponentId");
            JSONObject componentJsonObj = FcLayoutViewHandler.getComponentDetails((Long)componentId);
            String providerClassName = componentJsonObj.getString("DATA_PROVIDER_CLASS");
            Class<?> componentProviderClass = Class.forName(providerClassName);
            iComponent = (IComponent)componentProviderClass.newInstance();
            boolean isDomainSpecificField = ruleFieldDetailsObj.getBoolean("isDomainSpecificField");
            if (isDomainSpecificField) {
                String domainSpecificproviderClassName = ruleFieldDetailsObj.getString("domainSpecificDataProviderClassName");
                Class<?> domainSpecificDataProviderClass = Class.forName(domainSpecificproviderClassName);
                IDataProvider iDataProvider = (IDataProvider)domainSpecificDataProviderClass.newInstance();
                iDataProvider.setDefaultValue(FcLayoutUtil.getDPValues((Long)loginId, (String)domainName, (AdventNetResourceBundle)rb), iComponent, componentId.intValue(), domainName, rb, loginId);
            }
            iComponent.fillMgmtRuleValue(ruleFieldDetailsObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iComponent.serializeToJSONObject();
    }

    public static JSONArray getSupportedMatchCriterias(Long fieldId, AdventNetResourceBundle rb) {
        JSONArray supportedMatchCriteriasArray = new JSONArray();
        try {
            supportedMatchCriteriasArray = MgmtRuleHandler.getSupportedMatchCriteriaDetails((Long)fieldId, (AdventNetResourceBundle)rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return supportedMatchCriteriasArray;
    }

    public static boolean isRuleConditionsSatisfied(ArrayList<MgmtRuleField> fieldsArrayInRule, FcFormDataContainer fcFormDataContainer) {
        boolean returnValue = false;
        try {
            JSONArray critFieldsStatusArray = new JSONArray();
            boolean isRulingFieldPresent = false;
            for (MgmtRuleField mgmtRuleField : fieldsArrayInRule) {
                if (!mgmtRuleField.getIsRulingField().booleanValue()) continue;
                isRulingFieldPresent = true;
                Long fieldId = mgmtRuleField.getFieldId();
                FcLayoutField fcLayoutField = (FcLayoutField)fcFormDataContainer.get((Object)fieldId);
                if (fcLayoutField == null) continue;
                boolean isSatisified = fcLayoutField.isConditionSatisfied(mgmtRuleField.serializeToJsonObject(), mgmtRuleField.getMatchCriteriaId());
                JSONObject critFieldObj = new JSONObject();
                critFieldObj.put("processingOrder", mgmtRuleField.getProcessingOrder());
                critFieldObj.put("processMatchCriteria", (Object)mgmtRuleField.getProcessMatchCriteria());
                critFieldObj.put("status", isSatisified);
                critFieldsStatusArray.put((Object)critFieldObj);
            }
            if (critFieldsStatusArray.length() == 0 && !isRulingFieldPresent) {
                return true;
            }
            returnValue = FcLayoutUtil.isConditionsSatisfied((JSONArray)critFieldsStatusArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static String applyMgmtRulesInLayout(Long layoutId, FcFormDataContainer fromClientData, AdventNetResourceBundle rb, FcFormDataContainer templateData, FcFormDataContainer userData, FcFormDataContainer adData) {
        Hashtable<Long, String> m = new Hashtable<Long, String>();
        try {
            Long[] assignedRulesIds = MgmtRuleHandler.getAssignedRuleIds((Long)layoutId);
            Hashtable ruleVsFields = assignedRulesIds != null && assignedRulesIds.length != 0 ? MgmtRuleHandler.getFieldsDetailsInRule((Long[])assignedRulesIds, (AdventNetResourceBundle)rb) : new Hashtable();
            Long templateCategoryId = FcLayoutViewHandler.getTemplateCategoryId((Long)layoutId);
            boolean isModification = templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0;
            MgmtRuleFlow.resetFieldValues(m, ruleVsFields, templateCategoryId, fromClientData, rb, templateData, userData, adData, isModification);
            FcFormDataContainer actulalFromClientData = fromClientData.clone();
            if (assignedRulesIds != null) {
                for (Long ruleId : assignedRulesIds) {
                    ArrayList fieldsArrayInRule = ruleVsFields.containsKey(ruleId) ? (ArrayList)ruleVsFields.get(ruleId) : MgmtRuleHandler.getFieldsDetailsInRule((Long)ruleId, (AdventNetResourceBundle)rb);
                    boolean canApplyRule = MgmtRuleFlow.isRuleConditionsSatisfied(fieldsArrayInRule, actulalFromClientData);
                    logg.log(Level.INFO, "RuleId : " + ruleId + "... can Apply the Rule : " + canApplyRule);
                    for (MgmtRuleField mgmtRuleField : fieldsArrayInRule) {
                        FcLayoutField templateField;
                        Long fieldId;
                        FcLayoutField fcLayoutField;
                        if (mgmtRuleField.getIsRulingField().booleanValue() || (fcLayoutField = (FcLayoutField)fromClientData.get((Object)(fieldId = mgmtRuleField.getFieldId()))) == null) continue;
                        if (userData.containsKey((Object)fieldId)) {
                            m.put(fcLayoutField.getFieldId(), fcLayoutField.serializeToJsonObject().toString());
                            continue;
                        }
                        if (!canApplyRule) continue;
                        if (fcLayoutField.getComponentId().intValue() == 24 && (FcNamingFormat.formatIdVsValue == null || FcNamingFormat.formatIdVsName == null)) {
                            FcNamingFormat.formatIdVsValue = new Hashtable();
                            FcNamingFormat.formatIdVsName = new Hashtable();
                            FcFormatClientUtil.getFormatIdVsNameAndValues(rb, FcNamingFormat.formatIdVsName, FcNamingFormat.formatIdVsValue);
                        }
                        fcLayoutField.getIComponent().fillMgmtRuleValue(mgmtRuleField.serializeToJsonObject());
                        if (fcLayoutField.getComponentId().intValue() == 24 && (templateField = (FcLayoutField)templateData.get((Object)fieldId)) != null) {
                            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
                            iMgmtHandler.updateFieldsAttributes(fromClientData);
                            iMgmtHandler.updateFieldValuesToAttributes(fromClientData);
                            Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(fromClientData, new Properties());
                            ArrayList<Long> namingFormatField = new ArrayList<Long>();
                            namingFormatField.add(fieldId);
                            FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, namingFormatField, fromClientData, userData);
                        }
                        m.put(fcLayoutField.getFieldId(), fcLayoutField.serializeToJsonObject().toString());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = new JSONObject(m);
        logg.log(Level.INFO, "After applying Mgmt Rule -- Json string: " + jsonObject.toString());
        return jsonObject.toString();
    }

    private static void resetFieldValues(Map m, Hashtable<Long, ArrayList<MgmtRuleField>> ruleVsFields, Long templateCategoryId, FcFormDataContainer fromClientData, AdventNetResourceBundle rb, FcFormDataContainer templateData, FcFormDataContainer userData, FcFormDataContainer adData, Boolean isModification) {
        ArrayList<Long> revertedFields = new ArrayList<Long>();
        for (Long ruleId : ruleVsFields.keySet()) {
            ArrayList<MgmtRuleField> fieldsArrayInRule = ruleVsFields.get(ruleId);
            for (MgmtRuleField mgmtRuleField : fieldsArrayInRule) {
                FcLayoutField fcLayoutField;
                Long fieldId;
                if (mgmtRuleField.getIsRulingField().booleanValue() || revertedFields.contains(fieldId = mgmtRuleField.getFieldId()) || userData.containsKey((Object)fieldId) || (fcLayoutField = (FcLayoutField)fromClientData.get((Object)fieldId)) == null) continue;
                FcLayoutField templateField = (FcLayoutField)templateData.get((Object)fieldId);
                FcLayoutField adField = (FcLayoutField)adData.get((Object)fieldId);
                if (m.get(fcLayoutField.getFieldId()) != null) continue;
                if (fcLayoutField.getComponentId().intValue() == 9 || fcLayoutField.getComponentId().intValue() == 24 || fcLayoutField.getComponentId().intValue() == 25) {
                    if (templateField != null) {
                        fcLayoutField.init(templateField.serializeToJsonObject());
                    }
                    FcNamingFormat currField = (FcNamingFormat)fcLayoutField.getIComponent();
                    String currVal = currField.getFormattedValue();
                    FcLayoutField cloneField = fcLayoutField.clone();
                    cloneField.getIComponent().fillMgmtRuleValue(mgmtRuleField.serializeToJsonObject());
                    FcNamingFormat mgmtField = (FcNamingFormat)cloneField.getIComponent();
                    String ruleValue = mgmtField.getFormattedValue();
                    if (currVal.equals(ruleValue) || currVal == "") {
                        IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
                        iMgmtHandler.updateFieldsAttributes(fromClientData);
                        iMgmtHandler.updateFieldValuesToAttributes(fromClientData);
                        Properties prop = new Properties();
                        Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(fromClientData, prop);
                        ArrayList<Long> namingFormatField = new ArrayList<Long>();
                        namingFormatField.add(fieldId);
                        FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, namingFormatField, fromClientData, userData);
                    }
                    m.put(fcLayoutField.getFieldId(), fcLayoutField.serializeToJsonObject().toString());
                } else if (templateField != null && templateField.getIComponent().hasEmptyValue(isModification.booleanValue()) && adField != null) {
                    fcLayoutField.init(adField.serializeToJsonObject());
                    m.put(fcLayoutField.getFieldId(), fcLayoutField.serializeToJsonObject().toString());
                } else if (templateField != null) {
                    if (adField != null && (fcLayoutField.getComponentId().intValue() == 62 || fcLayoutField.getComponentId().intValue() == 72 || fcLayoutField.getComponentId().intValue() == 73)) {
                        fcLayoutField.init(templateField.serializeToJsonObject());
                        fcLayoutField.getIComponent().mergeValues(adField);
                        m.put(fcLayoutField.getFieldId(), fcLayoutField.serializeToJsonObject().toString());
                    } else {
                        fcLayoutField.init(templateField.serializeToJsonObject());
                        m.put(fcLayoutField.getFieldId(), fcLayoutField.serializeToJsonObject().toString());
                    }
                }
                if (!m.containsKey(fcLayoutField.getFieldId())) continue;
                revertedFields.add(fieldId);
            }
        }
    }

    public static void setDomainSpecificFieldValues(MgmtRuleGroup mgmtRuleGroup, String oldDomainName, String domainName, AdventNetResourceBundle rb, Long loginId) {
        try {
            ArrayList mgmtRuleList = mgmtRuleGroup.getMgmtRuleList();
            for (MgmtRule mgmtRule : mgmtRuleList) {
                ArrayList mgmtRuleFieldList = mgmtRule.getMgmtRuleFieldList();
                for (int i = 0; i < mgmtRuleFieldList.size(); ++i) {
                    MgmtRuleField mgmtRuleField = (MgmtRuleField)mgmtRuleFieldList.get(i);
                    Long fieldId = mgmtRuleField.getFieldId();
                    String fieldDetailsStr = FcLayoutViewHandler.getFieldDetails((Long)fieldId);
                    JSONObject fieldObj = new JSONObject(fieldDetailsStr);
                    boolean isDomainSpecificField = fieldObj.getBoolean("isDomainSpecificField");
                    if (!isDomainSpecificField) continue;
                    mgmtRuleFieldList.remove(i);
                    --i;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred while setting Domain Specific Values");
            e.printStackTrace();
        }
    }
}

