/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout.dataprovider;

import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.layout.component.Component;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RFInactiveFilter
extends Component {
    private boolean isExcludeDisabled = false;
    private boolean isExcludeNeverLogged = false;
    private String value = "7";

    public void init(JSONObject fcComponentJsonObject) {
        try {
            this.value = fcComponentJsonObject.getString("value");
            this.isExcludeDisabled = fcComponentJsonObject.getBoolean("isExcludeDisabled");
            this.isExcludeNeverLogged = fcComponentJsonObject.getBoolean("isExcludeNeverLogged");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject serializeToJSONObject() {
        JSONObject fcSingleLineJsonObject = new JSONObject();
        try {
            fcSingleLineJsonObject.put("value", (Object)this.value);
            fcSingleLineJsonObject.put("isExcludeDisabled", this.isExcludeDisabled);
            fcSingleLineJsonObject.put("isExcludeNeverLogged", this.isExcludeNeverLogged);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return fcSingleLineJsonObject;
    }

    public void fillMgmtRuleValue(JSONObject valueObj) {
        try {
            if (valueObj.has("fieldValues")) {
                JSONArray valueArray = valueObj.getJSONArray("fieldValues");
                for (int index = 0; index < valueArray.length(); ++index) {
                    JSONObject admpInputJsonObj = valueArray.getJSONObject(index);
                    AdmpInput admpInput = new AdmpInput(admpInputJsonObj);
                    if (admpInput.getName().equalsIgnoreCase("excludeNeverLogon")) {
                        this.isExcludeNeverLogged = Boolean.valueOf(admpInput.getValue());
                        continue;
                    }
                    if (admpInput.getName().equalsIgnoreCase("excludeDisabled")) {
                        this.isExcludeDisabled = Boolean.valueOf(admpInput.getValue());
                        continue;
                    }
                    this.value = admpInput.getValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<AdmpInput> getAdmpInputList() {
        ArrayList<AdmpInput> admpInputList = new ArrayList<AdmpInput>();
        try {
            AdmpInput admpInput = new AdmpInput("excludeNeverLogon", String.valueOf(this.isExcludeNeverLogged), false);
            admpInputList.add(admpInput);
            admpInput = new AdmpInput("excludeDisabled", String.valueOf(this.isExcludeDisabled), false);
            admpInputList.add(admpInput);
            admpInput = new AdmpInput("VAL", this.value, false);
            admpInputList.add(admpInput);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return admpInputList;
    }

    public boolean isExcludeDisabled() {
        return this.isExcludeDisabled;
    }

    public boolean isExcludeNeverLogged() {
        return this.isExcludeNeverLogged;
    }

    public String getValue() {
        return this.value;
    }
}

