/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout.gapps;

import com.adventnet.sym.adsm.common.server.iam.GAppsAdminConfiguration;
import com.google.api.services.admin.directory.Directory;
import com.google.api.services.admin.directory.model.Member;
import com.google.api.services.admin.directory.model.User;
import com.google.api.services.admin.directory.model.UserName;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class GappsMgmtUtil {
    public static boolean addNewUser(Properties gAppsConfigProp, Hashtable resultHash, String givenName, String familyName, String email, String password, boolean changePasswordAtNextLogin, String orgUnit, ArrayList<String> groupEmail) {
        boolean creationStatus = false;
        try {
            Directory directory = GAppsAdminConfiguration.getDirectoryService((Properties)gAppsConfigProp);
            UserName name = new UserName();
            name.setGivenName(givenName);
            name.setFamilyName(familyName);
            User user = new User();
            user.set("name", (Object)name);
            user.setChangePasswordAtNextLogin(Boolean.valueOf(changePasswordAtNextLogin));
            user.set("password", (Object)password);
            user.setPrimaryEmail(email);
            user.setOrgUnitPath(orgUnit);
            user = (User)directory.users().insert(user).execute();
            resultHash.put("email", user.getPrimaryEmail());
            resultHash.put("objectId", user.getId());
            if (groupEmail != null && groupEmail.size() != 0) {
                for (String singleGroupEmail : groupEmail) {
                    Member member = new Member();
                    member.setEmail(email);
                    directory.members().insert(singleGroupEmail.trim(), member).execute();
                }
            }
            creationStatus = true;
        }
        catch (Exception e) {
            GAppsAdminConfiguration.exceptionToMessage((Exception)e, (Hashtable)resultHash);
        }
        return creationStatus;
    }

    public static boolean deleteUser(String domainName, Long loginId, String userKey) {
        boolean isSuccess = false;
        Hashtable resultHash = new Hashtable();
        try {
            Properties gAppsConfigProp = GAppsAdminConfiguration.getGAppsConfigData((String)domainName, (Long)loginId);
            Directory directory = GAppsAdminConfiguration.getDirectoryService((Properties)gAppsConfigProp);
            directory.users().delete(userKey).execute();
            isSuccess = true;
        }
        catch (Exception e) {
            GAppsAdminConfiguration.exceptionToMessage((Exception)e, resultHash);
        }
        return isSuccess;
    }

    public static boolean suspendUser(String domainName, Long loginId, String userKey) {
        boolean isSuccess = false;
        Hashtable resultHash = new Hashtable();
        try {
            Properties gAppsConfigProp = GAppsAdminConfiguration.getGAppsConfigData((String)domainName, (Long)loginId);
            Directory directory = GAppsAdminConfiguration.getDirectoryService((Properties)gAppsConfigProp);
            User user = new User();
            user.set("suspended", (Object)true);
            user = (User)directory.users().update(userKey, user).execute();
            isSuccess = user.getSuspended();
        }
        catch (Exception e) {
            GAppsAdminConfiguration.exceptionToMessage((Exception)e, resultHash);
        }
        return isSuccess;
    }

    public static boolean resetPassword(String domainName, Long loginId, String userKey, String password, boolean changePasswordAtNextLogin) {
        boolean isSuccess = false;
        Hashtable resultHash = new Hashtable();
        try {
            Properties gAppsConfigProp = GAppsAdminConfiguration.getGAppsConfigData((String)domainName, (Long)loginId);
            Directory directory = GAppsAdminConfiguration.getDirectoryService((Properties)gAppsConfigProp);
            User user = new User();
            user.set("password", (Object)password);
            user.setChangePasswordAtNextLogin(Boolean.valueOf(changePasswordAtNextLogin));
            directory.users().update(userKey, user).execute();
            isSuccess = true;
        }
        catch (Exception e) {
            GAppsAdminConfiguration.exceptionToMessage((Exception)e, resultHash);
        }
        return isSuccess;
    }
}

