/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout.o365;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.PasswordPolicy;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.CreateO365UserForADUserMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DelayedSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.waad.WAADBulkMgmtController;
import com.adventnet.sym.adsm.common.webclient.formats.UserModificationFormatUtil;
import com.adventnet.sym.adsm.common.webclient.layout.o365.O365AppsUserCreationListener;
import com.adventnet.sym.adsm.common.webclient.layout.o365.O365MgmtUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtStatusUpdator;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class CreateO365UserForADUserMgmtListener
extends O365AppsUserCreationListener {
    JSONObject inputJson = null;
    String hostId = null;
    boolean isAuthorised = false;
    protected String noOfObjects = null;
    protected int licensedCount;
    public static final Integer O365_CRT_USER_REPORT_ID = 8055;
    String tenantId = new String();
    String tenantPwd = new String();
    PasswordPolicy pwdPolicy = new PasswordPolicy();

    public CreateO365UserForADUserMgmtListener() {
        this.noOfObjects = LicenseMgr.getInstance().getLicenseProperty("ADReports", "NumberOfObjects");
        if (this.noOfObjects == null) {
            this.noOfObjects = "100";
        }
        if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
            this.licensedCount = Integer.parseInt(this.noOfObjects);
        }
    }

    @Override
    public JSONObject doBulkMgmtAction(String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, JSONObject inputJson, String hostId, HttpServletRequest request) {
        JSONObject rvcJsonObject = new JSONObject();
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.inputJson = inputJson;
        this.hostId = hostId;
        this.nativeStatusProperties = new Properties();
        Properties o365ConfigProp = DomainInfoCache.getInstance().getO356AccountProperties(domainName);
        this.preMgmtActions(o365ConfigProp);
        this.tenantId = o365ConfigProp.getProperty("WAAD_TENANT_ID");
        this.tenantPwd = o365ConfigProp.getProperty("WAAD_TENANT_PASSWD");
        try {
            Thread action;
            String[] selectedObjectIdsArr;
            HttpSession session = request.getSession();
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)RVCConstants.O365_CRT_USER_RESULT_RVC_ID, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Row rvcDataRow = rvcDataObject.getRow("ADSMRVCDataConfiguration");
            long generationId = WAADBulkMgmtUtil.getNewGenerationId(O365_CRT_USER_REPORT_ID, loginId);
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            WAADBulkMgmtController.getInstance().addStatusUpdator(Long.valueOf(generationId), statusUpdater);
            Integer selectedObjectsView = Integer.parseInt(inputJson.getString("selectedObjectsView"));
            JSONArray selectedUsersList = inputJson.getJSONArray("selectedObjectIds");
            JSONArray deSelectedUsersList = inputJson.getJSONArray("deSelectedObjectIds");
            Boolean checkAll = inputJson.getBoolean("checkAll");
            Boolean excludeChildOU = inputJson.getBoolean("excludeChildOU");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ArrayList authOUList = null;
            Criteria crit = null;
            String tableName = "ADSMUserGeneralDetails";
            String colName = "OBJECT_GUID";
            if (authObject != null) {
                authOUList = (ArrayList)authObject.getDomainOUsMap().get(domainName);
            }
            this.initAttributeList(O365_CRT_USER_REPORT_ID);
            if (selectedObjectsView == 0 || selectedObjectsView == 1) {
                if (checkAll.booleanValue()) {
                    Criteria ouCrit;
                    JSONArray selectedOUArr = inputJson.getJSONArray("selectedOUs");
                    JSONArray unSelectedOUArr = null;
                    if (inputJson.has("unSelectedOUs")) {
                        unSelectedOUArr = inputJson.getJSONArray("unSelectedOUs");
                    }
                    if ((ouCrit = O365MgmtHandler.getAuthentictedOUCriteria((JSONArray)selectedOUArr, (JSONArray)unSelectedOUArr, (ArrayList)authOUList, (boolean)excludeChildOU)) != null) {
                        crit = ouCrit;
                    }
                } else {
                    selectedObjectIdsArr = StrUtil.getStringArray((JSONArray)selectedUsersList);
                    crit = new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)selectedObjectIdsArr, 8);
                }
            } else {
                tableName = "ADSMAUNamingAttributes";
                colName = "USER_INDEX";
                if (checkAll.booleanValue()) {
                    String[] deSelectedObjectIdsArr = StrUtil.getStringArray((JSONArray)deSelectedUsersList);
                    crit = new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)deSelectedObjectIdsArr, 9);
                } else {
                    selectedObjectIdsArr = StrUtil.getStringArray((JSONArray)selectedUsersList);
                    crit = new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)selectedObjectIdsArr, 8);
                }
            }
            JSONArray waadUserDetList = new JSONArray();
            Long userCreationID = null;
            JSONArray headerJsonArray = null;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)colName));
            if (selectedObjectsView.equals("0") || selectedObjectsView.equals("1")) {
                crit = crit != null ? crit.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_DELETED"), (Object)0, 1)) : new Criteria(Column.getColumn((String)tableName, (String)"IS_DELETED"), (Object)0, 1);
            }
            query.setCriteria(crit);
            DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataobj.isEmpty()) {
                Iterator rows = dataobj.getRows(tableName);
                while (rows.hasNext()) {
                    Row row = (Row)rows.next();
                    waadUserDetList.put((Object)row.get(colName).toString());
                }
            }
            this.isAuthorised = this.isAuthorized(request);
            if (selectedObjectsView < 2) {
                action = new CreateAction(generationId, waadUserDetList, hostId);
                action.start();
            } else {
                userCreationID = Long.parseLong(inputJson.getString("userCreationID"));
                headerJsonArray = new JSONArray(inputJson.getString("headerJsonArray"));
                if (!headerJsonArray.toString().toLowerCase().contains("password")) {
                    headerJsonArray.put((Object)"Password");
                }
                action = new CreateCSVAction(generationId, waadUserDetList, headerJsonArray, true, userCreationID, hostId, new JSONArray((Collection)authOUList));
                action.start();
            }
            rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)0, (Integer)RVCConstants.O365_CRT_USER_RESULT_RVC_ID, null, (DataObject)rvcDataObject, (AdventNetResourceBundle)this.rb, (Long)CommonUtil.ADMIN_LOGIN_ID);
            rvcJsonObject.put("isReportRunning", true);
            rvcJsonObject.put("generationId", generationId);
            JSONObject json = new JSONObject();
            if (selectedObjectsView < 2) {
                json.put("isCsvMgmt", false);
            } else {
                json.put("isCsvMgmt", true);
                json.put("userCreationID", (Object)userCreationID);
                json.put("headerJsonArray", (Object)headerJsonArray);
                json.put("userIndexes", (Object)waadUserDetList);
            }
            rvcJsonObject.put("customParams", (Object)json.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rvcJsonObject;
    }

    public void preMgmtActions(Properties o365ConfigProp) {
        this.exchangeAttribToNative = new ArrayList();
        this.attribListToNative = new ArrayList();
        this.attributeList = new ArrayList();
        this.licenseList = new ArrayList();
        this.mailGroupList = new ArrayList();
        this.securityGroupList = new ArrayList();
        this.auditList = new ArrayList();
        this.isBulkUserMgmt = true;
        this.passwordList = new Properties();
        CreateO365UserForADUserMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
        CreateO365UserForADUserMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
        this.setSourceAction(this.rb.getString("admp.mgmt.office365.mgmtname.create_user"));
        this.initAttributeIAMValues(o365ConfigProp, true);
        this.pwdPolicy.setPolicyDetails();
    }

    private Hashtable<String, ArrayList<Properties>> getO365UserDetailsForCreation(String[] objectIdArr, String uniqueValueParamName, JSONArray authOUList, boolean isCsvMgmt) {
        ArrayList<String> attribToSelect = new ArrayList<String>();
        attribToSelect.add("OBJECT_GUID");
        attribToSelect.add("CITY");
        attribToSelect.add("COUNTRY");
        attribToSelect.add("DEPARTMENT");
        attribToSelect.add("FAX");
        attribToSelect.add("FIRST_NAME");
        attribToSelect.add("LAST_NAME");
        attribToSelect.add("MOBILE");
        attribToSelect.add("ZIP_POSTAL_CODE");
        attribToSelect.add("OFFICE");
        attribToSelect.add("STATE_PROVINCE");
        attribToSelect.add("STREET_ADDRESS");
        attribToSelect.add("TITLE");
        attribToSelect.add("LOGON_NAME");
        attribToSelect.add("DISPLAY_NAME");
        attribToSelect.add("SAM_ACCOUNT_NAME");
        attribToSelect.add("DISTINGUISHED_NAME");
        return O365MgmtHandler.getWAADADSMUserDetails(attribToSelect, (String[])objectIdArr, (String)"", (String)this.domainName, (String)uniqueValueParamName, (JSONArray)authOUList);
    }

    protected String createO365User(String uniqueValue, String uniqueValueNativeParamName, Hashtable audit_info, DataObject auditDataObj, ArrayList attribListFromDb) {
        String result = "admp.mgmt.gpo_mgmt_some_err_occ";
        try {
            String objName = CommonUtil.objNameFromDataObj((DataObject)auditDataObj);
            objName = objName.equals("") ? uniqueValue : objName;
            try {
                if (this.isAuthorised) {
                    result = ADHandler.createO365UserFromADUser((String)this.tenantId, (String)this.tenantPwd, (Object)attribListFromDb, (ArrayList)this.licenseList, (ArrayList)this.attributeListToUpdate, (NativeListener)this);
                    try {
                        JSONObject json = new JSONObject(result);
                        ArrayList<Object> addedLicenseList = new ArrayList<Object>();
                        for (int i = 0; i < this.licenseList.size(); ++i) {
                            addedLicenseList.add(((Properties)this.licenseList.get(i)).get("AccountSku"));
                        }
                        O365InfoCache.getInstance().updateLicenseConsumptionData(addedLicenseList, "add");
                        TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.mgmt.office365.mgmtname.create_user"), objName, this.domainName, this.auditList, new ArrayList(), new ArrayList(), this.rb.getString("admp.mgmt.common.statmsg.successfully_created"), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
                        return result;
                    }
                    catch (Exception e) {
                    }
                } else {
                    result = "client.reports.ReportMgmtHandler.access_denied";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result = this.rb.getString("admp.mgmt.o365.error.unable_to_create_user") + " " + this.rb.getString(result);
            TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.mgmt.office365.mgmtname.create_user"), objName, this.domainName, this.auditList, new ArrayList(), new ArrayList(), result, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected String performPostCreationTasks(String objectId, String upn, Properties namingFormatProps) {
        String message = new String();
        if (this.securityGroupList != null && this.securityGroupList.size() > 0) {
            String returnMsg = ADHandler.addO365SecurityGroupMembership((String)this.tenantId, (String)this.tenantPwd, (String)objectId, (ArrayList)this.securityGroupList, (boolean)false);
            message = returnMsg == null || returnMsg.length() == 0 ? message + " " + this.rb.getString("admp.mgmt.o365.sec_grp_mem_success") : message + " " + this.rb.getString("admp.mgmt.o365.sec_grp_mem_error") + " " + this.rb.getString(returnMsg);
        }
        ArrayList<Object> exchangeAttribWithNamingFormats = new ArrayList();
        if (this.exchangeAttribToNative != null && this.exchangeAttribToNative.size() > 0) {
            exchangeAttribWithNamingFormats = this.applyNamingFormats(this.exchangeAttribToNative, namingFormatProps);
        }
        if (exchangeAttribWithNamingFormats != null && exchangeAttribWithNamingFormats.size() > 0 || this.mailGroupList != null && this.mailGroupList.size() > 0) {
            String statusMessage = DelayedSchedulerUtil.createNewDelayedTaskSchedule((String)this.tenantId, (String)objectId, (String)upn, exchangeAttribWithNamingFormats, (ArrayList)this.mailGroupList, (AdventNetResourceBundle)this.rb, (Long)this.loginId, (String)this.getSourceAction(), (Long)O365MgmtUtil.modifyExchOnlineMailboxTaskTypeId);
            message = statusMessage != null && statusMessage.length() > 0 ? message + " " + statusMessage : message + " " + this.rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view");
        }
        return message;
    }

    protected Properties updateStatus(Properties userProp, String statusMessage) {
        Properties resProp = new Properties();
        if (userProp.getProperty("STATUS").equalsIgnoreCase("SUCCESS")) {
            resProp.put((Object)302, userProp.getProperty("SAM_ACCOUNT_NAME"));
            resProp.put((Object)701, userProp.getProperty("USER_PRINCIPAL_NAME"));
            resProp.put((Object)703, userProp.getProperty("DISPLAY_NAME"));
            resProp.put((Object)709, userProp.getProperty("PASSWORD"));
            resProp.put((Object)708, statusMessage);
        } else {
            resProp.put((Object)302, userProp.getProperty("SAM_ACCOUNT_NAME"));
            resProp.put((Object)701, userProp.getProperty("LOGON_NAME"));
            resProp.put((Object)703, "-");
            resProp.put((Object)708, statusMessage);
        }
        return resProp;
    }

    private boolean isAuthorized(HttpServletRequest request) {
        Long actionId = 41013L;
        ArrayList linkedDomainNames = O365MgmtHandler.getLinkedDomainNames((String)this.tenantId, (int)3);
        return ClientAuthorizationUtil.isAuthorizedForIamAppAction(request, linkedDomainNames, actionId);
    }

    private ArrayList<Properties> applyNamingFormats(ArrayList<Properties> exchangeAttribToNative, Properties namingFormatProps) {
        ArrayList<Properties> propList = new ArrayList<Properties>();
        for (int i = 0; i < exchangeAttribToNative.size(); ++i) {
            Properties tempProp = new Properties();
            Properties exchProp = exchangeAttribToNative.get(i);
            String attribName = (String)exchProp.get("PARAMETER");
            tempProp.put("PARAMETER", attribName);
            String attribVal = (String)exchProp.get("VALUE");
            tempProp.put("VALUE", attribVal);
            if (attribName.equalsIgnoreCase("Alias") || attribName.equalsIgnoreCase("ArchiveName")) {
                String formattedValue = UserModificationFormatUtil.getFormatValue(attribVal, namingFormatProps, null, "o365UserForAD");
                tempProp.put("VALUE", formattedValue);
                this.auditList.add(this.getAuditProps(attribName, formattedValue));
            }
            propList.add(tempProp);
        }
        return propList;
    }

    private boolean connectToOffice365(boolean connectToOffice365, Integer reportId, StatusUpdater statusUpdater) {
        String connectionMsg;
        if (connectToOffice365 && (connectionMsg = ADHandler.connectPowershellService((String)this.tenantId, (String)this.tenantPwd)) != null && connectionMsg.trim().length() > 0) {
            ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(false);
            ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)reportId));
            ((WAADBulkMgmtStatusUpdator)statusUpdater).setCommonErrorMessage(this.rb.getString(connectionMsg));
            statusUpdater.setIsCompleted(true);
            this.isCompleted = true;
            return false;
        }
        this.queueRegID = QueueHandler.getInstance().registerForUpdate(this.getObjIdList(), this.attributeListHash);
        return true;
    }

    protected class CreateAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        boolean connectToOffice365 = false;
        String hostId;
        int reportId;

        public CreateAction(long generationId, JSONArray selectedUsersList, String hostId) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.connectToOffice365 = true;
            this.hostId = hostId;
            this.reportId = O365_CRT_USER_REPORT_ID;
        }

        @Override
        public void run() {
            try {
                StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                String[] objectIdArr = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                objectIdArr = null;
                if (!CreateO365UserForADUserMgmtListener.this.connectToOffice365(this.connectToOffice365, this.reportId, statusUpdater)) {
                    return;
                }
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)CreateO365UserForADUserMgmtListener.this.loginId, (String)this.hostId, (Integer)this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)CreateO365UserForADUserMgmtListener.this.rb);
                boolean isAllObjectsSucceeded = true;
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                ArrayList<String> objectOUList = new ArrayList<String>();
                Hashtable nameVsDetails = new Hashtable();
                Properties pwdProp = null;
                for (int i = 0; !((WAADBulkMgmtStatusUpdator)statusUpdater).isStopped() && i < this.selectedUsersList.length() && (CreateO365UserForADUserMgmtListener.this.noOfObjects.equalsIgnoreCase("unlimited") || i + 1 <= CreateO365UserForADUserMgmtListener.this.licensedCount); ++i) {
                    Hashtable<String, String> pwdStringForNotification = new Hashtable<String, String>();
                    String objectGuid = this.selectedUsersList.getString(i);
                    ArrayList attribListFromDb = (ArrayList)CreateO365UserForADUserMgmtListener.this.getO365UserDetailsForCreation(new String[]{objectGuid}, "OBJECT_GUID", null, false).get(objectGuid.toLowerCase());
                    attribListFromDb.addAll(CreateO365UserForADUserMgmtListener.this.attribListToNative);
                    if (CreateO365UserForADUserMgmtListener.this.isRandomPassword) {
                        CreateO365UserForADUserMgmtListener.this.passwordStr = PasswordGenerator.generatePassword((PasswordPolicy)CreateO365UserForADUserMgmtListener.this.pwdPolicy, (AdventNetResourceBundle)CreateO365UserForADUserMgmtListener.this.rb);
                        Properties attribProp = new Properties();
                        attribProp.put("PARAMETER", "Password");
                        attribProp.put("VALUE", "S:" + CreateO365UserForADUserMgmtListener.this.passwordStr);
                        attribListFromDb.add(attribProp);
                        if (pwdProp != null) {
                            CreateO365UserForADUserMgmtListener.this.auditList.remove(pwdProp);
                        }
                        pwdProp = CreateO365UserForADUserMgmtListener.this.getAuditProps(CreateO365UserForADUserMgmtListener.this.rb.getString("admp.common.attrib_disp_name.password"), CreateO365UserForADUserMgmtListener.this.passwordStr);
                        CreateO365UserForADUserMgmtListener.this.auditList.add(pwdProp);
                    }
                    pwdStringForNotification.put("password", CreateO365UserForADUserMgmtListener.this.passwordStr);
                    String objName = "";
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    Properties updateProp = new Properties();
                    updateProp.put("STATUS", "FAIL");
                    updateProp.put("LOGON_NAME", "-");
                    updateProp.put("SAM_ACCOUNT_NAME", "-");
                    String samAccountName = "";
                    Properties namingFormatProps = new Properties();
                    for (int index = 0; index < attribListFromDb.size(); ++index) {
                        String value;
                        if (((Properties)attribListFromDb.get(index)).getProperty("PARAMETER") != null) {
                            value = ((Properties)attribListFromDb.get(index)).getProperty("VALUE");
                            String attrName = ((Properties)attribListFromDb.get(index)).getProperty("PARAMETER").toLowerCase();
                            value = attrName.equalsIgnoreCase("userprincipalname") ? value.substring(2, value.length() - 1) : value.substring(2);
                            namingFormatProps.put(attrName, value);
                        }
                        if (((Properties)attribListFromDb.get(index)).getProperty("LOGON_NAME") != null) {
                            objName = ((Properties)attribListFromDb.get(index)).getProperty("LOGON_NAME");
                            value = ((Properties)attribListFromDb.get(index)).getProperty("VALUE");
                            value = value + CreateO365UserForADUserMgmtListener.this.upnSuffix;
                            ((Properties)attribListFromDb.get(index)).put("VALUE", value);
                            updateProp.put("LOGON_NAME", objName);
                            continue;
                        }
                        if (((Properties)attribListFromDb.get(index)).getProperty("SAM_ACCOUNT_NAME") != null) {
                            samAccountName = ((Properties)attribListFromDb.get(index)).getProperty("SAM_ACCOUNT_NAME");
                            updateProp.put("SAM_ACCOUNT_NAME", samAccountName);
                            attribListFromDb.remove(index--);
                            continue;
                        }
                        if (((Properties)attribListFromDb.get(index)).getProperty("DISTINGUISHED_NAME") == null) continue;
                        String distinguishedName = ((Properties)attribListFromDb.get(index)).getProperty("DISTINGUISHED_NAME");
                        String ouName = DirectoryObjectUtil.getOUNameFromDN((String)distinguishedName);
                        if (!objectOUList.contains(ouName)) {
                            objectOUList.add(ouName);
                        }
                        attribListFromDb.remove(index--);
                    }
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)objName, (String)CreateO365UserForADUserMgmtListener.this.domainName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    String message = CreateO365UserForADUserMgmtListener.this.createO365User(objectGuid, "ObjectGuid", audit_info, auditDataObj, attribListFromDb);
                    String objectId = "";
                    try {
                        JSONObject json = new JSONObject(message);
                        objectId = json.getString("ObjectId");
                        String upn = json.getString("UserPrincipalName");
                        updateProp = new Properties();
                        updateProp.put("USER_PRINCIPAL_NAME", upn);
                        updateProp.put("DISPLAY_NAME", json.getString("DisplayName"));
                        updateProp.put("SAM_ACCOUNT_NAME", samAccountName);
                        updateProp.put("STATUS", "SUCCESS");
                        updateProp.put("PASSWORD", CreateO365UserForADUserMgmtListener.this.passwordStr);
                        auditObjectIdList.add(object_id);
                        message = CreateO365UserForADUserMgmtListener.this.rb.getString("admp.mgmt.common.statmsg.successfully_created");
                        message = message + CreateO365UserForADUserMgmtListener.this.performPostCreationTasks(objectId, upn, namingFormatProps);
                        nameVsDetails.put(objName, pwdStringForNotification);
                    }
                    catch (Exception e) {
                        isAllObjectsSucceeded = false;
                    }
                    String auditMessage = message;
                    if (auditMessage.contains(CreateO365UserForADUserMgmtListener.this.rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"))) {
                        auditMessage = auditMessage.replace(CreateO365UserForADUserMgmtListener.this.rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"), "");
                    }
                    audit_info.put("error_msg", CreateO365UserForADUserMgmtListener.this.rb.getString(auditMessage));
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    Properties resProp = CreateO365UserForADUserMgmtListener.this.updateStatus(updateProp, message.replaceAll("\\<.*?>", ""));
                    statusUpdater.updateStatus(resProp, null, null);
                    Row row = new Row("WAADCreateUserResult");
                    row.set("OBJECT_GUID", (Object)objectGuid);
                    row.set("OBJECT_ID", (Object)objectId);
                    if (updateProp.get("STATUS") != null && ((String)updateProp.get("STATUS")).equalsIgnoreCase("SUCCESS")) {
                        row.set("PASSWORD", (Object)CreateO365UserForADUserMgmtListener.this.passwordStr);
                    }
                    row.set("REPORT_GENERATION_ID", (Object)this.generationId);
                    row.set("MESSAGE", (Object)message);
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    dataObj.addRow(row);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                }
                CreateO365UserForADUserMgmtListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    Integer objectId = 6;
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    notifyListener.triggerNotification(auditDataObj, auditObjectIdList, objectId, nameVsDetails, CreateO365UserForADUserMgmtListener.this.loginId, Integer.valueOf(this.reportId), CreateO365UserForADUserMgmtListener.this.domainName, CreateO365UserForADUserMgmtListener.this.rb, null, objectOUList);
                }
                CreateO365UserForADUserMgmtListener.this.isCompleted = true;
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)this.reportId));
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class CreateCSVAction
    extends Thread {
        long generationId;
        JSONArray selectedUsersList;
        JSONArray headerJsonArray;
        boolean connectToOffice365 = false;
        Long userCreationID;
        String hostId;
        JSONArray authOUList;
        int reportId = O365_CRT_USER_REPORT_ID;

        public CreateCSVAction(long generationId, JSONArray selectedUsersList, JSONArray headerJsonArray, boolean connectToOffice365, Long userCreationID, String hostId, JSONArray authOUList) {
            this.generationId = generationId;
            this.selectedUsersList = selectedUsersList;
            this.headerJsonArray = headerJsonArray;
            this.connectToOffice365 = true;
            this.userCreationID = userCreationID;
            this.authOUList = authOUList;
            this.hostId = hostId;
        }

        public void setActionDetails() {
        }

        @Override
        public void run() {
            try {
                boolean savePassword;
                StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(this.generationId));
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setCsvMgmt(true);
                String[] userIndexes = StrUtil.getStringArray((JSONArray)this.selectedUsersList);
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)userIndexes, 8);
                String uniqueValueParamName = new String();
                ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
                int priority = 4;
                for (int i = 0; i < this.headerJsonArray.length(); ++i) {
                    ArrayList l;
                    String attr = this.headerJsonArray.getString(i);
                    Hashtable attributesdetails = null;
                    if (attr.equalsIgnoreCase("UserPrincipalName") && priority > 0) {
                        uniqueValueParamName = "LOGON_NAME";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1005"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 0;
                    } else if (attr.equalsIgnoreCase("ObjectGuid") && priority > 2) {
                        uniqueValueParamName = "OBJECT_GUID";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1145"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 2;
                    } else if (attr.equalsIgnoreCase("SamAccountName") && priority > 3) {
                        uniqueValueParamName = "SAM_ACCOUNT_NAME";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1006"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 3;
                    } else if (attr.equalsIgnoreCase("DistinguishedName") && priority > 1) {
                        uniqueValueParamName = "DISTINGUISHED_NAME";
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1004"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                        priority = 1;
                    } else {
                        attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)attr);
                    }
                    attributeList.add(attributesdetails);
                }
                ArrayList user = AddUserHandler.getInstance().getUserDetailsList(this.userCreationID, attributeList, -1, 0, null, crit);
                String[] selectedUsers = new String[user.size()];
                for (int index = 0; index < user.size(); ++index) {
                    Hashtable hashtab = (Hashtable)user.get(index);
                    ArrayList hashtab1 = (ArrayList)hashtab.get("USER_VALUES");
                    for (int i = 0; i < hashtab1.size(); ++i) {
                        Hashtable temp = (Hashtable)hashtab1.get(i);
                        if (!uniqueValueParamName.equalsIgnoreCase((String)temp.get("ATTRIB_COLUMN_NAME"))) continue;
                        selectedUsers[index] = (String)temp.get("ATTRIB_VALUE");
                        break;
                    }
                    if (!uniqueValueParamName.equalsIgnoreCase("OBJECT_GUID") || selectedUsers[index].charAt(0) == '{') continue;
                    selectedUsers[index] = "{" + selectedUsers[index].concat("}");
                }
                if (!CreateO365UserForADUserMgmtListener.this.connectToOffice365(this.connectToOffice365, this.reportId, statusUpdater)) {
                    return;
                }
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)CreateO365UserForADUserMgmtListener.this.loginId, (String)this.hostId, (Integer)this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)CreateO365UserForADUserMgmtListener.this.rb);
                boolean isAllObjectsSucceeded = true;
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                ArrayList<String> objectOUList = new ArrayList<String>();
                Hashtable nameVsDetails = new Hashtable();
                ArrayList<Long> userIndexIds = new ArrayList<Long>();
                Properties pwdProp = null;
                for (int i = 0; !((WAADBulkMgmtStatusUpdator)statusUpdater).isStopped() && i < selectedUsers.length; ++i) {
                    String message = new String();
                    if (!CreateO365UserForADUserMgmtListener.this.noOfObjects.equalsIgnoreCase("unlimited") && i + 1 > CreateO365UserForADUserMgmtListener.this.licensedCount) break;
                    Hashtable<String, String> pwdStringForNotification = new Hashtable<String, String>();
                    Hashtable hashtable = (Hashtable)user.get(i);
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    userIndexIds.add(userIndex);
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    String uniqueValue = selectedUsers[i];
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)uniqueValue, (String)CreateO365UserForADUserMgmtListener.this.domainName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    try {
                        ArrayList attribListFromDb = (ArrayList)CreateO365UserForADUserMgmtListener.this.getO365UserDetailsForCreation(new String[]{uniqueValue}, uniqueValueParamName, this.authOUList, true).get(uniqueValue.toLowerCase());
                        attribListFromDb.addAll(CreateO365UserForADUserMgmtListener.this.attribListToNative);
                        if (CreateO365UserForADUserMgmtListener.this.isRandomPassword) {
                            CreateO365UserForADUserMgmtListener.this.passwordStr = PasswordGenerator.generatePassword((PasswordPolicy)CreateO365UserForADUserMgmtListener.this.pwdPolicy, (AdventNetResourceBundle)CreateO365UserForADUserMgmtListener.this.rb);
                            Properties attribProp = new Properties();
                            attribProp.put("PARAMETER", "Password");
                            attribProp.put("VALUE", "S:" + CreateO365UserForADUserMgmtListener.this.passwordStr);
                            attribListFromDb.add(attribProp);
                            if (pwdProp != null) {
                                CreateO365UserForADUserMgmtListener.this.auditList.remove(pwdProp);
                            }
                            pwdProp = CreateO365UserForADUserMgmtListener.this.getAuditProps(CreateO365UserForADUserMgmtListener.this.rb.getString("admp.common.attrib_disp_name.password"), CreateO365UserForADUserMgmtListener.this.passwordStr);
                            CreateO365UserForADUserMgmtListener.this.auditList.add(pwdProp);
                        }
                        pwdStringForNotification.put("password", CreateO365UserForADUserMgmtListener.this.passwordStr);
                        Properties namingFormatProps = new Properties();
                        for (int index = 0; index < attribListFromDb.size(); ++index) {
                            String value;
                            if (((Properties)attribListFromDb.get(index)).getProperty("PARAMETER") != null) {
                                value = ((Properties)attribListFromDb.get(index)).getProperty("VALUE");
                                String attrName = ((Properties)attribListFromDb.get(index)).getProperty("PARAMETER").toLowerCase();
                                value = attrName.equalsIgnoreCase("userprincipalname") ? value.substring(2, value.length() - 1) : value.substring(2);
                                namingFormatProps.put(attrName, value);
                            }
                            if (((Properties)attribListFromDb.get(index)).getProperty("LOGON_NAME") != null) {
                                value = ((Properties)attribListFromDb.get(index)).getProperty("VALUE");
                                value = value + CreateO365UserForADUserMgmtListener.this.upnSuffix;
                                ((Properties)attribListFromDb.get(index)).put("VALUE", value);
                                continue;
                            }
                            if (((Properties)attribListFromDb.get(index)).getProperty("SAM_ACCOUNT_NAME") != null) {
                                attribListFromDb.remove(index--);
                                continue;
                            }
                            if (((Properties)attribListFromDb.get(index)).getProperty("DISTINGUISHED_NAME") == null) continue;
                            String distinguishedName = ((Properties)attribListFromDb.get(index)).getProperty("DISTINGUISHED_NAME");
                            String ouName = DirectoryObjectUtil.getOUNameFromDN((String)distinguishedName);
                            if (!objectOUList.contains(ouName)) {
                                objectOUList.add(ouName);
                            }
                            attribListFromDb.remove(index--);
                        }
                        message = CreateO365UserForADUserMgmtListener.this.createO365User(uniqueValue, "ObjectGuid", audit_info, auditDataObj, attribListFromDb);
                        try {
                            JSONObject json = new JSONObject(message);
                            String objectId = json.getString("ObjectId");
                            String upn = json.getString("UserPrincipalName");
                            message = CreateO365UserForADUserMgmtListener.this.rb.getString("admp.mgmt.common.statmsg.successfully_created");
                            auditObjectIdList.add(object_id);
                            message = message + CreateO365UserForADUserMgmtListener.this.performPostCreationTasks(objectId, upn, namingFormatProps);
                            nameVsDetails.put(uniqueValue, pwdStringForNotification);
                        }
                        catch (Exception e) {
                            message = CreateO365UserForADUserMgmtListener.this.rb.getString(message);
                            isAllObjectsSucceeded = false;
                        }
                    }
                    catch (NullPointerException e) {
                        message = CreateO365UserForADUserMgmtListener.this.rb.getString("admp.mgmt.common.statmsg.cannot_retrieve_object_does_not_exist_or_access_denied");
                    }
                    Properties prop = new Properties();
                    prop.setProperty("CREATION_STATUS", "WARNING");
                    prop.setProperty("CREATION_MESSAGE", message);
                    if (CreateO365UserForADUserMgmtListener.this.passwordStr != null) {
                        prop.setProperty("PASSWORD", CreateO365UserForADUserMgmtListener.this.passwordStr);
                    }
                    prop.put("USER_INDEX", userIndex);
                    AddUserHandler.getInstance().updateCreationStatus(CreateO365UserForADUserMgmtListener.this.rb, prop);
                    String auditMessage = message;
                    if (auditMessage.contains(CreateO365UserForADUserMgmtListener.this.rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"))) {
                        auditMessage = auditMessage.replace(CreateO365UserForADUserMgmtListener.this.rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"), "");
                    }
                    audit_info.put("error_msg", CreateO365UserForADUserMgmtListener.this.rb.getString(auditMessage));
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).updateCsvStatus(valuesList, message);
                }
                if (!(savePassword = PasswordUtil.getSavePasswordValue())) {
                    AddUserHandler.getInstance();
                    String tempTableName = AddUserHandler.createBulkUserLayoutTempTable((Long)this.userCreationID);
                    AddUserHandler.getInstance();
                    AddUserHandler.copyIntoBulkUserLayoutTempTable((Long)this.userCreationID, userIndexIds, (String)tempTableName);
                    AddUserHandler.getInstance();
                    AddUserHandler.clearPwdForBUM((Long)this.userCreationID);
                }
                CreateO365UserForADUserMgmtListener.this.completedAction();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    Integer objectId = 6;
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    notifyListener.triggerNotification(auditDataObj, auditObjectIdList, objectId, nameVsDetails, CreateO365UserForADUserMgmtListener.this.loginId, Integer.valueOf(this.reportId), CreateO365UserForADUserMgmtListener.this.domainName, CreateO365UserForADUserMgmtListener.this.rb, null, objectOUList);
                }
                CreateO365UserForADUserMgmtListener.this.isCompleted = true;
                ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsAllObjectsSucceeded(isAllObjectsSucceeded);
                if (!isAllObjectsSucceeded) {
                    ((WAADBulkMgmtStatusUpdator)statusUpdater).setHelpLink(O365MgmtHandler.getHelpLink((Integer)this.reportId));
                }
                statusUpdater.setIsCompleted(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

