/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout.o365;

import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcContactCreationMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.FcFields;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApp;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.DBStringTransformerUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteNamingFormat;
import com.adventnet.sym.adsm.common.webclient.layout.o365.O365AppsUserCreationListener;
import com.adventnet.sym.adsm.common.webclient.layout.o365.O365MgmtUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class O365AppsContactCreationListener
extends O365AppsUserCreationListener {
    ArrayList<Properties> attribListToNativeNewContact = null;
    ArrayList<Properties> attribListToNativeModifyContact = null;
    ArrayList<Properties> attribListToNativeModifyMailContact = null;
    Integer o365UserCreationType = 0;
    protected String baseTableName = "O365ContactGeneralDetails";
    protected String objectClass = "o365contact";
    private static final int O365_CONTACT_FROM_AD_USER_REPORT_ID = 8063;
    private static Logger logg = Logger.getLogger("ADMangLogger");

    @Override
    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.creationId = creationId;
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.nativeStatusProperties = new Properties();
        if (this.executeLayout == null) {
            this.isBulkMgmt = true;
        }
        this.createContact();
    }

    private void createContact() {
        this.attribListToNativeNewContact = new ArrayList();
        this.attribListToNativeModifyContact = new ArrayList();
        this.attribListToNativeModifyMailContact = new ArrayList();
        this.attributeList = new ArrayList();
        this.auditList = new ArrayList();
        this.nativeStatusProperties.put("isSuccess", (Object)false);
        this.nativeStatusProperties.put("message", "");
        Properties additionalNativeStatusProperties = new Properties();
        additionalNativeStatusProperties.put("message", "");
        Properties o365ConfigProp = O365MgmtHandler.getO365ConfigData((String)this.domainName, (Long)this.loginId);
        if (o365ConfigProp == null) {
            this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.fc_layout.no_office365_credentials"));
            return;
        }
        String o365TenantId = o365ConfigProp.getProperty("username");
        String o365TenantPass = o365ConfigProp.getProperty("password");
        this.initAttributeIAMValues(o365ConfigProp);
        this.initAttributeList(8063);
        this.queueRegID = QueueHandler.getInstance().registerForUpdate(this.getObjIdList(), this.attributeListHash);
        boolean isContactCreated = O365MgmtUtil.addNewContact(this.nativeStatusProperties, o365TenantId, o365TenantPass, this.attribListToNativeNewContact, this.rb, this, this.attributeListToUpdate, additionalNativeStatusProperties);
        if (isContactCreated) {
            additionalNativeStatusProperties.put("message", "");
            String contactIdentity = this.nativeStatusProperties.getProperty("contactIdentity");
            if (contactIdentity != null && contactIdentity != "") {
                Properties attribProp = new Properties();
                attribProp.put("PARAMETER", "Identity");
                attribProp.put("VALUE", "S:" + contactIdentity);
                boolean isContactModified = true;
                if (this.attribListToNativeModifyContact.size() > 0) {
                    this.attribListToNativeModifyContact.add(attribProp);
                    isContactModified = O365MgmtUtil.modifyContact(this.nativeStatusProperties, o365TenantId, o365TenantPass, this.attribListToNativeModifyContact, this.rb, additionalNativeStatusProperties);
                }
                boolean isMailContactModified = true;
                if (this.attribListToNativeModifyMailContact.size() > 0) {
                    this.attribListToNativeModifyMailContact.add(attribProp);
                    isMailContactModified = O365MgmtUtil.modifyMailContact(this.nativeStatusProperties, o365TenantId, o365TenantPass, this.attribListToNativeModifyMailContact, this.rb, additionalNativeStatusProperties);
                }
                if (isContactModified && isMailContactModified) {
                    this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.office365.contact_creation.success"));
                    this.nativeStatusProperties.put("isSuccess", (Object)true);
                } else {
                    this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.office365.contact_creation.partial_failure"));
                    this.nativeStatusProperties.put("isSuccess", (Object)false);
                }
            } else {
                this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.office365.contact_creation.partial_failure"));
                this.nativeStatusProperties.put("isSuccess", (Object)false);
            }
        } else {
            this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.office365.contact_creation.failure"));
            this.nativeStatusProperties.put("isSuccess", (Object)false);
        }
        if (additionalNativeStatusProperties.getProperty("message") != "") {
            this.nativeStatusProperties.put("message", this.nativeStatusProperties.getProperty("message") + " " + additionalNativeStatusProperties.getProperty("message"));
        }
        this.sendSysLogs(this.rb.getString("admp.mgmt.fc_layout.o365_user_creation"), this.nativeStatusProperties.getProperty("message"), o365TenantId);
    }

    public void initAttributeIAMValues(Properties o365ConfigProp) {
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcContactCreationMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop);
        Enumeration e = this.fromClientData.elements();
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            Integer iamAppId = fcLayoutField.getIamAppId();
            ArrayList fcAttributeList_ = fcLayoutField.getFcAttributeList();
            if (iamAppId.intValue() == FcLayoutConstants.OFFICE_365_APPID.intValue()) {
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                for (FcAttributes fcAttribute : fcAttributeList) {
                    String attributeName = fcAttribute.getAttribLdapName();
                    Object attribValue = fcAttribute.getAttribValue();
                    if ("SimpleDisplayName".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("SimpleDisplayName", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        this.auditList.add(this.getAuditProps(this.rb.getString("admp.mgmt.fc_layout.common.text_o365_simple_display_name"), attribValue));
                        continue;
                    }
                    if ("Title".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("Title", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("O365Manager".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("Manager", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        this.auditList.add(this.getAuditProps(this.rb.getString("admp.mgmt.fc_layout.common.text_o365_manager"), attribValue));
                        continue;
                    }
                    if (!"O365HiddenFromAddressListsEnabled".equalsIgnoreCase(attributeName) || attribValue == null) continue;
                    this.addAttribValueToList("HiddenFromAddressListsEnabled", "B:" + attribValue.toString(), this.attribListToNativeModifyMailContact);
                    this.auditList.add(this.getAuditProps(this.rb.getString("admp.mgmt.fc_layout.common.text_o365_hide_from_exchange_online_address_lists"), attribValue));
                }
                continue;
            }
            if (fcLayoutField.getChildFieldArr() == null || fcLayoutField.getChildFieldArr().size() <= 0) continue;
            FcIamApp fcIamApp = this.fcIamApps.getIamApp(iamAppId);
            ArrayList childFieldArr = fcLayoutField.getChildFieldArr();
            int length = fcLayoutField.getChildFieldArr().size();
            for (int i = 0; i < length; ++i) {
                FcFields fcField = fcIamApp.getChildFieldObject((Long)childFieldArr.get(i));
                if (fcField == null || fcField.getIamAppId().intValue() != FcLayoutConstants.OFFICE_365_APPID.intValue()) continue;
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                for (FcAttributes fcAttribute : fcAttributeList) {
                    String attributeName = fcAttribute.getAttribLdapName();
                    Object attribValue = fcAttribute.getAttribValue();
                    if ("givenName".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("FirstName", "S:" + attribValue.toString(), this.attribListToNativeNewContact);
                        continue;
                    }
                    if ("sn".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("LastName", "S:" + attribValue.toString(), this.attribListToNativeNewContact);
                        continue;
                    }
                    if ("name".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("Name", "S:" + attribValue.toString(), this.attribListToNativeNewContact);
                        continue;
                    }
                    if ("mail".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("ExternalEmailAddress", "S:" + FcExecuteNamingFormat.getFormatValue(attribValue.toString(), null, ldapVsValueProps), this.attribListToNativeNewContact);
                        continue;
                    }
                    if ("displayName".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("DisplayName", "S:" + attribValue.toString(), this.attribListToNativeNewContact);
                        continue;
                    }
                    if ("initials".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("Initials", "S:" + attribValue.toString(), this.attribListToNativeNewContact);
                        continue;
                    }
                    if ("l".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("City", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("co".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("CountryOrRegion", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("company".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("Company", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("department".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("Department", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("facsimileTelephoneNumber".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("Fax", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("homePhone".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("HomePhone", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("mobile".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("MobilePhone", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("info".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("Notes", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("physicalDeliveryOfficeName".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("Office", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("pager".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("Pager", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("postalCode".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("PostalCode", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("postOfficeBox".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("PostOfficeBox", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("st".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("StateOrProvince", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("streetAddress".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("StreetAddress", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if ("wWWHomePage".equalsIgnoreCase(attributeName)) {
                        if (attribValue == null) continue;
                        this.addAttribValueToList("WebPage", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                        continue;
                    }
                    if (!"Title".equalsIgnoreCase(attributeName) || attribValue == null) continue;
                    this.addAttribValueToList("Title", "S:" + attribValue.toString(), this.attribListToNativeModifyContact);
                }
            }
        }
    }

    private void addAttribValueToList(String attribName, String value, ArrayList<Properties> attribList) {
        if (!this.attributeList.contains(attribName)) {
            Properties attribProp = new Properties();
            attribProp.put("PARAMETER", attribName);
            attribProp.put("VALUE", value);
            attribList.add(attribProp);
            this.attributeList.add(attribName);
        }
    }

    @Override
    public void addRow(Properties prop) {
        Properties uiProps = new Properties();
        Hashtable tableStringMap = DBStringTransformerUtil.getReportRows((Properties)prop, (ArrayList)this.attributeProps, (String)"", (Properties)uiProps, (Hashtable)new Properties(), (AdventNetResourceBundle)this.rb);
        QueueHandler.getInstance().getQueue(this.objClass.getId()).updateData(this.queueRegID, tableStringMap);
    }

    @Override
    protected ArrayList getObjIdList() {
        this.objClass = DirectoryObjectAPI.getInstance().getObjectClassFromBaseTableName(this.baseTableName);
        ArrayList<Integer> objectIds = new ArrayList<Integer>();
        objectIds.add(this.objClass.getId());
        return objectIds;
    }

    @Override
    public void sendSysLogs(String taskName, String status, String o365TenantId) {
        try {
            String value;
            String parameter;
            Properties prop;
            int i;
            JSONObject syslogMessage = new JSONObject();
            syslogMessage.put("ACTION", (Object)taskName);
            syslogMessage.put(this.rb.getString("admp.mgmt.common.text.task"), (Object)taskName);
            syslogMessage.put(this.rb.getString("admp.mgmt.fc_layout.o365_account"), (Object)o365TenantId);
            if (this.attribListToNativeNewContact != null && this.attribListToNativeNewContact.size() > 0) {
                for (i = 0; i < this.attribListToNativeNewContact.size(); ++i) {
                    prop = this.attribListToNativeNewContact.get(i);
                    parameter = prop.get("PARAMETER").toString();
                    value = prop.get("VALUE").toString();
                    value = value.substring(2);
                    syslogMessage.put(parameter, (Object)value);
                }
            }
            if (this.attribListToNativeModifyContact != null && this.attribListToNativeModifyContact.size() > 0) {
                for (i = 0; i < this.attribListToNativeModifyContact.size(); ++i) {
                    prop = this.attribListToNativeModifyContact.get(i);
                    parameter = prop.get("PARAMETER").toString();
                    value = prop.get("VALUE").toString();
                    value = value.substring(2);
                    syslogMessage.put(parameter, (Object)value);
                }
            }
            if (this.attribListToNativeModifyMailContact != null && this.attribListToNativeModifyMailContact.size() > 0) {
                for (i = 0; i < this.attribListToNativeModifyMailContact.size(); ++i) {
                    prop = this.attribListToNativeModifyMailContact.get(i);
                    parameter = prop.get("PARAMETER").toString();
                    value = prop.get("VALUE").toString();
                    value = value.substring(2);
                    syslogMessage.put(parameter, (Object)value);
                }
            }
            syslogMessage.put(this.rb.getString("admp.mgmt.bulk_creation.common.text.cre_and_status"), (Object)status);
            LogForwarderAPI.getInstance().sendMessage(syslogMessage);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void reInit() {
    }

    @Override
    public boolean getIsBulkMgmt() {
        return false;
    }

    @Override
    public boolean getIsCreationSuccess() {
        return false;
    }

    @Override
    public Properties getNativeStatusProps() {
        return this.nativeStatusProperties;
    }

    @Override
    public String getRusMessage() {
        return null;
    }

    @Override
    public void setRusMessage(String string) {
    }

    @Override
    public void setStatusMsgForResponse(HttpServletRequest request) {
    }

    @Override
    public void setSingleUserErrorMessage(String appsResult) {
    }

    @Override
    public void setIsCreationSuccess() {
    }

    @Override
    public void setFieldValueList(Properties fieldValue) {
    }
}

