/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout.o365;

import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.util.DelayedSchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.layout.o365.O365AppsUserCreationListener;
import com.adventnet.sym.adsm.common.webclient.layout.o365.O365MgmtUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class O365AppsResourceMailboxCreationListener
extends O365AppsUserCreationListener {
    private static Logger logg = Logger.getLogger("ADMangLogger");

    @Override
    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.creationId = creationId;
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.nativeStatusProperties = new Properties();
        this.objectClass = "o365RoomMailbox";
        this.createResourceMailbox();
    }

    private void createResourceMailbox() {
        String resourceType;
        this.attribListToNative = new ArrayList();
        this.attributeList = new ArrayList();
        this.exchangeAttribToNative = new ArrayList();
        this.modifyExchangeAttribToNative = new ArrayList();
        this.modifyCalendarAttribToNative = new ArrayList();
        this.fillValuesForExchOnline = true;
        this.nativeStatusProperties.put("isSuccess", (Object)false);
        this.nativeStatusProperties.put("message", "");
        String sourceAction = this.rb.getString("admp.workflow.layout.createrequest.category_single_roommailbox_creation");
        this.setSourceAction(sourceAction);
        Properties o365ConfigProp = O365MgmtHandler.getO365ConfigData((String)this.domainName, (Long)this.loginId);
        if (o365ConfigProp == null) {
            this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.fc_layout.no_office365_credentials"));
            return;
        }
        String o365TenantId = o365ConfigProp.getProperty("username");
        String o365TenantPass = o365ConfigProp.getProperty("password");
        this.initAttributeIAMValues(o365ConfigProp, false);
        if (this.o365UserCreationType.equals(1) && !this.attributeList.contains("ImmutableId")) {
            this.nativeStatusProperties.put("message", this.rb.getString("admp.mgmt.office365.error.unable_to_fetch_aduser_guid"));
            this.nativeStatusProperties.put("isSuccess", (Object)false);
        }
        boolean isSuccess = false;
        isSuccess = O365MgmtUtil.addNewResourceMailbox(this.nativeStatusProperties, o365TenantId, o365TenantPass, this.getResourceType(), this.exchangeAttribToNative, this.rb);
        this.fillReturnMsg(isSuccess);
        if (isSuccess && this.getResourceType().equalsIgnoreCase("Room") && this.attribListToNative.size() > 0) {
            logg.log(Level.FINE, this.getResourceType() + "Mailbox Created. Proceeding to set user attributes.");
            this.addAttribValueToList("Identity", "S:" + this.nativeStatusProperties.getProperty("Identity"));
            Boolean isUserModified = O365MgmtUtil.modifyUser(this.nativeStatusProperties, o365TenantId, o365TenantPass, this.attribListToNative, this.rb);
        }
        if (isSuccess && this.getResourceType().equalsIgnoreCase("Room") && this.modifyCalendarAttribToNative.size() > 0) {
            String identity = this.nativeStatusProperties.getProperty("Identity");
            this.addAttribValueToModifyCalendarList("Identity", "S:" + identity);
            ArrayList<Properties> singArrayList = new ArrayList<Properties>();
            ArrayList<Properties> multiValList = new ArrayList<Properties>();
            this.getValueListForRoomMailboxDelayedTask(this.modifyCalendarAttribToNative, singArrayList, multiValList);
            this.getValueListForRoomMailboxDelayedTask(this.modifyExchangeAttribToNative, singArrayList, multiValList);
            String delayedTaskMsg = DelayedSchedulerUtil.createNewDelayedTaskSchedule((String)o365TenantId, (String)(identity + "_" + new Date().getTime()), (String)identity, singArrayList, multiValList, (AdventNetResourceBundle)this.rb, (Long)this.loginId, (String)this.getSourceAction(), (Long)O365MgmtUtil.modifyExchOnlineRoomMailboxTaskTypeId);
            if (delayedTaskMsg != null && delayedTaskMsg.length() > 0) {
                this.nativeStatusProperties.put("message", this.nativeStatusProperties.get("message") + " " + delayedTaskMsg);
            } else {
                this.nativeStatusProperties.put("message", this.nativeStatusProperties.get("message") + " " + this.rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"));
            }
        }
        if ((resourceType = this.getResourceType()).equalsIgnoreCase("Equipment")) {
            this.sendSysLogs(this.rb.getString("admp.mgmt.fc_layout.o365_eqmbx_creation"), this.nativeStatusProperties.getProperty("message"), o365TenantId);
        } else {
            this.sendSysLogs(this.rb.getString("admp.mgmt.fc_layout.o365_roommbx_creation"), this.nativeStatusProperties.getProperty("message"), o365TenantId);
        }
    }

    private void getValueListForRoomMailboxDelayedTask(ArrayList modifyCalendarAttribToNative, ArrayList<Properties> singArrayList, ArrayList<Properties> multiValList) {
        for (int i = 0; i < modifyCalendarAttribToNative.size(); ++i) {
            Properties attribProp = (Properties)modifyCalendarAttribToNative.get(i);
            if (attribProp.get("VALUE") == null) continue;
            String parameter = (String)attribProp.get("PARAMETER");
            String value = (String)attribProp.get("VALUE");
            if (value.startsWith("S:") || value.startsWith("B:")) {
                singArrayList.add(attribProp);
                continue;
            }
            if (!value.startsWith("P:")) continue;
            value = value.substring("P:".length());
            ArrayList<String> newValue = new ArrayList<String>();
            newValue.addAll(Arrays.asList(value.split(" ")));
            Properties newAttribProp = new Properties();
            newAttribProp.put("VALUE", newValue);
            newAttribProp.put("PARAMETER", parameter);
            multiValList.add(newAttribProp);
        }
    }

    public void fillReturnMsg(boolean isSuccess) {
    }

    @Override
    public Properties getNativeStatusProps() {
        return this.nativeStatusProperties;
    }

    @Override
    public void setRb(AdventNetResourceBundle rb) {
        this.rb = rb;
    }

    public String getResourceType() {
        return "";
    }
}

