/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout.o365;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.DelayedSchedulerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class O365MgmtUtil {
    public static final Long modifyExchOnlineMailboxTaskTypeId = 1L;
    public static final Long modifyExchOnlineRoomMailboxTaskTypeId = 2L;
    private static Logger logg = Logger.getLogger("ADMangLogger");

    public static boolean addNewUser(Properties nativeStatusProperties, String o365TenantId, String o365TenantPass, ArrayList<Properties> attribListToNative, ArrayList licenseList, AdventNetResourceBundle rb, boolean isDirSync, ArrayList<String> securityGroupList, ArrayList<Properties> exchangeAttribToNative, ArrayList<Properties> mailGroupList, Long loginId, NativeListener listener, ArrayList attributeListToUpdate, String sourceAction, Properties passwordList) {
        boolean creationStatus = true;
        O365InfoCache.getInstance();
        String returnMsg = ADHandler.createNewO365User((String)o365TenantId, (String)o365TenantPass, attribListToNative, (ArrayList)licenseList, (NativeListener)listener, (ArrayList)attributeListToUpdate, (String)O365InfoCache.getInstalledModule(), (Properties)passwordList);
        if (returnMsg.length() > 0) {
            try {
                JSONObject resultJson = new JSONObject(returnMsg);
                ArrayList<Object> addedLicenseList = new ArrayList<Object>();
                for (int i = 0; i < licenseList.size(); ++i) {
                    addedLicenseList.add(((Properties)licenseList.get(i)).get("AccountSku"));
                }
                O365InfoCache.getInstance().updateLicenseConsumptionData(addedLicenseList, "add");
                String objectId = resultJson.getString("ObjectId");
                String upn = resultJson.getString("UserPrincipalName");
                String statusMessage = rb.getString("admp.mgmt.office365.user_created_successfully");
                if (isDirSync) {
                    statusMessage = statusMessage + " " + rb.getString("admp.mgmt.o365.user_creation_info_dirsync");
                }
                nativeStatusProperties.put("isSuccess", (Object)true);
                if (securityGroupList != null && securityGroupList.size() > 0) {
                    returnMsg = ADHandler.addO365SecurityGroupMembership((String)o365TenantId, (String)o365TenantPass, (String)objectId, securityGroupList, (boolean)true);
                    statusMessage = returnMsg == null || returnMsg.length() == 0 ? statusMessage + " " + rb.getString("admp.mgmt.o365.sec_grp_mem_success") : statusMessage + " " + rb.getString("admp.mgmt.o365.sec_grp_mem_error") + " " + rb.getString(returnMsg);
                }
                if (exchangeAttribToNative != null && exchangeAttribToNative.size() > 0 || mailGroupList != null && mailGroupList.size() > 0) {
                    String message = DelayedSchedulerUtil.createNewDelayedTaskSchedule((String)o365TenantId, (String)objectId, (String)upn, exchangeAttribToNative, mailGroupList, (AdventNetResourceBundle)rb, (Long)loginId, (String)sourceAction, (Long)modifyExchOnlineMailboxTaskTypeId);
                    statusMessage = message != null && message.length() > 0 ? statusMessage + " " + message : statusMessage + " " + rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view");
                }
                nativeStatusProperties.put("message", statusMessage);
            }
            catch (JSONException ex) {
                nativeStatusProperties.put("message", rb.getString("admp.mgmt.office365.error.error_in_creating_user") + " " + rb.getString(returnMsg));
                nativeStatusProperties.put("isSuccess", (Object)false);
                creationStatus = false;
            }
        }
        return creationStatus;
    }

    public static boolean addNewContact(Properties nativeStatusProperties, String o365TenantId, String o365TenantPass, ArrayList<Properties> attribListToNative, AdventNetResourceBundle rb, NativeListener listener, ArrayList attributeListToUpdate, Properties additionalNativeStatusProperties) {
        boolean creationStatus = true;
        O365InfoCache.getInstance();
        String returnMsg = ADHandler.createNewO365Contact((String)o365TenantId, (String)o365TenantPass, attribListToNative, (NativeListener)listener, (ArrayList)attributeListToUpdate, (String)O365InfoCache.getInstalledModule());
        if (returnMsg.length() > 0) {
            try {
                JSONObject resultJson = new JSONObject(returnMsg);
                String contactIdentity = resultJson.getString("Identity");
                nativeStatusProperties.put("contactIdentity", resultJson.getString("Identity"));
            }
            catch (JSONException ex) {
                additionalNativeStatusProperties.put("message", rb.getString(returnMsg));
                creationStatus = false;
            }
        }
        return creationStatus;
    }

    public static boolean modifyContact(Properties nativeStatusProperties, String o365TenantId, String o365TenantPass, ArrayList<Properties> attribListToNative, AdventNetResourceBundle rb, Properties additionalNativeStatusProperties) {
        boolean modifyStatus = true;
        O365InfoCache.getInstance();
        String returnMsg = ADHandler.modifyO365Contact((String)o365TenantId, (String)o365TenantPass, attribListToNative, (String)O365InfoCache.getInstalledModule());
        if (returnMsg.length() > 0) {
            try {
                JSONObject resultJson = new JSONObject(returnMsg);
            }
            catch (JSONException ex) {
                additionalNativeStatusProperties.put("message", rb.getString(returnMsg));
                modifyStatus = false;
            }
        }
        return modifyStatus;
    }

    public static boolean modifyMailContact(Properties nativeStatusProperties, String o365TenantId, String o365TenantPass, ArrayList<Properties> attribListToNative, AdventNetResourceBundle rb, Properties additionalNativeStatusProperties) {
        boolean modifyStatus = true;
        O365InfoCache.getInstance();
        String returnMsg = ADHandler.modifyO365MailContact((String)o365TenantId, (String)o365TenantPass, attribListToNative, (String)O365InfoCache.getInstalledModule());
        if (returnMsg.length() > 0) {
            try {
                JSONObject resultJson = new JSONObject(returnMsg);
            }
            catch (JSONException ex) {
                additionalNativeStatusProperties.put("message", rb.getString(returnMsg));
                modifyStatus = false;
            }
        }
        return modifyStatus;
    }

    public static boolean addNewSharedMailbox(Properties nativeStatusProperties, String o365TenantId, String o365TenantPass, ArrayList<Properties> attribListToNative, AdventNetResourceBundle rb, ArrayList<Properties> delegAttribToNative) {
        boolean creationAndPermissionStatus = true;
        O365InfoCache.getInstance();
        String moduleName = O365InfoCache.getInstalledModule();
        String returnMsg = ADHandler.createNewO365SharedMailbox((String)o365TenantId, (String)o365TenantPass, attribListToNative, (String)moduleName);
        if (returnMsg.length() > 0) {
            try {
                JSONObject resultJson = new JSONObject(returnMsg);
                String name = resultJson.getString("Name");
                if (delegAttribToNative != null && delegAttribToNative.size() > 0) {
                    returnMsg = ADHandler.applyO365MailboxPermissions((String)o365TenantId, (String)o365TenantPass, delegAttribToNative, (String)name, (String)moduleName);
                    if (returnMsg == null || returnMsg.length() == 0) {
                        nativeStatusProperties.put("message", rb.getString("admp.mgmt.office365.shared_mailbox_created_successfully") + " " + rb.getString("admp.mgmt.office365.mb_permission_success"));
                        nativeStatusProperties.put("isSuccess", (Object)true);
                        creationAndPermissionStatus = false;
                    } else {
                        nativeStatusProperties.put("message", rb.getString("admp.mgmt.office365.shared_mailbox_created_successfully") + " " + rb.getString("admp.mgmt.office365.mb_permission_error") + " " + rb.getString(returnMsg));
                        nativeStatusProperties.put("isSuccess", (Object)true);
                        creationAndPermissionStatus = false;
                    }
                }
            }
            catch (JSONException ex) {
                nativeStatusProperties.put("message", rb.getString("admp.mgmt.office365.error.error_in_creating_shared_mailbox") + " " + rb.getString(returnMsg));
                nativeStatusProperties.put("isSuccess", (Object)false);
                creationAndPermissionStatus = false;
            }
        }
        return creationAndPermissionStatus;
    }

    public static boolean addNewResourceMailbox(Properties nativeStatusProperties, String o365TenantId, String o365TenantPass, String resourceType, ArrayList<Properties> attribListToNative, AdventNetResourceBundle rb) {
        boolean creationStatus = true;
        O365InfoCache.getInstance();
        String returnMsg = ADHandler.createNewO365ResourceMailbox((String)o365TenantId, (String)o365TenantPass, (String)resourceType, attribListToNative, (String)O365InfoCache.getInstalledModule());
        if (returnMsg.length() > 0) {
            try {
                JSONObject resultJson = new JSONObject(returnMsg);
                nativeStatusProperties.put("Identity", resultJson.getString("Identity"));
            }
            catch (JSONException ex) {
                nativeStatusProperties.put("message", rb.getString("admp.mgmt.office365.error.error_in_creating_resource_mailbox") + " " + rb.getString(returnMsg));
                nativeStatusProperties.put("isSuccess", (Object)false);
                creationStatus = false;
            }
        }
        return creationStatus;
    }

    public static boolean modifyResourceMailbox(Properties nativeStatusProperties, String o365TenantId, String o365TenantPass, ArrayList<Properties> attribListToNative, AdventNetResourceBundle rb) {
        boolean creationStatus = true;
        O365InfoCache.getInstance();
        String returnMsg = ADHandler.modifyO365ResourceMailbox((String)o365TenantId, (String)o365TenantPass, attribListToNative, (String)O365InfoCache.getInstalledModule());
        if (returnMsg.length() > 0) {
            try {
                JSONObject resultJson = new JSONObject(returnMsg);
            }
            catch (JSONException ex) {
                nativeStatusProperties.put("message", rb.getString("admp.mgmt.office365.error.error_in_modifing_resource_mailbox") + " " + rb.getString(returnMsg));
                nativeStatusProperties.put("modifyResourceMailboxErrorIncluded", (Object)true);
                creationStatus = false;
            }
        }
        return creationStatus;
    }

    public static boolean modifyCalenderProcessing(Properties nativeStatusProperties, String o365TenantId, String o365TenantPass, ArrayList<Properties> attribListToNative, AdventNetResourceBundle rb) {
        boolean creationStatus = true;
        O365InfoCache.getInstance();
        String returnMsg = ADHandler.modifyO365CalenderProcessing((String)o365TenantId, (String)o365TenantPass, attribListToNative, (String)O365InfoCache.getInstalledModule());
        if (returnMsg.length() > 0) {
            try {
                JSONObject resultJson = new JSONObject(returnMsg);
            }
            catch (JSONException ex) {
                if (nativeStatusProperties.get("modifyResourceMailboxErrorIncluded") != null && ((Boolean)nativeStatusProperties.get("modifyResourceMailboxErrorIncluded")).booleanValue()) {
                    nativeStatusProperties.put("message", " " + rb.getString(returnMsg));
                } else {
                    nativeStatusProperties.put("message", rb.getString("admp.mgmt.office365.error.error_in_modifing_resource_mailbox") + " " + rb.getString(returnMsg));
                }
                creationStatus = false;
            }
        }
        return creationStatus;
    }

    public static boolean modifyUser(Properties nativeStatusProperties, String o365TenantId, String o365TenantPass, ArrayList<Properties> attribListToNative, AdventNetResourceBundle rb) {
        boolean creationStatus = true;
        O365InfoCache.getInstance();
        String returnMsg = ADHandler.modifyO365User((String)o365TenantId, (String)o365TenantPass, attribListToNative, (String)O365InfoCache.getInstalledModule());
        if (returnMsg.length() > 0) {
            try {
                JSONObject resultJson = new JSONObject(returnMsg);
            }
            catch (JSONException ex) {
                if (nativeStatusProperties.get("modifyResourceMailboxErrorIncluded") != null && ((Boolean)nativeStatusProperties.get("modifyResourceMailboxErrorIncluded")).booleanValue()) {
                    nativeStatusProperties.put("message", nativeStatusProperties.getProperty("message") + ", " + rb.getString(returnMsg));
                } else {
                    if (nativeStatusProperties.get("modifyResourceMailboxPartialErrorIncluded") != null && ((Boolean)nativeStatusProperties.get("modifyResourceMailboxPartialErrorIncluded")).booleanValue()) {
                        nativeStatusProperties.put("message", nativeStatusProperties.getProperty("message") + ", " + rb.getString(returnMsg));
                    } else {
                        nativeStatusProperties.put("message", rb.getString("admp.mgmt.office365.error.partial_error_in_creating_resource_mailbox") + " " + rb.getString(returnMsg));
                        nativeStatusProperties.put("modifyResourceMailboxPartialErrorIncluded", (Object)true);
                    }
                    nativeStatusProperties.put("modifyResourceMailboxErrorIncluded", (Object)true);
                }
                creationStatus = false;
            }
        }
        return creationStatus;
    }

    public static boolean modifyO365DistGroup(Properties nativeStatusProperties, String o365TenantId, String o365TenantPass, String objectId, ArrayList<Properties> attribListToNative, AdventNetResourceBundle rb) {
        boolean creationStatus = true;
        O365InfoCache.getInstance();
        String returnMsg = ADHandler.modifyO365DistGroup((String)o365TenantId, (String)o365TenantPass, (String)objectId, attribListToNative, (String)O365InfoCache.getInstalledModule());
        if (returnMsg.length() > 0) {
            try {
                JSONObject resultJson = new JSONObject(returnMsg);
            }
            catch (JSONException ex) {
                ArrayList messageList = new ArrayList();
                Hashtable<String, String> errorHash = new Hashtable<String, String>();
                if (returnMsg.contains("admp.mgmt.o365.mod_single_grp.some_error_occured")) {
                    returnMsg = returnMsg.replace("admp.mgmt.o365.mod_single_grp.some_error_occured", rb.getString("admp.mgmt.o365.mod_single_grp.some_error_occured"));
                }
                errorHash.put("ERROR_MESSAGE", returnMsg);
                messageList.add(errorHash);
                nativeStatusProperties.put("CREATION_MESSAGE", messageList);
                nativeStatusProperties.put("CREATION_STATUS", "SEVERE");
                nativeStatusProperties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                nativeStatusProperties.put("STATUS_MESSAGE", rb.getString("admp.mgmt.office365.error.mod_o365_dist_group"));
                creationStatus = false;
            }
        }
        return creationStatus;
    }

    public static ArrayList getLicenseOptions(String o365TenantId, JSONArray accountSKUDetailsList, String domainName) {
        ArrayList<Properties> licenseDetails = new ArrayList<Properties>();
        try {
            Hashtable skuIdvsAllServPlans = O365MgmtUtil.getSkuIdVsAllServPlansList(o365TenantId);
            if (skuIdvsAllServPlans == null) {
                return licenseDetails;
            }
            for (int ind1 = 0; ind1 < accountSKUDetailsList.length(); ++ind1) {
                String serviceName;
                JSONObject accountSKUDetails = (JSONObject)accountSKUDetailsList.get(ind1);
                if (!accountSKUDetails.has("IS_SELECTED") || !accountSKUDetails.getBoolean("IS_SELECTED")) continue;
                String accountSKUId = accountSKUDetails.getString("ACCOUNT_SKU_ID");
                String disabledPlans = "";
                if (accountSKUDetails.has("ServicePlans")) {
                    JSONArray servicePlansList = (JSONArray)accountSKUDetails.get("ServicePlans");
                    ArrayList allServicePlans = (ArrayList)skuIdvsAllServPlans.get(accountSKUId);
                    for (int ind2 = 0; ind2 < servicePlansList.length(); ++ind2) {
                        JSONObject servicePlanDet = (JSONObject)servicePlansList.get(ind2);
                        serviceName = servicePlanDet.getString("SERVICE_NAME");
                        for (int i = 0; i < allServicePlans.size(); ++i) {
                            String service = (String)allServicePlans.get(i);
                            if (!serviceName.equalsIgnoreCase(service)) continue;
                            allServicePlans.remove(i);
                            break;
                        }
                        if (!servicePlanDet.has("SERVICE_NAME") || servicePlanDet.has("IS_SELECTED") && servicePlanDet.getBoolean("IS_SELECTED")) continue;
                        if (disabledPlans.length() > 0) {
                            disabledPlans = disabledPlans + ",";
                        }
                        disabledPlans = disabledPlans + servicePlanDet.getString("SERVICE_NAME");
                    }
                    for (int i = 0; i < allServicePlans.size(); ++i) {
                        String service = (String)allServicePlans.get(i);
                        if (disabledPlans.length() > 0) {
                            disabledPlans = disabledPlans + ",";
                        }
                        disabledPlans = disabledPlans + service;
                    }
                }
                O365InfoCache.getInstance();
                if (O365InfoCache.getInstalledModule().equalsIgnoreCase("AzureAD") && disabledPlans.length() > 0) {
                    String[] planList = disabledPlans.split(",");
                    Properties licenseProp = (Properties)O365InfoCache.getInstance().getO365LicenseStatusProps(accountSKUId);
                    HashMap serviceNameVsPlanId = (HashMap)licenseProp.get("serviceNameVsPlanId");
                    disabledPlans = "";
                    for (int i = 0; i < planList.length; ++i) {
                        serviceName = planList[i];
                        if (disabledPlans.length() > 0) {
                            disabledPlans = disabledPlans + ",";
                        }
                        disabledPlans = disabledPlans + (String)serviceNameVsPlanId.get(serviceName);
                    }
                }
                Properties prop = new Properties();
                prop.put("AccountSku", accountSKUId);
                prop.put("DisabledPlans", disabledPlans);
                licenseDetails.add(prop);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return licenseDetails;
    }

    public static String getLicenseForAudit(String o365TenantId, JSONArray accountSKUDetailsList, AdventNetResourceBundle rb) {
        StringBuilder licenseDetails = new StringBuilder();
        try {
            Hashtable skuIdvsAllServPlans = O365MgmtUtil.getSkuIdVsAllServPlansList(o365TenantId);
            if (skuIdvsAllServPlans == null) {
                return licenseDetails.toString();
            }
            for (int ind1 = 0; ind1 < accountSKUDetailsList.length(); ++ind1) {
                JSONObject accountSKUDetails = (JSONObject)accountSKUDetailsList.get(ind1);
                if (!accountSKUDetails.has("IS_SELECTED") || !accountSKUDetails.getBoolean("IS_SELECTED")) continue;
                String skuId = accountSKUDetails.getString("ACCOUNT_SKU_ID");
                String accountSKUId = rb.getString(O365MgmtHandler.getDispNameForWAADAccountSKU((String)skuId));
                ArrayList<String> servicePlans = new ArrayList<String>();
                boolean hasDisabledPlan = false;
                if (accountSKUDetails.has("ServicePlans")) {
                    JSONArray servicePlansList = (JSONArray)accountSKUDetails.get("ServicePlans");
                    ArrayList allServicePlans = (ArrayList)skuIdvsAllServPlans.get(skuId);
                    for (int ind2 = 0; ind2 < servicePlansList.length(); ++ind2) {
                        JSONObject servicePlanDet = (JSONObject)servicePlansList.get(ind2);
                        String serviceName = servicePlanDet.getString("SERVICE_NAME");
                        for (int i = 0; i < allServicePlans.size(); ++i) {
                            String service = (String)allServicePlans.get(i);
                            if (!serviceName.equalsIgnoreCase(service)) continue;
                            allServicePlans.remove(i);
                            break;
                        }
                        if (servicePlanDet.has("SERVICE_NAME") && servicePlanDet.has("IS_SELECTED") && servicePlanDet.getBoolean("IS_SELECTED")) {
                            servicePlans.add(rb.getString(O365MgmtHandler.getDisplayNameForWAADServicePlan((String)servicePlanDet.getString("SERVICE_NAME"))));
                            continue;
                        }
                        hasDisabledPlan = true;
                    }
                    if (allServicePlans.size() > 0) {
                        hasDisabledPlan = true;
                    }
                }
                licenseDetails.append(accountSKUId);
                if (servicePlans.size() > 0 && hasDisabledPlan) {
                    licenseDetails.append(servicePlans);
                }
                licenseDetails.append(";");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return licenseDetails.toString();
    }

    public static void fillUsageLocationMandatoryError(Properties nativeStatusProperties, AdventNetResourceBundle rb) {
        nativeStatusProperties.put("message", rb.getString("admp.office_365.error.provide_usagelocation_with_country"));
        nativeStatusProperties.put("isSuccess", (Object)false);
    }

    public static String getADUserObjectGUID(String domainName, Long loginId, String distinguishedName, String searchString) {
        String objectGUID = null;
        try {
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            ArrayList<String> attribsToFetch = new ArrayList<String>();
            attribsToFetch.add("objectGUID");
            ArrayList objectsList = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)distinguishedName, attribsToFetch, (String)searchString);
            if (objectsList != null && objectsList.size() > 0) {
                Properties prop = (Properties)objectsList.get(0);
                ArrayList valueList = (ArrayList)prop.get("objectGUID");
                objectGUID = (String)valueList.get(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return objectGUID;
    }

    private static Hashtable getSkuIdVsAllServPlansList(String o365TenantId) {
        Hashtable skuIdvsAllServPlans = new Hashtable();
        try {
            Properties o365AccountProps = DomainInfoCache.getInstance().getWAADDomainProperties(o365TenantId);
            if (o365AccountProps == null || !o365AccountProps.containsKey("SKU_DETAILS")) {
                logg.log(Level.INFO, "unable to fetch licenseDetails for o365TenantId " + o365TenantId);
                return null;
            }
            JSONArray waadAccSkuDetailsList = (JSONArray)o365AccountProps.get("SKU_DETAILS");
            for (int i = 0; i < waadAccSkuDetailsList.length(); ++i) {
                JSONObject accountSkuDetails = (JSONObject)waadAccSkuDetailsList.get(i);
                if (!accountSkuDetails.getString("TYPE").equalsIgnoreCase("User")) continue;
                String skuId = accountSkuDetails.getString("ACCOUNT_SKU_ID");
                JSONArray servicesJSONArray = (JSONArray)accountSkuDetails.get("ServicePlans");
                ArrayList<String> servicePlans = (ArrayList<String>)skuIdvsAllServPlans.get(skuId);
                if (servicePlans == null) {
                    servicePlans = new ArrayList<String>();
                    skuIdvsAllServPlans.put(skuId, servicePlans);
                }
                for (int j = 0; j < servicesJSONArray.length(); ++j) {
                    JSONObject servicePlanDet = (JSONObject)servicesJSONArray.get(j);
                    if (!servicePlanDet.getString("TYPE").equalsIgnoreCase("User")) continue;
                    servicePlans.add(servicePlanDet.getString("SERVICE_NAME"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return skuIdvsAllServPlans;
    }
}

