/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.oumanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.webclient.oumanagement.ModifyOUListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class DeleteOUListener
extends ModifyOUListener {
    public DeleteOUListener() {
        this.reportId = new Integer(9006);
        this.tableName = new String("ADSMModifyOUResult");
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{51027L})) {
            return this.rb.getString("admp.mgmt.contact_mgmt.delete_contacts.access_denied");
        }
        try {
            logger.log(Level.INFO, "Calling Modify User in the DeleteContactsListener");
            try {
                String dn = this.getValue(result, 8003);
                String guid = this.getValue(result, 8007);
                guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                logger.log(Level.INFO, "Starts deleting the OU ,guid: " + guid + "dn: " + dn);
                ADHandler.deleteContact((String)domainName, (Long)loginId, (String)dn);
                UserHandler.deleteOU((String)dn);
                message.append(this.rb.getString("ous.message.successfully_deleted_ou"));
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(this.rb.getString("ous.message.unable_deleted_ou") + ". " + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("ous.message.unable_deleted_ou") + ". " + e.getMessage());
            }
            TechAuditAPI.getInstance().auditDeleteObject(loginId, this.rb.getString("admp.mgmt.heading.ou_mgmt"), this.rb.getString("jsp.UserManagement.UserAdmin.delete_ou"), this.getValue(result, 8003), domainName, message.toString(), this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Returned Message is " + message.toString());
        return message.toString();
    }

    @Override
    public Properties getSIDProps() {
        Properties sidProps = new Properties();
        sidProps.put("ATTRIB_ID", new Integer(8007));
        sidProps.put("ATTRIB_COLUMN_NAME", "OBJECT_GUID");
        sidProps.put("TABLE_NAME", this.baseTableName);
        sidProps.put("RELATIONAL_TYPE", new Integer(0));
        return sidProps;
    }

    @Override
    public Long getCategoryId() {
        return null;
    }

    @Override
    public ArrayList getMgmtActions(ArrayList actions) {
        return null;
    }
}

