/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.oumanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.admin.SearchProfileHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ModifyOUListener
extends ModifyUserListener {
    public ModifyOUListener() {
        if (!LicenseMgr.getInstance().isModuleLicensed("OU Management")) {
            this.isLicenseExceeded = true;
        }
        this.dnAttribId = 8003;
        this.searchAttributes = SearchProfileHandler.getSearchAttributes((int)3, (int)5);
    }

    @Override
    public String getCSVQuery(String keyLdapName, String keyLdapValue) {
        return "(&(objectClass=organizationalUnit)(objectCategory=organizationalUnit)(" + keyLdapName + "=" + keyLdapValue + "))";
    }

    @Override
    public String getObjectName(Hashtable h) {
        return this.getValue(h, new Integer(8001));
    }

    @Override
    public void addDNProps(ArrayList attribList) {
        boolean dnExists = false;
        if (attribList != null) {
            for (int i = 0; i < attribList.size(); ++i) {
                Properties attributeProperties = (Properties)attribList.get(i);
                if (!attributeProperties.getProperty("ATTRIB_COLUMN_NAME").equals("DISTINGUISHED_NAME")) continue;
                dnExists = true;
            }
        }
        if (!dnExists) {
            Properties dnProps = new Properties();
            dnProps.put("ATTRIB_ID", new Integer(this.dnAttribId));
            dnProps.put("ATTRIB_COLUMN_NAME", "DISTINGUISHED_NAME");
            dnProps.put("ATTRIB_LDAP_NAME", "distinguishedName");
            dnProps.put("TABLE_NAME", this.baseTableName);
            dnProps.put("RELATIONAL_TYPE", new Integer(0));
            attribList.add(dnProps);
        }
    }

    @Override
    public void search(HttpServletRequest request, ReportBean bean) {
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.continueAction = true;
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)loginId);
            logger.log(Level.INFO, "Generation ID : " + this.generationId);
            ArrayList attributeList = this.getReportAttributeList();
            String searchString = request.getParameter("searchString");
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            logger.log(Level.INFO, "The container list is : " + containerList);
            StringBuffer str = new StringBuffer();
            str.append("(&(objectCategory=organizationalUnit)(objectClass=organizationalUnit)");
            if (searchString != null && !searchString.equals("")) {
                this.getSearchString(searchString, str);
            }
            str.append(")");
            logger.log(Level.INFO, "Searching the SIDs for the String " + searchString);
            logger.log(Level.INFO, "Form to Action : ");
            ModifyUserListener.Action action = new ModifyUserListener.Action(this, loginId, containerList, attributeList, str.toString(), this, dnDomainNameMap, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1068L);
        return categoryId;
    }

    @Override
    public ArrayList getMgmtActions(ArrayList actions) {
        ArrayList resultMgmtActions = new ArrayList();
        Hashtable<String, Object> mgmtActionItems = new Hashtable<String, Object>();
        for (int i = 0; i < actions.size(); ++i) {
            Hashtable hash = (Hashtable)actions.get(i);
            ArrayList actionItems = (ArrayList)hash.get("ACTION_ITEMS");
            String categoryName = (String)hash.get("CATEGORY_NAME");
            Long subCategoryId = (Long)hash.get("SUB_CATEGORY_ID");
            if (actionItems == null || subCategoryId != 1075L) continue;
            mgmtActionItems = new Hashtable();
            mgmtActionItems.put("CATEGORY_NAME", categoryName);
            mgmtActionItems.put("ACTION_ITEMS", actionItems);
            resultMgmtActions.add(mgmtActionItems);
        }
        return resultMgmtActions;
    }

    protected class ModifyCSVAction
    extends Thread {
        private ArrayList list = null;
        ReportBean bean = null;
        private ArrayList messageList = null;
        private int modifyCount = 0;
        private Long loginId = null;
        private String hostId = "";

        public ModifyCSVAction(Long loginId, String hostId, ReportBean b, ArrayList list) {
            this.bean = b;
            this.list = list;
            this.messageList = new ArrayList();
            this.modifyCount = 0;
            this.loginId = loginId;
            this.hostId = hostId;
        }

        private void updatePreviousList() {
            if (this.messageList.size() > 0) {
                for (int i = 0; i < this.messageList.size(); ++i) {
                    ModifyOUListener.this.out.write((String)this.messageList.get(i));
                    ModifyOUListener.this.out.flush();
                }
                this.messageList.clear();
            }
        }

        private void updateMessage(Long userIndex, String message) {
            ++this.modifyCount;
            String s = "<script>if(this.load) updateMessage('" + userIndex.toString() + "','" + message + "')</script>";
            String s1 = "<script>if(this.load) updateCount('" + this.modifyCount + "')</script>";
            if (ModifyOUListener.this.out != null) {
                this.updatePreviousList();
                ModifyOUListener.this.out.write(s);
                ModifyOUListener.this.out.flush();
                ModifyOUListener.this.out.write(s1);
                ModifyOUListener.this.out.flush();
            } else {
                this.messageList.add(s);
                this.messageList.add(s1);
            }
            Properties prop = new Properties();
            prop.setProperty("CREATION_STATUS", "WARNING");
            prop.setProperty("CREATION_MESSAGE", message);
            prop.put("USER_INDEX", userIndex);
            AddUserHandler.getInstance().updateCreationStatus(ModifyOUListener.this.rb, prop);
        }

        @Override
        public void run() {
            String[] domains = (String[])this.bean.get("domains");
            Hashtable dnDomainNameMap = (Hashtable)this.bean.get("dnDomainNameMap");
            String defaultNamingContext = domains[0];
            ModifyOUListener.this.domainName = (String)dnDomainNameMap.get(defaultNamingContext);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("domain", ModifyOUListener.this.domainName);
            this.bean.set("inputParams", inputParams);
            boolean isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"OU Management");
            ModifyOUListener.this.setTableProps(ModifyOUListener.this.domainName, new Long(-1L));
            ModifyOUListener.this.registerQueue();
            ModifyOUListener.this.updateResult = false;
            String keyLdapName = (String)this.bean.get("keyLdapName");
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)ModifyOUListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)ModifyOUListener.this.rb);
                for (int i = 0; ModifyOUListener.this.continueAction && i < this.list.size(); ++i) {
                    Hashtable hashtable = (Hashtable)this.list.get(i);
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    String keyLdapValue = null;
                    String message = "";
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    for (Hashtable hashtable1 : valuesList) {
                        String ldapName = (String)hashtable1.get("ATTRIB_LDAP_NAME");
                        if (!ldapName.equals(keyLdapName)) continue;
                        keyLdapValue = hashtable1.get("ATTRIB_VALUE").toString();
                        break;
                    }
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, keyLdapValue, (String)ModifyOUListener.this.domainName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    if (!isLicenseExceeded) {
                        String searchString = ModifyOUListener.this.getCSVQuery(keyLdapName, keyLdapValue);
                        message = ModifyOUListener.this.modifyCSVUser(searchString, this.bean, defaultNamingContext, this.loginId, audit_info, auditDataObj);
                        this.updateMessage(userIndex, message);
                    } else {
                        String licenseCount = LicenseMgr.getInstance().getLicenseProperty("ADMgmt", "NumberOfUsers");
                        message = MessageFormat.format(ModifyOUListener.this.rb.getString("admp.mgmt.comp_mgmt.common.license_exceeded_message"), licenseCount);
                        this.updateMessage(userIndex, message);
                    }
                    audit_info.put("error_msg", message);
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                }
                ModifyOUListener.this.updateQueue();
                ModifyOUListener.this.isCompleted = true;
                ModifyOUListener.this.totalCount = 0;
                ModifyOUListener.this.endQueue();
                ModifyOUListener.this.updateResult = true;
                this.messageList.clear();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

