/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.oumanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.oumanagement.ModifyOUListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class MoveOUListener
extends ModifyOUListener {
    public MoveOUListener() {
        this.reportId = new Integer(9007);
        this.tableName = new String("ADSMModifyOUResult");
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{51028L})) {
            return this.rb.getString("admp.mgmt.contact_mgmt.delete_contacts.access_denied");
        }
        try {
            BeanMap props = (BeanMap)bean.get("props");
            String dn = this.getValue(result, 8003);
            String guid = this.getValue(result, 8007);
            logger.log(Level.INFO, "Calling Modify User in the MoveOUListener");
            try {
                guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                logger.log(Level.INFO, "Starts deleting the OU,guid: " + guid + "dn: " + dn);
                ADHandlerForMgmt.moveObject((String)domainName, (Long)loginId, (String)dn, (String)props.getProperty("moveUsersDN"));
                ADHandler.updateContact((String)domainName, (Long)loginId, (String)guid, (String)dn, (ArrayList)attributeList, (NativeListener)this);
                message.append(this.rb.getString("ous.message.successfully_moved_ou"));
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(this.rb.getString("ous.message.unable_moved_ou") + ". " + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("ous.message.unable_moved_ou") + ". " + e.getMessage());
            }
            String sourceDN = StrUtil.getContainerDNFromDN((String)dn);
            TechAuditAPI.getInstance().auditMoveOU(loginId, this.rb.getString("jsp.UserManagement.UserAdmin.move_ou"), CommonUtil.deEscapeCharsInString((String)this.getValue(result, 8003), (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS), domainName, CommonUtil.deEscapeCharsInString((String)sourceDN, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS), CommonUtil.deEscapeCharsInString((String)props.getProperty("moveUsersDN"), (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Returned Message is " + message.toString());
        return message.toString();
    }

    @Override
    public Properties getSIDProps() {
        Properties sidProps = new Properties();
        sidProps.put("ATTRIB_ID", new Integer(8007));
        sidProps.put("ATTRIB_COLUMN_NAME", "OBJECT_GUID");
        sidProps.put("TABLE_NAME", this.baseTableName);
        sidProps.put("RELATIONAL_TYPE", new Integer(0));
        return sidProps;
    }
}

