/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.popup;

import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.popup.PopupDataModel;
import com.adventnet.sym.adsm.common.server.popup.PopupManager;
import com.adventnet.sym.adsm.common.server.popup.PopupReqParams;
import com.adventnet.sym.adsm.common.server.popup.PopupSelection;
import com.adventnet.sym.adsm.common.server.popup.PopupSingleton;
import com.adventnet.sym.adsm.common.server.popup.datamodel.DataModel;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ajax.AjaxUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PopupAction
extends DispatchAction {
    private static volatile PopupAction instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PopupAction getInstance() {
        if (instance != null) return instance;
        Class<PopupAction> clazz = PopupAction.class;
        synchronized (PopupAction.class) {
            if (instance != null) return instance;
            instance = new PopupAction();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ActionForward getConfigData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Long popupId = request.getParameter("popupId") != null ? new Long(request.getParameter("popupId")) : 1L;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            PopupSelection popupSelection = PopupSingleton.getInstance().getPopupSelection(popupId, loginId);
            String configData = AjaxUtil.getResponse("PopupSelection", popupSelection.toJSONObject());
            AjaxUtil.writeJsonResponse(response, configData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getPopupHeader(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("headerDesign");
    }

    public ActionForward getDataModelUIDesign(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String paramString = request.getParameter("params");
        Integer objViewModelId = null;
        try {
            FcExecuteFormBean fcExecuteFormBean;
            JSONObject json = new JSONObject(paramString);
            HttpSession session = request.getSession();
            ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            json.put("authObject", (Object)authObj);
            PopupReqParams popupReqParams = new PopupReqParams(json);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            popupReqParams.setLoginId(loginId);
            popupReqParams.setSessionId(session.getId());
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            popupReqParams.setRb(rb);
            String domainDN = popupReqParams.getDomainName();
            JSONObject inputParamsJson = popupReqParams.getInputParamsMap();
            if (inputParamsJson.has("actions")) {
                JSONArray actions = (JSONArray)inputParamsJson.get("actions");
                JSONObject actionIsAuth = new JSONObject();
                for (int i = 0; i < actions.length(); ++i) {
                    String action = (String)actions.get(i);
                    String domainName = DomainUtil.getDomainName((String)domainDN) == null ? domainDN : DomainUtil.getDomainName((String)domainDN);
                    boolean isAuth = ClientUtil.checkAuthorization(request, domainName, Long.parseLong(action));
                    actionIsAuth.put(action, isAuth);
                }
                popupReqParams.setInputParamsMap(actionIsAuth);
            }
            if ((fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean")) != null && fcExecuteFormBean.getApplyIamAppsDelegation()) {
                inputParamsJson.put("applyIamAppsDelegation", true);
            }
            if (!json.has("authOUList")) {
                String domain = (String)json.get("domainName");
                domain = DomainUtil.getDomainName((String)domain) == null ? domain : DomainUtil.getDomainName((String)domain);
                popupReqParams.setAuthOUList(HelpdeskUtil.getOUList((String)domain, (Long)loginId));
            }
            objViewModelId = popupReqParams.getViewModelId();
            DataModel iDataModel = PopupManager.getDataModel((PopupReqParams)popupReqParams);
            request.setAttribute("domainName", (Object)domainDN);
            request.setAttribute("IDataModel", (Object)iDataModel);
            request.setAttribute("popupReqParams", (Object)popupReqParams);
            if (json.has("rangeChange") && json.getBoolean("rangeChange")) {
                PopupDataModel pdmObject = PopupSingleton.getInstance().getPopupSelection(popupReqParams.getPopupId(), popupReqParams.getLoginId()).getPDM(popupReqParams.getPDMId());
                NavigateRangeUtil.setDefaultRange((String)pdmObject.getModuleName(), (int)popupReqParams.getRange(), (Long)loginId);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Hashtable hash = PopupSingleton.getInstance().getObjectViewModelInfo(objViewModelId);
        return mapping.findForward((String)hash.get("TILE_NAME"));
    }

    public ActionForward getSummaryView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String selectedObjects = request.getParameter("selectedObjects");
        try {
            JSONObject selectedObjectsJSON = new JSONObject(selectedObjects);
            Boolean showUniqueValue = false;
            if (request.getParameter("showUniqueValue") != null) {
                showUniqueValue = true;
            }
            request.setAttribute("showUniqueValue", (Object)showUniqueValue);
            request.setAttribute("selectedObjects", (Object)selectedObjectsJSON);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("summaryView");
    }

    public ActionForward getO365AdvancedLicenseFilterView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward = null;
        try {
            JSONObject reqParam = new JSONObject(request.getParameter("params"));
            String waadAccountId = reqParam.getString("waadAccountId");
            String reportId = reqParam.getString("reportId");
            Properties props = O365InfoCache.getInstance().getO365TenantIdvsLicenseServiceDetails(waadAccountId);
            HttpSession session = request.getSession();
            ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable iamAppAccountDetails = authObj.getAuthorizedIamAppAccountDetails(waadAccountId, 3);
            Hashtable authorizedLicenseDetails = (Hashtable)iamAppAccountDetails.get("SelectedLicenseServiceHash");
            Hashtable authorizedLicenseCountDetails = (Hashtable)iamAppAccountDetails.get("SelectedLicenseServiceCountHash");
            HashMap o365LicenseServicesDetails = new HashMap();
            JSONArray skuDetails = (JSONArray)props.get("SKU_DETAILS");
            if (skuDetails != null) {
                for (int i = 0; i < skuDetails.length(); ++i) {
                    JSONObject skuDetail = skuDetails.getJSONObject(i);
                    String skuId = skuDetail.getString("ACCOUNT_SKU_ID");
                    Hashtable authorizedServicesHash = (Hashtable)authorizedLicenseDetails.get(skuId);
                    Hashtable authorizedServicesCountDetails = (Hashtable)authorizedLicenseCountDetails.get(skuId);
                    if (((Boolean)authorizedServicesCountDetails.get("NoServicesSelected")).booleanValue()) continue;
                    ArrayList<String> services = new ArrayList<String>();
                    JSONArray servicePlans = skuDetail.getJSONArray("ServicePlans");
                    for (int j = 0; j < servicePlans.length(); ++j) {
                        JSONObject servicePlan = servicePlans.getJSONObject(j);
                        String serviceName = servicePlan.getString("SERVICE_NAME");
                        if (!Boolean.valueOf(servicePlan.getString("TYPE").equalsIgnoreCase("User")).booleanValue() || !((Boolean)authorizedServicesHash.get(serviceName)).booleanValue()) continue;
                        services.add(serviceName);
                    }
                    o365LicenseServicesDetails.put(skuId, services);
                }
            }
            request.setAttribute("o365LicenseServicesDetails", o365LicenseServicesDetails);
            request.setAttribute("reportId", (Object)reportId);
            forward = "O365AdvancedLicenseFilterPopupView";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public void getConfigData(HttpServletRequest request, HttpServletResponse response) {
        try {
            Long popupId = request.getParameter("popupId") != null ? new Long(request.getParameter("popupId")) : 1L;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            PopupSelection popupSelection = PopupSingleton.getInstance().getPopupSelection(popupId, loginId);
            JSONObject popupConfigData = popupSelection.toJSONObject();
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(popupConfigData.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getDataModelUIDesign(HttpServletRequest request, HttpServletResponse response) {
        String paramString = request.getParameter("params");
        Integer objViewModelId = null;
        JSONObject json = new JSONObject();
        JSONObject dataModelObject = new JSONObject();
        try {
            JSONObject inputParamsJson;
            json = new JSONObject(paramString);
            HttpSession session = request.getSession();
            ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            json.put("authObject", (Object)authObj);
            PopupReqParams popupReqParams = new PopupReqParams(json);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            popupReqParams.setLoginId(loginId);
            popupReqParams.setSessionId(session.getId());
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            popupReqParams.setRb(rb);
            String domainDN = popupReqParams.getDomainName();
            String domainName = "";
            if (domainDN != null && (domainName = DomainUtil.getDomainName((String)domainDN)) == null) {
                domainName = domainDN;
                domainDN = DomainUtil.getDefaultNamingContext((String)domainName);
                popupReqParams.setDomainName(domainDN);
            }
            if ((inputParamsJson = popupReqParams.getInputParamsMap()).has("actions")) {
                JSONArray actions = (JSONArray)inputParamsJson.get("actions");
                JSONObject actionIsAuth = new JSONObject();
                for (int i = 0; i < actions.length(); ++i) {
                    String action = (String)actions.get(i);
                    boolean isAuth = ClientUtil.checkAuthorization(request, domainName, Long.parseLong(action));
                    actionIsAuth.put(action, isAuth);
                }
                popupReqParams.setInputParamsMap(actionIsAuth);
            }
            if (!json.has("authOUList")) {
                String domain = DomainUtil.getDomainName((String)((String)json.get("domainName")));
                popupReqParams.setAuthOUList(HelpdeskUtil.getOUList((String)domain, (Long)loginId));
            }
            objViewModelId = popupReqParams.getViewModelId();
            DataModel iDataModel = PopupManager.getDataModel((PopupReqParams)popupReqParams);
            if (iDataModel.toJSONObject() != null) {
                dataModelObject = iDataModel.toJSONObject();
            }
            if (json.has("rangeChange") && json.getBoolean("rangeChange")) {
                PopupDataModel pdmObject = PopupSingleton.getInstance().getPopupSelection(popupReqParams.getPopupId(), popupReqParams.getLoginId()).getPDM(popupReqParams.getPDMId());
                NavigateRangeUtil.setDefaultRange((String)pdmObject.getModuleName(), (int)popupReqParams.getRange(), (Long)loginId);
            }
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(dataModelObject.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getPopupData(HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            JSONObject dataModelObject = new JSONObject();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            JSONObject requestObj = new JSONObject(request.getParameter("params"));
            String type = request.getParameter("type");
            JSONObject params = new JSONObject();
            PopupSelection popupSelection = PopupSingleton.getInstance().getPopupSelection(Long.valueOf(21L), loginId);
            JSONObject popupConfig = popupSelection.toJSONObject();
            JSONObject popupTab = (JSONObject)popupConfig.getJSONArray("popupTabs").get(0);
            requestObj.put("domainName", (Object)requestObj.getString("currentSelection"));
            requestObj.put("isExcludeChildOU", (Object)requestObj.getString("isExcludeChild"));
            requestObj.remove("currentSelection");
            requestObj.remove("isExcludeChild");
            requestObj.put("popupId", 21L);
            requestObj.put("actionId", popupTab.getLong("actionId"));
            requestObj.put("objectTypeId", popupTab.getLong("objectTypeId"));
            requestObj.put("exchType", (Object)"undefined");
            Long popupDataModelId = 0L;
            Integer viewModelId = 0;
            JSONObject advFilterObj = (JSONObject)popupTab.getJSONArray("advancedFilterObjectList").get(0);
            JSONArray popDataModelObjList = advFilterObj.getJSONArray("popupDataModelList");
            for (int index = 0; index < popDataModelObjList.length(); ++index) {
                JSONObject popupDataModelObj = (JSONObject)popDataModelObjList.get(index);
                String viewName = popupDataModelObj.getString("viewModelName");
                if ((!type.equalsIgnoreCase("tree") || !viewName.equalsIgnoreCase("admp.popup.common.link_tree_view")) && (!type.equalsIgnoreCase("table") || !viewName.equalsIgnoreCase("admp.popup.common.link_list_view"))) continue;
                popupDataModelId = (Long)popupDataModelObj.get("popupDataModelId");
                viewModelId = (Integer)popupDataModelObj.get("viewModelId");
            }
            requestObj.put("popupDataModelId", (Object)popupDataModelId);
            requestObj.put("viewModelId", (Object)viewModelId);
            requestObj.put("authObject", (Object)authObj);
            PopupReqParams popupReqParams = new PopupReqParams(requestObj);
            popupReqParams.setLoginId(loginId);
            popupReqParams.setSessionId(session.getId());
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            popupReqParams.setRb(rb);
            String domainDN = popupReqParams.getDomainName();
            String domain = DomainUtil.getDomainName((String)domainDN);
            popupReqParams.setAuthOUList(HelpdeskUtil.getOUList((String)domain, (Long)loginId));
            DataModel iDataModel = PopupManager.getDataModel((PopupReqParams)popupReqParams);
            if (iDataModel.toJSONObject() != null) {
                dataModelObject = iDataModel.toJSONObject();
            }
            if (requestObj.has("rangeChange") && requestObj.getBoolean("rangeChange")) {
                PopupDataModel pdmObject = PopupSingleton.getInstance().getPopupSelection(popupReqParams.getPopupId(), popupReqParams.getLoginId()).getPDM(popupReqParams.getPDMId());
                NavigateRangeUtil.setDefaultRange((String)pdmObject.getModuleName(), (int)popupReqParams.getRange(), (Long)loginId);
            }
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(dataModelObject.toString());
            out.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

