/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.adsync.ADSyncUtil;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class AbstractGroupListener
extends AbstractListener {
    public AbstractGroupListener() {
        this.mgmtIds = new int[]{2003, 2023, 2021, 2001, 2022};
    }

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1016L);
        return categoryId;
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, boolean allmembers, NativeListener listener) throws Exception {
        this.doAction(domainName, loginId, distinguishedName, attributeList, listener);
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            this.setSyncEnabled();
            ArrayList scheduledDomains = SchedulerUtil.getSchedulerDomains((Long)reportFilterConfig.getScheduleId());
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(this.rb, scheduledDomains, CommonUtil.ADMIN_LOGIN_ID, containerList, this.getAttributeList(), this, dnDomainNameMap, true, excludeContainerHash, this.isSyncEnabled());
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            this.setSyncEnabled();
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String[] domainList = request.getParameterValues("domains");
            ArrayList selectedDomains = new ArrayList();
            Hashtable defaultNamingContextVsDomainName = DomainInfoCache.getInstance().getDefaultNamingContextVsDomainName();
            for (int i = 0; i < domainList.length; ++i) {
                selectedDomains.add(defaultNamingContextVsDomainName.get(domainList[i]));
            }
            inputParams.put("domain", ClientUtil.getString(domainList));
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            bean.set("inputParams", inputParams);
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomains});
            String domainName = (String)dnDomainNameMap.get(containerList.get(0));
            if (domainName != null) {
                Action action = new Action(this.rb, selectedDomains, this.loginId, containerList, attributeList, this, dnDomainNameMap, false, excludeContainerHash, this.isSyncEnabled());
                action.start();
            } else {
                System.out.println("Error - the selected OU has been manually moved in AD");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private AbstractListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Hashtable excludeChildOUHash = null;
        private ArrayList domainList = null;
        private Long loginId = null;
        private boolean flag;
        private boolean isSyncEnabled = false;
        private AdventNetResourceBundle rb = null;

        public Action(AdventNetResourceBundle rb, ArrayList domainList, Long loginId, ArrayList list, ArrayList attributeList, AbstractListener li, Hashtable map, boolean flag, Hashtable excludeChildOUHash, boolean isSyncEnabled) {
            this.domainList = domainList;
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.excludeChildOUHash = excludeChildOUHash;
            this.flag = flag;
            this.rb = rb;
            this.isSyncEnabled = isSyncEnabled;
        }

        @Override
        public void run() {
            AbstractGroupListener.this.guidList = new ArrayList();
            Hashtable tableProps = AbstractGroupListener.this.getQueueProps();
            String key = "";
            Hashtable<String, String> domainKey = new Hashtable<String, String>();
            if (this.isSyncEnabled) {
                this.attributeList = ADSyncUtil.getNonSyncAttributes((ArrayList)this.attributeList);
                for (int i = 0; i < this.domainList.size(); ++i) {
                    key = DomainHandler.doReportSync((String)((String)this.domainList.get(i)), (Long)CommonUtil.ADMIN_LOGIN_ID, (String[])new String[]{"user", "group", "computer", "contact", "groupMember", "primaryGroup"});
                    domainKey.put(key, (String)this.domainList.get(i));
                }
            }
            ArrayList objectIds = AbstractGroupListener.this.getObjIdList();
            AbstractGroupListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, AbstractGroupListener.this.getTableColumns());
            AbstractGroupListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(AbstractGroupListener.this.resultTableName);
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    AbstractGroupListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    AbstractGroupListener.this.doAction(AbstractGroupListener.this.domainName, this.loginId, dn, this.attributeList, this.flag, this.listener);
                    AbstractGroupListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    AbstractGroupListener.this.errorMessage = e.getMessage(this.rb);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AbstractGroupListener.this.errorMessage = e.getMessage();
                }
            }
            AbstractGroupListener.this.updatedCount = 0;
            AbstractGroupListener.this.totalCount = 0;
            if (!domainKey.isEmpty()) {
                String syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                while (AbstractGroupListener.this.continueAction && syncStatus.equalsIgnoreCase("false")) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                }
            }
            AbstractGroupListener.this.completedAction();
        }
    }
}

