/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.MetaDataException;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.GroupByColumn;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DBQueue;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.adsync.ADSyncUtil;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCUtil;
import com.adventnet.sym.adsm.common.server.multidc.ResultProcessor;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.queue.QueueUtil;
import com.adventnet.sym.adsm.common.server.reports.AdvReportsListener;
import com.adventnet.sym.adsm.common.server.reports.DBStringTransformerUtil;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.reports.ReportTask;
import com.adventnet.sym.adsm.common.server.reports.RowUtil;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.workflow.ScheduledRequest;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportMgmtHandler;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportThread;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractListener
implements NativeListener,
ReportTask {
    public AdventNetResourceBundle rb = null;
    private Locale locale = null;
    protected static Logger reportLogger = Logger.getLogger("ReportLogger");
    String className = AbstractListener.class.getName();
    Logger outLog = Logger.getLogger(this.className);
    protected Integer reportId = null;
    protected Long generationId = null;
    protected Long loginId = 1L;
    protected PrintWriter out = null;
    protected boolean isCompleted = true;
    protected boolean continueAction = true;
    protected long sleepMillis = 700L;
    protected ArrayList updateList = null;
    protected StatusUpdater statusController = null;
    protected DBQueue queue = null;
    protected Long queueRegID = null;
    protected Long resultRegID = null;
    protected ObjectClass objClass = null;
    public String onClickText = null;
    protected String baseTableName = null;
    protected String resultTableName = null;
    protected String domainName = null;
    protected boolean isExcludeChildOU = false;
    protected boolean isDashboardRefresh = false;
    protected HashMap<String, HashMap<String, String>> domainVsErrorData = null;
    public ArrayList guidList = null;
    protected String desc = "";
    protected boolean updateDetails = true;
    protected String noOfObjects = null;
    protected Hashtable addlResultIps = new Hashtable();
    protected int dcIndex = -1;
    protected ResultProcessor resultObject = null;
    protected boolean updateResult = true;
    protected Boolean isBitlocker = false;
    protected Hashtable ouSelectedDomains = new Hashtable();
    protected ArrayList toBeExecutedAttributeList = null;
    protected String title = "";
    protected Long categoryId = new Long(1003L);
    protected String tableKey = "OBJECT_GUID";
    protected String tempTableKey = "OBJECT_GUID";
    protected String attrKey = "objectGUID";
    protected String attrKey2 = "objectGUID";
    protected int[] mgmtIds = new int[]{1004, 1144, 1143, 1023, 1006, 1145, 1149};
    protected Long mgmtGenerationId = null;
    protected String mgmtResultTableName = null;
    protected int updatedCount = -1;
    protected int totalCount = 0;
    protected int exportCount = 0;
    protected String exportFileName = "";
    protected String exportFileLocation = "-";
    Long exportAuditId = 0L;
    protected String errorMessageKeys = null;
    protected String errorMessage = null;
    protected Hashtable errorList = null;
    protected boolean isSyncEnabled = false;
    protected String[] cks = null;
    protected boolean processMultiDCAttribs = false;
    protected boolean multiDC = false;
    protected ArrayList multiDCAttribProps = null;
    protected ArrayList viewAttributeList = null;
    protected boolean resultUseTempFlag = true;
    protected boolean licenseExceed = false;
    protected boolean isPhotoAttribPresent = false;
    protected HashMap<String, HashMap> guidVsPolicyStatusMap = new HashMap();

    public String getTableKey() {
        return this.tableKey;
    }

    public void setTableKey(String tableKey) {
        this.tableKey = tableKey;
    }

    protected abstract void checkAttributeList(ArrayList var1);

    protected abstract void doAction(String var1, Long var2, String var3, ArrayList var4, NativeListener var5) throws Exception;

    public AbstractListener() {
        this.updateList = new ArrayList();
        this.guidList = new ArrayList();
        this.errorList = new Hashtable();
        this.noOfObjects = LicenseMgr.getInstance().getLicenseProperty("ADReports", "NumberOfObjects");
        this.queue = DBQueue.getInstance();
        this.addlResultIps = new Hashtable();
    }

    public HashMap getPolicyStatusMap() {
        return this.guidVsPolicyStatusMap;
    }

    public void getDescription() {
        this.desc = this.rb.getString("client.reports.AbstractListener.report_generated_for_the_domains") + " ";
    }

    public StatusUpdater getStatusController() {
        return this.statusController;
    }

    public void setStatusController(StatusUpdater statusController) {
        this.statusController = statusController;
    }

    public boolean isMultiDC() {
        return this.multiDC;
    }

    public void setMultiDC(boolean multiDC) {
        this.multiDC = multiDC;
    }

    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.common.text.report_generated_for_the_domains"), args);
    }

    public ArrayList getTrusteesList() {
        return null;
    }

    public void checkBoxes(HttpServletRequest request, ReportBean bean) {
        HashMap props = (HashMap)bean.get("filter");
        for (int i = 0; this.cks != null && i < this.cks.length; ++i) {
            if (request.getParameter("filter(" + this.cks[i] + ")") != null) continue;
            props.put(this.cks[i], "false");
        }
    }

    public boolean isResultViewOutputFilterAvailable() {
        return false;
    }

    public boolean isPermissionColumnIncluded() {
        return false;
    }

    public ArrayList getReportInputParam(ArrayList<Hashtable<String, ArrayList<Hashtable<String, Object>>>> cvcInputList) {
        ArrayList<Object> list = new ArrayList();
        for (Hashtable<String, ArrayList<Hashtable<String, Object>>> hash : cvcInputList) {
            if (!hash.containsKey("trusteesList")) continue;
            list = hash.get("trusteesList");
        }
        return list;
    }

    public String getOutputFilterLabelText() {
        return "";
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    protected void updateOutList() {
        if (this.updateList.size() > 0) {
            reportLogger.log(Level.INFO, "REPORT UPDATE COUNTS : " + this.updateList.size());
            for (int i = 0; i < this.updateList.size() && i < 24; ++i) {
                this.out.write((String)this.updateList.get(i));
                this.out.flush();
            }
            this.updateList.clear();
        }
    }

    public void updateUI(Properties uiValues, String objectClass, String guid, String str) {
        if (this.statusController != null) {
            this.statusController.updateStatus(uiValues, objectClass, guid);
        }
        this.updateUI(str);
    }

    private void updateUI(String str) {
        ++this.updatedCount;
        if (this.out != null) {
            this.updateOutList();
            boolean flush = true;
            if (this.updatedCount <= 25 && str != null) {
                this.out.write("<script>if(this.load) updateUI(" + str + ")</script>");
            }
            if (this.updatedCount < 5000) {
                this.out.write("<script>updateCount(" + this.updatedCount + ")</script>");
            } else if (this.updatedCount % 100 == 0) {
                this.out.write("<script>updateCount(" + this.updatedCount + ")</script>");
            } else {
                flush = false;
            }
            if (flush) {
                this.out.flush();
            }
        } else if (str != null) {
            this.updateList.add("<script>updateUI(" + str + ")</script>");
        }
    }

    public ArrayList getGUIDListFromCsv(ArrayList<Hashtable> attributeList, ArrayList<Hashtable> userDetailsList, boolean isADGuid, String csvADColumn, String csvO365Column, ScheduledRequest robo) {
        return null;
    }

    public ArrayList getGUIDListFromModifyUserCsv(ArrayList<Hashtable> attributeList, ArrayList<Hashtable> userDetailsList, ArrayList<String> validSelectedValues) {
        return null;
    }

    public void init(Long loginId, Integer subCategoryId, String domainName) {
    }

    public void init(Row r) {
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        if (this.rb == null) {
            this.rb = ResourceBundleMgr.getInstance().getBundle();
        }
        this.title = (String)r.get("REPORT_NAME");
    }

    public void shutDownQueue() {
    }

    public void init(HttpServletRequest request, Row r) {
        reportLogger.log(Level.INFO, "REPORT QUEUE INITIALIZATION... ");
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
        this.setGenerationId(request);
    }

    public void setGenerationId(HttpServletRequest request) {
        HttpSession session = request.getSession();
        this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String generationIdStr = request.getParameter("generationId");
        reportLogger.log(Level.INFO, "Generation Id Str : " + generationIdStr);
        if (generationIdStr != null && !"null".equalsIgnoreCase(generationIdStr)) {
            try {
                this.generationId = Long.parseLong(generationIdStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.generationId = null;
                reportLogger.log(Level.INFO, "Generation Id set to null : " + generationIdStr);
            }
        } else {
            this.generationId = ReportHandler.getRecentlyGeneratedReports((Integer)this.reportId, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Recently Generated Id : " + this.generationId);
        }
    }

    public void init(Locale locale, Row r, Long loginId) {
        reportLogger.log(Level.INFO, "REPORT QUEUE INITIALIZATION... ");
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
        this.generationId = ReportHandler.getRecentlyGeneratedReports((Integer)this.reportId, (Long)loginId);
        reportLogger.log(Level.INFO, "Recently Generated Id : " + this.generationId);
    }

    public void setGenerationId(Long id) {
        this.generationId = id;
    }

    public void setInputParams(HttpServletRequest request, ReportBean bean) {
    }

    public void setDashboardInputParams(Long schedulerValueMapping, HttpServletRequest request, ReportBean bean) {
    }

    public void setWriter(PrintWriter o) {
        this.out = o;
    }

    public Long getGenerationId() {
        return this.generationId;
    }

    public Long getGenerationId(HttpServletRequest request) {
        HttpSession session = request.getSession();
        this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
        reportLogger.log(Level.INFO, "Newly Generated Id : " + this.generationId);
        return this.generationId;
    }

    public String getResultTableName() {
        return this.resultTableName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setSyncEnabled() {
        this.setSyncEnabled(false);
    }

    public void setSyncEnabled(boolean isSyncEnabled) {
        this.isSyncEnabled = isSyncEnabled;
    }

    public boolean isSyncEnabled() {
        return this.isSyncEnabled;
    }

    protected boolean isOUAuthorised(Properties prop, Integer reportId) {
        return true;
    }

    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties uiValues) {
        this.addRow(prop, guid, tableRowMap, relationalTableRowMap, uiValues, null);
    }

    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties uiValues, Hashtable stringRowMap) {
        this.addRow(prop, guid, tableRowMap, uiValues);
    }

    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Properties uiValues) {
        try {
            ArrayList multiValueTables = this.objClass.getMultiValueTables();
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(this.reportId);
            int baseTableIndex = tableNames.indexOf(this.baseTableName);
            if (baseTableIndex > 0) {
                tableNames.remove(baseTableIndex);
                tableNames.add(0, this.baseTableName);
            }
            for (int i = 0; i < tableNames.size(); ++i) {
                String tableName = (String)tableNames.get(i);
                ArrayList attributeList = new ArrayList();
                if (this.multiDC) {
                    attributeList = MultiDCUtil.getNonMultiDCAttribs((ArrayList)ReportAttributeHandler.getInstance().getAttributes(tableName, this.reportId));
                } else {
                    if (this.isSyncEnabled && ADSyncUtil.isSyncTable((String)tableName)) continue;
                    attributeList = ReportAttributeHandler.getInstance().getAttributes(tableName, this.reportId);
                }
                if (multiValueTables.contains(tableName)) {
                    this.createMultiValueRows(tableName, attributeList, tableRowMap, prop, uiValues, guid);
                    continue;
                }
                this.createRows(tableName, attributeList, tableRowMap, prop, uiValues, guid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createMultiValueRows(String tableName, ArrayList attributeList, Hashtable tableRowMap, Properties prop, Properties uiValues, String guid) throws Exception {
        ArrayList dbValues = new ArrayList();
        try {
            Properties p = (Properties)attributeList.get(0);
            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
            ArrayList values = (ArrayList)prop.get(ldapName);
            Integer attribId = (Integer)p.get("ATTRIB_ID");
            Integer relational_type = (Integer)p.get("RELATIONAL_TYPE");
            Boolean isCMA = false;
            if (this.objClass.getCustomAttribStartRange() != null) {
                isCMA = attribId > this.objClass.getCustomAttribStartRange() && attribId < this.objClass.getEndRange() && relational_type == 1;
            }
            prop.put("isCMA", isCMA);
            ArrayList<CharSequence> multipleTableRowList = new ArrayList<CharSequence>();
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
            List columns = tableDef.getColumnList();
            StringBuffer buf = new StringBuffer();
            for (ColumnDefinition colDef : columns) {
                String columnName = colDef.getColumnName();
                dbValues = this.getDBCustomizedValues(columnName, ldapName, prop);
                if (values != null && values.size() != 0) {
                    for (int k = 0; k < values.size(); ++k) {
                        StringBuilder sb = null;
                        if (multipleTableRowList.size() > k) {
                            sb = (StringBuilder)multipleTableRowList.get(k);
                        } else {
                            sb = new StringBuilder();
                            multipleTableRowList.add(k, sb);
                        }
                        if (!"".equals(sb.toString())) {
                            sb.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                        }
                        if (colDef.getUniqueValueGeneration() != null) {
                            String uniqueId = DBStringTransformerUtil.generateUVHValue((String)colDef.getUniqueValueGeneration().getGeneratorName(), (TableDefinition)tableDef);
                            if (uniqueId == null) continue;
                            sb.append(EscapeUtil.getEscapedQuotedString((Object)uniqueId));
                            continue;
                        }
                        if (colDef.isChildOf(this.baseTableName) || isCMA.booleanValue() && columnName.equalsIgnoreCase("OBJECT_GUID")) {
                            sb.append(EscapeUtil.getEscapedQuotedString((Object)guid));
                            continue;
                        }
                        if (dbValues != null && !dbValues.isEmpty()) {
                            String value = (String)dbValues.get(k);
                            sb.append(EscapeUtil.getEscapedQuotedString((Object)value));
                            buf.append(value);
                            if (k == dbValues.size() - 1) continue;
                            buf.append(",");
                            continue;
                        }
                        sb.append(EscapeUtil.getEscapedQuotedString((Object)""));
                    }
                } else {
                    Hashtable hash = new Hashtable();
                    hash.put(guid, new ArrayList());
                    tableRowMap.put(tableName, hash);
                }
                for (int i = 0; i < attributeList.size(); ++i) {
                    Properties attribProp = (Properties)attributeList.get(0);
                    Integer attributeId = (Integer)attribProp.get("ATTRIB_ID");
                    if (!this.viewAttributeList.contains(attributeId)) continue;
                    uiValues.put(attributeId, buf.toString());
                }
            }
            if (multipleTableRowList.size() > 0) {
                for (int i = 0; i < multipleTableRowList.size(); ++i) {
                    StringBuilder sb = (StringBuilder)multipleTableRowList.remove(i);
                    multipleTableRowList.add(i, sb.toString());
                }
                Hashtable<String, ArrayList<CharSequence>> hash = new Hashtable<String, ArrayList<CharSequence>>();
                hash.put(guid, multipleTableRowList);
                tableRowMap.put(tableName, hash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createRows(String tableName, ArrayList attributeList, Hashtable tableRowMap, Properties prop, Properties uiValues, String guid) throws Exception {
        StringBuilder tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)guid));
        TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
        for (int j = 0; j < attributeList.size(); ++j) {
            Properties p = (Properties)attributeList.get(j);
            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
            String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
            Integer attributeId = (Integer)p.get("ATTRIB_ID");
            if (this.toBeExecutedAttributeList != null && !this.toBeExecutedAttributeList.contains(ldapName) || this.tableKey.equalsIgnoreCase(columnName)) continue;
            ArrayList values = (ArrayList)prop.get(ldapName);
            values = this.getDBCustomizedValues(columnName, ldapName, prop);
            ColumnDefinition colDef = tableDef.getColumnDefinitionByName(columnName);
            if (tableName.endsWith("CustomDetails")) {
                values = this.getCustomFieldValues(values, colDef, this.rb);
            }
            if (colDef.getDataType().equals("BOOLEAN")) {
                values = this.getBooleanFieldValues(values, this.rb);
            }
            String value = null;
            value = values != null && !values.isEmpty() ? values.get(0).toString() : "-";
            tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)value));
            if (!this.viewAttributeList.contains(attributeId)) continue;
            uiValues.put(attributeId, value);
        }
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put(guid, tableString.toString());
        tableRowMap.put(tableName, hash);
    }

    protected String getGuid(Properties prop) {
        ArrayList guids = (ArrayList)prop.get(this.attrKey);
        if (guids == null) {
            guids = (ArrayList)prop.get(this.attrKey2);
        }
        if (guids == null || guids.isEmpty()) {
            return null;
        }
        String guid = (String)guids.get(0);
        return guid;
    }

    protected Properties getMultiDCProps(Properties prop) {
        ArrayList l = ReportAttributesUtil.getAttributeListFromProps((ArrayList)this.multiDCAttribProps);
        l.add("objectSID");
        l.add("objectGUID");
        Properties ret = new Properties();
        for (int i = 0; i < l.size(); ++i) {
            String ldap = (String)l.get(i);
            if (prop.get(ldap) == null) continue;
            ret.put(ldap, prop.get(ldap));
        }
        return ret;
    }

    public void addRow(Properties prop) {
        if (this.noOfObjects == null || this.reportId == null) {
            this.continueAction = false;
            System.out.println("Number Of Objects exceeded beyond the License Limit");
            return;
        }
        if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
            try {
                int licensedCount = Integer.parseInt(this.noOfObjects);
                if (this.reportId < 100 && this.totalCount >= licensedCount || this.totalCount >= licensedCount && licensedCount == 100) {
                    this.postNativeData();
                    this.continueAction = false;
                    this.licenseExceed = true;
                    System.out.println("Number Of Objects exceeded beyond the License Limit");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String guid = this.getGuid(prop);
            if (guid == null) {
                reportLogger.log(Level.INFO, "SID is NULL for the Properties : " + prop);
                return;
            }
            if (!this.isOUAuthorised(prop, this.reportId)) {
                return;
            }
            ++this.totalCount;
            Hashtable tableRowMap = new Hashtable();
            Properties uiValues = new Properties();
            if (this.resultObject != null) {
                this.resultObject.addRow(this.domainName, this.dcIndex, this.getMultiDCProps(prop));
            }
            if (this.updatedCount < 1) {
                this.viewAttributeList = ReportAttributeHandler.getInstance().getViewAttributesList(this.reportId, this.loginId);
            }
            this.addRow(prop, guid, tableRowMap, uiValues);
            QueueHandler.getInstance().getQueue(this.objClass.getId()).updateData(this.queueRegID, tableRowMap);
            if (this.updateResult) {
                ResultDataHandler.getInstance().getProcessor().updateData(this.resultRegID, ResultDataUtil.getDBString((String)this.resultTableName, (Long)this.generationId, (String)guid, (Hashtable)this.addlResultIps));
            } else if (!this.guidList.contains(guid)) {
                this.guidList.add(guid);
            }
            if (this.updatedCount <= 25) {
                StringBuffer b = new StringBuffer();
                b.append("[");
                for (int i = 0; i < this.viewAttributeList.size(); ++i) {
                    Integer attributeId = (Integer)this.viewAttributeList.get(i);
                    b.append("'");
                    String s = (String)uiValues.get(attributeId);
                    if (s == null || s.trim().equalsIgnoreCase("")) {
                        b.append("-");
                    } else {
                        s = ListenerUtil.getDynamicUpdateValues(attributeId, s);
                        b.append(ClientUtil.htmlEscape(this.rb.getString(s)));
                    }
                    b.append("'");
                    if (i == this.viewAttributeList.size() - 1) continue;
                    b.append(",");
                }
                b.append("]");
                this.updateUI(uiValues, null, guid, b.toString());
            } else {
                this.updateUI(uiValues, null, guid, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getDescription(String[] domainList, Hashtable dnDomainNameMap) {
        String description = "";
        if (domainList == null) {
            return description;
        }
        for (int i = 0; i < domainList.length; ++i) {
            String val;
            if (i != 0) {
                this.desc = this.desc + ", ";
            }
            if ((val = domainList[i]).equalsIgnoreCase("")) continue;
            this.desc = this.desc + dnDomainNameMap.get(val);
        }
        return this.desc;
    }

    public void start(AdvReportsListener advReportsListener, Long genId, DataObject cvcDO, StatusUpdater statusupdater, Long loginId) {
        try {
            this.setStatusController(statusupdater);
            this.generationId = genId;
            this.isCompleted = false;
            ArrayList attributeList = this.getAttributeList();
            reportLogger.log(Level.INFO, "Manual report generation for the reportID : " + this.reportId);
            this.start(advReportsListener, attributeList, cvcDO, loginId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void start(Integer reportId, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.licenseExceed = false;
            this.continueAction = true;
            this.statusController.setIsCompleted(false);
            reportLogger.log(Level.INFO, "Manual report generation for the reportID : " + reportId);
            String[] domainList = request.getParameterValues("domains");
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)reportId, (String)this.desc, (Long)this.loginId);
            ListenerUtil.fillInputValues(this, request, bean);
            ArrayList attributeList = this.getAttributeList();
            this.desc = "";
            this.start(attributeList, request, bean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getAttributeList() {
        return this.getAttributeList(this.reportId);
    }

    public ArrayList getAttributeList(Integer reportId) {
        ArrayList<Object> attributeList = new ArrayList<Object>();
        ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(reportId);
        for (int i = 0; i < tableNames.size(); ++i) {
            ArrayList l = ReportAttributeHandler.getInstance().getAttributes((String)tableNames.get(i), reportId);
            for (int j = 0; j < l.size(); ++j) {
                Properties p = (Properties)l.get(j);
                if (!attributeList.contains(p.get("ATTRIB_LDAP_NAME"))) {
                    attributeList.add(p.get("ATTRIB_LDAP_NAME"));
                }
                if (!p.get("ATTRIB_COLUMN_NAME").toString().equalsIgnoreCase("PHOTO_FILE")) continue;
                this.isPhotoAttribPresent = true;
            }
        }
        if (!attributeList.contains("objectSID")) {
            attributeList.add("objectSID");
        }
        if (!attributeList.contains("objectGUID")) {
            attributeList.add("objectGUID");
        }
        return attributeList;
    }

    public void updateQueue() {
    }

    public void updateADObjectsCount() {
    }

    public void updateErrorStatus(Hashtable errors) {
        if (this.statusController != null) {
            this.statusController.updateErrorStatus(errors);
        }
    }

    public void completedAction() {
        reportLogger.log(Level.INFO, "Receiving Completed Action " + this.reportId);
        this.updateQueue();
        reportLogger.log(Level.INFO, "Updating Completed Action " + this.reportId);
        this.endQueue();
        ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        this.isCompleted = true;
        this.queue.deRegister(this.generationId);
        if (this.statusController != null) {
            this.statusController.setIsCompleted(this.isCompleted);
        }
        this.totalCount = 0;
        this.updatedCount = 0;
        this.updateADObjectsCount();
    }

    public void endQueue() {
        this.postNativeData();
        this.deRegister();
    }

    private void postNativeData() {
        if (!this.licenseExceed) {
            QueueHandler.getInstance().postNativeData(this.queueRegID);
            ResultDataHandler.getInstance().getProcessor().postNativeData(this.resultRegID, this.resultUseTempFlag);
        }
    }

    private void deRegister() {
        QueueHandler.getInstance().deRegister(this.queueRegID);
        ResultDataHandler.getInstance().getProcessor().deRegister(this.resultRegID);
    }

    public void endTableUpdateQueue() {
        QueueHandler.getInstance().postNativeData(this.queueRegID);
        QueueHandler.getInstance().deRegister(this.queueRegID);
        this.queueRegID = null;
    }

    public void stop(HttpServletRequest request) {
        reportLogger.log(Level.INFO, "Receiving Stop Action");
        this.continueAction = false;
        while (!this.isCompleted) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isCompleted() {
        return !this.continueAction;
    }

    public boolean isExcludeChildOU() {
        return this.isExcludeChildOU;
    }

    protected void setClientButtons(boolean flag) {
        if (this.out != null) {
            this.out.write("<script> setClientButtons(" + flag + "); </script>");
            this.out.flush();
        }
    }

    public void controlUI(PrintWriter o) {
        if (this.isCompleted) {
            return;
        }
        this.out = o;
        boolean actionSet = false;
        while (!this.isCompleted && this.continueAction) {
            try {
                if (this.continueAction && !actionSet) {
                    this.setClientButtons(true);
                    actionSet = true;
                }
                Thread.sleep(this.sleepMillis);
                if (this.sleepMillis != 700L) continue;
                this.sleepMillis = 200L;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.out.write(MessageFormat.format(this.rb.getString("admp.reports.common.statmsg.error_occurred_message"), e.getMessage()));
            }
        }
        boolean check = true;
        try {
            if (this.out == null || this.out.checkError() || !this.isCompleted) {
                check = false;
            }
        }
        catch (Exception e) {
            check = false;
            e.printStackTrace();
        }
        if (check) {
            try {
                this.setClientButtons(false);
                this.updateOutList();
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.out = null;
    }

    public Criteria getReportFilterCriteria(Criteria crit, ReportReqParams reqParams, ArrayList tableNames) {
        return crit;
    }

    public Criteria getReportResultFilterCriteria(HttpServletRequest request, ReportReqParams reqParams, Criteria crit) {
        return crit;
    }

    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit, String inputId) {
        return crit;
    }

    public Criteria getScheduledReportFilterCriteria(Criteria crit, ReportFilterConfig reportFilterConfig, ArrayList tableNames) {
        return crit;
    }

    public Criteria getScheduledReportFilterCriteria(Criteria crit, ReportFilterConfig reportFilterConfig, ArrayList tableNames, String inputId) {
        return crit;
    }

    public Criteria getMultiValueCrit(HttpServletRequest request, String resultTableName, DynaValidatorForm bean, ReportReqParams reqParams) {
        return null;
    }

    protected String getReportDomains(String[] domainList, Hashtable dnDomainNameMap) {
        String reportDomains = "";
        if (domainList == null) {
            return reportDomains;
        }
        for (int i = 0; i < domainList.length; ++i) {
            String val;
            if (i != 0) {
                reportDomains = reportDomains + ", ";
            }
            if ((val = domainList[i]).equalsIgnoreCase("")) continue;
            reportDomains = reportDomains + dnDomainNameMap.get(val);
        }
        return reportDomains;
    }

    public Long generateReportForAPI(Long loginId, ADMPAuthObject authObject, Integer reportId, String domain, Hashtable<String, String> requestParams) {
        try {
            this.loginId = loginId;
            this.reportId = reportId;
            String domainName = DomainUtil.getDomainName((String)domain);
            Hashtable domains = authObject.getDomainAndOUs();
            Hashtable dnDomainNameMap = (Hashtable)domains.get("dnDomainNameMap");
            ArrayList attributeList = this.getAttributeList();
            this.checkAttributeList(attributeList);
            ArrayList<String> containerList = new ArrayList<String>();
            ArrayList ous = ClientAuthorizationUtil.getAuthorizedOUList(authObject, domainName);
            if (ous != null && ous.size() > 0) {
                containerList.addAll(ous);
            } else {
                containerList.add(domain);
            }
            ArrayList objectIds = this.getObjIdList();
            this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, this.getTableColumns());
            this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(this.resultTableName);
            ReportThread action = new ReportThread(this.rb, loginId, containerList, attributeList, this, dnDomainNameMap, null);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.generationId;
    }

    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomains});
            ArrayList objectIds = this.getObjIdList();
            this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, this.getTableColumns());
            this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(this.resultTableName);
            if (this.isPhotoAttribPresent) {
                String productHome = System.getProperty("product.home");
                if (productHome == null) {
                    productHome = System.getProperty("server.home");
                }
                for (int index = 0; index < domainList.length; ++index) {
                    String domainDN = domainList[index];
                    String domainName = (String)DomainInfoCache.getInstance().getDefaultNamingContextVsDomainName().get(domainDN);
                    String path = "webapps" + File.separator + "adsm" + File.separator + "temp" + File.separator + "userPhotos" + File.separator + "thumbnailPhoto" + File.separator + domainName;
                    File file = new File(productHome + File.separator + path);
                    file.mkdirs();
                }
            }
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            ReportThread action = new ReportThread(this.rb, this.loginId, containerList, attributeList, this, dnDomainNameMap, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Hashtable constructExcludeContainerHash(ArrayList containerList, Hashtable domainVsExcludeChildOU, Hashtable excludedOUHash, Hashtable dnDomainNameMap) {
        Hashtable<String, Boolean> excludeContainerHash = new Hashtable<String, Boolean>();
        for (int i = 0; i < containerList.size(); ++i) {
            String dn = (String)containerList.get(i);
            String domainName = (String)dnDomainNameMap.get(dn);
            Boolean isExcludeChildOU = Boolean.FALSE;
            if (domainVsExcludeChildOU != null && domainName != null && domainVsExcludeChildOU.containsKey(domainName)) {
                isExcludeChildOU = (Boolean)domainVsExcludeChildOU.get(domainName);
            }
            if (isExcludeChildOU.booleanValue()) {
                excludeContainerHash.put(dn, isExcludeChildOU);
                continue;
            }
            Boolean isParentOfExcludedOU = Boolean.FALSE;
            ArrayList excludedOUList = new ArrayList();
            if (excludedOUHash != null && domainName != null && excludedOUHash.containsKey(domainName)) {
                excludedOUList = (ArrayList)excludedOUHash.get(domainName);
            }
            for (int counter = 0; counter < excludedOUList.size(); ++counter) {
                String excludedOUDN = (String)excludedOUList.get(counter);
                if (!excludedOUDN.endsWith(dn)) continue;
                isParentOfExcludedOU = Boolean.TRUE;
                break;
            }
            excludeContainerHash.put(dn, isParentOfExcludedOU);
        }
        return excludeContainerHash;
    }

    public void deleteResult(String tableName, long time) {
        try {
            SelectQueryImpl sq = new SelectQueryImpl(new Table(tableName));
            Criteria crit = new Criteria(new Column(tableName, "LAST_LOGON_TIME"), (Object)time, 5);
            crit = crit.and(new Criteria(new Column(this.resultTableName, "REPORT_GENERATION_ID"), (Object)this.generationId, 0));
            sq.setCriteria(crit);
            Join join = new Join(new Table(tableName), new Table(this.resultTableName), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            sq.addJoin(join);
            sq.addSelectColumn(new Column(tableName, "OBJECT_GUID"));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            ArrayList<Object> l = new ArrayList<Object>();
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                l.add(r.get("OBJECT_GUID"));
            }
            if (l.size() > 0) {
                String[] guids = new String[l.size()];
                for (int i = 0; i < l.size(); ++i) {
                    guids[i] = (String)l.get(i);
                }
                Criteria c = new Criteria(new Column(this.resultTableName, "OBJECT_GUID"), (Object)guids, 8);
                c = c.and(new Criteria(new Column(this.resultTableName, "REPORT_GENERATION_ID"), (Object)this.generationId, 0));
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ArrayList getObjIdList() {
        this.objClass = DirectoryObjectAPI.getInstance().getObjectClassFromBaseTableName(this.baseTableName);
        ArrayList<Integer> objectIds = new ArrayList<Integer>();
        objectIds.add(this.objClass.getId());
        return objectIds;
    }

    public void setRb(AdventNetResourceBundle rb) {
        this.rb = rb;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            ArrayList objectIds = this.getObjIdList();
            this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, this.getTableColumns());
            this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(this.resultTableName);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            ReportThread action = new ReportThread(this.rb, 1L, containerList, this.getAttributeList(), this, dnDomainNameMap, excludeContainerHash);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Integer getResultCount() {
        if (this.errorMessage != null) {
            return new Integer(-1);
        }
        return ReportHandler.getSIDReportCount((Long)this.generationId, (String)this.resultTableName);
    }

    public void mgmtAction(HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String hostId = request.getRemoteHost();
        try {
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.continueAction = true;
            DataObject obj = ReportHandler.getReportDetails((Integer)((Integer)bean.get("mgmtReportId")));
            Row r = obj.getFirstRow("ADSMReports");
            this.mgmtResultTableName = (String)r.get("RESULT_TABLE_NAME");
            ArrayList list = null;
            Properties p = new Properties();
            p.put("TABLE_NAME", this.mgmtResultTableName);
            p.put("ATTRIB_COLUMN_NAME", "OBJECT_GUID");
            ArrayList attributeList = ReportAttributeHandler.getInstance().getModifiedColumns((Integer)bean.get("mgmtReportId"));
            Long menuId = (Long)bean.get("menuId");
            ArrayList objectIds = this.getObjIdList();
            this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, this.getTableColumns());
            this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(this.mgmtResultTableName);
            if (menuId < 22L) {
                Properties sidProps = new Properties();
                sidProps.put("ATTRIB_ID", (Object)this.mgmtIds[1]);
                sidProps.put("ATTRIB_COLUMN_NAME", "SID_STRING");
                sidProps.put("TABLE_NAME", this.baseTableName);
                sidProps.put("RELATIONAL_TYPE", new Integer(0));
                attributeList.add(sidProps);
            }
            Criteria crit = null;
            Criteria resultTableCriteria = null;
            Criteria columnSearchCriteria = null;
            Hashtable multipleValuesSids = new Hashtable();
            list = ReportResultUtil.getRows(this, this.mgmtGenerationId, this.mgmtResultTableName, attributeList, p, true, -1, -1, multipleValuesSids, resultTableCriteria, columnSearchCriteria, this.tableKey, new ArrayList<String>());
            ArrayList tableNames = new ArrayList();
            Integer count = ReportHandler.getSIDReportCount((Long)this.mgmtGenerationId, tableNames, crit, (String)this.mgmtResultTableName);
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("multipleValuesSids", multipleValuesSids);
            request.setAttribute("result", (Object)list);
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ModifyAction action = new ModifyAction(hostId, authObject, bean, list, this.getReportAttributeList(), this.mgmtIds);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getReportAttributeList() {
        ArrayList<String> attributeList = new ArrayList<String>();
        ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(this.reportId);
        for (int i = 0; i < tableNames.size(); ++i) {
            ArrayList l = ReportAttributeHandler.getInstance().getAttributes((String)tableNames.get(i), this.reportId);
            for (int j = 0; j < l.size(); ++j) {
                Properties p = (Properties)l.get(j);
                String ldap = (String)p.get("ATTRIB_LDAP_NAME");
                if (attributeList.contains(ldap)) continue;
                attributeList.add(ldap);
            }
        }
        return attributeList;
    }

    public void removeInputParams(ReportBean bean) {
    }

    public ArrayList getRows(ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria reportFilterCriteria, Criteria columnSearchCriteria, ArrayList reportFilterTableNames) {
        return ReportResultUtil.getRows(this, this.generationId, this.resultTableName, attributeList, attributeProp, ascending, startIndex, numOfObjects, multipleValuesSids, reportFilterCriteria, columnSearchCriteria, this.tableKey, reportFilterTableNames);
    }

    public ArrayList getRows(ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria reportFilterCriteria, Criteria columnSearchCriteria, ArrayList reportFilterTableNames, boolean isScheduledReport) {
        return ReportResultUtil.getRows(this, this.generationId, this.resultTableName, attributeList, attributeProp, ascending, startIndex, numOfObjects, multipleValuesSids, reportFilterCriteria, columnSearchCriteria, this.tableKey, reportFilterTableNames, isScheduledReport);
    }

    public ArrayList getRows(ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria reportFilterCriteria, Criteria columnSearchCriteria, ArrayList reportFilterTableNames, boolean isScheduledReport, boolean isDistinct) {
        return ReportResultUtil.getRows(this, this.generationId, this.resultTableName, attributeList, attributeProp, ascending, startIndex, numOfObjects, multipleValuesSids, reportFilterCriteria, columnSearchCriteria, this.tableKey, reportFilterTableNames, null, null, isScheduledReport, isDistinct);
    }

    public void setReportRows(HttpServletRequest request, ReportBean bean, Long generationId, ArrayList attributelist, ReportReqParams reqParams) {
        ReportResultUtil.setReportRows(request, bean, generationId, attributelist, reqParams);
    }

    public void setReportRows(HttpServletRequest request, ReportBean bean, Long generationId, ArrayList attributelist, String action) {
    }

    public ArrayList getACERows(ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria crit) {
        return ReportResultUtil.getACERows(this, this.generationId, this.resultTableName, attributeList, attributeProp, ascending, startIndex, numOfObjects, multipleValuesSids, crit, this.tableKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport(int reportId, Long loginId, Long generationId, ReportTask listener, boolean zip, Long schedule_id, String storagePath, Integer count, ReportFilterConfig rfConfig) {
        ArrayList<Long> generatioIdList = (ArrayList<Long>)ResultDataUtil.resultTableUsageHash.get(listener.getResultTableName());
        if (generatioIdList == null) {
            generatioIdList = new ArrayList<Long>();
            ResultDataUtil.resultTableUsageHash.put(listener.getResultTableName(), generatioIdList);
        }
        generatioIdList.add(generationId);
        try {
            ReportExportUtil.exportReport(reportId, loginId, generationId, listener, zip, schedule_id, storagePath, count, rfConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            generatioIdList.remove(generationId);
        }
    }

    public void exportReport(Row reportDetails, String reportType, ArrayList attributelist, Map inputParams, HttpServletRequest request, HttpServletResponse response, String reportList, AbstractListener listener, ArrayList trusteesList, ReportReqParams reqParams) {
        ReportExportUtil.exportReport(reportDetails, reportType, attributelist, inputParams, request, response, reportList, listener, trusteesList, reqParams);
    }

    public void exportReport(Row reportDetails, String reportType, ArrayList attributelist, Map inputParams, HttpServletRequest request, HttpServletResponse response, String reportList, AbstractListener listener, ReportReqParams reqParams) {
        ReportExportUtil.exportReport(reportDetails, reportType, attributelist, inputParams, request, response, reportList, listener, reqParams);
    }

    public ArrayList getContainerList(HttpServletRequest request, ReportBean bean) {
        return ListenerUtil.getContainerList(request, bean, this.ouSelectedDomains);
    }

    public ArrayList getContainerList(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU) {
        return ListenerUtil.getContainerList(containerList, dnDomainNameMap, excludedOUList, domainVsExcludeChildOU);
    }

    public Hashtable getQueueProps() {
        return ListenerUtil.getQueueProps(this);
    }

    public ArrayList getDBCustomizedValues(String columnName, String ldapName, Properties prop) {
        return ListenerUtil.getDBCustomizedValues(this.domainName, columnName, ldapName, prop, this.rb);
    }

    public ArrayList getCustomFieldValues(ArrayList values, ColumnDefinition colDef, AdventNetResourceBundle rb) {
        return RowUtil.getCustomFieldValues((ArrayList)values, (ColumnDefinition)colDef, (AdventNetResourceBundle)rb);
    }

    public ArrayList getBooleanFieldValues(ArrayList values, AdventNetResourceBundle rb) {
        return RowUtil.getBooleanFieldValues((ArrayList)values, (AdventNetResourceBundle)rb);
    }

    public SelectQuery getCountSQ(Criteria crit, ArrayList reportFilterTableNames) {
        return ReportResultUtil.getCountSQ(crit, this.generationId, this.resultTableName, reportFilterTableNames, this.tableKey);
    }

    public void getCustomizedSingleValues(ArrayList attributeList, ArrayList resultList, Long loginId, AdventNetResourceBundle rb) {
        ListenerUtil.getCustomizedSingleValues(attributeList, resultList, loginId, rb);
    }

    public void initializeActionVariables() {
        this.errorMessage = null;
        this.guidList = new ArrayList();
        this.updatedCount = 0;
    }

    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
    }

    public void updateAttributeList(ReportBean bean, ArrayList attributeList) {
    }

    public void setErrorMessage(String error) {
        this.errorMessage = error;
    }

    public void setErrorMessageKeys(String error) {
        this.errorMessageKeys = error;
    }

    public String getErrorMessageKeys() {
        return this.errorMessageKeys;
    }

    public void updateNativeErrorMessage(ReportReqParams reqParams) {
        JSONArray rvcFiltersArray = reqParams.getRvcFilters();
        try {
            if (rvcFiltersArray != null && rvcFiltersArray.length() > 0) {
                String[] inputFiltervalues = new String[rvcFiltersArray.length()];
                ArrayList<String> errorMessageList = new ArrayList<String>();
                this.errorMessage = null;
                for (int index = 0; index < rvcFiltersArray.length(); ++index) {
                    JSONObject rvcFilterObject = (JSONObject)rvcFiltersArray.get(index);
                    Iterator iterator = rvcFilterObject.keys();
                    while (iterator.hasNext()) {
                        String inputId = (String)iterator.next();
                        Hashtable errorValues = (Hashtable)this.errorList.get(inputId);
                        if (errorValues == null || errorMessageList.contains((String)errorValues.get("ERROR_MESSAGE"))) continue;
                        this.errorMessage = this.errorMessage == null ? (String)errorValues.get("ERROR_MESSAGE") : this.errorMessage + "," + (String)errorValues.get("ERROR_MESSAGE");
                        errorMessageList.add((String)errorValues.get("ERROR_MESSAGE"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDomainName(String str) {
        this.domainName = str;
    }

    public void setIsExcludeChildOU(Boolean isExcludeChildOU) {
        this.isExcludeChildOU = isExcludeChildOU;
    }

    public void setIsDashboardRefresh(Boolean isDashboardRefresh) {
        this.isDashboardRefresh = isDashboardRefresh;
        if (isDashboardRefresh.booleanValue()) {
            this.domainVsErrorData = new HashMap();
        }
    }

    public HashMap<String, HashMap<String, String>> getDashboardErrors() {
        return this.domainVsErrorData;
    }

    public void setNativeError(String domainName, Hashtable errorHash) {
        if (this.isDashboardRefresh && errorHash != null) {
            HashMap<String, String> errorData = new HashMap<String, String>();
            errorData.put("ERROR_CODE", (String)errorHash.get("ERROR_CODE"));
            errorData.put("ERROR_MESSAGE", (String)errorHash.get("ERROR_MESSAGE"));
            this.domainVsErrorData.put(domainName, errorData);
        }
    }

    public void setNativeError(String domainName, String dCName, Hashtable errorHash) {
        try {
            if (this.isDashboardRefresh && errorHash != null) {
                HashMap<String, String> errorData;
                JSONObject dCError = new JSONObject();
                dCError.put("DC_NAME", (Object)dCName);
                dCError.put("DOMAIN_NAME", (Object)domainName);
                dCError.put("ERROR_CODE", errorHash.get("ERROR_CODE"));
                dCError.put("ERROR_MESSAGE", errorHash.get("ERROR_MESSAGE"));
                JSONArray dCErrorArray = null;
                if (this.domainVsErrorData.get(domainName) != null && (errorData = this.domainVsErrorData.get(domainName)).get("MULTI_DC_ERROR_JSON_ARRAY") != null) {
                    dCErrorArray = new JSONArray(errorData.get("MULTI_DC_ERROR_JSON_ARRAY"));
                }
                if (dCErrorArray == null) {
                    dCErrorArray = new JSONArray();
                }
                dCErrorArray.put((Object)dCError);
                HashMap<String, String> multiDCError = new HashMap<String, String>();
                multiDCError.put("MULTI_DC_ERROR_JSON_ARRAY", dCErrorArray.toString());
                this.domainVsErrorData.put(domainName, multiDCError);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Hashtable getProperties() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("baseTableName", this.baseTableName);
        hash.put("resultTableName", this.resultTableName);
        hash.put("title", this.title);
        if (this.mgmtResultTableName != null) {
            hash.put("mgmtResultTableName", this.mgmtResultTableName);
        }
        hash.put("tableKey", this.tableKey);
        return hash;
    }

    public String getSchedulerDomains(ArrayList containerList, Hashtable dnDomainNameMap) {
        return ListenerUtil.getSchedulerDomains(containerList, dnDomainNameMap);
    }

    protected Hashtable getTableColumns() {
        Hashtable hash = new Hashtable();
        ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(this.reportId);
        int baseTableIndex = tableNames.indexOf(this.baseTableName);
        if (baseTableIndex > 0) {
            tableNames.remove(baseTableIndex);
            tableNames.add(0, this.baseTableName);
        }
        for (int i = 0; i < tableNames.size(); ++i) {
            String tableName = (String)tableNames.get(i);
            ArrayList attributeList = new ArrayList();
            if (this.multiDC) {
                attributeList = MultiDCUtil.getNonMultiDCAttribs((ArrayList)ReportAttributeHandler.getInstance().getAttributes(tableName, this.reportId));
            } else {
                if (this.isSyncEnabled && ADSyncUtil.isSyncTable((String)tableName)) continue;
                attributeList = ReportAttributeHandler.getInstance().getAttributes(tableName, this.reportId);
            }
            ArrayList<String> columns = new ArrayList<String>();
            for (int j = 0; j < attributeList.size(); ++j) {
                Properties p = (Properties)attributeList.get(j);
                String columnName = p.getProperty("ATTRIB_COLUMN_NAME");
                if (columnName.equalsIgnoreCase("password")) continue;
                columns.add(columnName);
            }
            columns.remove(this.tableKey);
            columns.add(0, this.tableKey);
            hash.put(tableName, columns);
        }
        return hash;
    }

    protected ArrayList getMultiDCAttributes() {
        this.multiDCAttribProps = MultiDCUtil.getMultiDCAttributes((Integer)this.reportId);
        if (this.multiDCAttribProps.size() > 0) {
            this.processMultiDCAttribs = true;
        }
        return this.multiDCAttribProps;
    }

    protected ArrayList getBitLockerAttributes() {
        ArrayList<String> attribute = new ArrayList<String>();
        attribute.add("objectGUID");
        attribute.add("objectSID");
        attribute.add("bitlockerstatus");
        return attribute;
    }

    protected void deriveData(String domainName, String attrbName, String tableName) {
        ArrayList list = new ArrayList();
        RelationalAPI relationalAPI = RelationalAPI.getInstance();
        Object connection = null;
        try {
            Criteria crit;
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
            ColumnDefinition colDef = tableDef.getColumnDefinitionByName(attrbName);
            String dataType = colDef.getDataType();
            String selctAttrbCol_defaultValue = "-";
            if (!dataType.equals("CHAR")) {
                try {
                    selctAttrbCol_defaultValue = MetaDataUtil.convert((String)"0", (String)dataType).toString();
                }
                catch (MetaDataException me) {
                    if (dataType.equals("INTEGER")) {
                        selctAttrbCol_defaultValue = "0";
                    } else if (dataType.equals("BIGINT")) {
                        selctAttrbCol_defaultValue = "0";
                    } else if (dataType.equals("BOOLEAN")) {
                        selctAttrbCol_defaultValue = "false";
                    }
                    me.printStackTrace();
                }
            }
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)this.baseTableName));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)attrbName));
            query.addSelectColumn(Column.getColumn((String)this.baseTableName, (String)"DOMAIN_NAME"));
            query.addJoin(new Join(Table.getTable((String)this.baseTableName), Table.getTable((String)this.resultTableName), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2));
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)attrbName), (Object)selctAttrbCol_defaultValue, 1);
            criteria = criteria.and(new Criteria(Column.getColumn((String)this.baseTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            criteria = criteria.and(new Criteria(Column.getColumn((String)this.resultTableName, (String)"REPORT_GENERATION_ID"), (Object)this.generationId, 0));
            query.setCriteria(criteria);
            ArrayList<GroupByColumn> gbcList = new ArrayList<GroupByColumn>();
            gbcList.add(new GroupByColumn(new Column(tableName, attrbName), true));
            gbcList.add(new GroupByColumn(new Column(this.baseTableName, "DOMAIN_NAME"), true));
            GroupByClause gbcl = new GroupByClause(gbcList, new Criteria(Column.getColumn((String)tableName, (String)attrbName).count(), (Object)1, 5));
            query.setGroupByClause(gbcl);
            if (!tableName.equalsIgnoreCase(this.baseTableName)) {
                query.addJoin(new Join(Table.getTable((String)this.baseTableName), Table.getTable((String)tableName), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2));
            }
            ArrayList result = AbstractListener.getResult((SelectQuery)query, attrbName);
            ArrayList<Object> subList = new ArrayList<Object>();
            if (result.size() > 0) {
                SelectQueryImpl subquery = new SelectQueryImpl(new Table(tableName));
                subquery.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_GUID"));
                subquery.addSelectColumn(Column.getColumn((String)tableName, (String)attrbName));
                subquery.addSelectColumn(Column.getColumn((String)this.resultTableName, (String)"REPORT_GENERATION_ID"));
                Join subQueryjoin = new Join(new Table(tableName), new Table(this.resultTableName), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
                subquery.addJoin(subQueryjoin);
                Object[] attrbVals = new Object[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    attrbVals[i] = result.get(i);
                }
                Criteria crit2 = new Criteria(Column.getColumn((String)tableName, (String)attrbName), (Object)attrbVals, 8);
                crit2 = crit2.and(new Criteria(Column.getColumn((String)this.resultTableName, (String)"REPORT_GENERATION_ID"), (Object)this.generationId, 0));
                subquery.setCriteria(crit2);
                DataObject subDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)subquery);
                Iterator iter = subDataObj.getRows(tableName);
                while (iter.hasNext()) {
                    Row r = (Row)iter.next();
                    subList.add(r.get("OBJECT_GUID"));
                }
            }
            if (subList.size() > 0) {
                crit = new Criteria(Column.getColumn((String)this.resultTableName, (String)"REPORT_GENERATION_ID"), (Object)this.generationId, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
                ReportHandler.addSIDReportResult((Long)this.generationId, (String)this.resultTableName, subList);
            } else {
                crit = new Criteria(Column.getColumn((String)this.resultTableName, (String)"REPORT_GENERATION_ID"), (Object)this.generationId, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getResult(SelectQuery query, String column) {
        ArrayList<Object> result = new ArrayList<Object>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                result.add(dataSet.getValue(column));
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
        return result;
    }

    public ArrayList getExportAttributesList() {
        return new ArrayList();
    }

    public ArrayList getExportData(ArrayList p, ArrayList attributeList, ArrayList subReportList) {
        return new ArrayList();
    }

    public SelectQuery getSelectQuery(ArrayList attrList, String shareId, String type) {
        return new SelectQueryImpl(new Table(new String()));
    }

    public ArrayList getSubreportDetails() {
        return new ArrayList();
    }

    public ArrayList getSubReportAttributes(String subReportId) {
        return new ArrayList();
    }

    public void addPermissions() {
    }

    public void start(AdvReportsListener advReportsListener, ArrayList attributeList, DataObject cvcDO, Long loginId) {
    }

    public String getInputFilterDisplayName(String inputName) {
        return inputName;
    }

    public Hashtable getErrorList() {
        return this.errorList;
    }

    public void setErrorList(Hashtable errorList) {
        this.errorList = errorList;
    }

    public Integer getReportId() {
        return this.reportId;
    }

    public void setMgmtGenerationId(Long mgmtGenerationId) {
        this.mgmtGenerationId = mgmtGenerationId;
    }

    public Long getMgmtGenerationId() {
        return this.mgmtGenerationId;
    }

    public void setMgmtResultTableName(String mgmtResultTableName) {
        this.mgmtResultTableName = mgmtResultTableName;
    }

    public String getMgmtResultTableName() {
        return this.mgmtResultTableName;
    }

    public void setExportRowCount(int count) {
        this.exportCount = count;
    }

    public int getExportRowCount() {
        return this.exportCount;
    }

    public void setExportFileName(String fileName) {
        this.exportFileName = fileName;
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    public void setExportFileLocation(String exportFileLocation) {
        this.exportFileLocation = exportFileLocation;
    }

    public String getExportFileLocation() {
        return this.exportFileLocation;
    }

    public void setExportAuditID(Long auditId) {
        System.out.println("Setting export auditId..." + auditId);
        this.exportAuditId = auditId;
    }

    public Long getExportAuditID() {
        return this.exportAuditId;
    }

    protected class ModifyAction
    extends Thread {
        private ArrayList list = null;
        ReportBean bean = null;
        private ArrayList attributeList = null;
        private ArrayList messageList = null;
        private int modifyCount = 0;
        private ADMPAuthObject authObject = null;
        private String hostId = "";
        private int[] mgmtIds = null;
        private Integer objectId = null;
        private Integer reportIdForNotification = null;

        public ModifyAction(String hostId, ADMPAuthObject authObject, ReportBean b, ArrayList list, ArrayList attrib, int[] mgmtIds) {
            this.bean = b;
            this.list = list;
            this.messageList = new ArrayList();
            this.attributeList = attrib;
            this.modifyCount = 0;
            this.hostId = hostId;
            this.authObject = authObject;
            this.mgmtIds = mgmtIds;
        }

        private void updatePreviousList() {
            if (this.messageList.size() > 0) {
                for (int i = 0; i < this.messageList.size(); ++i) {
                    AbstractListener.this.out.write((String)this.messageList.get(i));
                    AbstractListener.this.out.flush();
                }
                this.messageList.clear();
            }
        }

        private void updateMessage(String guid, String message) {
            ++this.modifyCount;
            String s = "<script>if(this.load) updateMessage('" + guid + "','" + message + "')</script>";
            String s1 = "<script>if(this.load) updateCount('" + this.modifyCount + "')</script>";
            reportLogger.log(Level.INFO, "To Be updated Message.. " + s + " and the count : " + s1);
            if (AbstractListener.this.out != null) {
                this.updatePreviousList();
                AbstractListener.this.out.write(s);
                AbstractListener.this.out.flush();
                AbstractListener.this.out.write(s1);
                AbstractListener.this.out.flush();
            } else {
                this.messageList.add(s);
                this.messageList.add(s1);
            }
            ReportHandler.updateSIDMessage((String)AbstractListener.this.mgmtResultTableName, (Long)AbstractListener.this.mgmtGenerationId, (String)guid, (String)message);
        }

        @Override
        public void run() {
            Hashtable dnDomainNameMap = (Hashtable)this.bean.get("dnDomainNameMap");
            Long menuId = (Long)this.bean.get("menuId");
            AdmpInput admpInput = (AdmpInput)this.bean.get("mgmtActionInput");
            Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
            tableProps.put("baseTableName", AbstractListener.this.baseTableName);
            tableProps.put("resultTableName", AbstractListener.this.mgmtResultTableName);
            tableProps.put("generationId", AbstractListener.this.mgmtGenerationId);
            tableProps.put("resultHandling", "addOrUpdate");
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)AbstractListener.this.loginId, (String)this.hostId, (Integer)((Integer)this.bean.get("mgmtReportId")), (DataObject)auditDataObj, (AdventNetResourceBundle)AbstractListener.this.rb);
                DataObject obj = ReportHandler.getReportDetails((Integer)((Integer)this.bean.get("mgmtReportId")));
                Row r = obj.getFirstRow("ADSMReports");
                String className = (String)r.get("CLASS_NAME");
                Class<?> classToInvoke = Class.forName(className.trim());
                ModifyUserListener listener = (ModifyUserListener)classToInvoke.newInstance();
                AbstractListener.this.updateResult = false;
                Hashtable resultList = new Hashtable();
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                ArrayList<String> objectOUList = new ArrayList<String>();
                for (int i = 0; i < this.list.size() && AbstractListener.this.continueAction; ++i) {
                    Hashtable result = (Hashtable)this.list.get(i);
                    reportLogger.log(Level.INFO, "domain id : " + this.mgmtIds[2] + " : domain name : " + result.get(this.mgmtIds[2]));
                    AbstractListener.this.domainName = (String)result.get(this.mgmtIds[2]);
                    tableProps.put("domainName", AbstractListener.this.domainName);
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    String objectName = listener.getObjectName(result);
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)objectName, (String)AbstractListener.this.domainName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    AbstractListener.this.queue.registerForUpdation(AbstractListener.this.baseTableName, AbstractListener.this.generationId, tableProps);
                    reportLogger.log(Level.INFO, "The result Values is : " + result);
                    String guid = (String)result.get("OBJECT_GUID");
                    String dnValue = (String)result.get(1004);
                    System.out.println("The AbstractListener.java - distinguished name for the user object is :: " + dnValue);
                    String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dnValue);
                    if (!objectOUList.contains(ouName)) {
                        objectOUList.add(ouName);
                    }
                    String message = ReportMgmtHandler.mgmtAction(menuId, this.authObject, result, this.attributeList, AbstractListener.this.domainName, AbstractListener.this.loginId, this.bean.getListener(), this.mgmtIds, audit_info, auditDataObj, AbstractListener.this.rb, admpInput, AbstractListener.this.guidVsPolicyStatusMap);
                    StringBuilder auditMessage = new StringBuilder();
                    auditMessage.append(message);
                    Map policyStatusMap = AbstractListener.this.guidVsPolicyStatusMap.get(guid);
                    if (policyStatusMap != null) {
                        auditMessage.append(AbstractListener.this.guidVsPolicyStatusMap.get("auditMessage"));
                    }
                    this.updateMessage(guid, message);
                    if (message.toLowerCase().contains(AbstractListener.this.rb.getString("admp.admin.notification_profile.audit_obj_check.successfully_updated").toLowerCase())) {
                        auditObjectIdList.add(object_id);
                    }
                    audit_info.put("error_msg", auditMessage.toString());
                    if (this.objectId == null) {
                        this.objectId = audit_info.get("objectIdForNotification") != null ? (Integer)audit_info.get("objectIdForNotification") : 1;
                    }
                    if (this.reportIdForNotification == null) {
                        this.reportIdForNotification = audit_info.get("reportIdForNotification") != null ? (Integer)audit_info.get("reportIdForNotification") : 1;
                    }
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                }
                AbstractListener.this.completedAction();
                AbstractListener.this.updateResult = true;
                this.messageList.clear();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    notifyListener.triggerNotification(auditDataObj, auditObjectIdList, this.objectId, resultList, AbstractListener.this.loginId, this.reportIdForNotification, AbstractListener.this.domainName, AbstractListener.this.rb, null, objectOUList);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

