/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCHandler;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCUtil;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.queue.QueueUtil;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.MultiDCListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AllComputersListener
extends MultiDCListener {
    private Boolean isCompletedBitlocker = false;

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1025L);
        return categoryId;
    }

    public AllComputersListener() {
        this.mgmtIds = new int[]{3020, 3018, 3016, 3022};
        this.multiDC = true;
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(Properties domainDetails, String distinguishedName, String dc, ArrayList attributeList, NativeListener listener) throws Exception {
        ADHandler.getAllComputers((Properties)domainDetails, (String)distinguishedName, (String)dc, (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "addOrUpdate");
        return tableProps;
    }

    public String getSearchString() {
        return "(&(objectcategory=computer)(objectClass=computer))";
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            Hashtable reportDomains = this.getReportDomains(request, bean, loginId);
            inputParams.put("reportDomains", reportDomains);
            inputParams.put("multiDC", "true");
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            String reportDomain = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomain});
            this.statusController.init(reportDomains);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            if (attributeList.contains("bitlockerstatus")) {
                this.isBitlocker = true;
                attributeList.remove("bitlockerstatus");
                Action action = new Action(loginId, reportDomains, attributeList, this, dnDomainNameMap, this.multiDC, excludedOUList, domainVsExcludeChildOU, this.isBitlocker);
                action.start();
            } else {
                this.isCompletedBitlocker = true;
                Action action = new Action(loginId, reportDomains, attributeList, this, dnDomainNameMap, this.multiDC, excludedOUList, domainVsExcludeChildOU);
                action.start();
            }
            bean.set("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop(HttpServletRequest request) {
        if (!this.continueAction) {
            System.out.println("Already stop initialized. Second stop call");
            return;
        }
        this.isCompletedBitlocker = true;
        this.continueAction = false;
        MultiDCHandler.getInstance().stop(this.queueRegID);
        super.stop(request);
    }

    @Override
    public void updateADObjectsCount() {
        Enumeration e = this.ouSelectedDomains.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            boolean flag = (Boolean)this.ouSelectedDomains.get(key);
            if (!this.loginId.equals(CommonUtil.ADMIN_LOGIN_ID) || flag) continue;
            DomainHandler.checkForBaseTableRefresh((String)key, (Long)this.loginId, (String[])new String[]{"Computer"}, (boolean)false);
        }
    }

    protected void updateResult() {
        boolean result = MultiDCHandler.getInstance().isCompleted(this.queueRegID);
        while (!result || !this.isCompletedBitlocker.booleanValue() && this.isBitlocker.booleanValue()) {
            try {
                if (result) {
                    Thread.sleep(30L);
                    continue;
                }
                this.updateOtherDCCount();
                Thread.sleep(30L);
                result = MultiDCHandler.getInstance().isCompleted(this.queueRegID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.updateOtherDCStatus();
        this.updateDCErrorStatus();
        MultiDCHandler.getInstance().finishProcess(this.queueRegID);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        this.multiDC = true;
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Hashtable reportDomains = this.getReportDomains(containerList, dnDomainNameMap, excludedOUList, domainVsExcludeChildOU);
            Action action = new Action(1L, reportDomains, this.getAttributeList(), this, dnDomainNameMap, this.multiDC, excludedOUList, domainVsExcludeChildOU);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Action
    extends Thread {
        private Hashtable reportDomains = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Hashtable excludedOUList = null;
        private Hashtable domainVsExcludeChildOU = null;
        private Long loginId = null;
        private boolean multiDC = true;
        private boolean isBitlocker = false;

        public Action(Long loginId, Hashtable hash, ArrayList attributeList, NativeListener li, Hashtable map, boolean multiDC, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU) {
            this.loginId = loginId;
            this.reportDomains = hash;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.multiDC = multiDC;
            this.excludedOUList = excludedOUList;
            this.domainVsExcludeChildOU = domainVsExcludeChildOU;
        }

        public Action(Long loginId, Hashtable hash, ArrayList attributeList, NativeListener li, Hashtable map, boolean multiDC, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, boolean isBitlocker) {
            this.loginId = loginId;
            this.reportDomains = hash;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.multiDC = multiDC;
            this.excludedOUList = excludedOUList;
            this.domainVsExcludeChildOU = domainVsExcludeChildOU;
            this.isBitlocker = isBitlocker;
        }

        @Override
        public void run() {
            AllComputersListener.this.errorMessage = null;
            Hashtable tableProps = AllComputersListener.this.getQueueProps();
            ArrayList multiDCAttributes = AllComputersListener.this.getMultiDCAttributes();
            ArrayList bitlockerAttributes = AllComputersListener.this.getBitLockerAttributes();
            ArrayList objectIds = AllComputersListener.this.getObjIdList();
            AllComputersListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, AllComputersListener.this.getTableColumns());
            AllComputersListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(AllComputersListener.this.resultTableName);
            ArrayList clist = new ArrayList();
            if (this.reportDomains.isEmpty()) {
                AllComputersListener.this.domainName = null;
            }
            ArrayList<BitlockerAction> taskList = new ArrayList<BitlockerAction>();
            Enumeration e = this.reportDomains.keys();
            while (e.hasMoreElements()) {
                AllComputersListener.this.domainName = (String)e.nextElement();
                ReportDomain reportDomain = (ReportDomain)this.reportDomains.get(AllComputersListener.this.domainName);
                ArrayList containerList = reportDomain.getContainerList();
                if (this.isBitlocker) {
                    String dn = DomainUtil.getDefaultNamingContext((String)AllComputersListener.this.domainName);
                    BitlockerAction task = new BitlockerAction(AllComputersListener.this.domainName, this.loginId, dn, bitlockerAttributes, this.listener);
                    taskList.add(task);
                }
                clist.addAll(containerList);
            }
            Hashtable excludeContainerHash = AllComputersListener.this.constructExcludeContainerHash(clist, this.domainVsExcludeChildOU, this.excludedOUList, this.dnDomainNameMap);
            if (multiDCAttributes.size() > 0) {
                MultiDCHandler.getInstance().execute(AllComputersListener.this.queueRegID, this.loginId, clist, this.dnDomainNameMap, multiDCAttributes, AllComputersListener.this.getSearchString(), AllComputersListener.this.objClass.getId(), excludeContainerHash);
                MultiDCHandler.getInstance().setRemoveGuids(AllComputersListener.this.queueRegID, false);
            }
            if (this.isBitlocker) {
                ThreadPoolExecutor tpe = new ThreadPoolExecutor(10, 100, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
                try {
                    for (int i = 0; i < taskList.size(); ++i) {
                        try {
                            Runnable task = (Runnable)taskList.get(i);
                            tpe.execute(task);
                            continue;
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
            Enumeration e4 = this.reportDomains.keys();
            block11: while (e4.hasMoreElements()) {
                try {
                    AllComputersListener.this.domainName = (String)e4.nextElement();
                    Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)AllComputersListener.this.domainName, (Long)this.loginId);
                    ReportDomain reportDomain = (ReportDomain)this.reportDomains.get(AllComputersListener.this.domainName);
                    ArrayList containerList = reportDomain.getContainerList();
                    AbstractListener.reportLogger.log(Level.INFO, "containerList: " + containerList.size());
                    Hashtable domains = AllComputersListener.this.getDomainContainers(containerList, this.dnDomainNameMap);
                    for (int i = 0; i < containerList.size(); ++i) {
                        String dn = (String)containerList.get(i);
                        Boolean isExcludeChildOU = Boolean.FALSE;
                        if (excludeContainerHash != null && excludeContainerHash.containsKey(dn)) {
                            isExcludeChildOU = (Boolean)excludeContainerHash.get(dn);
                        }
                        this.listener.setIsExcludeChildOU(isExcludeChildOU);
                        ArrayList dcList = reportDomain.getDCList();
                        boolean error = true;
                        String errStr = null;
                        Hashtable<String, ArrayList> domainProps = new Hashtable<String, ArrayList>();
                        domainProps.put(AllComputersListener.this.domainName, dcList);
                        for (int j = 0; j < dcList.size(); ++j) {
                            Hashtable hash = (Hashtable)dcList.get(j);
                            Integer status = (Integer)hash.get("status");
                            AllComputersListener.this.dcIndex = j;
                            if (status == 0) {
                                Hashtable<String, String> errors;
                                AllComputersListener.this.dcName = (String)hash.get("dcName");
                                try {
                                    AllComputersListener.this.updateStatus(AllComputersListener.this.dcName);
                                    AllComputersListener.this.toBeExecutedAttributeList = this.attributeList;
                                    if (this.multiDC) {
                                        AllComputersListener.this.doAction(domainDetails, dn, AllComputersListener.this.dcName, this.attributeList, this.listener);
                                    }
                                    AllComputersListener.this.updateCompletionStatus();
                                    error = false;
                                }
                                catch (LocalizedException exc) {
                                    exc.printStackTrace();
                                    errStr = AllComputersListener.this.rb.getString("client.reports.RealLastLogonListener.error_while_getting_the_reports_from_the_domain") + " " + AllComputersListener.this.domainName + ". " + exc.getMessage(AllComputersListener.this.rb);
                                    System.out.println("LocalizedException: - " + exc.getMessage(AllComputersListener.this.rb));
                                    errors = new Hashtable();
                                    errors.put("INPUT_NAME", AllComputersListener.this.dcName);
                                    errors.put("ERROR_MESSAGE", errStr);
                                    AllComputersListener.this.errorList.put(AllComputersListener.this.dcName, errors);
                                    AllComputersListener.this.updateErrorStatus(errors);
                                    AllComputersListener.this.updateMultiDCStatus(AllComputersListener.this.domainName, AllComputersListener.this.dcName, "domain_error.jpg", null);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    errStr = AllComputersListener.this.rb.getString("client.reports.RealLastLogonListener.error_while_getting_the_reports_from_the_domain") + " " + AllComputersListener.this.domainName + ". " + ex.getMessage();
                                    errors = new Hashtable<String, String>();
                                    errors.put("INPUT_NAME", AllComputersListener.this.dcName);
                                    errors.put("ERROR_MESSAGE", errStr);
                                    AllComputersListener.this.errorList.put(AllComputersListener.this.dcName, errors);
                                    AllComputersListener.this.updateErrorStatus(errors);
                                    AllComputersListener.this.updateMultiDCStatus(AllComputersListener.this.domainName, AllComputersListener.this.dcName, "domain_error.jpg", null);
                                }
                                status = new Integer(1);
                                AllComputersListener.this.updatedCount = 0;
                            }
                            if (!error || error && !errStr.contains("8007203a")) break;
                        }
                        if (!error) continue;
                        AllComputersListener.this.errorMessage = errStr;
                        continue block11;
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            if (AllComputersListener.this.domainName != null) {
                AllComputersListener.this.updateResult();
            }
            AllComputersListener.this.completedAction();
            AllComputersListener.this.totalCount = 0;
        }
    }

    private class BitlockerAction
    implements Runnable,
    NativeListener {
        private String domainName = null;
        private NativeListener listener = null;
        private Long loginId = null;
        private String dn = null;
        private ArrayList attributeList = null;
        private Boolean excludeChildOU = false;
        private boolean continueAction = false;
        private final long threshold = 50000L;
        private ArrayList attributeLists = null;
        private Long queueRegID = null;

        public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
            ADHandler.getBitlockerEnabledComputers((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (NativeListener)listener);
        }

        public void completedActionBitLocker() {
            this.endQueue();
            AllComputersListener.this.isCompletedBitlocker = true;
        }

        public void endQueue() {
            this.postNativeData();
            this.deRegister();
        }

        private void postNativeData() {
            QueueHandler.getInstance().postNativeData(this.queueRegID);
        }

        private void deRegister() {
            QueueHandler.getInstance().deRegister(this.queueRegID);
        }

        public void addRow(Properties prop) {
            try {
                Hashtable tableRowMap = new Hashtable();
                String guid = MultiDCUtil.getGuid((Properties)prop);
                StringBuilder tableString = new StringBuilder(EscapeUtil.getEscapedQuotedString((Object)guid));
                if (guid == null) {
                    return;
                }
                for (int i = 0; i < this.attributeLists.size(); ++i) {
                    Hashtable h = (Hashtable)this.attributeLists.get(i);
                    String ldapName = (String)h.get("ATTRIB_LDAP_NAME");
                    String colName = (String)h.get("ATTRIB_COLUMN_NAME");
                    String value = "";
                    ArrayList nativeValues = (ArrayList)prop.get(ldapName);
                    if (ldapName.equalsIgnoreCase("objectguid")) continue;
                    if (nativeValues != null && nativeValues.size() > 0) {
                        try {
                            value = ldapName.equalsIgnoreCase("bitlockerstatus") ? "ENABLED" : (String)nativeValues.get(0);
                        }
                        catch (Exception e) {
                            AbstractListener.reportLogger.log(Level.INFO, "Error in getting native properties of ResultProcessor : " + nativeValues);
                        }
                    }
                    tableString.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER + EscapeUtil.getEscapedQuotedString((Object)value));
                }
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put(guid, tableString.toString());
                tableRowMap.put(AllComputersListener.this.baseTableName, hash);
                QueueHandler.getInstance().getQueue(AllComputersListener.this.objClass.getId()).updateData(this.queueRegID, tableRowMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setIsExcludeChildOU(Boolean excludeChildOU) {
            this.excludeChildOU = excludeChildOU;
        }

        public void setNativeError(String domainName, Hashtable errorHash) {
        }

        public void setNativeError(String domainName, String dCName, Hashtable errorHash) {
        }

        public boolean isCompleted() {
            return this.continueAction;
        }

        public boolean isExcludeChildOU() {
            return this.excludeChildOU;
        }

        public BitlockerAction(String domainName, Long loginId, String dn, ArrayList attributeList, NativeListener listener) {
            this.domainName = domainName;
            this.loginId = loginId;
            this.dn = dn;
            this.attributeList = attributeList;
        }

        @Override
        public void run() {
            boolean err = true;
            String errStr = "";
            try {
                this.attributeLists = MultiDCUtil.getNonMultiDCAttribsbitlocker((ArrayList)ReportAttributeHandler.getInstance().getAttributes(AllComputersListener.this.baseTableName, AllComputersListener.this.reportId));
                this.queueRegID = QueueHandler.getInstance().registerForUpdate(AllComputersListener.this.getObjIdList(), MultiDCUtil.getMultiDCTableBitlockerColumn((ArrayList)this.attributeLists));
                this.doAction(this.domainName, this.loginId, this.dn, this.attributeList, this);
                err = false;
            }
            catch (LocalizedException excep) {
                errStr = AllComputersListener.this.rb.getString("client.reports.InactiveComputersListener.error_while_getting_the_reports_from_the_domain") + " " + this.domainName + ". " + excep.getMessage(AllComputersListener.this.rb);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.completedActionBitLocker();
        }
    }
}

