/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.multidc.ResultProcessor;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.MultiDCListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class BadPwdTimeListener
extends MultiDCListener {
    private Hashtable dcVsGuidList = null;
    private Hashtable dcVsGuidAndBadPwdCount = new Hashtable();
    public Hashtable dcVsGuidAndLogonCount = new Hashtable();
    private Hashtable guidVsBadPwdCount = new Hashtable();
    public Hashtable guidVsLogonCount = new Hashtable();

    public BadPwdTimeListener() {
        this.multiDC = true;
    }

    public void getDescription(Object[] args, String dataLableText) {
        ArrayList<Object> objectList = new ArrayList<Object>(Arrays.asList(args));
        String daysInterval = "";
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            SimpleDateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
            String startVal = (String)objectList.get(0);
            String endVal = (String)objectList.get(1);
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                daysInterval = Integer.toString(DateTimeUtil.daysBetween((Date)formatter1.parse(startVal), (Date)formatter1.parse(endVal)));
            }
            objectList.add(daysInterval);
            Date date = formatter1.parse(startVal);
            Date date1 = formatter1.parse(endVal);
            objectList.set(0, formatter2.format(date));
            objectList.set(1, formatter2.format(date1));
            args = objectList.toArray();
            this.setDescription(args, dataLableText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDescription(Object[] args, String dataLableText) {
        this.desc = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_logon_failures_users.reportdesc_last_N_days"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.after_a_date") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_logon_failures_users.reportdesc_after_date"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.today") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_logon_failures_users.reportdesc_for_date"), args) : MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_logon_failures_users.reportdesc_between_dates"), args)));
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "no-update");
        return tableProps;
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, String dc, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
        ADHandler.getRecentlyBadLoginUsers((String)domainName, (Long)loginId, (String)distinguishedName, (String)dc, (ArrayList)attributeList, (NativeListener)listener, (String)filterString);
    }

    @Override
    public ArrayList getDBCustomizedValues(String columnName, String ldapName, Properties prop) {
        ArrayList<Long> ret = super.getDBCustomizedValues(columnName, ldapName, prop);
        if (columnName.equalsIgnoreCase("BAD_PASSWORD_COUNT")) {
            ret = new ArrayList<Long>();
            String guid = this.getGuid(prop);
            ArrayList badPwdCount = (ArrayList)prop.get("badPwdCount");
            if (badPwdCount != null) {
                this.guidVsBadPwdCount.put(guid, new Long((String)badPwdCount.get(0)));
                ret.add(new Long((String)badPwdCount.get(0)));
            } else {
                this.guidVsBadPwdCount.put(guid, 0L);
                ret.add(new Long(0L));
            }
        } else if (columnName.equalsIgnoreCase("LOGON_COUNT")) {
            ret = new ArrayList();
            String guid = this.getGuid(prop);
            ArrayList logonCount = (ArrayList)prop.get("logonCount");
            if (logonCount != null) {
                this.guidVsLogonCount.put(guid, new Long((String)logonCount.get(0)));
                ret.add(new Long((String)logonCount.get(0)));
            } else {
                this.guidVsLogonCount.put(guid, 0L);
                ret.add(new Long(0L));
            }
        }
        return ret;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            Hashtable reportDomains = this.getReportDomains(request, bean, loginId);
            inputParams.put("reportDomains", reportDomains);
            inputParams.put("multiDC", "true");
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            String startDateVal = request.getParameter("startDate");
            String endDateVal = request.getParameter("endDate");
            String dataLableText = request.getParameter("dateLable");
            String filterString = this.getFilterString(startDateVal, endDateVal, dataLableText);
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            String reportDomain = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString(dataLableText), reportDomain}, dataLableText);
            this.statusController.init(reportDomains);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            Action action = new Action(loginId, reportDomains, attributeList, filterString, this, dnDomainNameMap, this.multiDC, excludedOUList, domainVsExcludeChildOU);
            action.start();
            bean.set("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFilterString(String startDateVal, String endDateVal, String dataLableText) {
        String filterString = "";
        HashMap datesValueMap = this.getDateInterval(startDateVal, endDateVal, dataLableText);
        long startDate = (Long)datesValueMap.get("startDate");
        long endDate = (Long)datesValueMap.get("endDate");
        filterString = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.after_a_date") ? "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(badPasswordTime>=" + endDate + "))" : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days") ? "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(badPasswordTime>=" + startDate + "))" : "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(badPasswordTime>=" + startDate + ")(badPasswordTime<=" + endDate + "))");
        return filterString;
    }

    public HashMap getDateInterval(String startDateVal, String endDateVal, String dataLableText) {
        HashMap<String, Long> datesValueMap = new HashMap<String, Long>();
        long startDate = 0L;
        long endDate = 0L;
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            Date days = formatter1.parse(startDateVal);
            startDate = DateTimeUtil.getFileTime((Long)days.getTime());
            days = formatter1.parse(endDateVal);
            endDate = DateTimeUtil.getFileTime((Long)days.getTime());
            days = formatter1.parse(endDateVal);
            Calendar endoftheDay = Calendar.getInstance();
            endoftheDay.setTime(days);
            endoftheDay.set(endoftheDay.get(1), endoftheDay.get(2), endoftheDay.get(5), 23, 59, 59);
            endoftheDay.set(14, 0);
            endDate = DateTimeUtil.getFileTime((Long)endoftheDay.getTimeInMillis());
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                int lastNDays = DateTimeUtil.daysBetween((Date)formatter1.parse(startDateVal), (Date)formatter1.parse(endDateVal));
                long l = (long)(lastNDays * 24 * 60 * 60) * 1000L;
                startDate = DateTimeUtil.getFileTime((Long)(System.currentTimeMillis() - l));
                endDate = DateTimeUtil.getFileTime((Long)System.currentTimeMillis());
            }
            datesValueMap.put("startDate", startDate);
            datesValueMap.put("endDate", endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datesValueMap;
    }

    public void updateResult() {
        if (this.dcVsGuidList.size() > 0) {
            ArrayList<String> result = new ArrayList<String>();
            Enumeration dcs = this.dcVsGuidList.keys();
            while (dcs.hasMoreElements()) {
                String dc = (String)dcs.nextElement();
                ArrayList guids = (ArrayList)this.dcVsGuidList.get(dc);
                for (int i = 0; i < guids.size(); ++i) {
                    String guid = (String)guids.get(i);
                    if (result.contains(guid)) continue;
                    result.add(guid);
                }
            }
            ReportHandler.addSIDReportResult((Long)this.generationId, (String)this.resultTableName, result);
            this.updateDCErrorStatus();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            this.multiDC = true;
            long value = 2592000000L;
            Long reportDays = 0L;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                ListenerUtil.updateReportDaysForRegenerateReport(reportFilterConfig, admpInput, false);
                reportDays = Long.valueOf(admpInput.getValue());
                value = reportDays * 24L * 60L * 60L * 1000L;
            }
            HashMap dateValues = this.getScheduleDates(value);
            String startDateVal = (String)dateValues.get("startDate");
            String endDateVal = (String)dateValues.get("endDate");
            String filterString = this.getFilterString(startDateVal, endDateVal, "admp.common.matching_criteria.last_N_days");
            System.out.println("BadPwdTimeListener.java - Schedule Report - filterString is :: " + filterString);
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString("admp.common.matching_criteria.last_N_days"), schedulerDomains}, "admp.common.matching_criteria.last_N_days");
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Hashtable reportDomains = this.getReportDomains(1L, containerList, dnDomainNameMap);
            Action action = new Action(CommonUtil.ADMIN_LOGIN_ID, reportDomains, this.getAttributeList(), filterString, this, dnDomainNameMap, this.multiDC, excludedOUList, domainVsExcludeChildOU);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap getScheduleDates(long time) {
        HashMap<String, String> datesMap = new HashMap<String, String>();
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        Date days = new Date(System.currentTimeMillis() - time);
        String startDateVal = formatter1.format(days);
        days = new Date(System.currentTimeMillis());
        String endDateVal = formatter1.format(days);
        datesMap.put("startDate", startDateVal);
        datesMap.put("endDate", endDateVal);
        return datesMap;
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        ListenerUtil.setDashboardInputParams(dashboardReportMapping, request, bean, 1);
    }

    private class Action
    extends Thread {
        private Hashtable reportDomains = null;
        private ArrayList attributeList = null;
        private String filterString = "";
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private boolean multiDC = true;
        private Hashtable domainVsExcludeChildOU = null;
        private Hashtable excludedOUList = null;

        public Action(Long loginId, Hashtable hash, ArrayList attributeList, String filterString, NativeListener li, Hashtable map, boolean multiDC, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU) {
            this.loginId = loginId;
            this.reportDomains = hash;
            this.attributeList = attributeList;
            this.filterString = filterString;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.excludedOUList = excludedOUList;
            this.domainVsExcludeChildOU = domainVsExcludeChildOU;
            this.multiDC = multiDC;
        }

        @Override
        public void run() {
            BadPwdTimeListener.this.errorMessage = null;
            BadPwdTimeListener.this.updateResult = false;
            BadPwdTimeListener.this.resultUseTempFlag = true;
            BadPwdTimeListener.this.guidList = new ArrayList();
            BadPwdTimeListener.this.guidVsBadPwdCount = new Hashtable();
            BadPwdTimeListener.this.guidVsLogonCount = new Hashtable();
            Hashtable tableProps = BadPwdTimeListener.this.getQueueProps();
            ArrayList multiDCAttributes = BadPwdTimeListener.this.getMultiDCAttributes();
            ArrayList objectIds = BadPwdTimeListener.this.getObjIdList();
            BadPwdTimeListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, BadPwdTimeListener.this.getTableColumns());
            BadPwdTimeListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(BadPwdTimeListener.this.resultTableName);
            Enumeration e = this.reportDomains.keys();
            block5: while (e.hasMoreElements()) {
                try {
                    BadPwdTimeListener.this.domainName = (String)e.nextElement();
                    Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)BadPwdTimeListener.this.domainName, (Long)this.loginId);
                    ReportDomain reportDomain = (ReportDomain)this.reportDomains.get(BadPwdTimeListener.this.domainName);
                    ArrayList containerList = reportDomain.getContainerList();
                    Hashtable excludeContainerHash = BadPwdTimeListener.this.constructExcludeContainerHash(containerList, this.domainVsExcludeChildOU, this.excludedOUList, this.dnDomainNameMap);
                    for (int i = 0; i < containerList.size(); ++i) {
                        String dn = (String)containerList.get(i);
                        Boolean isExcludeChildOU = Boolean.FALSE;
                        if (excludeContainerHash != null && excludeContainerHash.containsKey(dn)) {
                            isExcludeChildOU = (Boolean)excludeContainerHash.get(dn);
                        }
                        this.listener.setIsExcludeChildOU(isExcludeChildOU);
                        BadPwdTimeListener.this.resultObject = new ResultProcessor(BadPwdTimeListener.this.queueRegID.longValue(), multiDCAttributes, BadPwdTimeListener.this.objClass.getId());
                        BadPwdTimeListener.this.resultObject.setRemoveGuids(false);
                        ArrayList dcList = reportDomain.getDCList();
                        ArrayList dcList1 = new ArrayList();
                        for (int k = 0; k < dcList.size(); ++k) {
                            Hashtable hash = (Hashtable)dcList.get(k);
                            dcList1.add(hash.get("dcName"));
                        }
                        Hashtable domainProps = new Hashtable();
                        domainProps.put(BadPwdTimeListener.this.domainName, dcList1);
                        BadPwdTimeListener.this.resultObject.setDomainProps(dcList.size(), domainProps);
                        if (!this.multiDC) {
                            Hashtable dcHash = (Hashtable)dcList.get(0);
                            dcList.clear();
                            dcList.add(dcHash);
                        }
                        BadPwdTimeListener.this.dcVsGuidList = new Hashtable();
                        BadPwdTimeListener.this.dcVsGuidAndBadPwdCount = new Hashtable();
                        BadPwdTimeListener.this.dcVsGuidAndLogonCount = new Hashtable();
                        boolean error = true;
                        String errStr = null;
                        for (int j = 0; j < dcList.size(); ++j) {
                            Hashtable hash = (Hashtable)dcList.get(j);
                            Integer status = (Integer)hash.get("status");
                            BadPwdTimeListener.this.dcIndex = j;
                            if (status == 0) {
                                Hashtable<String, String> errors;
                                BadPwdTimeListener.this.dcName = (String)hash.get("dcName");
                                try {
                                    BadPwdTimeListener.this.updateStatus(BadPwdTimeListener.this.dcName);
                                    ArrayList list = new ArrayList();
                                    BadPwdTimeListener.this.toBeExecutedAttributeList = list = this.attributeList;
                                    if (this.multiDC) {
                                        BadPwdTimeListener.this.doAction(BadPwdTimeListener.this.domainName, this.loginId, dn, BadPwdTimeListener.this.dcName, list, this.listener, this.filterString);
                                    }
                                    BadPwdTimeListener.this.updateCompletionStatus();
                                    error = false;
                                    BadPwdTimeListener.this.dcVsGuidList.put(BadPwdTimeListener.this.dcName, BadPwdTimeListener.this.guidList);
                                    BadPwdTimeListener.this.guidList = new ArrayList();
                                }
                                catch (LocalizedException excep) {
                                    errStr = excep.getMessage(BadPwdTimeListener.this.rb);
                                    errStr = BadPwdTimeListener.this.rb.getString("client.reports.RealLastLogonListener.error_while_getting_the_reports_from_the_domain") + " " + BadPwdTimeListener.this.domainName + ". " + errStr;
                                    errors = new Hashtable();
                                    errors.put("INPUT_NAME", BadPwdTimeListener.this.dcName);
                                    errors.put("ERROR_MESSAGE", errStr);
                                    BadPwdTimeListener.this.errorList.put(BadPwdTimeListener.this.dcName, errors);
                                    BadPwdTimeListener.this.updateErrorStatus(errors);
                                    BadPwdTimeListener.this.updateMultiDCStatus(BadPwdTimeListener.this.domainName, BadPwdTimeListener.this.dcName, "domain_error.jpg", null);
                                    System.out.println("LocalizedException in BadPwdTimeListener:-" + errStr);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    errStr = BadPwdTimeListener.this.rb.getString("client.reports.BadPwdTimeListener.error_while_getting_the_reports_from_the_domain") + " " + BadPwdTimeListener.this.domainName + ". " + ex.getMessage();
                                    errors = new Hashtable<String, String>();
                                    errors.put("INPUT_NAME", BadPwdTimeListener.this.dcName);
                                    errors.put("ERROR_MESSAGE", errStr);
                                    BadPwdTimeListener.this.errorList.put(BadPwdTimeListener.this.dcName, errors);
                                    BadPwdTimeListener.this.updateErrorStatus(errors);
                                    BadPwdTimeListener.this.updateMultiDCStatus(BadPwdTimeListener.this.domainName, BadPwdTimeListener.this.dcName, "domain_error.jpg", null);
                                }
                                status = new Integer(1);
                                BadPwdTimeListener.this.updatedCount = 0;
                            }
                            BadPwdTimeListener.this.resultObject.updateFinishedCount();
                        }
                        if (error) {
                            BadPwdTimeListener.this.errorMessage = errStr;
                            BadPwdTimeListener.this.resultObject.dropTempTable();
                            continue block5;
                        }
                        BadPwdTimeListener.this.updateQueue();
                        if (BadPwdTimeListener.this.updateDetails) {
                            BadPwdTimeListener.this.updateResult();
                        }
                        BadPwdTimeListener.this.resultObject.dropTempTable();
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            BadPwdTimeListener.this.completedAction();
            if (BadPwdTimeListener.this.updateDetails) {
                // empty if block
            }
            BadPwdTimeListener.this.totalCount = 0;
        }
    }
}

