/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.webclient.reports.GPOListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.SingleContainerListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class FreqModifiedGPOListener
extends GPOListener {
    protected int noOfGPOs = 30;

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "no-update");
        return tableProps;
    }

    @Override
    public void init(Row r) {
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        if (this.rb == null) {
            this.rb = ResourceBundleMgr.getInstance().getBundle();
        }
        this.title = (String)r.get("REPORT_NAME");
    }

    @Override
    public void init(HttpServletRequest request, Row r) {
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
        this.setGenerationId(request);
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            if (request.getParameter("day") != null) {
                try {
                    this.noOfGPOs = Integer.parseInt(request.getParameter("day"));
                }
                catch (Exception e) {
                    this.noOfGPOs = 30;
                    e.printStackTrace();
                }
            }
            ArrayList containerList = this.getContainerList(request, bean);
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomains});
            SingleContainerListener.Action action = new SingleContainerListener.Action(this, loginId, containerList, attributeList, this, dnDomainNameMap);
            action.start();
            bean.set("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "FreqModifiedGPOListener Execute Task Started ");
            this.isCompleted = false;
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                this.noOfGPOs = Integer.parseInt(admpInput.getValue());
            }
            reportLogger.log(Level.INFO, "Going to execute the for the reportId " + this.reportId + "No of GPO's " + this.noOfGPOs);
            SingleContainerListener.Action action = new SingleContainerListener.Action(this, this.loginId, containerList, this.getAttributeList(), this, dnDomainNameMap);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            reportLogger.log(Level.INFO, "FreqModifiedGPOListener Execute Task Completed ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void completedAction() {
        if (this.updateDetails) {
            reportLogger.log(Level.INFO, "GPO LIstener Receiving Completed Action");
            this.updateQueue();
            reportLogger.log(Level.INFO, "GPO LIstener pdating Completed Action");
            this.deriveData(this.noOfGPOs, this.domainName);
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        }
        this.isCompleted = true;
        this.queue.deRegister(this.generationId);
        if (this.statusController != null) {
            this.statusController.setIsCompleted(this.isCompleted);
        }
    }

    @Override
    public void updateUI(Properties uiValues, String objectClass, String guid, String str) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deriveData(int noOfGPOs, String domainName) {
        ArrayList<Object> list = new ArrayList<Object>();
        RelationalAPI relationalAPI = RelationalAPI.getInstance();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            connection = relationalAPI.getConnection();
            SelectQueryImpl sq = new SelectQueryImpl(new Table(this.baseTableName));
            sq.addSelectColumn(new Column("ADSMGPODetails", "OBJECT_GUID"));
            sq.setRange(new Range(0, noOfGPOs));
            sq.setCriteria(new Criteria(new Column("ADSMGPODetails", "DOMAIN_NAME"), (Object)domainName, 0));
            String query = "select  OBJECT_GUID, (COMPUTER_VERSION + USER_VERSION) as VERSION from ADSMGPODetails where DOMAIN_NAME='" + domainName + "' and (COMPUTER_VERSION!=0 or USER_VERSION!=0) order by VERSION desc";
            dataSet = relationalAPI.executeQuery((Query)sq, connection, query);
            while (dataSet.next()) {
                list.add(dataSet.getValue("OBJECT_GUID"));
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
        ReportHandler.addSIDReportResult((Long)this.generationId, (String)this.resultTableName, list);
    }

    @Override
    public void setDashboardInputParams(Long schedulerValueMapping, HttpServletRequest request, ReportBean bean) {
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        inputParams.put("day", ListenerUtil.getInputValues(schedulerValueMapping, request, bean));
    }
}

