/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.adsync.ADSyncUtil;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.BaseExchangeListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class GetProxyUsersListener
extends BaseExchangeListener {
    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void removeInputParams(ReportBean bean) {
        HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
        if (reportInputParams != null && reportInputParams.containsKey("trustee")) {
            reportInputParams.put("trustee", new ArrayList());
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, String trustee, ArrayList attributeList, NativeListener listener) throws Exception {
        ADHandler.getProxyAddressBasedUsers((String)domainName, (Long)loginId, (String)distinguishedName, (String)trustee, (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            this.setSyncEnabled();
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String trustee = "*" + request.getParameter("trustee") + "*";
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            inputParams.put("trustee", trustee);
            bean.set("inputParams", inputParams);
            ArrayList selectedDomains = new ArrayList();
            Hashtable defaultNamingContextVsDomainName = DomainInfoCache.getInstance().getDefaultNamingContextVsDomainName();
            for (int i = 0; i < domainList.length; ++i) {
                selectedDomains.add(defaultNamingContextVsDomainName.get(domainList[i]));
            }
            this.getDescription(new Object[]{dnDomainNameMap.get(containerList.get(0))});
            Action action = new Action(loginId, selectedDomains, containerList, attributeList, this, dnDomainNameMap, trustee, excludeContainerHash, this.isSyncEnabled());
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            this.isCompleted = false;
            String trustee = "";
            String proxyAddress = "";
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                proxyAddress = admpInput.getValue();
                trustee = "*" + proxyAddress + "*";
            }
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            this.setSyncEnabled();
            ArrayList scheduledDomains = SchedulerUtil.getSchedulerDomains((Long)reportFilterConfig.getScheduleId());
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(CommonUtil.ADMIN_LOGIN_ID, scheduledDomains, containerList, this.getAttributeList(), this, dnDomainNameMap, trustee, excludeContainerHash, this.isSyncEnabled());
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDashboardInputParams(Long schedulerValueMapping, HttpServletRequest request, ReportBean bean) {
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        inputParams.put("trustee", ListenerUtil.getInputValues(schedulerValueMapping, request, bean));
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private String trustee = null;
        private Long loginId = null;
        private Hashtable excludeChildOUHash = null;
        private ArrayList domainList = null;
        private boolean isSyncEnabled = false;

        public Action(Long loginId, ArrayList domainList, ArrayList list, ArrayList attributeList, NativeListener li, Hashtable map, String s, Hashtable excludeChildOUHash, boolean isSyncEnabled) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.excludeChildOUHash = excludeChildOUHash;
            this.dnDomainNameMap = map;
            this.trustee = s;
            this.domainList = domainList;
            this.isSyncEnabled = isSyncEnabled;
        }

        @Override
        public void run() {
            GetProxyUsersListener.this.guidList = new ArrayList();
            Hashtable tableProps = GetProxyUsersListener.this.getQueueProps();
            String key = "";
            Hashtable<String, String> domainKey = new Hashtable<String, String>();
            if (this.isSyncEnabled) {
                this.attributeList = ADSyncUtil.getNonSyncAttributes((ArrayList)this.attributeList);
                for (int i = 0; i < this.domainList.size(); ++i) {
                    key = DomainHandler.doReportSync((String)((String)this.domainList.get(i)), (Long)CommonUtil.ADMIN_LOGIN_ID, (String[])new String[]{"user", "group", "computer", "contact", "groupMember", "primaryGroup"});
                    domainKey.put(key, (String)this.domainList.get(i));
                }
            }
            ArrayList objectIds = GetProxyUsersListener.this.getObjIdList();
            GetProxyUsersListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, GetProxyUsersListener.this.getTableColumns());
            GetProxyUsersListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(GetProxyUsersListener.this.resultTableName);
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    GetProxyUsersListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    tableProps.put("domainName", GetProxyUsersListener.this.domainName);
                    GetProxyUsersListener.this.queue.registerForUpdation(GetProxyUsersListener.this.baseTableName, GetProxyUsersListener.this.generationId, tableProps);
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    AbstractListener.reportLogger.log(Level.INFO, "Datas for the Report ID " + GetProxyUsersListener.this.reportId + ", Attribute List : " + this.attributeList + ", Trustee : " + this.trustee + " Distinguished Name : " + dn);
                    GetProxyUsersListener.this.doAction(GetProxyUsersListener.this.domainName, this.loginId, dn, this.trustee, this.attributeList, this.listener);
                    GetProxyUsersListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    GetProxyUsersListener.this.errorMessage = e.getMessage(GetProxyUsersListener.this.rb);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GetProxyUsersListener.this.errorMessage = e.getMessage();
                }
            }
            GetProxyUsersListener.this.updatedCount = 0;
            GetProxyUsersListener.this.totalCount = 0;
            if (!domainKey.isEmpty()) {
                String syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                while (GetProxyUsersListener.this.continueAction && syncStatus.equalsIgnoreCase("false")) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                }
            }
            GetProxyUsersListener.this.completedAction();
        }
    }
}

