/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.GroupUsersListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GroupNotUsersListener
extends GroupUsersListener {
    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.grp_reports.users_not_in_group.text.users_not_in_group_of"), args);
    }

    @Override
    public boolean isResultViewOutputFilterAvailable() {
        return true;
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.group_report.text.showing_group_of";
    }

    @Override
    public void doAction(String domainName, Long loginId, String dn, String group, ArrayList attributeList, NativeListener listener) throws Exception {
        ADHandler.getUsersNotInGroup((String)domainName, (Long)loginId, (String)dn, (String)group, (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, ReportReqParams reqParams, Criteria crit) {
        JSONArray rvcFiltersArray = reqParams.getRvcFilters();
        try {
            String columnName = "INPUT_ID";
            if (rvcFiltersArray != null && rvcFiltersArray.length() > 0) {
                String[] inputFiltervalues = new String[rvcFiltersArray.length()];
                for (int index = 0; index < rvcFiltersArray.length(); ++index) {
                    JSONObject rvcFilterObject = (JSONObject)rvcFiltersArray.get(index);
                    Iterator iterator = rvcFilterObject.keys();
                    while (iterator.hasNext()) {
                        String inputId;
                        inputFiltervalues[index] = inputId = (String)iterator.next();
                        Hashtable errorValues = (Hashtable)this.errorList.get(inputId);
                        if (errorValues == null) continue;
                        if (this.errorMessage == null) {
                            this.errorMessage = (String)errorValues.get("ERROR_MESSAGE");
                            continue;
                        }
                        if (this.errorMessage.contains((String)errorValues.get("ERROR_MESSAGE"))) continue;
                        this.errorMessage = this.errorMessage + "," + (String)errorValues.get("ERROR_MESSAGE");
                    }
                }
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8));
            }
        }
        catch (JSONException jsonEx) {
            jsonEx.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return crit;
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit, String inputId) {
        try {
            String columnName = "INPUT_ID";
            ArrayList inputObjects = (ArrayList)bean.get("inputObjects");
            crit = !inputObjects.contains(inputId) && inputObjects.size() != 0 ? (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0))) : (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            ArrayList containerList = this.getContainerList(request, bean);
            String dn = request.getParameter("domains");
            String groupName = request.getParameter("gnameStr");
            String domainName = null;
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            if (dn != null) {
                domainName = (String)dnDomainNameMap.get(dn);
            } else {
                Properties domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            }
            this.getDescription(new Object[]{groupName, domainName});
            Action action = new Action(loginId, containerList, reportInputParams, this.getAttributeList(), this, dnDomainNameMap);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            this.isCompleted = false;
            String sidStr = "";
            String groupName = "";
            Long scheduleId = reportFilterConfig.getScheduleId();
            String inputTableName = "ADSMReportObjectDNDetails";
            DataObject dataObject = ListenerUtil.getInputIdForSchedulerReportResult(this.reportId, scheduleId, inputTableName);
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (!admpInput.getIsMultiple().booleanValue()) continue;
                for (FcOption fcOption : admpInput.getMultipleInput()) {
                    if (fcOption.getLabel().equalsIgnoreCase("SID_STRING")) {
                        sidStr = fcOption.getValue();
                        continue;
                    }
                    if (!fcOption.getLabel().equalsIgnoreCase("NAME")) continue;
                    groupName = fcOption.getValue();
                }
            }
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            this.domainName = (String)dnDomainNameMap.get(containerList.get(0));
            if (this.domainName != null) {
                String dn = UserHandler.getUserDN((String)this.domainName, (String)sidStr, (Long)this.loginId);
                if (dn == null) {
                    dn = "";
                }
                String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
                this.desc = MessageFormat.format(this.rb.getString("admp.reports.grp_reports.users_not_in_group.text.users_not_in_group_of"), groupName, schedulerDomains);
                Hashtable<String, Object> inputs = new Hashtable<String, Object>();
                inputs.put("INPUT_NAME", groupName);
                inputs.put("DISTINGUISHED_NAME", dn);
                inputs.put("REPORT_GENERATION_ID", this.generationId);
                Row row = dataObject.getRow(inputTableName, new Criteria(Column.getColumn((String)inputTableName, (String)"SID_STRING"), (Object)sidStr, 0));
                inputs.put("INPUT_ID", row.get("UNIQUE_VALUE_MAPPING"));
                ArrayList<Hashtable<String, Object>> inputList = new ArrayList<Hashtable<String, Object>>();
                inputList.add(inputs);
                HashMap<String, ArrayList<Hashtable<String, Object>>> reportInputParams = new HashMap<String, ArrayList<Hashtable<String, Object>>>();
                reportInputParams.put("trusteesList", inputList);
                Action action = new Action(1L, containerList, reportInputParams, this.getAttributeList(), this, dnDomainNameMap);
                action.start();
                while (!this.isCompleted) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        ArrayList trusteesList = (ArrayList)bean.get("trusteesList");
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String[] domainList = (String[])bean.get("domains");
        ArrayList valuesList = new ArrayList();
        for (int i = 0; i < trusteesList.size(); ++i) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            Properties prop = GroupNotUsersListener.getGroupProp((String)trusteesList.get(i), (String)dnDomainNameMap.get(domainList[0]));
            String inputName = (String)prop.get("GROUP_NAME");
            inputs.put("INPUT_NAME", inputName);
            String dn = (String)prop.get("DISTINGUISHED_NAME");
            inputs.put("DISTINGUISHED_NAME", dn);
            inputs.put("INPUT_OBJECT_ID", (String)trusteesList.get(i));
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    public static Properties getGroupProp(String guid, String domainName) {
        Properties prop = new Properties();
        try {
            String tableName = "ADSMGroupGeneralDetails";
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)guid, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow(tableName);
                prop.put("GROUP_NAME", (String)r.get("GROUP_NAME"));
                prop.put("DISTINGUISHED_NAME", (String)r.get("DISTINGUISHED_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    @Override
    public void updateUI(String str) {
        ++this.updatedCount;
        if (this.out != null) {
            this.updateOutList();
            boolean flush = true;
            if (this.updatedCount <= 25 && str != null) {
                this.out.write("<script>if(this.load) updateUI(" + str + ")</script>");
            }
            if (this.updatedCount < 5000) {
                this.out.write("<script>updateCount(" + this.updatedCount + ")</script>");
            } else if (this.updatedCount % 100 == 0) {
                this.out.write("<script>updateCount(" + this.updatedCount + ")</script>");
            } else {
                flush = false;
            }
            if (flush) {
                this.out.flush();
            }
        } else if (str != null) {
            this.updateList.add("<script>updateUI(" + str + ")</script>");
        }
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private Map inputParams = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList containerList, Map inputParams, ArrayList attributeList, NativeListener li, Hashtable map) {
            this.loginId = loginId;
            this.containerList = containerList;
            this.inputParams = inputParams;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
        }

        @Override
        public void run() {
            GroupNotUsersListener.this.guidList = new ArrayList();
            Hashtable tableProps = GroupNotUsersListener.this.getQueueProps();
            ArrayList objectIds = GroupNotUsersListener.this.getObjIdList();
            GroupNotUsersListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, GroupNotUsersListener.this.getTableColumns());
            GroupNotUsersListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(GroupNotUsersListener.this.resultTableName);
            ArrayList inputsList = (ArrayList)this.inputParams.get("trusteesList");
            for (int i = 0; i < inputsList.size(); ++i) {
                Hashtable inputValues = (Hashtable)inputsList.get(i);
                for (int j = 0; j < this.containerList.size(); ++j) {
                    try {
                        String dn = (String)this.containerList.get(j);
                        GroupNotUsersListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                        GroupNotUsersListener.this.setDomainName(GroupNotUsersListener.this.domainName);
                        tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                        GroupNotUsersListener.this.addlResultIps.put("INPUT_ID", (Long)inputValues.get("INPUT_ID"));
                        GroupNotUsersListener.this.queue.registerForUpdation(GroupNotUsersListener.this.baseTableName, GroupNotUsersListener.this.generationId, tableProps);
                        GroupNotUsersListener.this.doAction(GroupNotUsersListener.this.domainName, this.loginId, dn, (String)inputValues.get("DISTINGUISHED_NAME"), this.attributeList, this.listener);
                        GroupNotUsersListener.this.updateQueue();
                        continue;
                    }
                    catch (LocalizedException e) {
                        e.printStackTrace();
                        GroupNotUsersListener.this.errorMessage = e.getMessage(GroupNotUsersListener.this.rb);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        GroupNotUsersListener.this.errorMessage = e.getMessage();
                    }
                }
            }
            GroupNotUsersListener.this.updatedCount = 0;
            GroupNotUsersListener.this.totalCount = 0;
            GroupNotUsersListener.this.completedAction();
        }
    }
}

