/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;

public class LockedOutUsersListener
extends AbstractListener {
    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public ArrayList getDBCustomizedValues(String columnName, String ldapName, Properties prop) {
        ArrayList<Long> ret = super.getDBCustomizedValues(columnName, ldapName, prop);
        if (columnName.equalsIgnoreCase("BAD_PASSWORD_COUNT")) {
            ret = new ArrayList<Long>();
            ArrayList badPwdCount = (ArrayList)prop.get("badPwdCount");
            if (badPwdCount != null) {
                ret.add(new Long((String)badPwdCount.get(0)));
            } else {
                ret.add(new Long(0L));
            }
        }
        return ret;
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        ArrayList psoList = PolicyHandler.getPSObjects((String)domainName);
        long domLockDur = -1L;
        try {
            domLockDur = Long.parseLong(PolicyHandler.getPolicyProp((String)domainName, (Long)loginId, (String)"lockoutDuration"));
        }
        catch (Exception e) {
            e.printStackTrace();
            domLockDur = -1L;
        }
        if (domLockDur != -1L) {
            ADHandler.getLockedOutAccounts((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (ArrayList)psoList, (long)domLockDur, (NativeListener)listener);
        } else {
            reportLogger.log(Level.INFO, "Error in Getting Locked Out Accounts");
        }
    }
}

