/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LogonHourListener
extends AbstractListener {
    long[] dayByte = new long[]{20L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L};

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.user_reports.logon_hour_based.reportdesc_user_logon_perm_hrs"), args);
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        String[] inputValues = request.getParameterValues(key);
        ArrayList valuesList = new ArrayList();
        for (int i = 0; i < inputValues.length; ++i) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            inputs.put("INPUT_PROPERTY_NAME", key);
            inputs.put("INPUT_PROPERTY_VALUE", inputValues[i]);
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String[] days = new String[]{rb.getString("reports.logonhours.sunday"), rb.getString("reports.logonhours.monday"), rb.getString("reports.logonhours.tuesday"), rb.getString("reports.logonhours.wednesday"), rb.getString("reports.logonhours.thursday"), rb.getString("reports.logonhours.friday"), rb.getString("reports.logonhours.saturday")};
        System.out.println("LOGON ATTRIBUTE LIST " + attributeList);
        attributeList.add("logonHours");
        int logonAllowed = 1;
        String logonValue = null;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            HashMap<String, String> inputParams = new HashMap<String, String>();
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            String[] selectedDays = request.getParameterValues("days");
            StringBuffer str = new StringBuffer();
            for (int j = 0; j < selectedDays.length; ++j) {
                if (str.length() > 0) {
                    str.append(",");
                }
                str.append(selectedDays[j]);
            }
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            inputParams.put("days", str.toString());
            ArrayList<Properties> checkList = new ArrayList<Properties>();
            int startHours = 0;
            int endHours = 0;
            boolean dayByteCount = false;
            String startStr = request.getParameter("From");
            String endStr = request.getParameter("To");
            startHours = Integer.parseInt(startStr);
            endHours = Integer.parseInt(endStr);
            inputParams.put("From", String.valueOf(startHours));
            inputParams.put("To", String.valueOf(endHours));
            if (startHours == 24) {
                startHours = 0;
            }
            Long zoneBias = ADHandler.getTimezone();
            float zoneBiasHours = zoneBias.floatValue() / 60.0f;
            System.out.println("Logon Hrs zoneBiasHours: " + zoneBiasHours);
            int timeZoneBias = Math.round(zoneBiasHours);
            System.out.println("Logon Hrs timeZoneBias rounded: " + timeZoneBias);
            int startingDayByte = 0;
            startingDayByte = timeZoneBias < 0 ? (timeZoneBias < -8 ? 19 : 20) : (timeZoneBias >= 8 ? 1 : 0);
            int dayByte = startingDayByte;
            for (int i = 0; i < days.length; ++i) {
                boolean selected = false;
                for (int j = 0; j < selectedDays.length; ++j) {
                    if (!selectedDays[j].equals(days[i])) continue;
                    selected = true;
                }
                for (int hour = 0; hour < 24; ++hour) {
                    int timeBit = (hour + timeZoneBias + 16) % 8;
                    if (timeBit == 0 & hour != 0 || timeZoneBias % 8 == 0 & hour == 0 & i != 0) {
                        ++dayByte;
                    }
                    if (dayByte == 21) {
                        dayByte -= 21;
                    }
                    if (!selected || hour < startHours || hour >= endHours) continue;
                    Properties p = new Properties();
                    p.put("timeBit", new Long(timeBit));
                    p.put("dayByte", (Object)dayByte);
                    checkList.add(p);
                }
            }
            String logonStr = request.getParameter("logonAllowed");
            logonAllowed = Integer.parseInt(logonStr);
            logonValue = logonAllowed == 0 ? rb.getString("admp.reports.user_reports.logon_hour_based.desc.denied") : rb.getString("admp.reports.user_reports.logon_hour_based.desc.allowed");
            inputParams.put("logonPermit", logonValue);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{logonValue, str.toString(), String.valueOf(startHours), String.valueOf(endHours), reportDomains});
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(loginId, containerList, attributeList, checkList, logonAllowed, this, dnDomainNameMap, excludeContainerHash);
            action.start();
            bean.set("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private ArrayList checkList = null;
        private int value = 0;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Hashtable excludeChildOUHash = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, ArrayList checkList, int value, NativeListener li, Hashtable map, Hashtable excludeChildOUHash) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.checkList = checkList;
            this.excludeChildOUHash = excludeChildOUHash;
            this.value = value;
            this.listener = li;
            this.dnDomainNameMap = map;
        }

        @Override
        public void run() {
            LogonHourListener.this.guidList = new ArrayList();
            Hashtable tableProps = LogonHourListener.this.getQueueProps();
            ArrayList objectIds = LogonHourListener.this.getObjIdList();
            LogonHourListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, LogonHourListener.this.getTableColumns());
            LogonHourListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(LogonHourListener.this.resultTableName);
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    LogonHourListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    ADHandler.getLogonHourReports((String)LogonHourListener.this.domainName, (Long)this.loginId, (String)dn, (ArrayList)this.attributeList, (NativeListener)this.listener, (ArrayList)this.checkList, (int)this.value);
                    LogonHourListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    LogonHourListener.this.errorMessage = e.getMessage(LogonHourListener.this.rb);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LogonHourListener.this.errorMessage = e.getMessage();
                }
            }
            LogonHourListener.this.updatedCount = 0;
            LogonHourListener.this.totalCount = 0;
            LogonHourListener.this.completedAction();
        }
    }
}

