/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueUtil;
import com.adventnet.sym.adsm.common.server.reports.ComputerHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.FileServerMgmtUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractNTFSReportsListener;
import com.adventnet.sym.adsm.common.webclient.reports.DBWriterUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.reports.TableUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NTFSReportsListener
extends AbstractNTFSReportsListener {
    HashSet<String> locationList = new HashSet();
    String session1;
    Integer[] advancedPermissionValues = new Integer[]{32, 1, 128, 8, 2, 4, 256, 16, 64, 65536, 131072, 262144, 524288};
    ArrayList<Long> selectedPermissionsMask = new ArrayList();
    String directoryPath;
    boolean isNonInheritableFolders = false;

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(-1L);
        return categoryId;
    }

    @Override
    public boolean isResultViewOutputFilterAvailable() {
        return true;
    }

    @Override
    public boolean isPermissionColumnIncluded() {
        return true;
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.folder_report.text.showing_folder_of";
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    protected void doAction(String domainName, Long loginId, String dn, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    protected void doAction(String domainName, String directoryPath, String userDn, Long loginId, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    protected void doAction(String domainName, String directoryPath, String userDn, Long loginId, ArrayList attributeList, String permValue, int folderLevel, NativeListener listener) throws Exception {
        ADHandler.getFilesOverAnyControl((String)domainName, (String)directoryPath, (String)userDn, (Long)loginId, (ArrayList)attributeList, (String)permValue, (int)folderLevel, (NativeListener)listener);
    }

    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit) {
        try {
            String columnName = "INPUT_ID";
            ArrayList<String> inputObjects = (ArrayList<String>)bean.get("inputObjects");
            String[] inputFiltervalues = request.getParameterValues("inputs");
            if (inputFiltervalues != null) {
                inputObjects = new ArrayList<String>();
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8));
                for (int i = 0; i < inputFiltervalues.length; ++i) {
                    inputObjects.add(inputFiltervalues[i]);
                    Hashtable errorValues = (Hashtable)this.errorList.get(inputFiltervalues[i]);
                    if (errorValues == null) continue;
                    if (this.errorMessage == null) {
                        this.errorMessage = (String)errorValues.get("ERROR_MESSAGE");
                        continue;
                    }
                    if (this.errorMessage.contains((String)errorValues.get("ERROR_MESSAGE"))) continue;
                    this.errorMessage = this.errorMessage + "," + (String)errorValues.get("ERROR_MESSAGE");
                }
                bean.set("inputObjects", inputObjects);
            } else if (!inputObjects.isEmpty()) {
                String[] inputValues = new String[inputObjects.size()];
                for (int i = 0; i < inputObjects.size(); ++i) {
                    inputValues[i] = (String)inputObjects.get(i);
                }
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputValues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputValues, 8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit, String inputId) {
        try {
            String columnName = "INPUT_ID";
            ArrayList inputObjects = (ArrayList)bean.get("inputObjects");
            crit = !inputObjects.contains(inputId) && inputObjects.size() != 0 ? (crit == null ? new Criteria(Column.getColumn((String)this.resultTableName, (String)columnName), (Object)0L, 0) : crit.and(new Criteria(Column.getColumn((String)this.resultTableName, (String)columnName), (Object)0L, 0))) : (crit == null ? new Criteria(Column.getColumn((String)this.resultTableName, (String)columnName), (Object)inputId, 0) : new Criteria(Column.getColumn((String)this.resultTableName, (String)columnName), (Object)inputId, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String[] domainList = (String[])bean.get("domains");
        ArrayList valuesList = new ArrayList();
        if (inputTable.equalsIgnoreCase("ADSMReportSIDInputDetails")) {
            ArrayList trusteesList = (ArrayList)bean.get("trusteesList");
            for (int i = 0; i < trusteesList.size(); ++i) {
                Hashtable<String, Object> inputs = new Hashtable<String, Object>();
                String inputName = CommonUtil.getDisplayName((String)((String)dnDomainNameMap.get(domainList[0])), (String)((String)trusteesList.get(i)));
                if (inputName != null) {
                    inputs.put("INPUT_NAME", inputName);
                } else {
                    System.out.println("Unable to get inputName from SID table for the trustee: " + (String)trusteesList.get(i));
                    inputs.put("INPUT_NAME", "-");
                }
                String dn = CommonUtil.getDistinguishedName((String)((String)dnDomainNameMap.get(domainList[0])), (String)((String)trusteesList.get(i)));
                inputs.put("DISTINGUISHED_NAME", dn);
                inputs.put("INPUT_OBJECT_ID", (String)trusteesList.get(i));
                inputs.put("REPORT_GENERATION_ID", this.generationId);
                ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
                valuesList.add(inputs);
            }
        } else if (inputTable.equalsIgnoreCase("ADSMReportShareInputDetails")) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            String sharePath = request.getParameter(key);
            String sid = request.getParameter("serverSid");
            inputs.put("SERVER_SID", sid);
            inputs.put("INPUT_NAME", sharePath);
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        } else if (key.equalsIgnoreCase("folderLevel")) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            String searchPath = request.getParameter("searchPath");
            String folderLevel = request.getParameter(key);
            if (!searchPath.equalsIgnoreCase("CustomLevel")) {
                folderLevel = searchPath;
            }
            inputs.put("INPUT_PROPERTY_NAME", key);
            inputs.put("INPUT_PROPERTY_VALUE", folderLevel);
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    public NTFSReportsListener() {
        this.tableKey = "SHARE_ID";
        this.tempTableKey = "LOCATION";
        this.attrKey = "Location";
        this.attrKey2 = "Location";
    }

    @Override
    public void init(Row r) {
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        if (this.rb == null) {
            this.rb = ResourceBundleMgr.getInstance().getBundle();
        }
        this.title = (String)r.get("REPORT_NAME");
    }

    @Override
    public ArrayList getSubreportDetails() {
        ArrayList<Properties> propList = new ArrayList<Properties>();
        Properties prop = new Properties();
        prop.put("SUBREPORT_ID", "1");
        prop.put("NAME", "NTFS");
        prop.put("FILE_NAME", "SubReportDesign.xml");
        prop.put("HEADING", "admp.subreports.heading.ntfs_permissions");
        propList.add(prop);
        prop = new Properties();
        prop.put("SUBREPORT_ID", "2");
        prop.put("NAME", "SHARE");
        prop.put("FILE_NAME", "SubReportDesign.xml");
        prop.put("HEADING", "admp.subreports.heading.share_permissions");
        propList.add(prop);
        return propList;
    }

    @Override
    public ArrayList getSubReportAttributes(String subReportId) {
        Integer[] attrIds;
        Integer[] subAttrs1 = new Integer[]{11162, 11161, 11163, 11164, 11165};
        Integer[] subAttrs2 = new Integer[]{11162, 11161, 11163, 11164};
        Hashtable<String, Integer[]> attrs = new Hashtable<String, Integer[]>();
        attrs.put("1", subAttrs1);
        attrs.put("2", subAttrs2);
        ArrayList<Properties> attributePropsList = new ArrayList<Properties>();
        for (Integer attrId : attrIds = (Integer[])attrs.get(subReportId)) {
            Properties props = ReportAttributeHandler.getInstance().getAttributeProps(attrId);
            attributePropsList.add(props);
        }
        return attributePropsList;
    }

    @Override
    public void updateAttributeList(ReportBean bean, ArrayList attributeList) {
        HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
        ArrayList pathList = (ArrayList)reportInputParams.get("path");
        String[] domains = (String[])bean.get("domains");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        if (pathList != null && !pathList.isEmpty()) {
            Hashtable searchPathValues = (Hashtable)pathList.get(0);
            String sid = (String)searchPathValues.get("SERVER_SID");
            String generatedTableName = ComputerHandler.getName((String)sid, (String)((String)searchPathValues.get("INPUT_NAME")), (String)((String)dnDomainNameMap.get(domains[0])));
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties prop = (Properties)attributeList.get(i);
                String tableName = prop.getProperty("TABLE_NAME");
                if (!tableName.equalsIgnoreCase("ADSMFolderDetails")) continue;
                prop.put("TABLE_NAME", generatedTableName);
            }
            this.baseTableName = generatedTableName;
        }
    }

    @Override
    public void init(HttpServletRequest request, Row r) {
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
        this.setGenerationId(request);
    }

    @Override
    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties uiValues, Hashtable stringRowMap) {
        try {
            Object values = null;
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(this.reportId);
            int baseTableIndex = tableNames.indexOf(this.baseTableName);
            if (baseTableIndex > 0) {
                tableNames.remove(baseTableIndex);
                tableNames.add(0, this.baseTableName);
            }
            ArrayList aclsList = new ArrayList();
            ArrayList pList = (ArrayList)prop.get("Location");
            String Loc = (String)pList.get(0);
            String[] keyProps = new String[]{"FOLDER_LOCATION", "ACE_TYPE", "SECURITY_PRINCIPAL", "PERMISSION", "APPLIES_TO", "SESSION_ID", "INHERITED_ACE", "TRUSTEE_SID"};
            for (int i = 0; i < tableNames.size(); ++i) {
                ArrayList writerTableList;
                String tableName = (String)tableNames.get(i);
                ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributes(tableName, this.reportId);
                if (tableName.equalsIgnoreCase("ADSMFolderDetails")) {
                    tableName = this.baseTableName;
                }
                if ((writerTableList = ReportAttributeHandler.getInstance().getWriterTables()) != null && writerTableList.contains(tableName)) {
                    DBWriterUtil.createStringRows(tableName, attributeList, stringRowMap, prop, uiValues, this, this.tableKey, guid);
                } else {
                    this.createRows(tableName, attributeList, tableRowMap, relationalTableRowMap, prop, uiValues, this.tableKey, guid);
                }
                ArrayList folderAclsList = new ArrayList();
                ArrayList shareAclsList = new ArrayList();
                if (this.locationList.contains(Loc) || this.isNonInheritableFolders) continue;
                this.locationList.add(Loc);
                folderAclsList = ADHandler.getFolderPermissions((String)this.domainName, (Long)this.loginId, (String)Loc);
                shareAclsList = ADHandler.getSharePermissions((String)this.domainName, (Long)this.loginId, (String)Loc);
                this.updateStringRowMaps(folderAclsList, shareAclsList, stringRowMap, Loc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateStringRowMaps(ArrayList folderAclsList, ArrayList shareAclsList, Hashtable stringRowMap, String loc) {
        String keyProps = "FOLDER_LOCATION,ACE_TYPE,SECURITY_PRINCIPAL,PERMISSIONS,APPLIES_TO,SESSION_ID,INHERITED_ACE,TRUSTEE_SID";
        StringBuffer singleRowBuff = null;
        ArrayList<String> multipleTableRowList = new ArrayList<String>();
        if (!folderAclsList.isEmpty()) {
            for (int i = 0; i < folderAclsList.size(); ++i) {
                Properties props1 = (Properties)folderAclsList.get(i);
                singleRowBuff = new StringBuffer();
                singleRowBuff.append(loc);
                singleRowBuff.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff.append(this.rb.getString((String)props1.get("aceType")));
                singleRowBuff.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff.append(props1.get("trustee"));
                singleRowBuff.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                Object object = props1.get("permission");
                singleRowBuff.append(ReportResultUtil.splitPermissions(object, this.rb));
                singleRowBuff.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff.append(this.rb.getString((String)props1.get("appliesTo")));
                singleRowBuff.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff.append(this.generationId);
                singleRowBuff.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff.append(this.rb.getString((String)props1.get("inheritedAce")));
                singleRowBuff.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff.append(props1.get("sid"));
                multipleTableRowList.add(singleRowBuff.toString());
            }
            Hashtable<String, Object> colVsRowsMap = new Hashtable<String, Object>();
            colVsRowsMap.put("ColumnOrder", keyProps);
            colVsRowsMap.put("Rows", multipleTableRowList);
            stringRowMap.put("ADSMFolderACLs", colVsRowsMap);
        }
        ArrayList<String> multipleTableRowList2 = new ArrayList<String>();
        Hashtable<String, Object> colVsRowsMap2 = null;
        StringBuffer singleRowBuff2 = null;
        if (!shareAclsList.isEmpty()) {
            for (int i = 0; i < shareAclsList.size(); ++i) {
                Properties props2 = (Properties)shareAclsList.get(i);
                singleRowBuff2 = new StringBuffer();
                singleRowBuff2.append(loc);
                singleRowBuff2.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff2.append(this.rb.getString((String)props2.get("aceType")));
                singleRowBuff2.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff2.append(props2.get("trustee"));
                singleRowBuff2.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                Object object = props2.get("permission");
                singleRowBuff2.append(ReportResultUtil.splitPermissions(object, this.rb));
                singleRowBuff2.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff2.append(this.rb.getString((String)props2.get("appliesTo")));
                singleRowBuff2.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff2.append(this.generationId);
                singleRowBuff2.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff2.append(this.rb.getString((String)props2.get("inheritedAce")));
                singleRowBuff2.append(QueueUtil.COPY_FILE_TO_DB_DELIMITER);
                singleRowBuff2.append(props2.get("sid"));
                multipleTableRowList2.add(singleRowBuff2.toString());
            }
            colVsRowsMap2 = new Hashtable<String, Object>();
            colVsRowsMap2.put("ColumnOrder", keyProps);
            colVsRowsMap2.put("Rows", multipleTableRowList2);
            stringRowMap.put("ADSMShareACLs", colVsRowsMap2);
        }
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "updateMultiValues");
        tableProps.put("tableKey", "LOCATION");
        return tableProps;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            this.session1 = session.getId();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            this.directoryPath = request.getParameter("path");
            String sid = request.getParameter("serverSid");
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            String dn = request.getParameter("domains");
            String domainName = null;
            if (dn != null) {
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                domainName = (String)dnDomainNameMap.get(dn);
            } else {
                Properties domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            }
            Action action = new Action(loginId, domainName, reportInputParams, attributeList, sid, this);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updatetables() {
        try {
            String[] keyProps = new String[]{"FOLDER_LOCATION", "ACE_TYPE", "SECURITY_PRINCIPAL", "PERMISSIONS", "APPLIES_TO", "SESSION_ID", "INHERITED_ACE", "TRUSTEE_SID"};
            ArrayList aclsList = new ArrayList();
            if (!this.locationList.isEmpty()) {
                this.locationList.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateQueue() {
        try {
            while (!this.queue.isCompleted(this.generationId)) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public SelectQuery getSelectQuery(ArrayList attrList, String location, String type) {
        String tableName = "ADSMFolderACLs";
        ArrayList groupList = new ArrayList();
        tableName = type == null || type.equalsIgnoreCase("ntfs") ? "ADSMFolderACLs" : "ADSMShareACLs";
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
        Criteria c = null;
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < attrList.size(); ++i) {
            Properties p = (Properties)attrList.get(i);
            String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
            if (i == 0) {
                SortColumn sc = new SortColumn(tableName, columnName, true);
                sq.addSortColumn(sc);
            }
            columnNames.add(columnName);
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)columnName));
        }
        if (!columnNames.contains("FOLDER_LOCATION")) {
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"FOLDER_LOCATION"));
        }
        if (!columnNames.contains("ACE_TYPE")) {
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"ACE_TYPE"));
        }
        if (!columnNames.contains("ACLS_ID")) {
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"ACLS_ID"));
        }
        if (!columnNames.contains("SESSION_ID")) {
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"SESSION_ID"));
        }
        if (!columnNames.contains("TRUSTEE_SID")) {
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"TRUSTEE_SID"));
        }
        if (!columnNames.contains("INHERITED_ACE")) {
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"INHERITED_ACE"));
        }
        if (location != null) {
            c = new Criteria(Column.getColumn((String)tableName, (String)"FOLDER_LOCATION"), (Object)location, 0);
            c = c.and(new Criteria(Column.getColumn((String)tableName, (String)"SESSION_ID"), (Object)this.generationId, 0));
            if (type != null) {
                c = c.and(new Criteria(Column.getColumn((String)tableName, (String)"PERMISSIONS"), (Object)" ", 1));
            }
            sq.setCriteria(c);
        }
        return sq;
    }

    @Override
    public ArrayList getExportData(ArrayList sharesList, ArrayList attributeList, ArrayList subReportList) {
        ArrayList resultList = new ArrayList();
        for (int k = 0; k < sharesList.size(); ++k) {
            Properties attrProp;
            int i;
            Hashtable shareProp = (Hashtable)sharesList.get(k);
            ArrayList<Object> data = new ArrayList<Object>();
            for (i = 0; i < attributeList.size(); ++i) {
                attrProp = (Properties)attributeList.get(i);
                Integer attribId = (Integer)attrProp.get("ATTRIB_ID");
                if (attribId == 9054 || attribId == 9056 || attribId == 9057) {
                    String time = DateTimeUtil.getDateFromFileTime((Long)Long.parseLong((String)shareProp.get(attribId)), (Long)this.loginId);
                    data.add(time);
                    continue;
                }
                data.add((String)shareProp.get(attribId));
            }
            for (i = 0; i < subReportList.size(); ++i) {
                attrProp = (Properties)subReportList.get(i);
                ArrayList subAttributeList = (ArrayList)attrProp.get("ATTRIBUTE_LIST");
                String type = (String)attrProp.get("NAME");
                String location = (String)shareProp.get(9051);
                SelectQuery sq = this.getSelectQuery(subAttributeList, location, type);
                Hashtable<String, Object> ht = new Hashtable<String, Object>();
                ht.put("sq", sq);
                ht.put("attr", subAttributeList);
                if (type.equalsIgnoreCase("ntfs")) {
                    ht.put("table", "ADSMFolderACLs");
                } else {
                    ht.put("table", "ADSMShareACLs");
                }
                data.add(ht);
            }
            resultList.add(data);
        }
        return resultList;
    }

    @Override
    public void exportReport(Row reportDetails, String reportType, ArrayList attributelist, Map inputParams, HttpServletRequest request, HttpServletResponse response, String reportList, AbstractListener listener, ArrayList trusteesList, ReportReqParams reqParams) {
        Boolean permPresent = false;
        for (int i = 0; i < attributelist.size(); ++i) {
            Properties attributeProp = (Properties)attributelist.get(i);
            String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
            if (!columnName.equalsIgnoreCase("NTFS_PERMISSION")) continue;
            permPresent = true;
            attributelist.remove(i);
            break;
        }
        if (permPresent.booleanValue()) {
            ReportExportUtil.exportReportWithSubReport1(reportDetails, reportType, attributelist, inputParams, request, response, reportList, listener, trusteesList, reqParams);
        } else {
            ReportExportUtil.exportReportForHugeData(reportDetails, reportType, attributelist, inputParams, request, response, reportList, listener, trusteesList, reqParams);
        }
    }

    public class Action
    extends Thread {
        private String domainName = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Map inputParams = null;
        private Long loginId = null;
        private String serverSid = null;

        public Action(Long loginId, String domainName, Map inputParams, ArrayList attributeList, String serverSid, NativeListener li) {
            this.domainName = domainName;
            this.loginId = loginId;
            this.attributeList = attributeList;
            this.listener = li;
            this.serverSid = serverSid;
            this.inputParams = inputParams;
        }

        @Override
        public void run() {
            NTFSReportsListener.this.errorMessage = null;
            if (!NTFSReportsListener.this.errorList.isEmpty()) {
                NTFSReportsListener.this.errorList = new Hashtable();
            }
            ArrayList searchPath = (ArrayList)this.inputParams.get("path");
            int folderLevel = -1;
            if (this.inputParams.containsKey("folderLevel")) {
                ArrayList folderLevelList = (ArrayList)this.inputParams.get("folderLevel");
                Hashtable folderLevelValues = (Hashtable)folderLevelList.get(0);
                String folderLevelStr = (String)folderLevelValues.get("INPUT_PROPERTY_VALUE");
                folderLevel = Integer.parseInt(folderLevelStr);
            }
            HashMap serverVsShares = ComputerHandler.getSharesListForServers((ArrayList)searchPath, (Long)this.loginId, (String)this.domainName);
            Hashtable searchPathValues = (Hashtable)searchPath.get(0);
            NTFSReportsListener.this.baseTableName = ComputerHandler.getName((String)this.serverSid, (String)((String)searchPathValues.get("INPUT_NAME")), (String)this.domainName);
            TableUtil.createServerTable(NTFSReportsListener.this.baseTableName, "ADSMFolderDetails");
            Hashtable tableProps = NTFSReportsListener.this.getQueueProps();
            if (this.inputParams.containsKey("trusteesList")) {
                NTFSReportsListener.this.isNonInheritableFolders = false;
                String pathName = (String)searchPathValues.get("INPUT_NAME");
                ArrayList<String> sharesList = new ArrayList<String>();
                if (serverVsShares.containsKey(pathName)) {
                    sharesList.addAll((ArrayList)serverVsShares.get(pathName));
                } else {
                    sharesList.add(pathName);
                }
                ArrayList inputsList = (ArrayList)this.inputParams.get("trusteesList");
                ArrayList permValue = (ArrayList)this.inputParams.get("permValue");
                Hashtable permValueList = (Hashtable)permValue.get(0);
                String finalPermission = "0";
                try {
                    JSONArray json = new JSONArray((String)permValueList.get("INPUT_PROPERTY_VALUE"));
                    JSONObject json1 = (JSONObject)json.get(0);
                    JSONObject json2 = (JSONObject)json1.get("accessMask");
                    Integer advancedPermVal = 0x100000;
                    NTFSReportsListener.this.selectedPermissionsMask.clear();
                    for (Integer str : NTFSReportsListener.this.advancedPermissionValues) {
                        if (!json2.has(str.toString())) continue;
                        advancedPermVal = advancedPermVal | str;
                        NTFSReportsListener.this.selectedPermissionsMask.add((long)str);
                    }
                    finalPermission = advancedPermVal.toString();
                    if (advancedPermVal.toString().equals("1048576")) {
                        finalPermission = "0";
                    }
                    if (json2.has("0")) {
                        finalPermission = "0";
                    }
                    if (permValue != null) {
                        String permissionlist = "";
                        ArrayList returnedPermissionsMask = new ArrayList();
                        returnedPermissionsMask = FileServerMgmtUtil.updatePermissionVals(NTFSReportsListener.this.selectedPermissionsMask, (Long)Long.parseLong("3"), (String)"Folder");
                        for (int i = 0; i < returnedPermissionsMask.size(); ++i) {
                            Long val = (Long)returnedPermissionsMask.get(i);
                            permissionlist = permissionlist + NTFSReportsListener.this.rb.getString(FileServerMgmtUtil.getPermissionString((Long)val, (String)"folder"));
                            if (i >= returnedPermissionsMask.size() - 1) continue;
                            permissionlist = permissionlist + ", ";
                        }
                        NTFSReportsListener.this.desc = MessageFormat.format(NTFSReportsListener.this.rb.getString("admp.reports.ntfs_reports.full_control.reportdesc_report_generated_for_server_with_perm"), NTFSReportsListener.this.directoryPath, permissionlist);
                        if (finalPermission == "0") {
                            NTFSReportsListener.this.desc = MessageFormat.format(NTFSReportsListener.this.rb.getString("admp.reports.ntfs_reports.full_control.reportdesc_report_generated_for_server_with_perm"), NTFSReportsListener.this.directoryPath, "Any");
                        }
                    } else {
                        NTFSReportsListener.this.desc = MessageFormat.format(NTFSReportsListener.this.rb.getString("admp.reports.ntfs_reports.full_control.reportdesc_report_generated_for_server"), NTFSReportsListener.this.directoryPath);
                    }
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
                for (int i = 0; i < sharesList.size(); ++i) {
                    for (int j = 0; j < inputsList.size(); ++j) {
                        Hashtable<String, String> errors;
                        Hashtable inputValues = (Hashtable)inputsList.get(j);
                        try {
                            NTFSReportsListener.this.setDomainName(this.domainName);
                            tableProps.put("domainName", this.domainName);
                            tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                            NTFSReportsListener.this.queue.registerForUpdation(NTFSReportsListener.this.baseTableName, NTFSReportsListener.this.generationId, tableProps);
                            NTFSReportsListener.this.doAction(this.domainName, (String)sharesList.get(i), (String)inputValues.get("DISTINGUISHED_NAME"), this.loginId, this.attributeList, finalPermission, folderLevel, this.listener);
                            NTFSReportsListener.this.updateQueue();
                            continue;
                        }
                        catch (LocalizedException e) {
                            e.printStackTrace();
                            NTFSReportsListener.this.errorMessage = e.getMessage(NTFSReportsListener.this.rb);
                            errors = new Hashtable<String, String>();
                            errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                            errors.put("ERROR_MESSAGE", NTFSReportsListener.this.errorMessage);
                            NTFSReportsListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                            NTFSReportsListener.this.updateErrorStatus(errors);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            NTFSReportsListener.this.errorMessage = NTFSReportsListener.this.rb.getString(e.getMessage());
                            errors = new Hashtable();
                            errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                            errors.put("ERROR_MESSAGE", NTFSReportsListener.this.errorMessage);
                            NTFSReportsListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                            NTFSReportsListener.this.updateErrorStatus(errors);
                        }
                    }
                }
            } else {
                try {
                    NTFSReportsListener.this.isNonInheritableFolders = true;
                    NTFSReportsListener.this.queue.registerForUpdation(NTFSReportsListener.this.baseTableName, NTFSReportsListener.this.generationId, tableProps);
                    NTFSReportsListener.this.doAction(this.domainName, (String)searchPathValues.get("INPUT_NAME"), null, this.loginId, this.attributeList, this.listener);
                    NTFSReportsListener.this.updateQueue();
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    NTFSReportsListener.this.errorMessage = e.getMessage(NTFSReportsListener.this.rb);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    NTFSReportsListener.this.errorMessage = e.getMessage();
                }
            }
            NTFSReportsListener.this.updatedCount = 0;
            NTFSReportsListener.this.totalCount = 0;
            NTFSReportsListener.this.completedAction();
        }
    }
}

