/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.webclient.reports.InActiveListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class NeverLogonUsersListener
extends InActiveListener {
    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1003L);
        return categoryId;
    }

    public NeverLogonUsersListener() {
        this.lastLogonTableName = "ADSMUserGeneralDetails";
        this.mgmtIds = new int[]{1004, 1144, 1143, 1023, 1006, 1145};
        this.multiDC = true;
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.user_reports.never_logged_on.reportdesc_user_never_log_to_domain"), args);
    }

    @Override
    public void doAction(Properties domainDetails, String distinguishedName, String dcName, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
        ADHandler.getNeverLogonUsers((Properties)domainDetails, (String)distinguishedName, (String)dcName, (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public String getSearchString(String filterString) {
        return "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(&(|(!lastlogon=*)(lastlogon=0))(|(!lastlogontimestamp=*)(lastlogontimestamp=0))))";
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            Hashtable reportDomains = this.getReportDomains(request, bean, loginId);
            inputParams.put("reportDomains", reportDomains);
            inputParams.put("multiDC", "true");
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            String filterString = "";
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            String reportDomain = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomain});
            this.statusController.init(reportDomains);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            InActiveListener.Action action = new InActiveListener.Action(loginId, reportDomains, attributeList, filterString, this, dnDomainNameMap, this.multiDC, excludedOUList, domainVsExcludeChildOU);
            action.start();
            bean.set("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateCount(Hashtable dcVsGuidAndBadPwdCount, String columnName, String tableName) {
    }
}

