/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractNTFSReportsListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class NonInheritableListener
extends AbstractNTFSReportsListener {
    AdventNetResourceBundle rb = null;

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(-1L);
        return categoryId;
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            this.desc = this.rb.getString("client.reports.NonInheritableListener.objects_whose_permissions_cannot_be_inherited_by_its_child_objects_in_domains");
            this.desc = this.getDescription(domainList, dnDomainNameMap);
            Action action = new Action(loginId, containerList, attributeList, this, dnDomainNameMap, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Hashtable excludeChildOUHash = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, NativeListener li, Hashtable map, Hashtable excludeChildOUHash) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.excludeChildOUHash = excludeChildOUHash;
        }

        @Override
        public void run() {
            NonInheritableListener.this.guidList = new ArrayList();
            Hashtable tableProps = NonInheritableListener.this.getQueueProps();
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    NonInheritableListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    NonInheritableListener.this.queue.registerForUpdation(NonInheritableListener.this.baseTableName, NonInheritableListener.this.generationId, tableProps);
                    System.out.println("Getting the Locked Out User Reports for the domain " + NonInheritableListener.this.domainName);
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    ADHandler.getNonInheritableobjects((String)NonInheritableListener.this.domainName, (Long)this.loginId, (String)dn, (ArrayList)this.attributeList, (NativeListener)this.listener);
                    NonInheritableListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException excep) {
                    NonInheritableListener.this.errorMessage = excep.getMessage(NonInheritableListener.this.rb);
                    System.out.println("LocalizedException in NonInheritableListener :-" + NonInheritableListener.this.errorMessage);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    NonInheritableListener.this.errorMessage = e.getMessage();
                }
            }
            NonInheritableListener.this.updatedCount = 0;
            NonInheritableListener.this.totalCount = 0;
            NonInheritableListener.this.completedAction();
        }
    }
}

