/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class O365LicenseDetails
extends DispatchAction {
    public static final Integer O365_LICENSE_SERVICES_ATTRIB_ID = 12106;
    private static Object syncObj = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward loadReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage;
        block12: {
            forwardPage = "";
            try {
                Integer reportId = Integer.parseInt(request.getParameter("reportId"));
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMReports", (String)"REPORT_ID"), (Object)reportId, 0);
                DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReports", criteria);
                Row reportRow = dataobj.getFirstRow("ADSMReports");
                Long actionId = (Long)reportRow.get("ACTION_ID");
                if (!ClientAuthorizationUtil.isAuthorized(request, actionId).booleanValue()) {
                    return new ActionForward("/404Error.do");
                }
                forwardPage = (String)reportRow.get("TILE_NAME");
                if (!reportId.equals(43)) break block12;
                Long waadAccId = -1L;
                if (request.getParameter("waadAccId") != null) {
                    waadAccId = Long.parseLong(request.getParameter("waadAccId"));
                }
                ArrayList<Properties> waadAccList = new ArrayList<Properties>();
                ArrayList waadAccDetails = new ArrayList();
                HttpSession session = request.getSession();
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                Hashtable iamAccountVsDetails = authObject.getAuthorizedIamAppAccountDetails();
                Enumeration e = iamAccountVsDetails.keys();
                while (e.hasMoreElements()) {
                    String iamAccount = (String)e.nextElement();
                    Hashtable iamAccountDetails = (Hashtable)iamAccountVsDetails.get(iamAccount);
                    if (!((Boolean)iamAccountDetails.get("isWaadAccountSelected")).booleanValue() || (Integer)iamAccountDetails.get("iamAppId") != 3) continue;
                    Properties props = new Properties();
                    props.put("WAAD_DOMAIN_ID", iamAccountDetails.get("WaadDomainId"));
                    props.put("WAAD_TENANT_ID", iamAccount);
                    waadAccList.add(props);
                }
                if (waadAccList.size() > 0) {
                    Properties props = (Properties)waadAccList.get(0);
                    Long accountId = (Long)props.get("WAAD_DOMAIN_ID");
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMWAADAccountSKUDetails", (String)"WAAD_DOMAIN_ID"), (Object)accountId, 0);
                    DataObject waadAccDetailsDO = null;
                    if (waadAccId.equals(-1L)) {
                        request.setAttribute("selWaadAccId", (Object)accountId);
                        waadAccDetailsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMWAADAccountSKUDetails", crit);
                    } else {
                        accountId = waadAccId;
                        request.setAttribute("selWaadAccId", (Object)accountId);
                        crit = new Criteria(Column.getColumn((String)"ADSMWAADAccountSKUDetails", (String)"WAAD_DOMAIN_ID"), (Object)accountId, 0);
                        Object object = syncObj;
                        synchronized (object) {
                            boolean updated = O365MgmtHandler.updateAccountSKUDetails((Long)accountId);
                            if (!updated) {
                                request.setAttribute("errorMsg", (Object)"admp.reports.o365.unable_to_get_lic_det_conn_might_lost");
                            }
                            waadAccDetailsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMWAADAccountSKUDetails", crit);
                        }
                    }
                    waadAccDetails = CommonUtil.getList((DataObject)waadAccDetailsDO, (String)"ADSMWAADAccountSKUDetails");
                    O365InfoCache.getInstance().reInitializeLicenseDataCache();
                    O365LicenseDetails.addLicenseServiceDetails(waadAccDetails);
                }
                request.setAttribute("waadAccList", waadAccList);
                request.setAttribute("waadAccDetails", waadAccDetails);
                request.setAttribute("reportName", reportRow.get("REPORT_NAME"));
                request.setAttribute("description", reportRow.get("DESCRIPTION"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mapping.findForward(forwardPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward exportReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long actionId = ClientUtil.getActionId(reportId);
            if (!ClientAuthorizationUtil.isAuthorized(request, actionId).booleanValue()) {
                ActionForward actionForward = new ActionForward("/404Error.do");
                return actionForward;
            }
            Long waadAccId = Long.parseLong(request.getParameter("waadAccId"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_DOMAIN_ID"), (Object)waadAccId, 0);
            DataObject waadAccDetailsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMWAADDomainConfiguration", crit);
            Iterator it = waadAccDetailsDO.getRows("ADSMWAADDomainConfiguration");
            Row r = (Row)it.next();
            String waadTenantId = (String)r.get("WAAD_TENANT_ID");
            String reportType = request.getParameter("reportType");
            String reportFileName = request.getSession().getServletContext().getRealPath("/") + "jasperreports" + File.separator + "jrxml" + File.separator + "showAllUsersReport.xml";
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            reportFileName = "ADMPReport";
            HashMap<String, String> inputParams = new HashMap<String, String>();
            ArrayList attributeList = ReportAttributeHandler.getInstance().getViewColumn(reportId);
            ArrayList resultList = null;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMWAADAccountSKUDetails"));
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                if (columnName.equalsIgnoreCase("SERVICES")) continue;
                String table = attributeProperties.getProperty("TABLE_NAME");
                Column column = Column.getColumn((String)table, (String)columnName);
                selectColumnList.add(column);
            }
            query.addSelectColumns(selectColumnList);
            query.addSelectColumn(Column.getColumn((String)"ADSMWAADAccountSKUDetails", (String)"UNIQUE_ID"));
            query.setCriteria(new Criteria(Column.getColumn((String)"ADSMWAADAccountSKUDetails", (String)"WAAD_DOMAIN_ID"), (Object)waadAccId, 0));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            resultList = new ArrayList();
            while (dataSet.next()) {
                Hashtable<Integer, String> resultTable = new Hashtable<Integer, String>();
                ReportResultUtil.fillResult(dataSet, resultTable, attributeList);
                String accSkuId = (String)resultTable.get(12100);
                if (resultTable.get(12100) != null && !reportType.equalsIgnoreCase("csvde")) {
                    ArrayList list = new ArrayList();
                    list.add(resultTable.get(12100));
                    O365MgmtHandler.getUserFriendlyValues(list, (String)"LICENSES", (AdventNetResourceBundle)rb);
                    resultTable.put(12100, (String)list.get(0));
                }
                ArrayList servPlanList = new ArrayList();
                Properties o365LicenseProps = (Properties)O365InfoCache.getInstance().getO365LicenseStatusProps(accSkuId);
                if (o365LicenseProps != null && o365LicenseProps.get("servicePlans") != null) {
                    ArrayList list = (ArrayList)o365LicenseProps.get("servicePlans");
                    servPlanList = (ArrayList)list.clone();
                    if (!reportType.equalsIgnoreCase("csvde")) {
                        O365MgmtHandler.getUserFriendlyValues((ArrayList)servPlanList, (String)"SERVICES", (AdventNetResourceBundle)rb);
                    }
                }
                resultTable.put(O365_LICENSE_SERVICES_ATTRIB_ID, ClientUtil.getString(servPlanList));
                resultList.add(resultTable);
            }
            ReportJRDataSource dataSource = new ReportJRDataSource(resultList, new Hashtable(), reportType);
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            Hashtable columnWidths = JRDesignUtil.calculateWidth(attributeList, resultList, new Hashtable(), reportType, request, rb);
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributeList, reportType, null, 0, rb, loginId, locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            inputParams.put("title", rb.getString("admp.reports.o365.lic_details"));
            inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputParams.put("desc", rb.getString("admp.reports.o365.lic_rep_generated_for") + " " + waadTenantId);
            inputParams.put("Generated at", "");
            inputParams.put("date", "");
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, inputParams, (JRDataSource)dataSource);
            print.setName(rb.getString("admp.reports.o365.lic_details"));
            ReportExportUtil.exportReport(reportType, request, response, print, reportFileName, loginId);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.cre_role.action_name.ad_reports", (String)"admp.reports.o365.lic_details", (Integer)actionId.intValue(), (String)"-", (Boolean)Boolean.FALSE, (String)(reportFileName + reportType), (String)reportType.toLowerCase(), (String)"-", (Integer)resultList.size());
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return null;
    }

    public static void addLicenseServiceDetails(ArrayList waadAccDetails) {
        try {
            if (waadAccDetails != null) {
                for (int i = 0; i < waadAccDetails.size(); ++i) {
                    Properties props = (Properties)waadAccDetails.get(i);
                    String accSkuId = (String)props.get("ACCOUNT_SKU_ID");
                    ArrayList servPlanList = new ArrayList();
                    Properties o365LicenseProps = (Properties)O365InfoCache.getInstance().getO365LicenseStatusProps(accSkuId);
                    if (o365LicenseProps != null && o365LicenseProps.get("servicePlans") != null) {
                        ArrayList list = (ArrayList)o365LicenseProps.get("servicePlans");
                        servPlanList = (ArrayList)list.clone();
                    }
                    props.put("SERVICES", servPlanList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

