/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.BaseComputerListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OSBasedListener
extends BaseComputerListener {
    protected ArrayList trusteesListMap = new ArrayList();

    @Override
    public boolean isResultViewOutputFilterAvailable() {
        return true;
    }

    @Override
    public ArrayList getTrusteesList() {
        return this.trusteesListMap;
    }

    @Override
    public ArrayList getReportInputParam(ArrayList<Hashtable<String, ArrayList<Hashtable<String, Object>>>> cvcInputList) {
        ArrayList<Object> list = new ArrayList();
        for (Hashtable<String, ArrayList<Hashtable<String, Object>>> hash : cvcInputList) {
            if (!hash.containsKey("operatingSystem")) continue;
            list = hash.get("operatingSystem");
        }
        return list;
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.computer_report.text.showing_computer";
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String operatingSystem, String servicePack) throws Exception {
        ADHandler.getOSBasedComputers((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (NativeListener)listener, (String)operatingSystem, (String)servicePack);
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, ReportReqParams reqParams, Criteria crit) {
        JSONArray rvcFiltersArray = reqParams.getRvcFilters();
        try {
            String columnName = "INPUT_ID";
            if (rvcFiltersArray != null && rvcFiltersArray.length() > 0) {
                String[] inputFiltervalues = new String[rvcFiltersArray.length()];
                for (int index = 0; index < rvcFiltersArray.length(); ++index) {
                    JSONObject rvcFilterObject = (JSONObject)rvcFiltersArray.get(index);
                    Iterator iterator = rvcFilterObject.keys();
                    while (iterator.hasNext()) {
                        String inputId;
                        inputFiltervalues[index] = inputId = (String)iterator.next();
                        Hashtable errorValues = (Hashtable)this.errorList.get(inputId);
                        if (errorValues == null) continue;
                        if (this.errorMessage == null) {
                            this.errorMessage = (String)errorValues.get("ERROR_MESSAGE");
                            continue;
                        }
                        if (this.errorMessage.contains((String)errorValues.get("ERROR_MESSAGE"))) continue;
                        this.errorMessage = this.errorMessage + "," + (String)errorValues.get("ERROR_MESSAGE");
                    }
                }
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8));
            }
        }
        catch (JSONException jsonEx) {
            jsonEx.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return crit;
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit, String inputId) {
        try {
            String columnName = "INPUT_ID";
            ArrayList inputObjects = (ArrayList)bean.get("inputObjects");
            String[] inputFiltervalues = request.getParameterValues("inputs");
            crit = !inputObjects.contains(inputId) && inputObjects.size() != 0 ? (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0))) : (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public Criteria getScheduledReportFilterCriteria(Criteria crit, ReportFilterConfig reportFilterConfig, ArrayList tableNames, String inputId) {
        try {
            String columnName = "INPUT_ID";
            crit = crit == null ? new Criteria(Column.getColumn((String)this.resultTableName, (String)columnName), (Object)inputId, 0) : crit.and(new Criteria(Column.getColumn((String)this.resultTableName, (String)columnName), (Object)inputId, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public void setInputParams(HttpServletRequest request, ReportBean bean) {
        String[] domains;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String domainName = request.getParameter("domainName");
        if (domainName == null && (domains = (String[])bean.get("domains")).length > 0) {
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            domainName = (String)dnDomainNameMap.get(domains[0]);
        }
        if (domainName == null) {
            Properties selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
            domainName = selectedDomain.getProperty("DOMAIN_NAME");
        }
        ArrayList userList = CommonUtil.searchSecurityPrincipals(null, (String)domainName, (Long)loginId);
        request.setAttribute("users", (Object)userList);
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        ArrayList trusteesList = (ArrayList)bean.get("trusteesList");
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        ArrayList valuesList = new ArrayList();
        for (int i = 0; i < trusteesList.size(); ++i) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            inputs.put("INPUT_PROPERTY_NAME", key);
            inputs.put("INPUT_PROPERTY_VALUE", (String)trusteesList.get(i));
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            String[] domainList = request.getParameterValues("domains");
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomains});
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_OS_DETAILS.getValue());
            Action action = new Action(loginId, containerList, attributeList, this, dnDomainNameMap, reportInputParams, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            this.isCompleted = false;
            String operatingSys = "";
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            ArrayList inputList = new ArrayList();
            Long scheduleId = reportFilterConfig.getScheduleId();
            String inputTableName = "ADSMSchedulerMultiValues";
            DataObject dataObject = ListenerUtil.getInputIdForSchedulerReportResult(this.reportId, scheduleId, inputTableName);
            Long i = 0L;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                Long l = i;
                Long l2 = i = Long.valueOf(i + 1L);
                if (!admpInput.getIsMultiple().booleanValue()) continue;
                for (FcOption fcOption : admpInput.getMultipleInput()) {
                    if (!fcOption.getLabel().equalsIgnoreCase("INPUT_VALUE")) continue;
                    operatingSys = fcOption.getValue();
                }
                Hashtable<String, Object> inputs = new Hashtable<String, Object>();
                inputs.put("INPUT_PROPERTY_NAME", "operatingSystem");
                inputs.put("INPUT_PROPERTY_VALUE", operatingSys);
                inputs.put("REPORT_GENERATION_ID", this.generationId);
                Row row = dataObject.getRow(inputTableName, new Criteria(Column.getColumn((String)inputTableName, (String)"INPUT_PROPERTIES"), (Object)operatingSys, 0));
                if (row == null) {
                    inputs.put("INPUT_ID", i);
                } else {
                    inputs.put("INPUT_ID", row.get("UNIQUE_VALUE_MAPPING"));
                }
                inputList.add(inputs);
            }
            HashMap reportInputParams = new HashMap();
            reportInputParams.put("operatingSystem", inputList);
            this.trusteesListMap = inputList;
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains});
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(CommonUtil.ADMIN_LOGIN_ID, containerList, this.getAttributeList(), this, dnDomainNameMap, reportInputParams, excludeContainerHash);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getInputFilterDisplayName(String inputName) {
        inputName = inputName.replaceAll("\\*", "");
        inputName = inputName.replaceAll(":", " - ");
        return inputName;
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        inputParams.put("operatingSystem", ListenerUtil.getMultiInputValues(dashboardReportMapping, request, bean));
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private Map reportInputParams = null;
        private Hashtable excludeChildOUHash = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, NativeListener li, Hashtable map, Map reportInputParams, Hashtable excludeChildOUHash) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.reportInputParams = reportInputParams;
            this.excludeChildOUHash = excludeChildOUHash;
        }

        @Override
        public void run() {
            OSBasedListener.this.errorMessage = null;
            if (!OSBasedListener.this.errorList.isEmpty()) {
                OSBasedListener.this.errorList = new Hashtable();
            }
            OSBasedListener.this.guidList = new ArrayList();
            Hashtable tableProps = OSBasedListener.this.getQueueProps();
            ArrayList inputsList = (ArrayList)this.reportInputParams.get("operatingSystem");
            ArrayList objectIds = OSBasedListener.this.getObjIdList();
            OSBasedListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, OSBasedListener.this.getTableColumns());
            OSBasedListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(OSBasedListener.this.resultTableName);
            for (int j = 0; j < inputsList.size(); ++j) {
                Hashtable inputValues = (Hashtable)inputsList.get(j);
                String servicePack = "";
                String operatingSystem = (String)inputValues.get("INPUT_PROPERTY_VALUE");
                if (OSBasedListener.this.statusController != null) {
                    OSBasedListener.this.statusController.setTaskObject((Object)operatingSystem);
                }
                if (operatingSystem.contains(":")) {
                    servicePack = operatingSystem.substring(operatingSystem.indexOf(":") + 1);
                    operatingSystem = operatingSystem.substring(0, operatingSystem.indexOf(":"));
                }
                for (int i = 0; i < this.containerList.size(); ++i) {
                    Hashtable<String, String> errors;
                    try {
                        tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                        OSBasedListener.this.addlResultIps.put("INPUT_ID", (Long)inputValues.get("INPUT_ID"));
                        String dn = (String)this.containerList.get(i);
                        OSBasedListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                        Boolean isExcludeChildOU = Boolean.FALSE;
                        if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                            isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                        }
                        this.listener.setIsExcludeChildOU(isExcludeChildOU);
                        OSBasedListener.this.queue.registerForUpdation(OSBasedListener.this.baseTableName, OSBasedListener.this.generationId, tableProps);
                        OSBasedListener.this.doAction(OSBasedListener.this.domainName, this.loginId, dn, this.attributeList, this.listener, operatingSystem, servicePack);
                        OSBasedListener.this.updateQueue();
                        continue;
                    }
                    catch (LocalizedException e) {
                        e.printStackTrace();
                        OSBasedListener.this.errorMessage = e.getMessage(OSBasedListener.this.rb);
                        errors = new Hashtable();
                        errors.put("INPUT_NAME", OSBasedListener.this.getInputFilterDisplayName((String)inputValues.get("INPUT_PROPERTY_VALUE")));
                        errors.put("ERROR_MESSAGE", OSBasedListener.this.errorMessage);
                        OSBasedListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                        OSBasedListener.this.updateErrorStatus(errors);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        OSBasedListener.this.errorMessage = e.getMessage();
                        errors = new Hashtable<String, String>();
                        errors.put("INPUT_NAME", OSBasedListener.this.getInputFilterDisplayName((String)inputValues.get("INPUT_PROPERTY_VALUE")));
                        errors.put("ERROR_MESSAGE", OSBasedListener.this.errorMessage);
                        OSBasedListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                        OSBasedListener.this.updateErrorStatus(errors);
                    }
                }
            }
            OSBasedListener.this.updatedCount = 0;
            OSBasedListener.this.totalCount = 0;
            OSBasedListener.this.completedAction();
        }
    }
}

