/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PwdExpiredUsersListener
extends AbstractListener {
    public PwdExpiredUsersListener() {
        this.cks = new String[]{"disUsers"};
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, long value) throws Exception {
        ADHandler.getPasswordExpiredUsers((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (NativeListener)listener, (long)value);
    }

    public void doAction(String domainName, Long loginId, String dn, ArrayList attributeList, ArrayList psoList, long domMaxPwdAgeTime, NativeListener listener) throws Exception {
        ADHandler.getPasswordExpiredUsersForW2K8((String)domainName, (Long)loginId, (String)dn, (ArrayList)attributeList, (ArrayList)psoList, (long)domMaxPwdAgeTime, (NativeListener)listener);
    }

    @Override
    public Criteria getReportFilterCriteria(Criteria crit, ReportReqParams reqParams, ArrayList tableNames) {
        try {
            AdmpInput admpInput = reqParams.getCvcFilters();
            if (admpInput != null && admpInput.getIsMultiple().booleanValue()) {
                for (FcOption fcOption : admpInput.getMultipleInput()) {
                    if (!fcOption.getValue().equalsIgnoreCase("true")) continue;
                    crit = this.getCriteria(crit, tableNames);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public Criteria getScheduledReportFilterCriteria(Criteria crit, ReportFilterConfig reportFilterConfig, ArrayList tableNames) {
        boolean excludeDisabled = false;
        try {
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue() || !admpInput.getValue().equalsIgnoreCase("true")) continue;
                crit = this.getCriteria(crit, tableNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public Criteria getCriteria(Criteria criteria, ArrayList tableNames) {
        try {
            String tableName = "ADSMUserGeneralDetails";
            String columnName = "ACCOUNT_STATUS";
            criteria = criteria == null ? new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)this.rb.getString("admp.reports.user.customized_column_values.Disabled"), 1) : criteria.and(new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)this.rb.getString("admp.reports.user.customized_column_values.Disabled"), 1));
            if (!tableNames.contains(tableName)) {
                tableNames.add(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return criteria;
    }

    @Override
    public Long generateReportForAPI(Long loginId, ADMPAuthObject authObject, Integer reportId, String domain, Hashtable<String, String> requestParams) {
        try {
            String domainName = DomainUtil.getDomainName((String)domain);
            Hashtable domains = authObject.getDomainAndOUs();
            Hashtable dnDomainNameMap = (Hashtable)domains.get("dnDomainNameMap");
            ArrayList attributeList = this.getAttributeList();
            this.checkAttributeList(attributeList);
            ArrayList<String> containerList = new ArrayList<String>();
            ArrayList ous = ClientAuthorizationUtil.getAuthorizedOUList(authObject, domainName);
            if (ous != null && ous.size() > 0) {
                containerList.addAll(ous);
            } else {
                containerList.add(domain);
            }
            Action action = new Action(loginId, containerList, attributeList, this, dnDomainNameMap, null);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.generationId;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomains});
            Action action = new Action(loginId, containerList, attributeList, this, dnDomainNameMap, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started called for the Pwd Expired Report");
            this.isCompleted = false;
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(1L, containerList, this.getAttributeList(), this, dnDomainNameMap, excludeContainerHash);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        try {
            Criteria crit = new Criteria(new Column("DashboardReportInputVals", "DASHBOARD_REPORT_MAPPING"), (Object)dashboardReportMapping, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("DashboardReportInputVals", crit);
            String value = (String)dataObj.getFirstRow("DashboardReportInputVals").get("VALUE");
            if (value.equals("true")) {
                ArrayList<String> resultFilterCheck = new ArrayList<String>();
                resultFilterCheck.add("excludedisabled");
                HashMap inputParams = (HashMap)bean.get("reportInputParams");
                inputParams.put("resultFilterCheck", resultFilterCheck);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private Hashtable excludeChildOUHash = null;
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, NativeListener li, Hashtable map, Hashtable excludeChildOUHash) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.excludeChildOUHash = excludeChildOUHash;
        }

        @Override
        public void run() {
            PwdExpiredUsersListener.this.guidList = new ArrayList();
            Hashtable tableProps = PwdExpiredUsersListener.this.getQueueProps();
            ArrayList objectIds = PwdExpiredUsersListener.this.getObjIdList();
            PwdExpiredUsersListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, PwdExpiredUsersListener.this.getTableColumns());
            PwdExpiredUsersListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(PwdExpiredUsersListener.this.resultTableName);
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    PwdExpiredUsersListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    AbstractListener.reportLogger.log(Level.INFO, "Getting the Pwd Expired User Reports for the domain " + PwdExpiredUsersListener.this.domainName);
                    Properties policy = PolicyHandler.getPolicies((String)PwdExpiredUsersListener.this.domainName, (Long)this.loginId);
                    String domMaxPwdAge = policy.getProperty("maxPwdAge");
                    long domMaxPwdAgeTime = Long.parseLong(domMaxPwdAge) * 24L * 60L * 60L * 10000000L;
                    ArrayList psoList = PolicyHandler.getPSObjects((String)PwdExpiredUsersListener.this.domainName);
                    String domainFuncLevel = CommonUtil.getDomainFunctionalLevel((String)PwdExpiredUsersListener.this.domainName, (Long)this.loginId);
                    if (domainFuncLevel != null && (domainFuncLevel.equalsIgnoreCase("Windows Server 2008") || domainFuncLevel.equalsIgnoreCase("Windows Server 2008 R2")) && psoList != null && !psoList.isEmpty()) {
                        PwdExpiredUsersListener.this.doAction(PwdExpiredUsersListener.this.domainName, this.loginId, dn, this.attributeList, psoList, domMaxPwdAgeTime, this.listener);
                        PwdExpiredUsersListener.this.updateQueue();
                        continue;
                    }
                    if (domMaxPwdAge != null && !domMaxPwdAge.equals("0")) {
                        long l = System.currentTimeMillis();
                        System.out.println("The pass expired time : " + (l -= Long.parseLong(domMaxPwdAge) * 24L * 60L * 60L * 1000L));
                        PwdExpiredUsersListener.this.doAction(PwdExpiredUsersListener.this.domainName, this.loginId, dn, this.attributeList, this.listener, l);
                        PwdExpiredUsersListener.this.updateQueue();
                        continue;
                    }
                    if (!PwdExpiredUsersListener.this.updateDetails) continue;
                    PwdExpiredUsersListener.this.errorMessage = PwdExpiredUsersListener.this.rb.getString("client.reports.PwdExpiredUsersListener.since_the_domain_password_age_is_not_defined_there_were_no_password_expired_users");
                    continue;
                }
                catch (LocalizedException excep) {
                    PwdExpiredUsersListener.this.errorMessage = excep.getMessage(PwdExpiredUsersListener.this.rb);
                    System.out.println("LocalizedException in PwdExpiredUsersListener :- " + PwdExpiredUsersListener.this.errorMessage);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PwdExpiredUsersListener.this.errorMessage = e.getMessage();
                }
            }
            PwdExpiredUsersListener.this.updatedCount = 0;
            PwdExpiredUsersListener.this.totalCount = 0;
            PwdExpiredUsersListener.this.completedAction();
        }
    }
}

