/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCHandler;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.MultiDCListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RealLastLogonListener
extends MultiDCListener {
    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(Properties domainDetails, String distinguishedName, String dcName, ArrayList userList, ArrayList attributeList, NativeListener listener) throws Exception {
        ADHandler.getUsersRealLastLogon((Properties)domainDetails, (String)distinguishedName, (String)dcName, (ArrayList)userList, (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1003L);
        return categoryId;
    }

    public RealLastLogonListener() {
        this.mgmtIds = new int[]{1004, 1144, 1143, 1023, 1006, 1145};
        this.multiDC = true;
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.user_reports.real_last_logon.reportdesc_real_last_logon_for_users_in_the_domain"), args);
    }

    @Override
    public void removeInputParams(ReportBean bean) {
        bean.set("USERSDN", new ArrayList());
        bean.set("CHECKEDDN", new ArrayList());
        bean.set("USERSLIST", new ArrayList());
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "addOrUpdate");
        return tableProps;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            Hashtable reportDomains = this.getReportDomains(request, bean, loginId);
            inputParams.put("reportDomains", reportDomains);
            inputParams.put("multiDC", "true");
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            ArrayList userList = (ArrayList)bean.get("USERSDN");
            reportLogger.log(Level.INFO, "userList Size: " + userList.size());
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            String reportDomain = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDomain});
            this.statusController.init(reportDomains);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            Hashtable excludeChildOUHash = null;
            Action action = new Action(loginId, reportDomains, attributeList, userList, this, dnDomainNameMap, this.multiDC, excludeChildOUHash);
            action.start();
            bean.set("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop(HttpServletRequest request) {
        if (!this.continueAction) {
            System.out.println("Already stop initialized. Second stop call");
            return;
        }
        this.continueAction = false;
        MultiDCHandler.getInstance().stop(this.queueRegID);
        super.stop(request);
    }

    protected void updateResult() {
        boolean result = MultiDCHandler.getInstance().isCompleted(this.queueRegID);
        while (!result) {
            try {
                this.updateOtherDCCount();
                Thread.sleep(30L);
                result = MultiDCHandler.getInstance().isCompleted(this.queueRegID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.updateOtherDCStatus();
        this.updateDCErrorStatus();
        MultiDCHandler.getInstance().finishProcess(this.queueRegID);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        ArrayList userList = new ArrayList();
        this.multiDC = true;
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Hashtable reportDomains = this.getReportDomains(containerList, dnDomainNameMap, excludedOUList, domainVsExcludeChildOU);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(1L, reportDomains, this.getAttributeList(), userList, this, dnDomainNameMap, this.multiDC, excludeContainerHash);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Action
    extends Thread {
        private Hashtable reportDomains = null;
        private ArrayList attributeList = null;
        private ArrayList userList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private boolean multiDC = true;
        private Hashtable excludeChildOUHash = null;

        public Action(Long loginId, Hashtable hash, ArrayList attributeList, ArrayList userList, NativeListener li, Hashtable map, boolean multiDC, Hashtable excludeChildOUHash) {
            this.loginId = loginId;
            this.reportDomains = hash;
            this.attributeList = attributeList;
            this.userList = userList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.multiDC = multiDC;
            this.excludeChildOUHash = excludeChildOUHash;
        }

        @Override
        public void run() {
            RealLastLogonListener.this.errorMessage = null;
            Hashtable tableProps = RealLastLogonListener.this.getQueueProps();
            ArrayList multiDCAttributes = RealLastLogonListener.this.getMultiDCAttributes();
            ArrayList objectIds = RealLastLogonListener.this.getObjIdList();
            RealLastLogonListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, RealLastLogonListener.this.getTableColumns());
            RealLastLogonListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(RealLastLogonListener.this.resultTableName);
            ArrayList clist = new ArrayList();
            if (this.reportDomains.isEmpty()) {
                RealLastLogonListener.this.domainName = null;
            }
            Enumeration e = this.reportDomains.keys();
            while (e.hasMoreElements()) {
                RealLastLogonListener.this.domainName = (String)e.nextElement();
                ReportDomain reportDomain = (ReportDomain)this.reportDomains.get(RealLastLogonListener.this.domainName);
                ArrayList containerList = reportDomain.getContainerList();
                clist.addAll(containerList);
            }
            if (multiDCAttributes.size() > 0) {
                MultiDCHandler.getInstance().execute(RealLastLogonListener.this.queueRegID, this.loginId, clist, this.dnDomainNameMap, multiDCAttributes, "", this.userList, RealLastLogonListener.this.objClass.getId(), null);
                MultiDCHandler.getInstance().setRemoveGuids(RealLastLogonListener.this.queueRegID, false);
            }
            if (RealLastLogonListener.this.statusController != null) {
                RealLastLogonListener.this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            }
            e = this.reportDomains.keys();
            block6: while (e.hasMoreElements()) {
                try {
                    RealLastLogonListener.this.domainName = (String)e.nextElement();
                    Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)RealLastLogonListener.this.domainName, (Long)this.loginId);
                    ReportDomain reportDomain = (ReportDomain)this.reportDomains.get(RealLastLogonListener.this.domainName);
                    ArrayList containerList = reportDomain.getContainerList();
                    AbstractListener.reportLogger.log(Level.INFO, "containerList: " + containerList.size());
                    if (multiDCAttributes.size() > 0) {
                        // empty if block
                    }
                    for (int i = 0; i < containerList.size(); ++i) {
                        String dn = (String)containerList.get(i);
                        ArrayList dcList = reportDomain.getDCList();
                        Hashtable<String, ArrayList> domainProps = new Hashtable<String, ArrayList>();
                        domainProps.put(RealLastLogonListener.this.domainName, dcList);
                        boolean error = true;
                        String errStr = null;
                        Boolean isExcludeChildOU = Boolean.FALSE;
                        if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                            isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                        }
                        this.listener.setIsExcludeChildOU(isExcludeChildOU);
                        for (int j = 0; j < dcList.size(); ++j) {
                            Hashtable hash = (Hashtable)dcList.get(j);
                            Integer status = (Integer)hash.get("status");
                            RealLastLogonListener.this.dcIndex = j;
                            if (status == 0) {
                                Hashtable<String, String> errors;
                                RealLastLogonListener.this.dcName = (String)hash.get("dcName");
                                try {
                                    RealLastLogonListener.this.updateStatus(RealLastLogonListener.this.dcName);
                                    RealLastLogonListener.this.toBeExecutedAttributeList = this.attributeList;
                                    if (this.multiDC) {
                                        RealLastLogonListener.this.doAction(domainDetails, dn, RealLastLogonListener.this.dcName, this.userList, this.attributeList, this.listener);
                                    }
                                    RealLastLogonListener.this.updateCompletionStatus();
                                    error = false;
                                }
                                catch (LocalizedException exc) {
                                    exc.printStackTrace();
                                    errStr = RealLastLogonListener.this.rb.getString("client.reports.RealLastLogonListener.error_while_getting_the_reports_from_the_domain") + " " + RealLastLogonListener.this.domainName + ". " + exc.getMessage(RealLastLogonListener.this.rb);
                                    errors = new Hashtable();
                                    errors.put("INPUT_NAME", RealLastLogonListener.this.dcName);
                                    errors.put("ERROR_MESSAGE", errStr);
                                    RealLastLogonListener.this.errorList.put(RealLastLogonListener.this.dcName, errors);
                                    RealLastLogonListener.this.updateErrorStatus(errors);
                                    RealLastLogonListener.this.updateMultiDCStatus(RealLastLogonListener.this.domainName, RealLastLogonListener.this.dcName, "domain_error.jpg", null);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    errStr = RealLastLogonListener.this.rb.getString("client.reports.RealLastLogonListener.error_while_getting_the_reports_from_the_domain") + " " + RealLastLogonListener.this.domainName + ". " + ex.getMessage();
                                    errors = new Hashtable<String, String>();
                                    errors.put("INPUT_NAME", RealLastLogonListener.this.dcName);
                                    errors.put("ERROR_MESSAGE", errStr);
                                    RealLastLogonListener.this.errorList.put(RealLastLogonListener.this.dcName, errors);
                                    RealLastLogonListener.this.updateErrorStatus(errors);
                                    RealLastLogonListener.this.updateMultiDCStatus(RealLastLogonListener.this.domainName, RealLastLogonListener.this.dcName, "domain_error.jpg", null);
                                }
                                status = new Integer(1);
                                RealLastLogonListener.this.updatedCount = 0;
                            }
                            if (!error || error && !errStr.contains("8007203a")) break;
                        }
                        if (!error) continue;
                        RealLastLogonListener.this.errorMessage = errStr;
                        continue block6;
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            if (RealLastLogonListener.this.updateDetails && RealLastLogonListener.this.domainName != null) {
                RealLastLogonListener.this.updateResult();
            }
            RealLastLogonListener.this.completedAction();
            if (RealLastLogonListener.this.updateDetails) {
                // empty if block
            }
            RealLastLogonListener.this.totalCount = 0;
        }
    }
}

