/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.SingleContainerListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RecentlyCreatedGPOListener
extends SingleContainerListener {
    public RecentlyCreatedGPOListener() {
        this.mgmtIds = new int[]{6031, 6028, 6021, 6028};
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.gpo_reports.rec_created.reportdesc_gpos_created_in_recent_days_of_the_domains"), args);
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String time) throws Exception {
        ADHandler.getRecentlyCreatedGPOs((String)domainName, (Long)loginId, (ArrayList)attributeList, (NativeListener)listener, (String)time);
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            int day = 30;
            if (request.getParameter("day") != null) {
                try {
                    day = Integer.parseInt(request.getParameter("day"));
                }
                catch (Exception e) {
                    day = 7;
                    e.printStackTrace();
                }
            }
            long l = (long)(day * 24 * 60 * 60) * 1000L;
            Date d = new Date(System.currentTimeMillis() - l);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddhhmmss", Locale.US);
            String time = formatter.format(d) + ".0Z";
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            inputParams.put("days", String.valueOf(day));
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{String.valueOf(day), reportDomains});
            Action action = new Action(loginId, containerList, attributeList, time, this, dnDomainNameMap);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            this.isCompleted = false;
            Long reportDays = 0L;
            long value = 2592000000L;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                reportDays = Long.parseLong(admpInput.getValue());
                value = reportDays * 24L * 60L * 60L * 1000L;
            }
            reportLogger.log(Level.INFO, "Going to execute the for the reportId " + this.reportId + "No of day's " + reportDays);
            Date d = new Date(System.currentTimeMillis() - value);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddhhmmss", Locale.US);
            String time = formatter.format(d) + ".0Z";
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{reportDays, schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Action action = new Action(1L, containerList, this.getAttributeList(), time, this, dnDomainNameMap);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        attributeList.remove("objectSID");
        attributeList.add("objectGUID");
    }

    @Override
    public void setGenerationId(HttpServletRequest request) {
        String generationIdStr = request.getParameter("generationId");
        reportLogger.log(Level.INFO, "Generation Id Str : " + generationIdStr);
        if (generationIdStr != null) {
            try {
                this.generationId = Long.parseLong(generationIdStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ArrayList guids;
            this.generationId = ReportHandler.getRecentlyGeneratedReports((Integer)this.reportId, (Long)this.loginId);
            if (this.generationId == null && (guids = this.getReportsFromDB()).size() > 0) {
                this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
                ReportHandler.addSIDReportResult((Long)this.generationId, (String)this.resultTableName, (ArrayList)guids);
                ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            }
            reportLogger.log(Level.INFO, "Recently Generated Id : " + this.generationId);
        }
    }

    public ArrayList getReportsFromDB() {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            long l = 2592000000L;
            l = System.currentTimeMillis() - l;
            l = DateTimeUtil.getFileTime((Long)l);
            Criteria crit = new Criteria(new Column(this.baseTableName, "WHEN_CREATED"), (Object)l, 4);
            SelectQueryImpl sq = new SelectQueryImpl(new Table(this.baseTableName));
            sq.setCriteria(crit);
            sq.addSelectColumn(new Column(this.baseTableName, "OBJECT_GUID"));
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            Iterator it = obj.getRows(this.baseTableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                list.add(r.get("OBJECT_GUID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        inputParams.put("day", ListenerUtil.getInputValues(dashboardReportMapping, request, bean));
    }

    private class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private String time = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, String t, NativeListener li, Hashtable map) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.time = t;
            this.dnDomainNameMap = map;
        }

        @Override
        public void run() {
            RecentlyCreatedGPOListener.this.guidList = new ArrayList();
            Hashtable tableProps = RecentlyCreatedGPOListener.this.getQueueProps();
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    RecentlyCreatedGPOListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    RecentlyCreatedGPOListener.this.queue.registerForUpdation(RecentlyCreatedGPOListener.this.baseTableName, RecentlyCreatedGPOListener.this.generationId, tableProps);
                    SingleContainerListener.reportLogger.log(Level.INFO, "Getting the Recently Created GPOs " + RecentlyCreatedGPOListener.this.reportId + ", with the time : " + this.time + ", DN :" + dn + ", Domain : " + RecentlyCreatedGPOListener.this.domainName);
                    if (RecentlyCreatedGPOListener.this.domainName != null) {
                        RecentlyCreatedGPOListener.this.doAction(RecentlyCreatedGPOListener.this.domainName, this.loginId, dn, this.attributeList, this.listener, this.time);
                    }
                    RecentlyCreatedGPOListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException exc) {
                    exc.printStackTrace();
                    RecentlyCreatedGPOListener.this.errorMessage = RecentlyCreatedGPOListener.this.rb.getString("client.reports.RealLastLogonListener.error_while_getting_the_reports_from_the_domain") + " " + RecentlyCreatedGPOListener.this.domainName + ". " + exc.getMessage(RecentlyCreatedGPOListener.this.rb);
                    System.out.println("LocalizedException: - " + exc.getMessage(RecentlyCreatedGPOListener.this.rb));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RecentlyCreatedGPOListener.this.errorMessage = e.getMessage();
                    break;
                }
            }
            RecentlyCreatedGPOListener.this.updatedCount = 0;
            RecentlyCreatedGPOListener.this.totalCount = 0;
            RecentlyCreatedGPOListener.this.completedAction();
        }
    }
}

