/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RecentlyExpiredListener
extends AbstractListener {
    @Override
    public Long getCategoryId() {
        return this.categoryId;
    }

    public void getDescription(Object[] args, String dataLableText) {
        ArrayList<Object> objectList = new ArrayList<Object>(Arrays.asList(args));
        String daysInterval = "";
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            SimpleDateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
            String startVal = (String)objectList.get(0);
            String endVal = (String)objectList.get(1);
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_N_days")) {
                daysInterval = Integer.toString(DateTimeUtil.daysBetween((Date)formatter1.parse(startVal), (Date)Calendar.getInstance().getTime()));
            }
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days") || dataLableText.equalsIgnoreCase("admp.common.matching_criteria.next_N_days")) {
                daysInterval = Integer.toString(DateTimeUtil.daysBetween((Date)formatter1.parse(startVal), (Date)formatter1.parse(endVal)));
            }
            objectList.add(daysInterval);
            Date date = formatter1.parse(startVal);
            Date date1 = formatter1.parse(endVal);
            objectList.set(0, formatter2.format(date));
            objectList.set(1, formatter2.format(date1));
            args = objectList.toArray();
            this.setDescription(args, dataLableText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDescription(Object[] args, String dataLableText) {
        this.desc = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_N_days") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_expired_users.reportdesc_before_N_days"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_expired_users.reportdesc_last_N_days"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_a_date") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_expired_users.reportdesc_before_date"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.after_a_date") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_expired_users.reportdesc_after_date"), args) : MessageFormat.format(this.rb.getString("admp.reports.user_reports.rec_expired_users.reportdesc_between_dates"), args))));
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
        ADHandler.getRecentlyExpiredUsers((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (NativeListener)listener, (String)filterString);
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            int topCount = -1;
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String startDateVal = request.getParameter("startDate");
            String endDateVal = request.getParameter("endDate");
            String dataLableText = request.getParameter("dateLable");
            String filterString = this.getFilterString(startDateVal, endDateVal, dataLableText);
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            String[] domainList = request.getParameterValues("domains");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            inputParams.put("domain", ClientUtil.getString(domainList));
            bean.set("inputParams", inputParams);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString(dataLableText), reportDomains}, dataLableText);
            Action action = new Action(loginId, containerList, attributeList, filterString, this, dnDomainNameMap, excludeContainerHash);
            action.start();
            System.out.println("Bean for topCount : " + inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFilterString(String startDateVal, String endDateVal, String dataLableText) {
        String filterString = "";
        HashMap datesValueMap = this.getDateInterval(startDateVal, endDateVal, dataLableText);
        long startDate = (Long)datesValueMap.get("startDate");
        long endDate = (Long)datesValueMap.get("endDate");
        filterString = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_a_date") || dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_N_days") ? "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(!(accountExpires=0))(!(accountExpires=9223372036854775807))(!(accountExpires>=" + endDate + ")))" : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.after_a_date") ? "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(!(accountExpires=0))(!(accountExpires=9223372036854775807))(!(accountExpires<=" + startDate + "))(accountExpires<=" + endDate + "))" : "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(!(accountExpires=0))(!(accountExpires=9223372036854775807))(accountExpires>=" + startDate + ")(accountExpires<=" + endDate + "))");
        return filterString;
    }

    public HashMap getDateInterval(String startDateVal, String endDateVal, String dataLableText) {
        HashMap<String, Long> datesValueMap = new HashMap<String, Long>();
        long startDate = 0L;
        long endDate = 0L;
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            Date days = formatter1.parse(startDateVal);
            startDate = DateTimeUtil.getFileTimeFromSystemTime((Long)days.getTime());
            days = formatter1.parse(endDateVal);
            endDate = DateTimeUtil.getFileTimeFromSystemTime((Long)days.getTime());
            Date currentDate = Calendar.getInstance().getTime();
            Calendar yesterday = Calendar.getInstance();
            yesterday.setTime(currentDate);
            yesterday.set(yesterday.get(1), yesterday.get(2), yesterday.get(5) - 1, 0, 0, 0);
            yesterday.set(14, 0);
            days = new Date(yesterday.getTimeInMillis());
            long yesterdayDate = DateTimeUtil.getFileTimeFromSystemTime((Long)days.getTime());
            Calendar today = Calendar.getInstance();
            today.setTime(currentDate);
            today.set(today.get(1), today.get(2), today.get(5), 0, 0, 0);
            today.set(14, 0);
            days = new Date(today.getTimeInMillis());
            long todaydayDate = DateTimeUtil.getFileTimeFromSystemTime((Long)days.getTime());
            if (startDate > yesterdayDate && endDate > yesterdayDate) {
                startDate = 0L;
                endDate = 0L;
                if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_a_date") || dataLableText.equalsIgnoreCase("admp.common.matching_criteria.before_N_days")) {
                    endDate = todaydayDate;
                }
            } else if (endDate > yesterdayDate || dataLableText.equalsIgnoreCase("admp.common.matching_criteria.after_a_date") || dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                endDate = yesterdayDate;
            }
            datesValueMap.put("startDate", startDate);
            datesValueMap.put("endDate", endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datesValueMap;
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.isCompleted = false;
            long time = 259200000L;
            Long reportDays = 0L;
            boolean isSoonToExpireReport = false;
            if (this.reportId.equals(7)) {
                isSoonToExpireReport = true;
            }
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (admpInput.getIsMultiple().booleanValue()) continue;
                ListenerUtil.updateReportDaysForRegenerateReport(reportFilterConfig, admpInput, isSoonToExpireReport);
                reportDays = Long.parseLong(admpInput.getValue());
                time = reportDays * 24L * 60L * 60L * 1000L;
            }
            HashMap dateValues = this.getScheduleDates(time);
            String startDateVal = (String)dateValues.get("startDate");
            String endDateVal = (String)dateValues.get("endDate");
            String filterString = this.getFilterString(startDateVal, endDateVal, "admp.common.matching_criteria.last_N_days");
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{startDateVal, endDateVal, this.rb.getString("admp.common.matching_criteria.last_N_days"), schedulerDomains}, "admp.common.matching_criteria.last_N_days");
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            Action action = new Action(1L, containerList, this.getAttributeList(), filterString, this, dnDomainNameMap, excludeContainerHash);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap getScheduleDates(long time) {
        HashMap<String, String> datesMap = new HashMap<String, String>();
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        Date days = new Date(System.currentTimeMillis() - time);
        String startDateVal = formatter1.format(days);
        days = new Date(System.currentTimeMillis());
        String endDateVal = formatter1.format(days);
        datesMap.put("startDate", startDateVal);
        datesMap.put("endDate", endDateVal);
        return datesMap;
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        ListenerUtil.setDashboardInputParams(dashboardReportMapping, request, bean, 1);
    }

    private class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private String filterString = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private Hashtable excludeChildOUHash = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, String filterString, NativeListener li, Hashtable map, Hashtable excludeChildOUHash) {
            this.loginId = loginId;
            this.containerList = list;
            this.excludeChildOUHash = excludeChildOUHash;
            this.attributeList = attributeList;
            this.listener = li;
            this.filterString = filterString;
            this.dnDomainNameMap = map;
        }

        @Override
        public void run() {
            RecentlyExpiredListener.this.guidList = new ArrayList();
            Hashtable tableProps = RecentlyExpiredListener.this.getQueueProps();
            ArrayList objectIds = RecentlyExpiredListener.this.getObjIdList();
            RecentlyExpiredListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, RecentlyExpiredListener.this.getTableColumns());
            RecentlyExpiredListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(RecentlyExpiredListener.this.resultTableName);
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    RecentlyExpiredListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    System.out.println("Getting the Locked Out User Reports for the domain " + RecentlyExpiredListener.this.domainName);
                    RecentlyExpiredListener.this.doAction(RecentlyExpiredListener.this.domainName, this.loginId, dn, this.attributeList, this.listener, this.filterString);
                    RecentlyExpiredListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    RecentlyExpiredListener.this.errorMessage = e.getMessage(RecentlyExpiredListener.this.rb);
                    System.out.println("LocalizedException: - " + RecentlyExpiredListener.this.errorMessage);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RecentlyExpiredListener.this.errorMessage = e.getMessage();
                }
            }
            RecentlyExpiredListener.this.updatedCount = 0;
            RecentlyExpiredListener.this.totalCount = 0;
            RecentlyExpiredListener.this.completedAction();
        }
    }
}

