/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class ReportController {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private Hashtable genIdVsReport = new Hashtable();
    private static ReportController handler = null;

    private ReportController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportController getInstance() {
        if (handler != null) return handler;
        Class<ReportController> clazz = ReportController.class;
        synchronized (ReportController.class) {
            if (handler != null) return handler;
            handler = new ReportController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public Long generateReport(Integer reportId, HttpServletRequest request, ReportBean bean, StatusUpdater statusUpdater) {
        AbstractListener listener = bean.getListener();
        listener.start(reportId, request, bean);
        Long generationId = listener.getGenerationId();
        this.genIdVsReport.put(generationId, listener);
        return generationId;
    }

    public Long generateReportForAPI(Long loginId, ADMPAuthObject authObject, Integer reportId, String domainName, AbstractListener listener, StatusUpdater statusUpdater, Hashtable<String, String> requestParams) {
        Long generationId = ReportHandler.addReportGenerationDetails((Integer)reportId, (String)" ", (Long)loginId);
        listener.setGenerationId(generationId);
        listener.generateReportForAPI(loginId, authObject, reportId, domainName, requestParams);
        this.genIdVsReport.put(generationId, listener);
        return generationId;
    }

    public void stopReport(Long generationId, ReportBean bean, HttpServletRequest request) {
        reportLogger.log(Level.INFO, "Stopping the report....................");
        AbstractListener listener = bean.getListener();
        listener.stop(request);
        this.genIdVsReport.remove(generationId);
    }

    public StatusUpdater getStatusUpdater(Long generationId) {
        AbstractListener listener = (AbstractListener)this.genIdVsReport.get(generationId);
        if (listener == null) {
            return null;
        }
        return listener.getStatusController();
    }

    public void removeGenId(Long generationId) {
        this.genIdVsReport.remove(generationId);
    }
}

