/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultInputUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class ReportExportInputUtil {
    public static JasperPrint insertSummaryReport(String reportFilePath, String basePath, String tempJRReportFileName, Long scheduleId, Integer maxWidth, Map inputParams, AbstractListener listener, String reportType, Long loginId, ReportReqParams reqParams, ReportFilterConfig rfConfig, Criteria reportFilterCriteria, Criteria reportColumnCrit, ArrayList reportTables, AdventNetResourceBundle rb, Locale locale, boolean isInline) {
        String productHome = System.getProperty("product.home");
        JasperPrint jasperPrint = null;
        Integer[] excludeDomain = new Integer[]{803, 954, 958, 957};
        List<Integer> excludeDomainSummary = Arrays.asList(excludeDomain);
        try {
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFilePath);
            if (maxWidth != null) {
                jasperDesign.setColumnWidth(maxWidth.intValue());
                jasperDesign.setPageWidth(maxWidth + 60);
            }
            if (isInline) {
                ReportExportUtil.addEncodedLogoToInputParams(jasperDesign, inputParams);
            }
            ArrayList<ArrayList<Hashtable>> subReportColumns = new ArrayList<ArrayList<Hashtable>>();
            ArrayList domainReportCols = new ArrayList();
            ArrayList inputReportCols = new ArrayList();
            Hashtable<String, String> column = new Hashtable<String, String>();
            column.put("columnName", rb.getString("admp.reports.export.selected_domains"));
            column.put("fieldName", "DOMAIN_NAME");
            domainReportCols.add(column);
            column = new Hashtable();
            column.put("columnName", rb.getString("admp.reports.export.object_count"));
            column.put("fieldName", "count");
            domainReportCols.add(column);
            column = new Hashtable();
            column.put("columnName", rb.getString("admp.reports.export.selected_objects"));
            column.put("fieldName", "INPUT_NAME");
            inputReportCols.add(column);
            column = new Hashtable();
            column.put("columnName", rb.getString("admp.reports.export.object_count"));
            column.put("fieldName", "count");
            inputReportCols.add(column);
            String domainTable = "ADSMReportDomainDetails";
            String[] domainTableColumns = new String[]{"DOMAIN_NAME"};
            Long genId = listener.getGenerationId();
            ArrayList domainList = null;
            ArrayList inputList = null;
            boolean showReportSummary = JRFieldDesignUtil.getShowSummary();
            if (showReportSummary) {
                ArrayList<ArrayList> summaryDataList = new ArrayList<ArrayList>();
                Hashtable listenerProps = listener.getProperties();
                Integer reportId = listener.getReportId();
                if (!excludeDomainSummary.contains(reportId) && (domainList = scheduleId == null ? ListenerUtil.getInputDetails(domainTable, genId, domainTableColumns) : SchedulerUtil.getSchedulerDomains((Long)scheduleId)) != null && !domainList.isEmpty()) {
                    domainList = ReportExportInputUtil.updateDomainObjectCount(domainList, (String)listenerProps.get("baseTableName"), (String)listenerProps.get("resultTableName"), genId, (String)listenerProps.get("tableKey"), listener, reqParams, rfConfig, reportFilterCriteria, reportColumnCrit, reportTables);
                    summaryDataList.add(domainList);
                    subReportColumns.add(domainReportCols);
                }
                if ((inputList = ReportResultInputUtil.getInputList(genId, listener.getReportId(), rfConfig)) != null && !inputList.isEmpty()) {
                    ReportExportInputUtil.updateInputObjectCount(inputList, (String)listenerProps.get("resultTableName"), genId, (String)listenerProps.get("tableKey"), reportFilterCriteria, reportColumnCrit, reportTables);
                    summaryDataList.add(inputList);
                    subReportColumns.add(inputReportCols);
                }
                if (!summaryDataList.isEmpty()) {
                    jasperPrint = JRDesignUtil.fillSummarySubreport(jasperDesign, basePath, inputParams, subReportColumns, "DomainSummary", tempJRReportFileName, summaryDataList, reportType, loginId, rb, locale);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jasperPrint;
    }

    public static JasperPrint insertSummaryReport(ArrayList summaryDetails, String reportFilePath, String basePath, String tempJRReportFileName, Integer maxWidth, Map inputParams, String reportType, Long loginId, AdventNetResourceBundle rb, Locale locale, boolean isInline) {
        String productHome = System.getProperty("product.home");
        JasperPrint jasperPrint = null;
        try {
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFilePath);
            if (maxWidth != null) {
                jasperDesign.setColumnWidth(maxWidth.intValue());
                jasperDesign.setPageWidth(maxWidth + 60);
            }
            if (isInline) {
                ReportExportUtil.addEncodedLogoToInputParams(jasperDesign, inputParams);
            }
            ArrayList<ArrayList<Hashtable>> subReportColumns = new ArrayList<ArrayList<Hashtable>>();
            ArrayList objectReportCols = new ArrayList();
            Hashtable<String, String> column = new Hashtable<String, String>();
            column.put("columnName", rb.getString("admp.reports.export.selected_objects"));
            column.put("fieldName", "OBJECT_NAME");
            objectReportCols.add(column);
            column = new Hashtable();
            column.put("columnName", rb.getString("admp.reports.export.object_count"));
            column.put("fieldName", "count");
            objectReportCols.add(column);
            boolean showReportSummary = JRFieldDesignUtil.getShowSummary();
            if (showReportSummary) {
                ArrayList<ArrayList> summaryDataList = new ArrayList<ArrayList>();
                if (summaryDetails != null && !summaryDetails.isEmpty()) {
                    summaryDataList.add(summaryDetails);
                    subReportColumns.add(objectReportCols);
                }
                if (!summaryDataList.isEmpty()) {
                    jasperPrint = JRDesignUtil.fillSummarySubreport(jasperDesign, basePath, inputParams, subReportColumns, "ObjectSummary", tempJRReportFileName, summaryDataList, reportType, loginId, rb, locale);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jasperPrint;
    }

    private static void updateInputObjectCount(ArrayList inputList, String resultTable, Long genId, String tableKey, Criteria reportFilterCrit, Criteria reportColumnCrit, ArrayList tableNames) {
        try {
            for (int i = 0; i < inputList.size(); ++i) {
                Hashtable inputTable = (Hashtable)inputList.get(i);
                Long inputId = (Long)inputTable.get("INPUT_ID");
                Column col = Column.getColumn((String)resultTable, (String)tableKey);
                Criteria crit = null;
                TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)resultTable);
                List columns = tableDef.getColumnNames();
                if (columns != null && columns.contains("INPUT_ID")) {
                    crit = new Criteria(Column.getColumn((String)resultTable, (String)"INPUT_ID"), (Object)inputId, 0);
                }
                Criteria reportFilterCriteria = null;
                if (reportFilterCrit == null) {
                    reportFilterCriteria = reportColumnCrit != null ? reportColumnCrit : null;
                } else {
                    Criteria criteria = reportFilterCriteria = reportColumnCrit != null ? reportFilterCrit.and(reportColumnCrit) : reportFilterCrit;
                }
                if (reportFilterCriteria != null) {
                    crit = crit != null ? crit.and(reportFilterCriteria) : reportFilterCriteria;
                }
                SelectQuery sq = ReportResultUtil.getCountSQ(crit, genId, resultTable, tableNames, tableKey);
                Integer count = DBUtil.getCount((SelectQuery)sq);
                inputTable.put("count", count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ArrayList updateDomainObjectCount(ArrayList domainList, String baseTable, String resultTable, Long genId, String tableKey, AbstractListener listener, ReportReqParams reqParams, ReportFilterConfig rfConfig, Criteria reportFilterCrit, Criteria reportColumnCrit, ArrayList tableNames) {
        ArrayList domainCountList = new ArrayList();
        try {
            for (int i = 0; i < domainList.size(); ++i) {
                Hashtable<String, Object> domainTable = new Hashtable<String, Object>();
                String domainName = (String)domainList.get(i);
                Criteria crit = new Criteria(Column.getColumn((String)baseTable, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                Criteria reportFilterCriteria = null;
                Integer reportId = listener.getReportId();
                if (reportFilterCrit == null) {
                    reportFilterCriteria = reportColumnCrit != null ? reportColumnCrit : null;
                } else {
                    Criteria criteria = reportFilterCriteria = reportColumnCrit != null ? reportFilterCrit.and(reportColumnCrit) : reportFilterCrit;
                }
                if (reportFilterCriteria != null) {
                    crit = crit.and(reportFilterCriteria);
                }
                if (!tableNames.contains(baseTable)) {
                    tableNames.add(baseTable);
                }
                SelectQuery sq = ReportResultUtil.getCountSQ(crit, genId, resultTable, tableNames, tableKey);
                Integer count = DBUtil.getCount((SelectQuery)sq);
                domainTable.put("DOMAIN_NAME", domainName);
                domainTable.put("count", count);
                domainCountList.add(domainTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainCountList;
    }
}

