/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.CategoryHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.gpomgmt.GPOMgmtHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.webclient.groups.GroupErrorHandler;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class ReportMgmtHandler {
    public static Long RESTORE_USER_MENU_ID = 12L;
    public static Long RESTORE_COMP_MENU_ID = 13L;
    public static Long DELETE_GPO_MENU_ID = 23L;
    public static Long ENABLE_GPO_MENU_ID = 24L;
    public static Long DISABLE_GPO_MENU_ID = 25L;
    public static Long ENABLE_USER_GPO_SETTINGS_MENU_ID = 26L;
    public static Long ENABLE_COMP_GPO_SETTINGS_MENU_ID = 27L;

    public static String mgmtAction(Long menuId, ADMPAuthObject authObject, Hashtable result, ArrayList attributeList, String domainName, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        return ReportMgmtHandler.mgmtAction(menuId, authObject, result, attributeList, domainName, loginId, listener, mgmtIds, audit_info, auditDataObj, rb, null, new HashMap());
    }

    public static String mgmtAction(Long menuId, ADMPAuthObject authObject, Hashtable result, ArrayList attributeList, String domainName, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb, AdmpInput admpInput, HashMap guidVsPolicyStatusMap) {
        String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_modified");
        Hashtable menuProps = CategoryHandler.getMenuProps((Long)menuId);
        Long actionId = (Long)menuProps.get("ACTION_ID");
        Integer reportId = (Integer)menuProps.get("REPORT_ID");
        audit_info.put("reportIdForNotification", reportId);
        ArrayList actionIds = authObject.getActionList(domainName);
        if (!actionIds.contains(actionId)) {
            errorMessage = rb.getString("admp.reports.reports_to_mgmt.errmsg_access_denied");
            return errorMessage;
        }
        String dn = ReportMgmtHandler.getValue(result, mgmtIds[0]);
        if (menuId == RESTORE_USER_MENU_ID || menuId == RESTORE_COMP_MENU_ID) {
            dn = ReportMgmtHandler.getValue(result, mgmtIds[6]);
        }
        Hashtable authorizedDomainOUHash = authObject.getDomainOUsMap();
        ArrayList ouList = (ArrayList)authorizedDomainOUHash.get(domainName);
        boolean checkAuthorization = true;
        Long[] menuIdsNotBasedOnOus = new Long[]{DELETE_GPO_MENU_ID, ENABLE_GPO_MENU_ID, ENABLE_COMP_GPO_SETTINGS_MENU_ID, ENABLE_USER_GPO_SETTINGS_MENU_ID, DISABLE_GPO_MENU_ID};
        if (Arrays.asList(menuIdsNotBasedOnOus).contains(menuId)) {
            checkAuthorization = false;
        }
        if (checkAuthorization && !ClientAuthorizationUtil.isAuthorizedObject(dn, ouList)) {
            errorMessage = rb.getString("admp.reports.reports_to_mgmt.errmsg_access_denied");
            return errorMessage;
        }
        try {
            switch ((int)menuId.longValue()) {
                case 1: {
                    errorMessage = ReportMgmtHandler.deleteUsers(result, attributeList, domainName, loginId, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 1);
                    break;
                }
                case 2: {
                    errorMessage = ReportMgmtHandler.enableUsers(result, attributeList, domainName, dn, loginId, listener, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 1);
                    break;
                }
                case 3: {
                    errorMessage = ReportMgmtHandler.disableUsers(result, attributeList, domainName, dn, loginId, listener, mgmtIds, audit_info, auditDataObj, rb, true, guidVsPolicyStatusMap);
                    audit_info.put("objectIdForNotification", 1);
                    break;
                }
                case 4: {
                    errorMessage = ReportMgmtHandler.unLockUsers(result, attributeList, domainName, dn, loginId, listener, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 1);
                    break;
                }
                case 5: {
                    errorMessage = ReportMgmtHandler.changePwdNeverExpires(result, attributeList, domainName, dn, loginId, listener, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 1);
                    break;
                }
                case 6: {
                    errorMessage = ReportMgmtHandler.changePwdNextLogon(result, attributeList, domainName, dn, loginId, listener, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 1);
                    break;
                }
                case 7: {
                    errorMessage = ReportMgmtHandler.changeACNeverExpires(result, attributeList, domainName, dn, loginId, listener, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 1);
                    break;
                }
                case 8: {
                    errorMessage = ReportMgmtHandler.deleteComputers(result, attributeList, domainName, loginId, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 3);
                    break;
                }
                case 9: {
                    errorMessage = ReportMgmtHandler.enableComputers(result, attributeList, domainName, dn, loginId, listener, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 3);
                    break;
                }
                case 10: {
                    errorMessage = ReportMgmtHandler.disableComputers(result, attributeList, domainName, dn, loginId, listener, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 3);
                    break;
                }
                case 12: {
                    errorMessage = ReportMgmtHandler.restoreDeletedUsers(result, attributeList, domainName, dn, loginId, listener, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 1);
                    break;
                }
                case 13: {
                    errorMessage = ReportMgmtHandler.restoreDeletedComputers(result, attributeList, domainName, loginId, listener, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 3);
                    break;
                }
                case 14: {
                    errorMessage = ReportMgmtHandler.deleteGroups(result, attributeList, domainName, loginId, listener, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 2);
                    break;
                }
                case 15: {
                    errorMessage = ReportMgmtHandler.moveUserToOU(result, attributeList, domainName, loginId, listener, mgmtIds, audit_info, auditDataObj, rb, admpInput, ouList);
                    audit_info.put("objectIdForNotification", 2);
                    break;
                }
                case 16: {
                    errorMessage = ReportMgmtHandler.moveUserToOU(result, attributeList, domainName, loginId, listener, mgmtIds, audit_info, auditDataObj, rb, admpInput, ouList);
                    audit_info.put("objectIdForNotification", 1);
                    break;
                }
                case 17: {
                    errorMessage = ReportMgmtHandler.moveUserToOU(result, attributeList, domainName, loginId, listener, mgmtIds, audit_info, auditDataObj, rb, admpInput, ouList);
                    audit_info.put("objectIdForNotification", 3);
                    break;
                }
                case 18: {
                    errorMessage = ReportMgmtHandler.addToGroup(result, attributeList, domainName, loginId, listener, mgmtIds, audit_info, auditDataObj, rb, admpInput, ouList);
                    audit_info.put("objectIdForNotification", 1);
                    break;
                }
                case 20: {
                    errorMessage = ReportMgmtHandler.addToGroup(result, attributeList, domainName, loginId, listener, mgmtIds, audit_info, auditDataObj, rb, admpInput, ouList);
                    audit_info.put("objectIdForNotification", 3);
                    break;
                }
                case 19: {
                    errorMessage = ReportMgmtHandler.removeFromGroup(result, attributeList, domainName, loginId, listener, mgmtIds, audit_info, auditDataObj, rb, admpInput, ouList);
                    audit_info.put("objectIdForNotification", 1);
                    break;
                }
                case 21: {
                    errorMessage = ReportMgmtHandler.removeFromGroup(result, attributeList, domainName, loginId, listener, mgmtIds, audit_info, auditDataObj, rb, admpInput, ouList);
                    audit_info.put("objectIdForNotification", 3);
                    break;
                }
                case 22: {
                    errorMessage = ReportMgmtHandler.deleteOU(result, attributeList, domainName, loginId, mgmtIds, audit_info, auditDataObj, rb);
                    audit_info.put("objectIdForNotification", 3);
                    break;
                }
                case 23: {
                    errorMessage = ReportMgmtHandler.deleteGPO(result, attributeList, domainName, loginId, mgmtIds, audit_info, auditDataObj, rb);
                    break;
                }
                case 24: {
                    errorMessage = ReportMgmtHandler.enableDisableGPO(result, domainName, loginId, mgmtIds, audit_info, auditDataObj, new Integer(0), rb);
                    break;
                }
                case 25: {
                    errorMessage = ReportMgmtHandler.enableDisableGPO(result, domainName, loginId, mgmtIds, audit_info, auditDataObj, new Integer(3), rb);
                    break;
                }
                case 26: {
                    errorMessage = ReportMgmtHandler.enableDisableGPO(result, domainName, loginId, mgmtIds, audit_info, auditDataObj, new Integer(2), rb);
                    break;
                }
                case 27: {
                    errorMessage = ReportMgmtHandler.enableDisableGPO(result, domainName, loginId, mgmtIds, audit_info, auditDataObj, new Integer(1), rb);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errorMessage;
    }

    public static String deleteUsers(Hashtable result, ArrayList attributeList, String domainName, Long loginId, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage = rb.getString("admp.mgmt.user_mgmt.del_users.statmsg.successfully_deleted_user");
        try {
            String dn = ReportMgmtHandler.getValue(result, mgmtIds[0]);
            System.out.println("Delete User : " + domainName + " : DN : " + dn);
            String guid = ReportMgmtHandler.getValue(result, mgmtIds[5]);
            guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
            errorMessage = ReportMgmtHandler.deleteUser(domainName, loginId, guid, dn, result, rb);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        TechAuditAPI.getInstance().auditDeleteUser(loginId, rb.getString("admp.mgmt.user_mgmt.del_users.mgmtname.del_users"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, errorMessage.toString(), rb);
        return errorMessage;
    }

    public static String deleteUser(String domainName, Long loginId, String guid, String dn, Hashtable result, AdventNetResourceBundle rb) {
        StringBuffer errorMessage = new StringBuffer();
        try {
            errorMessage = DeleteUtil.deleteUser(domainName, loginId, dn, guid, result, rb);
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = new StringBuffer(e.getMessage(rb));
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = new StringBuffer(e.getMessage());
            e.printStackTrace();
        }
        return errorMessage.toString();
    }

    public static String restoreDeletedUsers(Hashtable result, ArrayList attributeList, String domainName, String dn, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage;
        block6: {
            errorMessage = rb.getString("admp.mgmt.user_mgmt.recycle_bin.statmsg.successfully_restored_user");
            try {
                int index;
                Boolean OUDeleted = false;
                String deletedDN = ReportMgmtHandler.getValue(result, mgmtIds[0]);
                String parentDN = ReportMgmtHandler.getValue(result, mgmtIds[6]);
                String sid = ReportMgmtHandler.getValue(result, mgmtIds[1]);
                String defaultNamingContext = DomainUtil.getDefaultNamingContext((String)domainName);
                int ind = parentDN.indexOf("\\0A");
                if (ind != -1) {
                    OUDeleted = true;
                    parentDN = "CN=Users," + defaultNamingContext;
                }
                if ((index = deletedDN.indexOf("\\0A")) != -1) {
                    String restoreDN = deletedDN.substring(0, index) + "," + parentDN;
                    System.out.println("Restoring the user,deletedDN: " + deletedDN + " to the destination: " + parentDN);
                    ADHandlerForMgmt.restoreDeletedObject((String)domainName, (Long)loginId, (String)deletedDN, (String)restoreDN, (String)parentDN);
                    ADHandlerForMgmt.updateUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)listener);
                    if (OUDeleted.booleanValue()) {
                        errorMessage = rb.getString("admp.mgmt.user_mgmt.recycle_bin.statmsg.successfully_restored_in_users_container");
                    }
                    break block6;
                }
                throw new Exception(rb.getString("admp.mgmt.user_mgmt.recycle_bin.statmsg.invalid_dn"));
            }
            catch (LocalizedException e) {
                e.printStackTrace();
                errorMessage = e.getMessage(rb);
                System.out.println("LocalizedException: - " + errorMessage);
            }
            catch (Exception e) {
                errorMessage = e.getMessage();
                e.printStackTrace();
            }
        }
        TechAuditAPI.getInstance().auditDeleteUser(loginId, rb.getString("admp.mgmt.user_mgmt.restore_users.mgmtname.restore_reclycle_bin"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, errorMessage.toString(), rb);
        return errorMessage;
    }

    public static String restoreDeletedComputers(Hashtable result, ArrayList attributeList, String domainName, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage;
        block6: {
            errorMessage = rb.getString("admp.mgmt.comp_mgmt.restore_comp.statmsg.successfully_restored");
            try {
                int index;
                Boolean OUDeleted = false;
                String deletedDN = ReportMgmtHandler.getValue(result, mgmtIds[0]);
                String parentDN = ReportMgmtHandler.getValue(result, mgmtIds[5]);
                String sid = ReportMgmtHandler.getValue(result, mgmtIds[1]);
                String defaultNamingContext = DomainUtil.getDefaultNamingContext((String)domainName);
                int ind = parentDN.indexOf("\\0A");
                if (ind != -1) {
                    OUDeleted = true;
                    parentDN = "CN=Computers," + defaultNamingContext;
                }
                if ((index = deletedDN.indexOf("\\0A")) != -1) {
                    String restoreDN = deletedDN.substring(0, index) + "," + parentDN;
                    System.out.println("Restoring the user,deletedDN: " + deletedDN + " to the destination: " + parentDN);
                    ADHandlerForMgmt.restoreDeletedObject((String)domainName, (Long)loginId, (String)deletedDN, (String)restoreDN, (String)parentDN);
                    DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])new String[]{"Computer"}, (boolean)false);
                    if (OUDeleted.booleanValue()) {
                        errorMessage = rb.getString("admp.mgmt.user_mgmt.recycle_bin.statmsg.successfully_restored_in_computers_container");
                    }
                    break block6;
                }
                throw new Exception(rb.getString("admp.mgmt.comp_mgmt.restore_comp.statmsg.invalid_dn"));
            }
            catch (LocalizedException e) {
                e.printStackTrace();
                errorMessage = e.getMessage(rb);
                System.out.println("LocalizedException: - " + errorMessage);
            }
            catch (Exception e) {
                errorMessage = e.getMessage();
                e.printStackTrace();
            }
        }
        TechAuditAPI.getInstance().auditDeleteUser(loginId, rb.getString("admp.mgmt.comp_mgmt.common.mgmtname.restore_deleted_computers"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, errorMessage.toString(), rb);
        return errorMessage;
    }

    public static String deleteComputers(Hashtable result, ArrayList attributeList, String domainName, Long loginId, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_deleted");
        try {
            String dn = ReportMgmtHandler.getValue(result, mgmtIds[0]);
            System.out.println("Delete computer : " + domainName + " : DN : " + dn);
            ADHandlerForMgmt.deleteUser((String)domainName, (Long)loginId, (String)CommonUtil.escapeDN((String)dn));
            UserHandler.deleteUser((String)domainName, (Long)loginId, (String)dn);
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = e.getMessage(rb);
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        TechAuditAPI.getInstance().auditDeleteUser(loginId, rb.getString("admp.mgmt.comp_mgmt.del_comps.mgmtname.del_comps"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, errorMessage.toString(), rb);
        return errorMessage;
    }

    public static String deleteOU(Hashtable result, ArrayList attributeList, String domainName, Long loginId, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_deleted");
        try {
            String dn = ReportMgmtHandler.getValue(result, mgmtIds[0]);
            System.out.println("Delete OU : " + domainName + " : DN : " + dn);
            ADHandler.deleteContact((String)domainName, (Long)loginId, (String)dn);
            UserHandler.deleteOU((String)dn);
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = e.getMessage(rb);
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        TechAuditAPI.getInstance().auditDeleteUser(loginId, rb.getString("admp.mgmt.ou_mgmt.dele_ous.mgmtname.delete_ous"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, errorMessage.toString(), rb);
        return errorMessage;
    }

    public static String disableUsers(Hashtable result, ArrayList attributeList, String domainName, String dn, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb, boolean isUserObject, HashMap guidVsPolicyStatusMap) {
        String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_disabled");
        ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
        String disablePolicyMsg = "";
        try {
            int userAccountControl = 0;
            int andUserAccountControl = 0xFFFFFFF;
            userAccountControl |= 2;
            Properties p = new Properties();
            p.put("DATA_HANDLER_TYPE", new Long(7L));
            p.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p.put("ATTRIB_LDAP_NAME", "userAccountControl");
            p.put("ATTRIB_VALUE", String.valueOf(userAccountControl));
            p.put("ATTRIB_AND_VALUE", String.valueOf(andUserAccountControl));
            modifyAttributeList.add(p);
            String sid = ReportMgmtHandler.getValue(result, mgmtIds[1]);
            String objGuid = (String)result.get("OBJECT_GUID");
            String guid = objGuid.substring(objGuid.indexOf("{") + 1, objGuid.indexOf("}"));
            System.out.println("Disable Obj attr list : " + attributeList + " : Modify List : " + modifyAttributeList + " : SID :" + sid + " : Domain Name : " + domainName);
            ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, null, new ArrayList(), modifyAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
            HashMap policyStatusMap = new HashMap();
            if (isUserObject) {
                disablePolicyMsg = DeleteUtil.executeDisablePolicyTasks(domainName, loginId, guid, ReportMgmtHandler.getValue(result, mgmtIds[0]), sid, result, rb, policyStatusMap);
                if (policyStatusMap.size() > 0) {
                    CommonUtil.getAttributeModified(policyStatusMap, modifyAttributeList, (AdventNetResourceBundle)rb);
                    guidVsPolicyStatusMap.put(objGuid, policyStatusMap);
                    guidVsPolicyStatusMap.put("auditMessage", disablePolicyMsg);
                }
            }
            if (policyStatusMap.isEmpty()) {
                guidVsPolicyStatusMap.remove(guid);
            }
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = e.getMessage(rb);
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        Properties p2 = (Properties)modifyAttributeList.get(0);
        p2.put("ATTRIB_LDAP_NAME", "UserAccountStatus");
        p2.put("ATTRIB_VALUE", rb.getString("admp.ad_explorer.view_props.user.common.statmsg.disabled"));
        TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt_or_comp_mgmt.dis_user_or_comp.mgmtname.dis_user_or_comp"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, modifyAttributeList, new ArrayList(), new ArrayList(), errorMessage.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        return errorMessage;
    }

    public static String enableUsers(Hashtable result, ArrayList attributeList, String domainName, String dn, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_enabled");
        ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
        try {
            int userAccountControl = 0;
            int andUserAccountControl = 0xFFFFFFF;
            andUserAccountControl &= 0xFFFFFD;
            Properties p = new Properties();
            p.put("DATA_HANDLER_TYPE", new Long(7L));
            p.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p.put("ATTRIB_LDAP_NAME", "userAccountControl");
            p.put("ATTRIB_VALUE", String.valueOf(userAccountControl));
            p.put("ATTRIB_AND_VALUE", String.valueOf(andUserAccountControl));
            modifyAttributeList.add(p);
            String sid = ReportMgmtHandler.getValue(result, mgmtIds[1]);
            System.out.println("Enable Obj attr list : " + attributeList + " : Modify List : " + modifyAttributeList + " : SID :" + sid + " : Domain Name : " + domainName);
            ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, null, new ArrayList(), modifyAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = e.getMessage(rb);
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        Properties p2 = (Properties)modifyAttributeList.get(0);
        p2.put("ATTRIB_LDAP_NAME", "UserAccountStatus");
        p2.put("ATTRIB_VALUE", rb.getString("admp.ad_explorer.view_props.user.common.statmsg.enabled"));
        TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt_or_comp_mgmt.ena_user_or_comp.mgmtname.ena_user_or_comp"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, modifyAttributeList, new ArrayList(), new ArrayList(), errorMessage.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        return errorMessage;
    }

    public static String unLockUsers(Hashtable result, ArrayList attributeList, String domainName, String dn, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_modified");
        ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
        try {
            boolean userAccountControl = false;
            int andUserAccountControl = 0xFFFFFFF;
            andUserAccountControl &= 0xFFFFFEF;
            Properties p1 = new Properties();
            p1.put("DATA_HANDLER_TYPE", new Long(10L));
            p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p1.put("ATTRIB_LDAP_NAME", "lockoutTime");
            p1.put("ATTRIB_VALUE", new Long(0L));
            setAttributeList.add(p1);
            String sid = ReportMgmtHandler.getValue(result, mgmtIds[1]);
            ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, null, setAttributeList, new ArrayList(), new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = e.getMessage(rb);
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt.unlock_users.mgmtname.unlock_user"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, setAttributeList, new ArrayList(), new ArrayList(), errorMessage.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        return errorMessage;
    }

    public static String changePwdNeverExpires(Hashtable result, ArrayList attributeList, String domainName, String dn, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_modified");
        ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
        try {
            String sid = ReportMgmtHandler.getValue(result, mgmtIds[1]);
            if (ADHandlerForMgmt.checkUserMustChangePassword((String)domainName, (Long)loginId, (String)sid, (String)dn)) {
                errorMessage = rb.getString("client.reports.ReportMgmtHandler.user_must_change_password_at_next_logon_is_already_set_to_this_user");
            } else if (ADHandlerForMgmt.checkPasswordNeverExpires((String)domainName, (Long)loginId, (String)sid, (String)dn)) {
                errorMessage = rb.getString("client.reports.ReportMgmtHandler.password_never_expires_is_already_set_to_this_user");
            } else {
                int userAccountControl = 0;
                int andUserAccountControl = 0xFFFFFFF;
                Properties p = new Properties();
                p.put("DATA_HANDLER_TYPE", new Long(7L));
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", "userAccountControl");
                p.put("ATTRIB_VALUE", String.valueOf(userAccountControl |= 0x10000));
                p.put("ATTRIB_AND_VALUE", String.valueOf(andUserAccountControl));
                p.put("ATTRIB_UAC_VALUE", MessageFormat.format(rb.getString("admp.auditing.uac_password_never_expire_flag"), rb.getString("admp.common.attribvalue.true")));
                modifyAttributeList.add(p);
                ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, null, new ArrayList(), modifyAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
            }
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = e.getMessage(rb);
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt.chg_pwd_never_exp.mgmtname.chg_pwd_never_exp"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, modifyAttributeList, new ArrayList(), new ArrayList(), errorMessage.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        return errorMessage;
    }

    public static String changePwdNextLogon(Hashtable result, ArrayList attributeList, String domainName, String dn, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_modified");
        ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
        try {
            String sid = ReportMgmtHandler.getValue(result, mgmtIds[1]);
            String samAccountName = ReportMgmtHandler.getValue(result, mgmtIds[4]);
            if (ADHandlerForMgmt.checkCantChangePassword((String)domainName, (Long)loginId, (String)samAccountName, (String)dn)) {
                errorMessage = rb.getString("client.reports.ReportMgmtHandler.user_cannot_change_password_is_already_set_to_this_user");
            } else if (ADHandlerForMgmt.checkPasswordNeverExpires((String)domainName, (Long)loginId, (String)sid, (String)dn)) {
                errorMessage = rb.getString("client.reports.ReportMgmtHandler.password_never_expires_is_already_set_to_this_user");
            } else {
                Properties p = new Properties();
                p.put("DATA_HANDLER_TYPE", new Long(10L));
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", "pwdLastSet");
                p.put("ATTRIB_VALUE", new Long(0L));
                setAttributeList.add(p);
                ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, null, setAttributeList, new ArrayList(), new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
            }
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = e.getMessage(rb);
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt.chg_pwd_next_log.mgmtname.chg_pwd_next_log"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, setAttributeList, new ArrayList(), new ArrayList(), errorMessage.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        return errorMessage;
    }

    public static String changeACNeverExpires(Hashtable result, ArrayList attributeList, String domainName, String dn, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_modified");
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            Properties p = new Properties();
            p.put("DATA_HANDLER_TYPE", new Long(10L));
            p.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p.put("ATTRIB_LDAP_NAME", "accountExpires");
            Long expireTime = new Long(0L);
            p.put("ATTRIB_VALUE", expireTime);
            list.add(p);
            String sid = ReportMgmtHandler.getValue(result, mgmtIds[1]);
            ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, null, list, new ArrayList(), new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = e.getMessage(rb);
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt.chg_acct_never_exp.mgmtname.chg_acct_never_exp"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, list, new ArrayList(), new ArrayList(), errorMessage.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        return errorMessage;
    }

    public static String enableComputers(Hashtable result, ArrayList attributeList, String domainName, String dn, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        return ReportMgmtHandler.enableUsers(result, attributeList, domainName, dn, loginId, listener, mgmtIds, audit_info, auditDataObj, rb);
    }

    public static String disableComputers(Hashtable result, ArrayList attributeList, String domainName, String dn, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        return ReportMgmtHandler.disableUsers(result, attributeList, domainName, dn, loginId, listener, mgmtIds, audit_info, auditDataObj, rb, false, new HashMap());
    }

    public static String deleteGroups(Hashtable result, ArrayList attributeList, String domainName, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_deleted");
        try {
            String dn = ReportMgmtHandler.getValue(result, mgmtIds[0]);
            dn = CommonUtil.escapeDN((String)dn);
            ADHandler.deleteGroup((String)domainName, (Long)loginId, (String)dn);
            GroupHandler.deleteGroup((String)domainName, (Long)loginId, (String)dn);
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = e.getMessage(rb);
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        TechAuditAPI.getInstance().auditDeleteGroup(loginId, rb.getString("admp.mgmt.grp_mgmt.del_grps.mgmtname.del_grps"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, errorMessage.toString(), rb);
        return errorMessage;
    }

    public static String moveUserToOU(Hashtable result, ArrayList attributeList, String domainName, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb, AdmpInput admpInput, ArrayList ouList) {
        String destinationOU;
        String dn;
        StringBuffer message;
        block9: {
            message = new StringBuffer();
            dn = ReportMgmtHandler.getValue(result, mgmtIds[0]);
            String sid = ReportMgmtHandler.getValue(result, mgmtIds[1]);
            destinationOU = "";
            if (admpInput.getIsMultiple().booleanValue()) {
                ArrayList fcOptionList = admpInput.getMultipleInput();
                for (FcOption fcOption : fcOptionList) {
                    if (!fcOption.getLabel().equalsIgnoreCase("Container")) continue;
                    destinationOU = fcOption.getValue();
                }
            }
            if (!ClientAuthorizationUtil.isAuthorizedObject(destinationOU, ouList)) {
                return rb.getString("admp.reports.reports_to_mgmt.errmsg_access_denied");
            }
            try {
                if (!destinationOU.equals("")) {
                    ADHandlerForMgmt.moveObject((String)domainName, (Long)loginId, (String)dn, (String)destinationOU);
                    ADHandlerForMgmt.updateUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                    } else {
                        message.insert(0, rb.getString("admp.mgmt.common.statmsg.successfully_modified_error"));
                    }
                    break block9;
                }
                System.out.println("Move to container action.. Error occurred while parsing input.. This case wont be occurred.. FIXME " + admpInput.serializeToJsonObject());
                throw new Exception(rb.getString("admp.mgmt.common.text.error"));
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), new String(le.getMessage(rb))));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), new String(e.getMessage())));
                e.printStackTrace();
            }
        }
        TechAuditAPI.getInstance().auditMoveUser(loginId, rb.getString("admp.mgmt.common.mgmtname.move_user"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, dn, destinationOU, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        return message.toString();
    }

    public static String addToGroup(Hashtable result, ArrayList attributeList, String domainName, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb, AdmpInput admpInput, ArrayList ouList) throws Exception {
        String dn = ReportMgmtHandler.getValue(result, mgmtIds[0]);
        String sid = ReportMgmtHandler.getValue(result, mgmtIds[1]);
        StringBuffer message = new StringBuffer();
        String status = "";
        ArrayList<String> addToGroupNameList = new ArrayList<String>();
        ArrayList<String> addToGroupSidList = new ArrayList<String>();
        if (admpInput.getIsMultiple().booleanValue()) {
            ArrayList fcOptionList = admpInput.getMultipleInput();
            for (FcOption fcOption : fcOptionList) {
                addToGroupSidList.add(fcOption.getValue());
                addToGroupNameList.add(fcOption.getLabel());
            }
        }
        ArrayList<Hashtable> handleErrorList = new ArrayList<Hashtable>();
        ArrayList groupList = new ArrayList();
        String groupModifyStatusMessage = "";
        if (addToGroupSidList != null && addToGroupSidList.size() > 0) {
            groupList = GroupHandler.getDNList((String)domainName, addToGroupSidList);
        }
        if (groupList.size() > 0) {
            int errorFlag = 0;
            ArrayList<Properties> list = new ArrayList<Properties>();
            Properties p = new Properties();
            p.put("ATTRIB_VALUE", groupList);
            p.put("ATTRIB_VALUE_COUNT", new Long(groupList.size()));
            p.put("DATA_HANDLER_TYPE", new Long(1L));
            p.put("ATTRIB_LDAP_NAME", "member");
            p.put("DW_CONTROL_CODE", new Long(3L));
            list.add(p);
            try {
                NativeError errHdlr = ADHandlerForMgmt.modifyGroup((String)domainName, (Long)loginId, (String)sid, (String)dn, new ArrayList(), (ArrayList)groupList, (boolean)true);
                for (int index = 0; index < groupList.size(); ++index) {
                    String errorSeverity = errHdlr.getSeverityLevel(groupList.get(index));
                    if (errorSeverity == null || !errorSeverity.equals("WARNING")) continue;
                    Hashtable errorDetails = errHdlr.getErrorDetails(groupList.get(index));
                    if (errorDetails != null) {
                        handleErrorList.add(errorDetails);
                    }
                    ++errorFlag;
                }
            }
            catch (LocalizedException le) {
                ReportMgmtHandler.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                status = le.getMsgFromDetails(rb);
            }
            catch (Exception ex) {
                message.append(ex.getMessage());
                if (ex.getMessage() != null) {
                    status = ex.getMessage();
                }
                ex.printStackTrace();
            }
            groupModifyStatusMessage = GroupErrorHandler.handleModifyGroupError(handleErrorList, groupList.size(), rb, new ArrayList(), "", "add", errorFlag);
            message.append(groupModifyStatusMessage);
            ReportMgmtHandler.fillAttribs(list, "memberOf", addToGroupNameList);
            TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt.grp_attribs.mgmtname.add_to_group"), ReportMgmtHandler.getValue(result, 1010), domainName, list, new ArrayList(), new ArrayList(), status, (Long)audit_info.get("object_id"), auditDataObj, rb);
            try {
                ADHandlerForMgmt.updateUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)listener);
            }
            catch (LocalizedException le) {
                message.append(le.getMessage(rb));
            }
            System.out.println("AddToGroup Final status message " + message + " for the DN " + dn);
        }
        return message.toString();
    }

    public static String removeFromGroup(Hashtable result, ArrayList attributeList, String domainName, Long loginId, NativeListener listener, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb, AdmpInput admpInput, ArrayList ouList) throws Exception {
        String dn = ReportMgmtHandler.getValue(result, mgmtIds[0]);
        String sid = ReportMgmtHandler.getValue(result, mgmtIds[1]);
        String primaryGrp = ReportMgmtHandler.getValue(result, mgmtIds[3]);
        StringBuffer message = new StringBuffer();
        String status = "";
        ArrayList<String> removeFromGroupSidList = new ArrayList<String>();
        ArrayList<String> removeFromGroupNameList = new ArrayList<String>();
        Boolean isRemoveFromAllGroup = false;
        System.out.println("RemoveFromGroup admpInput " + admpInput.serializeToJsonObject());
        if (admpInput.getIsMultiple().booleanValue()) {
            ArrayList fcOptionList = admpInput.getMultipleInput();
            for (FcOption fcOption : fcOptionList) {
                if (fcOption.getLabel().equalsIgnoreCase("isRemoveAllGroup")) {
                    isRemoveFromAllGroup = Boolean.parseBoolean(fcOption.getValue());
                    continue;
                }
                removeFromGroupSidList.add(fcOption.getValue());
                removeFromGroupNameList.add(fcOption.getLabel());
            }
        }
        if (isRemoveFromAllGroup.booleanValue()) {
            System.out.println("Going to Remove From all group from the user : " + dn);
            String searchString = "(&(objectCategory=Group)(objectClass=group)(member=" + dn + "))";
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            ArrayList<String> groupAttributeList = new ArrayList<String>();
            groupAttributeList.add("cn");
            groupAttributeList.add("distinguishedName");
            groupAttributeList.add("objectSid");
            ArrayList grouplistProps = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), groupAttributeList, (String)searchString);
            if (grouplistProps.isEmpty()) {
                message = new StringBuffer(rb.getString("admp.workflow.view_request.stat_msg.user_not_part_of_any_group_other_than_primary"));
            } else {
                removeFromGroupSidList = new ArrayList();
                removeFromGroupNameList = new ArrayList();
                for (int index = 0; index < grouplistProps.size(); ++index) {
                    Properties props = (Properties)grouplistProps.get(index);
                    if (props == null) continue;
                    ArrayList groupObjectSid = (ArrayList)props.get("objectSid");
                    removeFromGroupSidList.add((String)groupObjectSid.get(0));
                    ArrayList groupObjectName = (ArrayList)props.get("cn");
                    removeFromGroupNameList.add((String)groupObjectName.get(0));
                }
            }
        }
        System.out.println("removeFromGroupNameList " + removeFromGroupNameList + " removeFromGroupSidList " + removeFromGroupSidList);
        ArrayList<Hashtable> handleErrorList = new ArrayList<Hashtable>();
        ArrayList groupList = new ArrayList();
        String groupModifyStatusMessage = "";
        if (removeFromGroupSidList != null && !removeFromGroupSidList.isEmpty()) {
            handleErrorList = new ArrayList();
            ArrayList<Properties> list = new ArrayList<Properties>();
            Properties p = new Properties();
            p.put("ATTRIB_VALUE", dn);
            p.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p.put("DATA_HANDLER_TYPE", new Long(3L));
            p.put("ATTRIB_LDAP_NAME", "member");
            p.put("DW_CONTROL_CODE", new Long(4L));
            list.add(p);
            boolean flag = false;
            int removeFailCount = 0;
            for (int index = 0; index < removeFromGroupSidList.size(); ++index) {
                try {
                    ADHandlerForMgmt.modifyGroup((String)domainName, (Long)loginId, (String)((String)removeFromGroupSidList.get(index)), (String)dn, list, null, (boolean)true);
                    continue;
                }
                catch (LocalizedException le) {
                    ReportMgmtHandler.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                    status = le.getMsgFromDetails(rb);
                    flag = true;
                    ++removeFailCount;
                    continue;
                }
                catch (Exception ex) {
                    message.append(ex.getMessage());
                    status = ex.getMessage();
                    ++removeFailCount;
                    flag = true;
                }
            }
            groupModifyStatusMessage = GroupErrorHandler.handleModifyGroupError(handleErrorList, removeFromGroupSidList.size(), rb, removeFromGroupNameList, primaryGrp, "remove", removeFailCount);
            message.append(groupModifyStatusMessage);
            ReportMgmtHandler.fillAttribs(list, "memberOf", removeFromGroupNameList);
            TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt.grp_attribs.mgmtname.remove_from_group"), ReportMgmtHandler.getValue(result, 1010), domainName, list, new ArrayList(), new ArrayList(), status, (Long)audit_info.get("object_id"), auditDataObj, rb);
            try {
                ADHandlerForMgmt.updateUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)listener);
            }
            catch (LocalizedException le) {
                message.append(le.getMessage(rb));
            }
        }
        return message.toString();
    }

    public static String enableDisableGPO(Hashtable result, String domainName, Long loginId, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, Integer action, AdventNetResourceBundle rb) {
        String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_modified");
        ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
        String curGpcGuid = (String)result.get("OBJECT_GUID");
        curGpcGuid = curGpcGuid.replaceAll("[{}]", "");
        ArrayList<String> gpcguid = new ArrayList<String>();
        gpcguid.add(curGpcGuid);
        try {
            ArrayList results = ADHandler.gpoEnableDisable((String)domainName, (Long)loginId, (int)action, gpcguid);
            String userconfig = "admp.ad_explorer.view_props.user.common.statmsg.enabled";
            String computerconfig = "admp.ad_explorer.view_props.user.common.statmsg.enabled";
            if ((action & 2) == 2) {
                computerconfig = "admp.ad_explorer.view_props.user.common.statmsg.disabled";
            }
            if ((action & 1) == 1) {
                userconfig = "admp.ad_explorer.view_props.user.common.statmsg.disabled";
            }
            if (results != null && results.size() > 0) {
                int resSize = results.size();
                ArrayList<String> updateGpcGuids = new ArrayList<String>();
                for (int i = 0; i < resSize; ++i) {
                    String msgtype = ((Properties)results.get(i)).getProperty("msgtype");
                    String msg = ((Properties)results.get(i)).getProperty("msg");
                    if (msgtype != null && msgtype.equalsIgnoreCase("success")) {
                        updateGpcGuids.add("{" + ((Properties)results.get(i)).getProperty("gpoid") + "}");
                        Properties p = new Properties();
                        p.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.comp_conf_settings"));
                        if (computerconfig.equals("admp.ad_explorer.view_props.user.common.statmsg.disabled")) {
                            p.put("ATTRIB_VALUE", rb.getString("admp.ad_explorer.view_props.user.common.statmsg.disabled"));
                        } else {
                            p.put("ATTRIB_VALUE", rb.getString("admp.ad_explorer.view_props.user.common.statmsg.enabled"));
                        }
                        modifyAttributeList.add(p);
                        p = new Properties();
                        p.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.user_conf_settings"));
                        if (userconfig.equals("admp.ad_explorer.view_props.user.common.statmsg.disabled")) {
                            p.put("ATTRIB_VALUE", rb.getString("admp.ad_explorer.view_props.user.common.statmsg.disabled"));
                        } else {
                            p.put("ATTRIB_VALUE", rb.getString("admp.ad_explorer.view_props.user.common.statmsg.enabled"));
                        }
                        modifyAttributeList.add(p);
                        continue;
                    }
                    errorMessage = rb.getString(msg);
                }
                if (updateGpcGuids.size() > 0) {
                    GPOMgmtHandler.updateGpoStatus(updateGpcGuids, (String)userconfig, (String)computerconfig, (String)("" + action), (String)domainName);
                }
            }
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = e.getMessage(rb);
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt_or_comp_mgmt.ena_user_or_comp.mgmtname.ena_user_or_comp"), ReportMgmtHandler.getValue(result, mgmtIds[0]), domainName, modifyAttributeList, new ArrayList(), new ArrayList(), errorMessage.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        return errorMessage;
    }

    public static String deleteGPO(Hashtable result, ArrayList attributeList, String domainName, Long loginId, int[] mgmtIds, Hashtable audit_info, DataObject auditDataObj, AdventNetResourceBundle rb) {
        String errorMessage = rb.getString("admp.mgmt.common.text.successfully_deleted");
        ArrayList modifyAttributeList = new ArrayList();
        String gpDn = (String)result.get(mgmtIds[0]);
        try {
            ADHandler.deleteGPO((String)domainName, (Long)loginId, (String)gpDn);
        }
        catch (LocalizedException e) {
            e.printStackTrace();
            errorMessage = e.getMessage(rb);
            System.out.println("LocalizedException: - " + errorMessage);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        return errorMessage;
    }

    public static String getValue(Hashtable h, int i) {
        return ReportMgmtHandler.getValue(h, new Integer(i));
    }

    public static String getValue(Hashtable h, Integer i) {
        String s = (String)h.get(i);
        if (s == null || s.equalsIgnoreCase("null") || s.equalsIgnoreCase("-")) {
            s = "";
        }
        return s;
    }

    public static void fillAttribs(ArrayList list, String attribName, Object attribValue) {
        if (list != null && list.size() > 0) {
            Properties prop = (Properties)list.get(0);
            prop.put("ATTRIB_LDAP_NAME", attribName);
            if (attribValue instanceof String) {
                prop.put("ATTRIB_VALUE", attribValue.toString());
            } else if (attribValue instanceof ArrayList) {
                prop.put("ATTRIB_LDAP_NAME", attribName);
                prop.put("ATTRIB_VALUE_COUNT", (Object)2L);
                prop.put("ATTRIB_VALUE", attribValue);
            }
        }
    }

    private static void addErrorMsgDetails(ArrayList<Hashtable> handlerErrorMsgList, ArrayList nativeErrorMsgList) {
        if (nativeErrorMsgList != null & !nativeErrorMsgList.isEmpty()) {
            for (int count = 0; count < nativeErrorMsgList.size(); ++count) {
                handlerErrorMsgList.add((Hashtable)nativeErrorMsgList.get(count));
            }
        }
    }
}

