/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DerivedTable;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.util.ReportClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportResultInputUtil {
    public static ArrayList<Hashtable<String, ArrayList<Hashtable<String, Object>>>> getCVCSelectedInputList(Integer reportId, Long generatioId, Integer startIndex, String searchText) {
        ArrayList<Hashtable<String, ArrayList<Hashtable<String, Object>>>> cvcInputList = new ArrayList<Hashtable<String, ArrayList<Hashtable<String, Object>>>>();
        try {
            DataObject dataObj = ListenerUtil.getInputTablesDO(reportId);
            if (dataObj != null) {
                Iterator it = dataObj.getRows("ADSMInputMappingDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String tableName = (String)r.get("INPUT_TABLE_NAME");
                    String key = (String)r.get("KEY_VALUE");
                    Hashtable<String, ArrayList<Hashtable<String, Object>>> hash = new Hashtable<String, ArrayList<Hashtable<String, Object>>>();
                    hash.put(key, ReportResultInputUtil.getCVCSelectedInputList(tableName, generatioId, startIndex, key, searchText));
                    cvcInputList.add(hash);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cvcInputList;
    }

    public static Integer getCVCSelectedInputsCount(Integer reportId, Long generationId, String searchText) throws Exception {
        Integer count = 0;
        try {
            DataObject dataObj = ListenerUtil.getInputTablesDO(reportId);
            if (dataObj != null) {
                Iterator it = dataObj.getRows("ADSMInputMappingDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String tableName = (String)r.get("INPUT_TABLE_NAME");
                    String keyValue = (String)r.get("KEY_VALUE");
                    String clientValueColumnName = "INPUT_NAME";
                    if (tableName.equalsIgnoreCase("ADSMReportOtherInputDetails")) {
                        clientValueColumnName = "INPUT_PROPERTY_VALUE";
                    }
                    if (!keyValue.equalsIgnoreCase("trusteesList") && !keyValue.equalsIgnoreCase("operatingSystem") && !keyValue.equalsIgnoreCase("pathList")) continue;
                    SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
                    Column col = Column.getColumn((String)tableName, (String)"INPUT_ID");
                    Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                    if (searchText != null) {
                        crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)clientValueColumnName), (Object)searchText, 2));
                    }
                    Column countColumn = col.distinct();
                    query.addSelectColumn(countColumn.count());
                    query.setCriteria(crit);
                    count = DBUtil.getCount((SelectQuery)query);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return count;
    }

    private static String getInputTable(Integer reportId, Long scheduleId) {
        String inputTable = null;
        String inputMappingTable = null;
        String tableColumn = null;
        String[] keyValues = new String[]{"trusteesList", "trustee", "operatingSystem", "pathList"};
        String[] tableValues = new String[]{"ADSMReportObjectDNDetails", "ADSMSchedulerMultiValues"};
        try {
            inputMappingTable = scheduleId != null ? "ADSMReportInputParams" : "ADSMInputMappingDetails";
            tableColumn = scheduleId != null ? "TABLE_NAME" : "INPUT_TABLE_NAME";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)inputMappingTable));
            sq.addSelectColumn(Column.getColumn((String)inputMappingTable, (String)"REPORT_ID"));
            sq.addSelectColumn(Column.getColumn((String)inputMappingTable, (String)tableColumn));
            Criteria crit = new Criteria(Column.getColumn((String)inputMappingTable, (String)"REPORT_ID"), (Object)reportId, 0);
            if (inputMappingTable.equalsIgnoreCase("ADSMInputMappingDetails")) {
                sq.addSelectColumn(Column.getColumn((String)inputMappingTable, (String)"KEY_VALUE"));
                crit = crit.and(new Criteria(Column.getColumn((String)inputMappingTable, (String)"KEY_VALUE"), (Object)keyValues, 8));
            } else {
                crit = crit.and(new Criteria(Column.getColumn((String)inputMappingTable, (String)"TABLE_NAME"), (Object)tableValues, 8));
            }
            sq.setCriteria(crit);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getFirstRow(inputMappingTable);
                inputTable = (String)row.get(tableColumn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputTable;
    }

    public static ArrayList getInputList(Long genID, Integer reportId, ReportFilterConfig rfConfig) {
        ArrayList inputList = new ArrayList();
        try {
            Long keyValue;
            String inputTable;
            Long scheduleId = null;
            if (rfConfig != null) {
                scheduleId = rfConfig.getScheduleId();
            }
            if ((inputTable = ReportResultInputUtil.getInputTable(reportId, scheduleId)) == null) {
                return inputList;
            }
            String inputColumn = "INPUT_NAME";
            String inputId = "INPUT_ID";
            String keyColumn = scheduleId != null ? "REPORT_VALUE_ID" : "REPORT_GENERATION_ID";
            Long l = keyValue = scheduleId != null ? rfConfig.getSchedulerValuesMapping() : genID;
            if (inputTable.equalsIgnoreCase("ADSMReportOtherInputDetails")) {
                inputColumn = "INPUT_PROPERTY_VALUE";
            } else if (inputTable.equalsIgnoreCase("ADSMReportObjectDNDetails")) {
                inputId = "UNIQUE_VALUE_MAPPING";
                inputColumn = "NAME";
            } else if (inputTable.equalsIgnoreCase("ADSMSchedulerMultiValues")) {
                inputId = "UNIQUE_VALUE_MAPPING";
                inputColumn = "INPUT_VALUE";
            }
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)inputTable));
            sq.addSelectColumn(Column.getColumn((String)inputTable, (String)inputId));
            sq.addSelectColumn(Column.getColumn((String)inputTable, (String)inputColumn));
            sq.setCriteria(new Criteria(Column.getColumn((String)inputTable, (String)keyColumn), (Object)keyValue, 0));
            SortColumn sortcolumn = new SortColumn(new Column(inputTable, inputColumn), true);
            sq.addSortColumn(sortcolumn);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (dataObj != null) {
                Iterator it = dataObj.getRows(inputTable);
                while (it.hasNext()) {
                    Hashtable<String, Object> hash = new Hashtable<String, Object>();
                    Row row = (Row)it.next();
                    hash.put("INPUT_ID", row.get(inputId));
                    hash.put("INPUT_NAME", row.get(inputColumn));
                    inputList.add(hash);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputList;
    }

    public static ArrayList<Hashtable<String, Object>> getCVCSelectedInputList(String inputTableName, Long reportGenerationId, Integer startIndex, String key, String searchText) throws Exception {
        ArrayList<Hashtable<String, Object>> cvcInputList = new ArrayList<Hashtable<String, Object>>();
        try {
            Hashtable<String, Object> cvcInputDetails = null;
            String clientValueColumnName = "INPUT_NAME";
            String serverValueColumnName = "DISTINGUISHED_NAME";
            if (inputTableName.equalsIgnoreCase("ADSMReportOtherInputDetails")) {
                serverValueColumnName = "INPUT_PROPERTY_NAME";
                clientValueColumnName = "INPUT_PROPERTY_VALUE";
            } else if (inputTableName.equalsIgnoreCase("ADSMReportShareInputDetails")) {
                serverValueColumnName = "SERVER_SID";
            }
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)inputTableName));
            Criteria criteria = new Criteria(Column.getColumn((String)inputTableName, (String)"REPORT_GENERATION_ID"), (Object)reportGenerationId, 0);
            if (inputTableName.equalsIgnoreCase("ADSMReportOtherInputDetails")) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)inputTableName, (String)"INPUT_PROPERTY_NAME"), (Object)key, 0));
            }
            if (searchText != null) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)inputTableName, (String)clientValueColumnName), (Object)searchText, 2));
            }
            query.setCriteria(criteria);
            query.addSelectColumn(new Column(inputTableName, "*"));
            if (startIndex != -1) {
                query.setRange(new Range(startIndex.intValue(), RVCConstants.OUTPUT_FILTER_QUERY_RANGE));
            }
            query.addSortColumn(new SortColumn(Column.getColumn((String)inputTableName, (String)"INPUT_ID"), true));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator it = dataObject.getRows(inputTableName);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                cvcInputDetails = new Hashtable<String, Object>();
                String inputName = (String)row.get(clientValueColumnName);
                cvcInputDetails.put("inputId", row.get("INPUT_ID"));
                if (key.equalsIgnoreCase("operatingSystem")) {
                    inputName = ReportResultInputUtil.getInputFilterDisplayName(inputName);
                }
                cvcInputDetails.put("objectGUID", row.get(serverValueColumnName));
                cvcInputDetails.put("objectName", inputName);
                cvcInputList.add(cvcInputDetails);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cvcInputList;
    }

    public static String getInputFilterDisplayName(String inputName) {
        inputName = inputName.replaceAll("\\*", "");
        inputName = inputName.replaceAll(":", " - ");
        return inputName;
    }

    public static ArrayList getSelectedSids(HttpServletRequest request, ReportBean reportBean) {
        ArrayList selectedSidList = new ArrayList();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject selectedSidsJson = null;
            JSONObject cvcFilter = null;
            String oldResultTableName = request.getParameter("oldResultTableName");
            String oldGenerationIdStr = request.getParameter("oldGenerationId");
            Long oldGenerationId = Long.parseLong(oldGenerationIdStr);
            String domainName = request.getParameter("domainName");
            String isIntersect = request.getParameter("intersect");
            JSONObject jsonObject = new JSONObject(request.getParameter("params"));
            if (request.getParameter("selectedSids") != null) {
                selectedSidsJson = new JSONObject(request.getParameter("selectedSids"));
                if (request.getParameter("cvcFilter") != null) {
                    cvcFilter = new JSONObject(request.getParameter("cvcFilter"));
                    cvcFilter.put("resourceBundle", (Object)rb);
                }
                AbstractListener listener = reportBean.getListener();
                selectedSidList = ReportResultInputUtil.getSelectedSids(selectedSidsJson, cvcFilter, jsonObject, oldResultTableName, oldGenerationId, listener.baseTableName, domainName, isIntersect, listener);
            }
            JSONArray selectedSidsArray = selectedSidsJson.getJSONArray("selectedSids");
            String[] selectedSids = FcJSONUtility.getStringArray((JSONArray)selectedSidsArray);
            if (selectedSidList.size() == 0 && selectedSidsJson != null && !selectedSidsJson.getBoolean("checkAllUsers") && selectedSids == null) {
                Integer reportId = (Integer)reportBean.get("reportId");
                ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId);
                AbstractListener listener = reportBean.getListener();
                ReportReqParams reqParams = new ReportReqParams(jsonObject);
                ArrayList<String> tableNames = new ArrayList<String>();
                Criteria crit = null;
                Criteria columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(attributelist, reqParams, tableNames);
                columnSearchCriteria = listener.getReportFilterCriteria(columnSearchCriteria, reqParams, tableNames);
                Criteria reportFiltercriteria = listener.getReportResultFilterCriteria(request, reqParams, crit);
                if (columnSearchCriteria != null) {
                    crit = columnSearchCriteria;
                }
                if (reportFiltercriteria != null) {
                    crit = crit != null ? crit.and(reportFiltercriteria) : reportFiltercriteria;
                }
                Criteria domainFilterCriteria = null;
                if (domainName != null) {
                    if (!tableNames.contains(listener.baseTableName)) {
                        tableNames.add(listener.baseTableName);
                    }
                    domainFilterCriteria = new Criteria(Column.getColumn((String)listener.baseTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                }
                Criteria resutlTableCriteria = new Criteria(Column.getColumn((String)listener.resultTableName, (String)"REPORT_GENERATION_ID"), (Object)oldGenerationId, 0);
                if (crit != null) {
                    resutlTableCriteria = resutlTableCriteria.and(crit);
                }
                if (domainFilterCriteria != null) {
                    resutlTableCriteria = resutlTableCriteria.and(domainFilterCriteria);
                }
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)listener.resultTableName));
                sq.addSelectColumn(Column.getColumn((String)listener.resultTableName, (String)"*"));
                sq.setCriteria(resutlTableCriteria);
                for (int i = 0; i < tableNames.size(); ++i) {
                    String tableName = (String)tableNames.get(i);
                    Join join = new Join(Table.getTable((String)listener.resultTableName), Table.getTable((String)tableName), new String[]{listener.tableKey}, new String[]{listener.tableKey}, 2);
                    sq.addJoin(join);
                }
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                if (!dataObject.isEmpty()) {
                    Iterator iterator = dataObject.getRows(listener.resultTableName);
                    while (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        Object object = row.get("OBJECT_GUID");
                        if (selectedSidList.contains(object)) continue;
                        selectedSidList.add(row.get("OBJECT_GUID"));
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return selectedSidList;
    }

    public static ArrayList getSelectedSidsFromHomeTabRequest(HttpServletRequest request, ReportBean reportBean) {
        ArrayList selectedSidList = new ArrayList();
        String oldResultTableName = request.getParameter("oldResultTableName");
        String oldGenerationIdStr = request.getParameter("oldGenerationId");
        Long oldGenerationId = Long.parseLong(oldGenerationIdStr);
        try {
            if (selectedSidList.size() == 0) {
                System.out.println("For HomeTab to Mgmt case  oldGenerationId " + oldGenerationId);
                Criteria crit = new Criteria(Column.getColumn((String)oldResultTableName, (String)"REPORT_GENERATION_ID"), (Object)oldGenerationId, 0);
                ReportClientUtil.getDefaultSearchList(oldResultTableName, crit, selectedSidList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return selectedSidList;
    }

    public static ArrayList getSelectedSids(JSONObject selectedSidsJson, String resultTableName, Long generationId, String srcTableName, String domainName) {
        ArrayList selectedSidList = new ArrayList();
        selectedSidList = ReportResultInputUtil.getSelectedSids(selectedSidsJson, null, null, resultTableName, generationId, srcTableName, domainName, null, null);
        return selectedSidList;
    }

    public static ArrayList getSelectedSids(JSONObject selectedSidsJson, JSONObject cvcFilter, JSONObject rvcFilter, String resultTableName, Long generationId, String srcTableName, String domainName, String isIntersect, AbstractListener listener) {
        ArrayList<Object> selectedSidList = new ArrayList<Object>();
        try {
            AdventNetResourceBundle rb = null;
            Boolean isCheckAllUsers = selectedSidsJson.getBoolean("checkAllUsers");
            if (isCheckAllUsers.booleanValue()) {
                String[] deSelectedSids;
                Criteria crit = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                JSONArray deSelectedSidsArray = selectedSidsJson.getJSONArray("deSelectedSids");
                boolean excludeNevLog = false;
                boolean excludeDisabled = false;
                boolean excludeNotSet = false;
                if (cvcFilter != null) {
                    rb = (AdventNetResourceBundle)cvcFilter.get("resourceBundle");
                    AdmpInput admpInput = new AdmpInput(cvcFilter);
                    if (admpInput != null && admpInput.getIsMultiple().booleanValue()) {
                        for (FcOption fcOption : admpInput.getMultipleInput()) {
                            if (fcOption.getLabel().equalsIgnoreCase("excludedisabled")) {
                                excludeDisabled = Boolean.valueOf(fcOption.getValue());
                                continue;
                            }
                            if (fcOption.getLabel().equalsIgnoreCase("excludeneverlogon")) {
                                excludeNevLog = Boolean.valueOf(fcOption.getValue());
                                continue;
                            }
                            if (!fcOption.getLabel().equalsIgnoreCase("excludeNotSet")) continue;
                            excludeNotSet = Boolean.valueOf(fcOption.getValue());
                        }
                    }
                }
                if ((deSelectedSids = FcJSONUtility.getStringArray((JSONArray)deSelectedSidsArray)) != null && deSelectedSids.length > 0) {
                    crit = crit.and(new Criteria(Column.getColumn((String)resultTableName, (String)"OBJECT_GUID"), (Object)deSelectedSids, 9));
                }
                if (listener != null) {
                    crit = crit.and(listener.getReportResultFilterCriteria(null, new ReportReqParams(rvcFilter), null));
                }
                SelectQueryImpl sq = null;
                if (isIntersect != null && isIntersect.equalsIgnoreCase("true")) {
                    SelectQuery intersectQuery = ReportResultUtil.getIntersectSubquery(new ReportReqParams(rvcFilter), resultTableName, generationId, "OBJECT_GUID");
                    sq = new SelectQueryImpl((Table)new DerivedTable(resultTableName, (Query)intersectQuery));
                    sq.addSelectColumn(Column.getColumn((String)resultTableName, (String)"*"));
                } else {
                    Criteria joinCriteria;
                    sq = new SelectQueryImpl(Table.getTable((String)resultTableName));
                    sq.addSelectColumn(Column.getColumn((String)resultTableName, (String)"*"));
                    if (domainName != null || excludeNotSet || excludeDisabled || excludeNevLog) {
                        sq.addJoin(new Join(Table.getTable((String)resultTableName), Table.getTable((String)srcTableName), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2));
                    }
                    if (domainName != null) {
                        joinCriteria = new Criteria(Column.getColumn((String)srcTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                        crit = crit.and(joinCriteria);
                    }
                    if (excludeNevLog) {
                        joinCriteria = new Criteria(Column.getColumn((String)srcTableName, (String)"LAST_LOGON_TIME"), (Object)"0", 1);
                        crit = crit.and(joinCriteria);
                    }
                    if (excludeDisabled) {
                        joinCriteria = new Criteria(Column.getColumn((String)srcTableName, (String)"ACCOUNT_STATUS"), (Object)rb.getString("admp.reports.user.customized_column_values.Disabled"), 1);
                        crit = crit.and(joinCriteria);
                    }
                    if (excludeNotSet) {
                        joinCriteria = new Criteria(Column.getColumn((String)srcTableName, (String)"LCS_ENABLED"), (Object)"-", 1);
                        crit = crit.and(joinCriteria);
                    }
                    sq.setCriteria(crit);
                }
                DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                Iterator it = obj.getRows(resultTableName);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    if (selectedSidList.contains(row.get("OBJECT_GUID"))) continue;
                    selectedSidList.add(row.get("OBJECT_GUID"));
                }
            } else {
                JSONArray selectedSidsArray = selectedSidsJson.getJSONArray("selectedSids");
                String[] selectedSids = FcJSONUtility.getStringArray((JSONArray)selectedSidsArray);
                if (selectedSids != null) {
                    if (domainName != null) {
                        Criteria crit = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                        crit = crit.and(new Criteria(Column.getColumn((String)resultTableName, (String)"OBJECT_GUID"), (Object)selectedSids, 8));
                        crit = crit.and(new Criteria(Column.getColumn((String)srcTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
                        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)resultTableName));
                        sq.addSelectColumn(Column.getColumn((String)resultTableName, (String)"*"));
                        sq.addJoin(new Join(Table.getTable((String)resultTableName), Table.getTable((String)srcTableName), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2));
                        sq.setCriteria(crit);
                        DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                        Iterator it = obj.getRows(resultTableName);
                        while (it.hasNext()) {
                            Row row = (Row)it.next();
                            selectedSidList.add(row.get("OBJECT_GUID"));
                        }
                    } else {
                        for (int index = 0; index < selectedSidsArray.length(); ++index) {
                            selectedSidList.add(selectedSidsArray.get(index));
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return selectedSidList;
    }
}

