/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.DerivedTable;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultInputUtil;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ReportClientUtil;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportResultUtil {
    static Logger reportLogger = Logger.getLogger("ReportLogger");
    public static String TABLE_KEY = "OBJECT_GUID";

    public static ArrayList getRows(AbstractListener listener, Long generationId, String resultTableName, ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria reportFiltercriteria, Criteria columnSearchCriteria, String tableKey, ArrayList<String> reportFilterTableNames) {
        return ReportResultUtil.getRows(listener, generationId, resultTableName, attributeList, attributeProp, ascending, startIndex, numOfObjects, multipleValuesSids, reportFiltercriteria, columnSearchCriteria, tableKey, reportFilterTableNames, null, null, false);
    }

    public static ArrayList getRows(AbstractListener listener, Long generationId, String resultTableName, ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria reportFiltercriteria, Criteria columnSearchCriteria, String tableKey, ArrayList<String> reportFilterTableNames, boolean isScheduledReport) {
        return ReportResultUtil.getRows(listener, generationId, resultTableName, attributeList, attributeProp, ascending, startIndex, numOfObjects, multipleValuesSids, reportFiltercriteria, columnSearchCriteria, tableKey, reportFilterTableNames, null, null, isScheduledReport);
    }

    public static ArrayList getRows(AbstractListener listener, Long generationId, String resultTableName, ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria reportFiltercriteria, Criteria columnSearchCriteria, String tableKey, ArrayList<String> reportFilterTableNames, ReportReqParams reqParams, String interSect, boolean isScheduledReport) {
        return ReportResultUtil.getRows(listener, generationId, resultTableName, attributeList, attributeProp, ascending, startIndex, numOfObjects, multipleValuesSids, reportFiltercriteria, columnSearchCriteria, tableKey, reportFilterTableNames, reqParams, interSect, isScheduledReport, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getRows(AbstractListener listener, Long generationId, String resultTableName, ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria reportFiltercriteria, Criteria columnSearchCriteria, String tableKey, ArrayList<String> reportFilterTableNames, ReportReqParams reqParams, String interSect, boolean isScheduledReport, boolean isDistinct) {
        Connection connection = null;
        ArrayList resultList = null;
        DataSet dataSet = null;
        try {
            String table;
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            String baseTableName = null;
            ArrayList<String> tableNames = new ArrayList<String>();
            boolean relationalTypePresent = false;
            ReportAttributeHandler.getInstance().removeAttribsWithoutColDef(attributeList);
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) {
                    relationalTypePresent = true;
                    continue;
                }
                table = attributeProperties.getProperty("TABLE_NAME");
                if (baseTableName == null) {
                    baseTableName = table;
                }
                Column column = new Column(table, attributeProperties.getProperty("ATTRIB_COLUMN_NAME"));
                if (!attributeProperties.getProperty("ATTRIB_COLUMN_NAME").equalsIgnoreCase("NTFS_PERMISSION")) {
                    selectColumnList.add(column);
                }
                if (tableNames.contains(table) || table.equalsIgnoreCase(baseTableName)) continue;
                tableNames.add(table);
            }
            ArrayList onClickTextAttributeList = ReportResultUtil.getOnClickTextAttributes(listener.onClickText);
            for (int i = 0; onClickTextAttributeList != null && i < onClickTextAttributeList.size(); ++i) {
                String columnName;
                Column column;
                Properties p = (Properties)onClickTextAttributeList.get(i);
                table = p.getProperty("TABLE_NAME");
                if (table.equalsIgnoreCase("ADSMFolderDetails")) {
                    table = attributeProp.getProperty("TABLE_NAME");
                }
                if (!selectColumnList.contains(column = new Column(table, columnName = p.getProperty("ATTRIB_COLUMN_NAME")))) {
                    selectColumnList.add(column);
                }
                if (tableNames.contains(table) || table.equalsIgnoreCase(baseTableName)) continue;
                tableNames.add(table);
            }
            for (String reportFilterTableName : reportFilterTableNames) {
                if (tableNames.contains(reportFilterTableName) || reportFilterTableName.equalsIgnoreCase(baseTableName)) continue;
                tableNames.add(reportFilterTableName);
            }
            Table baseTable = Table.getTable(baseTableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            String listenerBaseTable = listener.baseTableName;
            if (!tableNames.contains(listenerBaseTable) && !listenerBaseTable.equalsIgnoreCase(baseTableName)) {
                tableNames.add(listenerBaseTable);
            }
            for (int i = 0; i < tableNames.size(); ++i) {
                String table2 = (String)tableNames.get(i);
                Join join = new Join(baseTable, new Table(table2), new String[]{tableKey}, new String[]{tableKey}, 1);
                query.addJoin(join);
            }
            Column keyColumn = Column.getColumn((String)listener.baseTableName, (String)tableKey);
            if (!selectColumnList.contains(keyColumn)) {
                selectColumnList.add(keyColumn);
            }
            Column keyColumn1 = Column.getColumn((String)listener.baseTableName, (String)"OBJECT_GUID");
            if (listener.reportId == 957) {
                selectColumnList.add(keyColumn1);
            }
            query.addSelectColumns(selectColumnList);
            if (columnSearchCriteria != null) {
                query.setCriteria(columnSearchCriteria);
            }
            SelectQueryImpl subInnerQuery = null;
            if (interSect != null && interSect.equalsIgnoreCase("true")) {
                subInnerQuery = ReportResultUtil.getIntersectSubquery(reqParams, resultTableName, generationId, tableKey);
            } else {
                subInnerQuery = new SelectQueryImpl(Table.getTable((String)resultTableName));
                subInnerQuery.addSelectColumn(Column.getColumn((String)resultTableName, (String)tableKey));
                Criteria resultTableCriteria = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                if (reportFiltercriteria != null) {
                    resultTableCriteria = resultTableCriteria.and(reportFiltercriteria);
                }
                subInnerQuery.setCriteria(resultTableCriteria);
                ArrayList<Column> groupByColumnsList = new ArrayList<Column>();
                groupByColumnsList.add(Column.getColumn((String)resultTableName, (String)tableKey));
                GroupByClause groupByClause = new GroupByClause(groupByColumnsList);
                subInnerQuery.setGroupByClause(groupByClause);
            }
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (attributeProp != null && attributeProp.getProperty("TABLE_NAME") != null) {
                SortColumn sortcolumn = new SortColumn(new Column(attributeProp.getProperty("TABLE_NAME"), attributeProp.getProperty("ATTRIB_COLUMN_NAME")), ascending);
                query.addSortColumn(sortcolumn);
            }
            DerivedTable derivedTable = new DerivedTable(resultTableName, (Query)subInnerQuery);
            query.addJoin(new Join(Table.getTable((String)baseTableName), (Table)derivedTable, new String[]{tableKey}, new String[]{tableKey}, 2));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            if (isDistinct) {
                query.setDistinct(true);
            }
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            resultList = new ArrayList();
            String tempTableKeyValue = "";
            while (dataSet.next()) {
                Object guid = dataSet.getValue(selectColumnList.indexOf(keyColumn) + 1);
                if (isScheduledReport && guid != null) {
                    if (tempTableKeyValue.equals(guid)) continue;
                    tempTableKeyValue = guid.toString();
                }
                Hashtable<Object, Object> resultTable = new Hashtable<Object, Object>();
                ReportResultUtil.fillResult(dataSet, resultTable, attributeList);
                ReportResultUtil.fillResult(dataSet, resultTable, onClickTextAttributeList);
                if (guid != null) {
                    resultTable.put(tableKey, guid);
                }
                if (listener.reportId == 957) {
                    Object objGuid = dataSet.getValue(selectColumnList.indexOf(keyColumn1) + 1);
                    resultTable.put(11115, objGuid);
                }
                if (relationalTypePresent) {
                    multipleValuesSids.put(guid, new Hashtable());
                }
                if (listener.reportId == 951 || listener.reportId == 803) {
                    ReportResultUtil.fillOnClickText(listener.onClickText, resultTable, generationId);
                } else {
                    ReportResultUtil.fillOnClickText(listener.onClickText, resultTable);
                }
                resultList.add(resultTable);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return resultList;
    }

    public static SelectQuery getIntersectSubquery(ReportReqParams reqParams, String resultTableName, Long generationId, String tableKey) {
        JSONArray rvcFiltersArray = reqParams.getRvcFilters();
        SelectQueryImpl sq = null;
        SelectQueryImpl subQuery = null;
        try {
            String columnName = "INPUT_ID";
            String[] inputFiltervalues = new String[rvcFiltersArray.length()];
            if (rvcFiltersArray != null && rvcFiltersArray.length() > 0) {
                for (int index = 0; index < rvcFiltersArray.length(); ++index) {
                    JSONObject rvcFilterObject = (JSONObject)rvcFiltersArray.get(index);
                    Iterator iterator = rvcFilterObject.keys();
                    while (iterator.hasNext()) {
                        String inputId;
                        inputFiltervalues[index] = inputId = (String)iterator.next();
                    }
                }
            }
            Table table = Table.getTable((String)resultTableName, (String)(resultTableName + "0"));
            sq = new SelectQueryImpl(table);
            sq.addSelectColumn(Column.getColumn((String)(resultTableName + "0"), (String)tableKey));
            sq.addSelectColumn(Column.getColumn((String)(resultTableName + "0"), (String)"INPUT_ID"));
            sq.addSelectColumn(Column.getColumn((String)(resultTableName + "0"), (String)"REPORT_GENERATION_ID"));
            ArrayList<Column> groupByColumnsList = new ArrayList<Column>();
            groupByColumnsList.add(Column.getColumn((String)(resultTableName + "0"), (String)tableKey));
            GroupByClause groupByClause = new GroupByClause(groupByColumnsList);
            Criteria resultTableCriteria = new Criteria(Column.getColumn((String)(resultTableName + "0"), (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            Criteria crit = new Criteria(Column.getColumn((String)(resultTableName + "0"), (String)columnName), (Object)inputFiltervalues[0], 0);
            crit = crit.and(resultTableCriteria);
            sq.setCriteria(crit);
            DerivedTable baseDerivedTable = new DerivedTable(resultTableName + "0", (Query)sq);
            for (int i = 1; i < inputFiltervalues.length; ++i) {
                table = Table.getTable((String)resultTableName, (String)(resultTableName + i));
                SelectQueryImpl selectQuery = new SelectQueryImpl(table);
                selectQuery.addSelectColumn(Column.getColumn((String)(resultTableName + i), (String)tableKey));
                selectQuery.addSelectColumn(Column.getColumn((String)(resultTableName + i), (String)"INPUT_ID"));
                selectQuery.addSelectColumn(Column.getColumn((String)(resultTableName + i), (String)"REPORT_GENERATION_ID"));
                groupByColumnsList = new ArrayList();
                groupByColumnsList.add(Column.getColumn((String)(resultTableName + i), (String)tableKey));
                groupByClause = new GroupByClause(groupByColumnsList);
                resultTableCriteria = new Criteria(Column.getColumn((String)(resultTableName + i), (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                Criteria criteria = new Criteria(Column.getColumn((String)(resultTableName + i), (String)columnName), (Object)inputFiltervalues[i], 0);
                criteria = criteria.and(resultTableCriteria);
                selectQuery.setCriteria(criteria);
                DerivedTable derivedTable = new DerivedTable(resultTableName + i, (Query)selectQuery);
                subQuery = new SelectQueryImpl((Table)baseDerivedTable);
                subQuery.addSelectColumn(Column.getColumn((String)baseDerivedTable.getTableAlias(), (String)tableKey));
                subQuery.addSelectColumn(Column.getColumn((String)baseDerivedTable.getTableAlias(), (String)"INPUT_ID"));
                subQuery.addSelectColumn(Column.getColumn((String)baseDerivedTable.getTableAlias(), (String)"REPORT_GENERATION_ID"));
                subQuery.addJoin(new Join((Table)baseDerivedTable, (Table)derivedTable, new String[]{tableKey}, new String[]{tableKey}, 2));
                baseDerivedTable = new DerivedTable(resultTableName + "joined" + i, (Query)subQuery);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return subQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getRowsForAPI(Long generationId, String resultTableName, String reportBaseTableName, ArrayList attributeList, int startIndex, int numOfObjects, String searchPattern, String tableKey) {
        boolean ascending = true;
        Properties attributeProp = (Properties)attributeList.get(0);
        Criteria columnSearchCriteria = null;
        if (searchPattern != null && searchPattern != "") {
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                String showSearch = attributeProperties.getProperty("SHOW_SEARCH");
                if (relationalType.equals(new Integer(1)) || showSearch.equalsIgnoreCase("false")) continue;
                String tableName = attributeProperties.getProperty("TABLE_NAME");
                String attrColumnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                try {
                    TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
                    ColumnDefinition colDef = tableDef.getColumnDefinitionByName(attrColumnName);
                    String dataType = colDef.getDataType();
                    if (!dataType.equals("CHAR") && !dataType.equals("NCHAR")) {
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                columnSearchCriteria = i == 0 ? new Criteria(Column.getColumn((String)tableName, (String)attrColumnName), (Object)searchPattern, 2, false) : columnSearchCriteria.or(new Criteria(Column.getColumn((String)tableName, (String)attrColumnName), (Object)searchPattern, 2, false));
            }
        }
        Connection connection = null;
        ArrayList<Properties> resultList = null;
        DataSet dataSet = null;
        try {
            String table;
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            String baseTableName = null;
            ArrayList<String> tableNames = new ArrayList<String>();
            boolean relationalTypePresent = false;
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) {
                    relationalTypePresent = true;
                    continue;
                }
                table = attributeProperties.getProperty("TABLE_NAME");
                if (baseTableName == null) {
                    baseTableName = table;
                }
                Column column = Column.getColumn((String)table, (String)attributeProperties.getProperty("ATTRIB_COLUMN_NAME"));
                selectColumnList.add(column);
                if (tableNames.contains(table) || table.equalsIgnoreCase(baseTableName)) continue;
                tableNames.add(table);
            }
            Table baseTable = Table.getTable(baseTableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            for (int i = 0; i < tableNames.size(); ++i) {
                table = (String)tableNames.get(i);
                Join join = new Join(baseTable, new Table(table), new String[]{tableKey}, new String[]{tableKey}, 1);
                query.addJoin(join);
            }
            Column keyColumn = Column.getColumn((String)reportBaseTableName, (String)tableKey);
            if (!selectColumnList.contains(keyColumn)) {
                selectColumnList.add(keyColumn);
            }
            query.addSelectColumns(selectColumnList);
            if (columnSearchCriteria != null) {
                query.setCriteria(columnSearchCriteria);
            }
            SelectQueryImpl subInnerQuery = new SelectQueryImpl(Table.getTable((String)resultTableName));
            subInnerQuery.addSelectColumn(Column.getColumn((String)resultTableName, (String)tableKey));
            Criteria resultTableCriteria = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            subInnerQuery.setCriteria(resultTableCriteria);
            ArrayList<Column> groupByColumnsList = new ArrayList<Column>();
            groupByColumnsList.add(Column.getColumn((String)resultTableName, (String)tableKey));
            GroupByClause groupByClause = new GroupByClause(groupByColumnsList);
            subInnerQuery.setGroupByClause(groupByClause);
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (attributeProp != null && attributeProp.getProperty("TABLE_NAME") != null) {
                SortColumn sortcolumn = new SortColumn(new Column(attributeProp.getProperty("TABLE_NAME"), attributeProp.getProperty("ATTRIB_COLUMN_NAME")), ascending);
                query.addSortColumn(sortcolumn);
            }
            DerivedTable derivedTable = new DerivedTable(resultTableName, (Query)subInnerQuery);
            query.addJoin(new Join(Table.getTable((String)baseTableName), (Table)derivedTable, new String[]{tableKey}, new String[]{tableKey}, 2));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            resultList = new ArrayList<Properties>();
            while (dataSet.next()) {
                Properties resultTable = new Properties();
                ReportResultUtil.fillResultForAPI(dataSet, resultTable, attributeList);
                Object guid = dataSet.getValue(selectColumnList.indexOf(keyColumn) + 1);
                if (guid != null) {
                    resultTable.put(tableKey, guid);
                }
                resultList.add(resultTable);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return resultList;
    }

    public static Integer getRecordsCountForAPI(Long generationId, String resultTableName, String reportBaseTableName, String searchPattern, ArrayList attributeList, String tableKey) {
        Criteria columnSearchCriteria = null;
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(reportBaseTableName);
        if (searchPattern != null && searchPattern != "") {
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                String showSearch = attributeProperties.getProperty("SHOW_SEARCH");
                if (relationalType.equals(new Integer(1)) || showSearch.equalsIgnoreCase("false")) continue;
                String tableName = attributeProperties.getProperty("TABLE_NAME");
                if (!tableNames.contains(tableName)) {
                    tableNames.add(tableName);
                }
                String attrColumnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                try {
                    TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
                    ColumnDefinition colDef = tableDef.getColumnDefinitionByName(attrColumnName);
                    String dataType = colDef.getDataType();
                    if (!dataType.equals("CHAR") && !dataType.equals("NCHAR")) {
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                columnSearchCriteria = i == 0 ? new Criteria(Column.getColumn((String)tableName, (String)attrColumnName), (Object)searchPattern, 2, false) : columnSearchCriteria.or(new Criteria(Column.getColumn((String)tableName, (String)attrColumnName), (Object)searchPattern, 2, false));
            }
        }
        SelectQuery sq = ReportResultUtil.getCountSQ(columnSearchCriteria, generationId, resultTableName, tableNames, tableKey);
        Integer count = DBUtil.getCount((SelectQuery)sq);
        return count;
    }

    public static void setRecordsCount(HttpServletRequest request, ReportBean bean, Long generationId, ReportReqParams reqParams) {
        AbstractListener listener = bean.getListener();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Criteria crit = null;
        Criteria reportFiltercriteria = listener.getReportResultFilterCriteria(request, reqParams, crit);
        SelectQuery sq = ReportResultUtil.getCountSQ(reportFiltercriteria, generationId, listener.getResultTableName(), new ArrayList(), listener.tableKey);
        Integer count = DBUtil.getCount((SelectQuery)sq);
        request.setAttribute("recordsCount", (Object)count);
        if (count == null || count == 0) {
            if (listener.errorMessage != null) {
                request.setAttribute("errorMsg", (Object)listener.errorMessage);
                listener.errorMessage = null;
            } else if (listener.updatedCount != -1) {
                request.setAttribute("errorMsg", (Object)rb.getString("client.admin.SearchListener.no_reports_available"));
            }
        } else {
            request.setAttribute("errorList", (Object)listener.errorList);
            request.setAttribute("tableKey", (Object)listener.tableKey);
        }
    }

    public static void getSearchResultRowsCount(HttpServletRequest request, ReportBean bean, Long generationId, ArrayList attributelist) {
        AbstractListener listener = bean.getListener();
        Integer reportId = (Integer)bean.get("reportId");
        ArrayList tableNames = new ArrayList();
        SelectQuery sq = ReportResultUtil.getCountSQ(null, generationId, listener.getResultTableName(), tableNames, listener.tableKey);
        Integer count = DBUtil.getCount((SelectQuery)sq);
        reportLogger.log(Level.INFO, "REPORT COUNT : " + count);
        request.setAttribute("recordsCount", (Object)count);
    }

    public static JSONArray getOutputFiltersList(Integer reportId, Long generationId, int fromIndex) {
        ArrayList<Hashtable<String, ArrayList<Hashtable<String, Object>>>> cvcInputList = ReportResultInputUtil.getCVCSelectedInputList(reportId, generationId, fromIndex, null);
        return ReportResultUtil.getOutputFiltersList(cvcInputList);
    }

    public static JSONArray getOutputFiltersList(ArrayList<Hashtable<String, ArrayList<Hashtable<String, Object>>>> cvcInputList) {
        JSONArray opFiltersList = new JSONArray();
        JSONObject jsonObj = null;
        try {
            ArrayList<Object> list = new ArrayList();
            for (Hashtable<String, ArrayList<Hashtable<String, Object>>> hash : cvcInputList) {
                if (hash.containsKey("trusteesList")) {
                    list = hash.get("trusteesList");
                    continue;
                }
                if (hash.containsKey("operatingSystem")) {
                    list = hash.get("operatingSystem");
                    continue;
                }
                if (!hash.containsKey("pathList")) continue;
                list = hash.get("pathList");
            }
            for (Hashtable<String, ArrayList<Hashtable<String, Object>>> details : list) {
                jsonObj = new JSONObject();
                jsonObj.put("inputId", details.get("inputId"));
                jsonObj.put("objectName", (Object)ClientUtil.htmlEscape((String)((Object)details.get("objectName"))));
                jsonObj.put("objectGUID", (Object)((String)((Object)details.get("objectGUID"))));
                opFiltersList.put((Object)jsonObj);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return opFiltersList;
    }

    public static void setReportRows(HttpServletRequest request, ReportBean bean, Long generationId, ArrayList attributelist, String action, Hashtable requestProperties) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        AbstractListener listener = bean.getListener();
        Integer reportId = (Integer)bean.get("reportId");
        ArrayList tableNames = new ArrayList();
        String[] inputFiltervalues = request.getParameterValues("inputs");
        String inputChange = request.getParameter("inputChange");
        Criteria crit = null;
        Criteria columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(request, bean, attributelist, tableNames);
        Criteria reportFiltercriteria = null;
        if (columnSearchCriteria != null) {
            crit = columnSearchCriteria;
        }
        SelectQuery sq = ReportResultUtil.getCountSQ(crit, generationId, listener.getResultTableName(), tableNames, listener.tableKey);
        Integer count = DBUtil.getCount((SelectQuery)sq);
        reportLogger.log(Level.INFO, "REPORT COUNT is  : " + count + " for the generation id : " + generationId);
        if (count != null && count != 0) {
            if (listener.updatedCount == 0) {
                listener.updatedCount = -1;
            }
            Integer range = (Integer)bean.get("RANGE");
            Long startIndex = (Long)requestProperties.get("FROM_INDEX");
            Integer attributeId = (Integer)requestProperties.get("attributeId");
            if (attributeId == null || attributeId.equals(new Integer(-1))) {
                attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (ArrayList)attributelist);
            }
            String ascending = (String)requestProperties.get("ascending");
            if (action.equalsIgnoreCase("showList") || action.equalsIgnoreCase("showListPermissions")) {
                Properties attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
                if (attributeProp == null) {
                    attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (ArrayList)attributelist);
                    attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
                }
                Hashtable multipleValuesSids = new Hashtable();
                ArrayList list = ReportResultUtil.getRows(listener, generationId, listener.getResultTableName(), attributelist, attributeProp, new Boolean(ascending), startIndex.intValue(), range, multipleValuesSids, reportFiltercriteria, columnSearchCriteria, listener.tableKey, new ArrayList<String>());
                ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids, (String)listener.tableKey, null);
                ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
                request.setAttribute("multipleValuesSids", multipleValuesSids);
                request.setAttribute("result", (Object)list);
                request.setAttribute("tableKey", (Object)listener.tableKey);
            }
            if (ascending.equals("true")) {
                request.setAttribute("sortImage", (Object)"images/sortdown.gif");
            } else {
                request.setAttribute("sortImage", (Object)"images/sortup.gif");
            }
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("errorList", (Object)listener.errorList);
        } else if (listener.errorMessage != null) {
            request.setAttribute("errorMsg", (Object)listener.errorMessage);
            listener.errorMessage = null;
        } else if (listener.updatedCount != -1) {
            request.setAttribute("errorMsg", (Object)rb.getString("client.admin.SearchListener.no_reports_available"));
        }
    }

    public static void setReportRows(HttpServletRequest request, ReportBean bean, Long generationId, ArrayList attributelist, ReportReqParams reqParams) {
        AbstractListener listener = bean.getListener();
        Integer reportId = (Integer)bean.get("reportId");
        AdventNetResourceBundle rb = reqParams.getRb();
        ArrayList tableNames = new ArrayList();
        String[] inputFiltervalues = request.getParameterValues("inputs");
        String inputChange = request.getParameter("inputChange");
        String isIntersect = request.getParameter("intersect");
        Criteria crit = null;
        Criteria columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(attributelist, reqParams, tableNames);
        columnSearchCriteria = listener.getReportFilterCriteria(columnSearchCriteria, reqParams, tableNames);
        Criteria reportFiltercriteria = listener.getReportResultFilterCriteria(request, reqParams, crit);
        if (columnSearchCriteria != null) {
            crit = columnSearchCriteria;
        }
        if (reportFiltercriteria != null) {
            crit = crit != null ? crit.and(reportFiltercriteria) : reportFiltercriteria;
        }
        SelectQuery sq = null;
        sq = isIntersect != null && isIntersect.equalsIgnoreCase("true") ? ReportResultUtil.getIntersectCountSQ(generationId, listener.getResultTableName(), listener.tableKey, reqParams) : ReportResultUtil.getCountSQ(crit, generationId, listener.getResultTableName(), tableNames, listener.tableKey);
        Integer count = DBUtil.getCount((SelectQuery)sq);
        request.setAttribute("recordsCount", (Object)count);
        reportLogger.log(Level.INFO, "REPORT COUNT is  : " + count + " for the generation id : " + generationId);
        if (count != null && count != 0) {
            Properties attributeProp;
            Integer attributeId;
            if (listener.updatedCount == 0) {
                listener.updatedCount = -1;
            }
            if ((attributeId = reqParams.getSortAttribId()) == null || attributeId.equals(new Integer(-1))) {
                attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (ArrayList)attributelist);
            }
            if ((attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist)) == null) {
                attributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (ArrayList)attributelist);
                attributeProp = ListenerUtil.getAttributeProp(attributeId, attributelist);
            }
            Hashtable multipleValuesSids = new Hashtable();
            ArrayList list = ReportResultUtil.getRows(listener, generationId, listener.getResultTableName(), attributelist, attributeProp, new Boolean(reqParams.isSortOrder()), reqParams.getFromIndex(), reqParams.getRange(), multipleValuesSids, reportFiltercriteria, columnSearchCriteria, listener.tableKey, new ArrayList<String>(), reqParams, isIntersect, false);
            Criteria criteria = listener.getMultiValueCrit(request, listener.getResultTableName(), bean, reqParams);
            ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids, (String)listener.tableKey, (Criteria)criteria, (Integer)reqParams.getReportId());
            ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
            request.setAttribute("multipleValuesSids", multipleValuesSids);
            request.setAttribute("result", (Object)list);
            request.setAttribute("tableKey", (Object)listener.tableKey);
            request.setAttribute("errorList", (Object)listener.errorList);
        } else if (listener.errorMessage != null) {
            request.setAttribute("errorMsg", (Object)listener.errorMessage);
            listener.errorMessage = null;
        } else if (listener.updatedCount != -1) {
            request.setAttribute("errorMsg", (Object)rb.getString("client.admin.SearchListener.no_reports_available"));
        }
    }

    private static SelectQuery getIntersectCountSQ(Long generationId, String resultTableName, String tableKey, ReportReqParams reqParams) {
        SelectQueryImpl sq = null;
        try {
            Table resultTable = new Table(resultTableName, "ResultTable");
            sq = new SelectQueryImpl(resultTable);
            Column column = Column.getColumn((String)"ResultTable", (String)tableKey);
            Column countColumn = column.distinct();
            sq.addSelectColumn(countColumn.count());
            SelectQuery subInnerQuery = ReportResultUtil.getIntersectSubquery(reqParams, resultTableName, generationId, tableKey);
            DerivedTable derivedTable = new DerivedTable("SubInnerQuerytable", (Query)subInnerQuery);
            sq.addJoin(new Join(resultTable, (Table)derivedTable, new String[]{tableKey}, new String[]{tableKey}, 2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    public static SelectQuery getCountSQ(Criteria c, Long generationId, String resultTableName, ArrayList tableNames, String tableKey) {
        SelectQueryImpl sq = null;
        try {
            Column col = new Column(resultTableName, tableKey);
            Criteria crit = new Criteria(new Column(resultTableName, "REPORT_GENERATION_ID"), (Object)generationId, 0);
            if (c != null) {
                crit = crit.and(c);
            }
            sq = new SelectQueryImpl(new Table(resultTableName));
            Column column = col.distinct();
            sq.addSelectColumn(column.count());
            sq.setCriteria(crit);
            for (int i = 0; i < tableNames.size(); ++i) {
                String tableName = (String)tableNames.get(i);
                Join join = new Join(new Table(resultTableName), new Table(tableName), new String[]{tableKey}, new String[]{tableKey}, 2);
                sq.addJoin(join);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    public static Criteria getColumnSearchCriteria(ArrayList totalColumnList, ReportReqParams reqParams, ArrayList tableNames) {
        Criteria andCriteria = null;
        JSONObject searchTextJson = reqParams.getSearchStringJson();
        JSONObject searchCriteriaType = reqParams.getSearchCriteriaTypeJson();
        String matchingCriteria = reqParams.getMatchCriteria();
        if (searchTextJson != null && searchTextJson.length() > 0) {
            try {
                Criteria crit = null;
                for (int i = 0; i < totalColumnList.size(); ++i) {
                    Properties attributeProperties = (Properties)totalColumnList.get(i);
                    Integer id = (Integer)attributeProperties.get("ATTRIB_ID");
                    String table = (String)attributeProperties.get("TABLE_NAME");
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    Integer dataHandlerType = ((Long)attributeProperties.get("DATA_HANDLER_TYPE")).intValue();
                    String attribColumnName = (String)attributeProperties.get("ATTRIB_COLUMN_NAME");
                    if (relationalType.equals(new Integer(1)) || !searchTextJson.has(attribColumnName)) continue;
                    try {
                        String searchText = searchTextJson.getString(attribColumnName);
                        searchText = DBUtil.escapeDBWildChars((String)searchText);
                        Integer criteriaFlag = searchCriteriaType.getInt(attribColumnName);
                        if (searchText == null || searchText.equalsIgnoreCase("")) continue;
                        if (dataHandlerType == 6) {
                            crit = searchText.equalsIgnoreCase("true") ? new Criteria(Column.getColumn((String)table, (String)attribColumnName), (Object)"true", 0) : (searchText.equalsIgnoreCase("false") ? new Criteria(Column.getColumn((String)table, (String)attribColumnName), (Object)"false", 0) : new Criteria(Column.getColumn((String)table, (String)attribColumnName), (Object)searchText, criteriaFlag.intValue()));
                        } else {
                            int len = searchText.length();
                            searchText = searchText.charAt(0) == '*' && searchText.charAt(len - 1) == '*' ? "*" + searchText + "*" : (searchText.charAt(len - 1) == '*' ? searchText + "*" : (searchText.charAt(0) == '*' ? "*" + searchText : "*" + searchText + "*"));
                            crit = new Criteria(Column.getColumn((String)table, (String)attribColumnName), (Object)searchText, criteriaFlag.intValue());
                        }
                        if (!tableNames.contains(table)) {
                            tableNames.add(table);
                        }
                        if (matchingCriteria.equalsIgnoreCase("AND")) {
                            if (andCriteria == null) {
                                andCriteria = crit;
                                continue;
                            }
                            andCriteria = andCriteria.and(crit);
                            continue;
                        }
                        if (!matchingCriteria.equalsIgnoreCase("OR")) continue;
                        if (andCriteria == null) {
                            andCriteria = crit;
                            continue;
                        }
                        andCriteria = andCriteria.or(crit);
                        continue;
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return andCriteria;
    }

    public static Criteria getColumnSearchCriteria(HttpServletRequest request, ReportBean bean, ArrayList attributeList, ArrayList tableNames) {
        Criteria crit = null;
        AbstractListener listener = bean.getListener();
        try {
            String searchString = (String)bean.get("searchString");
            boolean search = false;
            if (request.getParameter("search") != null) {
                searchString = "";
                search = true;
            }
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties p = (Properties)attributeList.get(i);
                Integer id = (Integer)p.get("ATTRIB_ID");
                String val = null;
                if (search) {
                    if (request.getParameter("search" + id.toString()) != null) {
                        val = request.getParameter("search" + id);
                        if (!searchString.equalsIgnoreCase("")) {
                            searchString = searchString + "&";
                        }
                        searchString = searchString + "search" + id + "=" + val;
                    }
                } else {
                    val = ReportResultUtil.getSearchString(searchString, id);
                }
                if (val == null || val.equalsIgnoreCase("")) continue;
                String tableName = p.getProperty("TABLE_NAME");
                String columnName = p.getProperty("ATTRIB_COLUMN_NAME");
                Column col = Column.getColumn((String)tableName, (String)columnName);
                TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
                ColumnDefinition colDef = tableDef.getColumnDefinitionByName(columnName);
                String dataType = colDef.getDataType();
                if (dataType.equals("BOOLEAN")) {
                    crit = crit == null ? new Criteria(col, (Object)val, 0) : crit.and(new Criteria(col, (Object)val, 0));
                } else {
                    boolean hasWildCard = false;
                    int index = val.indexOf("*");
                    while (index != -1) {
                        if (index == 0 || val.charAt(index - 1) != '\\') {
                            hasWildCard = true;
                            break;
                        }
                        index = val.indexOf("*", index + 1);
                    }
                    if (!hasWildCard) {
                        val = "*" + val + "*";
                    }
                    crit = crit == null ? new Criteria(col, (Object)val, 2) : crit.and(new Criteria(col, (Object)val, 2));
                }
                if (tableNames.contains(tableName)) continue;
                tableNames.add(tableName);
            }
            if (search) {
                bean.set("searchString", searchString);
                bean.set("FROM_INDEX", 1L);
                bean.set("PAGE_NUMBER", "1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        bean.set("searchCriteria", crit);
        bean.set("searchTableNames", tableNames);
        return crit;
    }

    public static String getSearchString(String searchString, Integer id) {
        String val = "";
        int index = searchString.indexOf("search" + id + "=");
        if (index != -1) {
            val = searchString.indexOf("&", index) != -1 ? searchString.substring(searchString.indexOf("=", index) + 1, searchString.indexOf("&", index)) : searchString.substring(searchString.indexOf("=", index) + 1);
        }
        return val;
    }

    public static String setSearchString(String searchString, Integer id, String value) {
        String key = "search" + id;
        int index = searchString.indexOf(key + "=");
        if (index != -1) {
            if (searchString.indexOf("&", index) != -1) {
                int nextIndex = searchString.indexOf("=", index);
                searchString = searchString.substring(0, nextIndex + 1) + value + searchString.substring(searchString.indexOf("&", nextIndex));
            } else {
                searchString = searchString.substring(0, searchString.indexOf("=", index) + 1) + value;
            }
        } else {
            searchString = searchString + "&" + key + "=" + value;
        }
        return searchString;
    }

    public static String getSearchString(String searchString, String id) {
        String val = "";
        int index = searchString.indexOf(id + "=");
        if (index != -1) {
            val = searchString.indexOf("&", index) != -1 ? searchString.substring(searchString.indexOf("=", index) + 1, searchString.indexOf("&", index)) : searchString.substring(searchString.indexOf("=", index) + 1);
        }
        return val;
    }

    public static String setSearchString(String searchString, String id, String value) {
        int index = searchString.indexOf(id + "=");
        if (index != -1) {
            if (searchString.indexOf("&", index) != -1) {
                int nextIndex = searchString.indexOf("=", index);
                searchString = searchString.substring(0, nextIndex + 1) + value + searchString.substring(searchString.indexOf("&", nextIndex));
            } else {
                searchString = searchString.substring(0, searchString.indexOf("=", index) + 1) + value;
            }
        } else {
            searchString = searchString + "&" + id + "=" + value;
        }
        return searchString;
    }

    public static void setModifyResult(HttpServletRequest request, ReportBean bean, Integer repId, Long id, String tableName) {
        AbstractListener listener = bean.getListener();
        Criteria crit = ReportResultUtil.getModifiedSidCriteria(tableName);
        ArrayList tableNames = (ArrayList)bean.get("searchTableNames");
        Integer count = ReportHandler.getSIDReportCount((Long)id, (ArrayList)tableNames, (Criteria)crit, (String)tableName);
        Integer range = (Integer)bean.get("RANGE");
        Long startIndex = (Long)bean.get("FROM_INDEX");
        String modifyResultColumn = (String)bean.get("modifyResultColumn");
        if (modifyResultColumn == null || modifyResultColumn.equals("")) {
            modifyResultColumn = "MESSAGE";
        }
        bean.set("modifyResultColumn", modifyResultColumn);
        String ascending = (String)bean.get("ascending");
        ArrayList attributelist = ReportAttributeHandler.getInstance().getModifiedColumns(repId);
        Column sortColumn = ReportClientUtil.getSortColumn(tableName, modifyResultColumn, attributelist);
        Hashtable multipleValuesSids = new Hashtable();
        ArrayList list = ReportResultUtil.getModifyRows(id, listener.baseTableName, tableName, attributelist, sortColumn, new Boolean(ascending), startIndex.intValue(), range, multipleValuesSids, crit);
        ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids);
        ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
        request.setAttribute("multipleValuesSids", multipleValuesSids);
        request.setAttribute("result", (Object)list);
        if (ascending.equals("true")) {
            request.setAttribute("sortImage", (Object)"images/sortdown.gif");
        } else {
            request.setAttribute("sortImage", (Object)"images/sortup.gif");
        }
        request.setAttribute("recordsCount", (Object)count);
    }

    public static Criteria getModifiedSidCriteria(String tableName) {
        Column column = Column.getColumn((String)tableName, (String)"MESSAGE");
        Criteria criteria = new Criteria(column, (Object)"NULL", 1);
        return criteria;
    }

    public static Criteria getModifiedSidFilterCriteria(String tableName) {
        Column column = Column.getColumn((String)tableName, (String)"MESSAGE");
        Criteria criteria = new Criteria(column, (Object)"*Error*", 3);
        criteria = criteria.and(new Criteria(column, (Object)"*Warning*", 3));
        return criteria;
    }

    public static void setModifyResult(HttpServletRequest request, ReportBean bean, Integer repId, Long id, String tableName, Hashtable requestProperties) throws Exception {
        AbstractListener listener = bean.getListener();
        Criteria crit = null;
        crit = ReportResultUtil.getModifiedSidCriteria(tableName);
        ArrayList tableNames = (ArrayList)bean.get("searchTableNames");
        Integer count = ReportHandler.getSIDReportCount((Long)id, (ArrayList)tableNames, (Criteria)crit, (String)tableName);
        Integer range = (Integer)bean.get("RANGE");
        Long startIndex = (Long)requestProperties.get("FROM_INDEX");
        String modifyResultColumn = (String)requestProperties.get("modifyResultColumn");
        if (modifyResultColumn == null || modifyResultColumn.equals("")) {
            modifyResultColumn = "MESSAGE";
        }
        request.setAttribute("modifyResultColumn", (Object)modifyResultColumn);
        String ascending = (String)requestProperties.get("ascending");
        ArrayList attributelist = ReportAttributeHandler.getInstance().getModifiedColumns(repId);
        Column sortColumn = ReportClientUtil.getSortColumn(tableName, modifyResultColumn, attributelist);
        Hashtable multipleValuesSids = new Hashtable();
        ArrayList list = ReportResultUtil.getModifyRows(id, listener.baseTableName, tableName, attributelist, sortColumn, new Boolean(ascending), startIndex.intValue(), range, multipleValuesSids, crit, repId);
        ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids);
        ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
        request.setAttribute("multipleValuesSids", multipleValuesSids);
        request.setAttribute("result", (Object)list);
        if (ascending.equals("true")) {
            request.setAttribute("sortImage", (Object)"images/sortdown.gif");
        } else {
            request.setAttribute("sortImage", (Object)"images/sortup.gif");
        }
        request.setAttribute("recordsCount", (Object)count);
    }

    public static Criteria getSIDCriteria(ReportBean bean, String[] selectedSidArray) {
        AbstractListener listener = bean.getListener();
        return ReportResultUtil.getSelectedSidCriteria(listener.getResultTableName(), selectedSidArray);
    }

    public static Criteria getSIDCriteria(ReportBean bean) {
        AbstractListener listener = bean.getListener();
        return ReportResultUtil.getSIDCriteria(bean, listener.getResultTableName());
    }

    public static Criteria getSIDCriteria(ReportBean bean, String tableName) {
        Criteria crit = null;
        String selectAllUsers = (String)bean.get("selectAllUsers");
        ArrayList deSelectedSIDs = (ArrayList)bean.get("deSelectedSIDs");
        reportLogger.log(Level.INFO, "SELECT ALL USERS : " + selectAllUsers);
        if (selectAllUsers.equals("false")) {
            ArrayList objectIdList = (ArrayList)bean.get("selectedSIDs");
            String[] objectIds = new String[objectIdList.size()];
            for (int i = 0; i < objectIdList.size(); ++i) {
                objectIds[i] = (String)objectIdList.get(i);
            }
            Column col = new Column(tableName, "OBJECT_GUID");
            crit = new Criteria(col, (Object)objectIds, 8);
        } else if (deSelectedSIDs.size() > 0) {
            String[] objectIds = new String[deSelectedSIDs.size()];
            for (int i = 0; i < deSelectedSIDs.size(); ++i) {
                objectIds[i] = (String)deSelectedSIDs.get(i);
            }
            Column col = new Column(tableName, "OBJECT_GUID");
            crit = new Criteria(col, (Object)objectIds, 9);
        }
        reportLogger.log(Level.FINE, "CRIT for SELECT ALL USERS : " + crit);
        return crit;
    }

    public static Criteria getSelectedSidCriteria(String tableName, String[] selectedSidArray) {
        Column column = Column.getColumn((String)tableName, (String)"OBJECT_GUID");
        Criteria criteria = new Criteria(column, (Object)selectedSidArray, 8);
        return criteria;
    }

    public static ArrayList getModifyRows(Long id, String baseTableName, String tableName, ArrayList attributeList, Column sortColumn, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria crit) {
        ArrayList resultList = ReportResultUtil.getModifyRows(id, baseTableName, tableName, attributeList, sortColumn, ascending, startIndex, numOfObjects, multipleValuesSids, crit, null);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getModifyRows(Long id, String baseTableName, String tableName, ArrayList attributeList, Column sortColumn, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria crit, Integer repId) {
        Connection connection = null;
        ArrayList resultList = null;
        DataSet dataSet = null;
        try {
            int i;
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            Table baseTable = new Table(tableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            ArrayList<String> tableNames = new ArrayList<String>();
            boolean relationalTypePresent = false;
            for (i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) {
                    relationalTypePresent = true;
                    continue;
                }
                String table = attributeProperties.getProperty("TABLE_NAME");
                if (table != null) {
                    Column column = Column.getColumn((String)table, (String)attributeProperties.getProperty("ATTRIB_COLUMN_NAME"));
                    selectColumnList.add(column);
                }
                if (table == null || tableNames.contains(table)) continue;
                tableNames.add(table);
            }
            for (i = 0; i < tableNames.size(); ++i) {
                String table = (String)tableNames.get(i);
                Join join = new Join(baseTable, new Table(table), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                query.addJoin(join);
            }
            Column guidColumn = Column.getColumn((String)baseTableName, (String)"OBJECT_GUID");
            Column msgColumn = Column.getColumn((String)tableName, (String)"MESSAGE");
            if (!selectColumnList.contains(guidColumn)) {
                selectColumnList.add(guidColumn);
            }
            selectColumnList.add(msgColumn);
            query.addSelectColumns(selectColumnList);
            Criteria generationCriteria = new Criteria(new Column(tableName, "REPORT_GENERATION_ID"), (Object)id, 0);
            if (crit != null) {
                generationCriteria = generationCriteria.and(crit);
            }
            query.setCriteria(generationCriteria);
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (sortColumn == null) {
                sortColumn = Column.getColumn((String)tableName, (String)"REPORT_GENERATION_ID");
            }
            SortColumn sort = new SortColumn(sortColumn, ascending);
            query.addSortColumn(sort);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            resultList = new ArrayList();
            while (dataSet.next()) {
                Hashtable<Object, String> resultTable = new Hashtable<Object, String>();
                for (int i2 = 0; i2 < attributeList.size(); ++i2) {
                    Properties attributeProperties = (Properties)attributeList.get(i2);
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    if (relationalType.equals(new Integer(1))) {
                        relationalTypePresent = true;
                        continue;
                    }
                    String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                    if (dataSet.getValue(columnName) == null) continue;
                    Object obj = dataSet.getValue(columnName);
                    resultTable.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, obj));
                }
                String guid = (String)dataSet.getValue(selectColumnList.indexOf(guidColumn) + 1);
                String message = (String)dataSet.getValue(selectColumnList.indexOf(msgColumn) + 1);
                if (guid != null) {
                    resultTable.put("OBJECT_GUID", guid);
                }
                if (message != null) {
                    resultTable.put("MESSAGE", message);
                }
                if (relationalTypePresent) {
                    multipleValuesSids.put(guid, new Hashtable());
                }
                resultList.add(resultTable);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return resultList;
    }

    public static ArrayList getOnClickTextAttributes(String onClickText) {
        if (onClickText == null || onClickText.equalsIgnoreCase("")) {
            return null;
        }
        ArrayList<Properties> list = new ArrayList<Properties>();
        int from = 0;
        int index = -1;
        while ((index = onClickText.indexOf("{", from)) != -1) {
            from = onClickText.indexOf("}", index);
            String ids = onClickText.substring(index + 1, from);
            StringTokenizer token = new StringTokenizer(ids, ",");
            Properties p = new Properties();
            p.put("ATTRIB_ID", new Integer(token.nextToken()));
            p.put("TABLE_NAME", token.nextToken());
            p.put("ATTRIB_COLUMN_NAME", token.nextToken());
            p.put("RELATIONAL_TYPE", new Integer(0));
            list.add(p);
        }
        return list;
    }

    public static void fillOnClickText(String onClickText, Hashtable result, Long generationId) {
        ReportResultUtil.fillOnClickText(onClickText, result);
        String onClkText = (String)result.get("ONCLICK_TEXT");
        onClkText = new StringBuilder(onClkText).insert(onClkText.length() - 1, ",'" + generationId + "'").toString();
        result.put("ONCLICK_TEXT", onClkText);
    }

    public static void fillOnClickText(String onClickText, Hashtable result) {
        if (onClickText == null || onClickText.equalsIgnoreCase("")) {
            return;
        }
        String s = "";
        int from = 0;
        int index = -1;
        while ((index = onClickText.indexOf("{", from)) != -1) {
            s = s + onClickText.substring(from, index);
            from = onClickText.indexOf("}", index);
            String ids = onClickText.substring(index + 1, from);
            String id = ids.substring(0, ids.indexOf(","));
            String tmp = (String)result.get(new Integer(id));
            s = s + ClientUtil.scriptEscape(tmp);
            ++from;
        }
        s = s + onClickText.substring(from);
        result.put("ONCLICK_TEXT", s);
    }

    public static void fillResult(DataSet dataSet, Hashtable result, ArrayList attributeList) {
        for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
            try {
                String columnName;
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1)) || (columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME")).equalsIgnoreCase("NTFS_PERMISSION")) continue;
                Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                if (dataSet.getValue(columnName) == null) continue;
                Object obj = dataSet.getValue(columnName);
                result.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, obj));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void fillResultForAPI(DataSet dataSet, Properties result, ArrayList attributeList) {
        for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
            try {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) continue;
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                if (dataSet.getValue(columnName) == null) continue;
                Object obj = dataSet.getValue(columnName);
                result.put(columnName, ListenerUtil.getUICustomizedValues(attributeId, obj));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void getCustomizedMultipleValues(Hashtable multipleValuesSids) {
        Enumeration e = multipleValuesSids.keys();
        while (e.hasMoreElements()) {
            Object guid = e.nextElement();
            Hashtable colVsValues = (Hashtable)multipleValuesSids.get(guid);
            Enumeration e1 = colVsValues.keys();
            while (e1.hasMoreElements()) {
                Integer attributeId = (Integer)e1.nextElement();
                ArrayList values = (ArrayList)colVsValues.get(attributeId);
                ArrayList<String> customizedValues = new ArrayList<String>();
                if (attributeId == 2031) {
                    for (int i = 0; i < values.size(); ++i) {
                        String value = (String)values.get(i);
                        if (value == null) continue;
                        value = StrUtil.getCanonicalFormDN((String)((String)values.get(i)));
                        customizedValues.add(value);
                    }
                    colVsValues.put(attributeId, customizedValues);
                    continue;
                }
                colVsValues.put(attributeId, values);
            }
        }
    }

    public static void getCustomizedO365Values(Hashtable multipleValuesSids, AdventNetResourceBundle rb) {
        Enumeration e = multipleValuesSids.keys();
        while (e.hasMoreElements()) {
            Object guid = e.nextElement();
            Hashtable colVsValues = (Hashtable)multipleValuesSids.get(guid);
            Enumeration e1 = colVsValues.keys();
            while (e1.hasMoreElements()) {
                Integer attributeId = (Integer)e1.nextElement();
                ArrayList values = (ArrayList)colVsValues.get(attributeId);
                ArrayList<String> customizedValues = new ArrayList<String>();
                if (attributeId == 17018) {
                    ArrayList uniqueLicenseValues = new ArrayList();
                    LinkedHashSet s = new LinkedHashSet(values);
                    uniqueLicenseValues.addAll(s);
                    for (int i = 0; i < uniqueLicenseValues.size(); ++i) {
                        customizedValues.add(rb.getString(O365MgmtHandler.getDispNameForWAADAccountSKU((String)((String)uniqueLicenseValues.get(i)))));
                    }
                    colVsValues.put(attributeId, customizedValues);
                    continue;
                }
                if (attributeId != 17019) continue;
                for (int i = 0; i < values.size(); ++i) {
                    customizedValues.add(rb.getString(O365MgmtHandler.getDisplayNameForWAADServicePlan((String)((String)values.get(i)))));
                }
                colVsValues.put(attributeId, customizedValues);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getACERows(AbstractListener listener, Long generationId, String tableName, ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria crit, String tableKey) {
        Connection connection = null;
        ArrayList resultList = null;
        DataSet dataSet = null;
        try {
            int i;
            Column column;
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            Table baseTable = new Table(tableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            ArrayList<String> tableNames = new ArrayList<String>();
            boolean relationalTypePresent = false;
            for (int i2 = 0; i2 < attributeList.size(); ++i2) {
                Properties attributeProperties = (Properties)attributeList.get(i2);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                String ldapName = (String)attributeProperties.get("ATTRIB_LDAP_NAME");
                if (relationalType.equals(new Integer(1)) && ldapName.equalsIgnoreCase("member")) {
                    relationalTypePresent = true;
                    continue;
                }
                String table = attributeProperties.getProperty("TABLE_NAME");
                if (table == null || relationalType.equals(new Integer(1))) {
                    attributeProperties.put("RELATIONAL_TYPE", new Integer(0));
                }
                if (!selectColumnList.contains(column = new Column(table, attributeProperties.getProperty("ATTRIB_COLUMN_NAME")))) {
                    selectColumnList.add(column);
                } else {
                    attributeList.remove(i2);
                    --i2;
                }
                if (tableNames.contains(table)) continue;
                tableNames.add(table);
            }
            ArrayList onClickTextAttributeList = ReportResultUtil.getOnClickTextAttributes(listener.onClickText);
            for (i = 0; onClickTextAttributeList != null && i < onClickTextAttributeList.size(); ++i) {
                String columnName;
                Properties p = (Properties)onClickTextAttributeList.get(i);
                String table = p.getProperty("TABLE_NAME");
                if (table.equalsIgnoreCase("ADSMFolderDetails")) {
                    table = attributeProp.getProperty("TABLE_NAME");
                }
                if (!selectColumnList.contains(column = Column.getColumn((String)table, (String)(columnName = p.getProperty("ATTRIB_COLUMN_NAME"))))) {
                    selectColumnList.add(column);
                }
                if (tableNames.contains(table)) continue;
                tableNames.add(table);
            }
            for (i = 0; i < tableNames.size(); ++i) {
                String table = (String)tableNames.get(i);
                Join join = new Join(baseTable, new Table(table), new String[]{tableKey}, new String[]{tableKey}, 1);
                query.addJoin(join);
            }
            Column keyColumn = Column.getColumn((String)listener.baseTableName, (String)tableKey);
            if (!selectColumnList.contains(keyColumn)) {
                selectColumnList.add(keyColumn);
            }
            Column keyColumn1 = Column.getColumn((String)listener.baseTableName, (String)"OBJECT_GUID");
            if (listener.reportId == 957) {
                selectColumnList.add(keyColumn1);
            }
            query.addSelectColumns(selectColumnList);
            query.setDistinct(true);
            Criteria generationCriteria = new Criteria(new Column(tableName, "REPORT_GENERATION_ID"), (Object)generationId, 0);
            if (crit != null) {
                generationCriteria = generationCriteria.and(crit);
            }
            query.setCriteria(generationCriteria);
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (attributeProp != null && attributeProp.getProperty("TABLE_NAME") != null) {
                SortColumn sortcolumn = new SortColumn(new Column(attributeProp.getProperty("TABLE_NAME"), attributeProp.getProperty("ATTRIB_COLUMN_NAME")), ascending);
                query.addSortColumn(sortcolumn);
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            resultList = new ArrayList();
            while (dataSet.next()) {
                Hashtable<String, Object> resultTable = new Hashtable<String, Object>();
                ReportResultUtil.fillResult(dataSet, resultTable, attributeList);
                ReportResultUtil.fillResult(dataSet, resultTable, onClickTextAttributeList);
                Object guid = dataSet.getValue(selectColumnList.indexOf(keyColumn) + 1);
                if (guid != null) {
                    resultTable.put(tableKey, guid);
                }
                if (listener.reportId == 957) {
                    Object objGuid = dataSet.getValue(selectColumnList.indexOf(keyColumn1) + 1);
                    resultTable.put("OBJECT_GUID", objGuid);
                    if (relationalTypePresent) {
                        multipleValuesSids.put(objGuid, new Hashtable());
                    }
                }
                ReportResultUtil.fillOnClickText(listener.onClickText, resultTable);
                resultList.add(resultTable);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        if (listener.reportId == 957) {
            ArrayList<Properties> attribList = new ArrayList<Properties>();
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                String ldap = (String)attributeProperties.get("ATTRIB_LDAP_NAME");
                if (!ldap.equalsIgnoreCase("member")) continue;
                attribList.add(attributeProperties);
            }
            ReportHandler.getMultipleValues(attribList, (Hashtable)multipleValuesSids, (String)"OBJECT_GUID", null);
            ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
        }
        return resultList;
    }

    public static ArrayList getSharePermissions(String folderLocation, String generationId, String permType, AdventNetResourceBundle rb) {
        String tableName = "ADSMSharePermissionDetails_" + generationId;
        String resultTable = "ADSMShareReportResult";
        String baseTable = "ADSMShareGeneralDetails";
        ArrayList<Properties> resultList = new ArrayList<Properties>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"SHARE_ID"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"PERMISSION_ID"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"SECURITY_PRINCIPAL"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"ACE_TYPE"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"PERMISSIONS"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"APPLIES_TO"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"TRUSTEE_SID"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"INHERITED_ACE"));
            SortColumn sortcolumn = new SortColumn(Column.getColumn((String)tableName, (String)"SECURITY_PRINCIPAL"), false);
            sq.addSortColumn(sortcolumn);
            Join join = new Join(Table.getTable((String)tableName), Table.getTable((String)baseTable), new String[]{"SHARE_ID"}, new String[]{"SHARE_ID"}, 1);
            sq.addJoin(join);
            Join join1 = new Join(Table.getTable((String)baseTable), Table.getTable((String)resultTable), new String[]{"SHARE_ID"}, new String[]{"SHARE_ID"}, 1);
            sq.addJoin(join1);
            Criteria c = new Criteria(Column.getColumn((String)resultTable, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            c = c.and(new Criteria(Column.getColumn((String)tableName, (String)"PERMISSION_TYPE"), (Object)permType, 0));
            c = c.and(new Criteria(Column.getColumn((String)tableName, (String)"PERMISSIONS"), (Object)" ", 1));
            c = c.and(new Criteria(Column.getColumn((String)baseTable, (String)"LOCATION"), (Object)folderLocation, 0));
            sq.setCriteria(c);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows(tableName);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Properties prop = new Properties();
                    prop.setProperty("ACE_TYPE", (String)row.get("ACE_TYPE"));
                    prop.setProperty("SECURITY_PRINCIPAL", (String)row.get("SECURITY_PRINCIPAL"));
                    prop.setProperty("TRUSTEE_SID", (String)row.get("TRUSTEE_SID"));
                    prop.setProperty("PERMISSIONS", ReportResultUtil.splitPermissions(row.get("PERMISSIONS"), rb));
                    prop.setProperty("APPLIES_TO", (String)row.get("APPLIES_TO"));
                    prop.setProperty("INHERITED_ACE", (String)row.get("INHERITED_ACE"));
                    resultList.add(prop);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static String splitPermissions(Object object, AdventNetResourceBundle rb) {
        String permissionStr = "";
        if (object instanceof List) {
            ArrayList permList = (ArrayList)object;
            StringBuffer permissionsBuffer = new StringBuffer();
            for (int j = 0; j < permList.size(); ++j) {
                if (j > 0) {
                    permissionsBuffer.append(", ");
                }
                String temp = (String)permList.get(j);
                temp = rb.getString(temp);
                if ((temp = temp.trim()).startsWith(" ")) {
                    temp = temp.substring(1, temp.length());
                }
                permissionsBuffer.append(temp);
            }
            permissionStr = permissionsBuffer.toString();
        } else if (object instanceof String) {
            String permString = (String)object;
            StringTokenizer permList = new StringTokenizer(permString, "\\");
            int count = permList.countTokens();
            StringBuffer permissions = new StringBuffer();
            for (int k = 0; k < count; ++k) {
                if (k > 0) {
                    permissions.append("\\");
                }
                String perm = permList.nextToken();
                perm = rb.getString(perm);
                permissions.append(perm);
            }
            permissionStr = permissions.toString();
        } else {
            System.out.println("Not matched with any java objects listed above");
        }
        return permissionStr;
    }

    public static ArrayList getShares(Long inputId, Long genId, Criteria crit, Properties sortAttributeProp, boolean isAscending) {
        String resultTable = "ADSMShareReportResult";
        String baseTable = "ADSMShareGeneralDetails";
        ArrayList<Properties> resultList = new ArrayList<Properties>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)baseTable));
            sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"SHARE_ID"));
            sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"LOCATION"));
            sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"LOCAL_PATH"));
            sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"OWNER_NAME"));
            SortColumn sortColumn = new SortColumn(Column.getColumn((String)baseTable, (String)"LOCATION"), true);
            if (sortAttributeProp != null) {
                sortColumn = new SortColumn(Column.getColumn((String)sortAttributeProp.getProperty("TABLE_NAME"), (String)sortAttributeProp.getProperty("ATTRIB_COLUMN_NAME")), isAscending);
            }
            sq.addSortColumn(sortColumn);
            Join join = new Join(Table.getTable((String)baseTable), Table.getTable((String)resultTable), new String[]{"SHARE_ID"}, new String[]{"SHARE_ID"}, 1);
            sq.addJoin(join);
            Criteria c = new Criteria(Column.getColumn((String)resultTable, (String)"REPORT_GENERATION_ID"), (Object)genId, 0);
            c = c.and(new Criteria(Column.getColumn((String)resultTable, (String)"INPUT_ID"), (Object)inputId, 0));
            c = c.and(crit);
            sq.setCriteria(c);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows(baseTable);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Properties prop = new Properties();
                    prop.setProperty("LOCATION", (String)row.get("LOCATION"));
                    prop.setProperty("SHARE_ID", row.get("SHARE_ID").toString());
                    prop.setProperty("OWNER_NAME", (String)row.get("OWNER_NAME"));
                    prop.setProperty("LOCAL_PATH", (String)row.get("LOCAL_PATH"));
                    resultList.add(prop);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getSharesRows(ArrayList attributeList, AbstractListener listener, AdventNetResourceBundle rb) {
        Connection connection = null;
        ArrayList resultList = null;
        DataSet dataSet = null;
        try {
            SelectQuery sq = listener.getSelectQuery(attributeList, null, null);
            sq.setRange(new Range(0, 1000));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            resultList = new ArrayList();
            while (dataSet.next()) {
                Hashtable<Integer, String> resultTable = new Hashtable<Integer, String>();
                for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
                    try {
                        Properties attributeProperties = (Properties)attributeList.get(i);
                        String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                        Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                        if (dataSet.getValue(columnName) == null) continue;
                        Object obj = dataSet.getValue(columnName);
                        if (columnName.equalsIgnoreCase("PERMISSIONS")) {
                            resultTable.put(attributeId, ReportResultUtil.splitPermissions(ListenerUtil.getUICustomizedValues(attributeId, obj), rb));
                            continue;
                        }
                        resultTable.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, obj));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                resultList.add(resultTable);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return resultList;
    }

    public static JSONObject getReportResultRows(Long loginId, Integer reportId, Long generationId, JSONObject reqParams) {
        JSONObject resultTable = new JSONObject();
        try {
            JSONArray attributeList = reqParams.getJSONArray("columns");
            JSONObject pageNavigateData = reqParams.getJSONObject("pageNavigateData");
            ArrayList<Column> columnList = new ArrayList<Column>();
            Row reportRow = ReportHandler.getReportDetailsRow((Integer)reportId);
            String baseTableName = (String)reportRow.get("BASE_TABLE_NAME");
            String resultTableName = (String)reportRow.get("RESULT_TABLE_NAME");
            boolean isRelationTypeExists = false;
            ArrayList<String> tableNames = new ArrayList<String>();
            tableNames.add(baseTableName);
            for (int i = 0; i < attributeList.length(); ++i) {
                JSONObject attributeProp = (JSONObject)attributeList.get(i);
                String tableName = (String)attributeProp.get("TABLE_NAME");
                Integer relationalType = (Integer)attributeProp.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) {
                    isRelationTypeExists = true;
                    continue;
                }
                Column column = new Column(tableName, (String)attributeProp.get("ATTRIB_COLUMN_NAME"));
                columnList.add(column);
                if (tableNames.contains(tableName)) continue;
                tableNames.add(tableName);
            }
            Criteria crit = null;
            Criteria columnSearchCriteria = ReportResultUtil.getColumnSearchCriteria(attributeList, reqParams, tableNames);
            if (reqParams.has("reportResultFilter")) {
                String className = (String)ReportHandler.getReportDetailsRow((Integer)reportId).get("CLASS_NAME");
                Class<?> classToInvoke = Class.forName(className.trim());
                Method getReportFilterCriteria = classToInvoke.getMethod("getReportFilterCriteria", Criteria.class, JSONObject.class, ArrayList.class);
                columnSearchCriteria = (Criteria)getReportFilterCriteria.invoke(null, columnSearchCriteria, reqParams, tableNames);
            }
            if (columnSearchCriteria != null) {
                crit = columnSearchCriteria;
            }
            SelectQuery sq = ReportResultUtil.getCountSQ(crit, generationId, resultTableName, tableNames, TABLE_KEY);
            Integer count = DBUtil.getCount((SelectQuery)sq);
            resultTable.put("count", (Object)count);
            if (count != null && count != 0) {
                JSONObject sortAttributeProp;
                tableNames.remove(baseTableName);
                Integer sortAttributeId = reqParams.optInt("sortAttribId", -1);
                if (sortAttributeId.equals(new Integer(-1))) {
                    sortAttributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (JSONArray)attributeList);
                }
                if ((sortAttributeProp = ListenerUtil.getAttributeProp(sortAttributeId, attributeList)) == null) {
                    sortAttributeId = ReportAttributesUtil.getDefaultSortingProp((Integer)reportId, (JSONArray)attributeList);
                    sortAttributeProp = ListenerUtil.getAttributeProp(sortAttributeId, attributeList);
                }
                JSONObject multipleValuesSids = new JSONObject();
                JSONArray resultRows = ReportResultUtil.getResultRows(generationId, baseTableName, resultTableName, tableNames, columnList, attributeList, new ArrayList(), crit, sortAttributeProp, reqParams.getBoolean("sortingOrder"), (Integer)pageNavigateData.get("startIndex"), (Integer)pageNavigateData.get("range"), multipleValuesSids, isRelationTypeExists, TABLE_KEY, reportId, loginId);
                ReportResultUtil.getMultipleValues(attributeList, multipleValuesSids, TABLE_KEY, null);
                resultTable.put("resultRows", (Object)resultRows);
                resultTable.put("multipleValuesSids", (Object)multipleValuesSids);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultTable;
    }

    public static Criteria getColumnSearchCriteria(JSONArray totalColumnList, JSONObject reqParams, ArrayList tableNames) {
        Criteria andCriteria = null;
        try {
            String matchingCriteria;
            JSONObject searchTextJson = reqParams.has("searchText") ? reqParams.getJSONObject("searchText") : null;
            JSONObject searchCriteriaType = reqParams.has("searchCriteriaType") ? reqParams.getJSONObject("searchCriteriaType") : new JSONObject();
            String string = matchingCriteria = reqParams.has("matchingCriteria") ? reqParams.getString("matchingCriteria") : "AND";
            if (searchTextJson != null && searchTextJson.length() > 0) {
                for (int i = 0; i < totalColumnList.length(); ++i) {
                    JSONObject attributeProperties = (JSONObject)totalColumnList.get(i);
                    Integer id = (Integer)attributeProperties.get("ATTRIB_ID");
                    String table = (String)attributeProperties.get("TABLE_NAME");
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    Integer dataHandlerType = ((Long)attributeProperties.get("DATA_HANDLER_TYPE")).intValue();
                    String attribColumnName = (String)attributeProperties.get("ATTRIB_COLUMN_NAME");
                    if (relationalType.equals(new Integer(1)) || !searchTextJson.has(attribColumnName)) continue;
                    try {
                        String searchText = searchTextJson.getString(attribColumnName);
                        searchText = DBUtil.escapeDBWildChars((String)searchText);
                        Integer criteriaFlag = searchCriteriaType.optInt(attribColumnName, -1) != -1 ? searchCriteriaType.getInt(attribColumnName) : 2;
                        if (searchText == null || searchText.equalsIgnoreCase("")) continue;
                        Criteria crit = null;
                        if (dataHandlerType == 6) {
                            crit = searchText.equalsIgnoreCase("true") ? new Criteria(Column.getColumn((String)table, (String)attribColumnName), (Object)"true", 0) : (searchText.equalsIgnoreCase("false") ? new Criteria(Column.getColumn((String)table, (String)attribColumnName), (Object)"false", 0) : new Criteria(Column.getColumn((String)table, (String)attribColumnName), (Object)searchText, criteriaFlag.intValue()));
                        } else {
                            int len = searchText.length();
                            searchText = searchText.charAt(0) == '*' && searchText.charAt(len - 1) == '*' ? "*" + searchText + "*" : (searchText.charAt(len - 1) == '*' ? searchText + "*" : (searchText.charAt(0) == '*' ? "*" + searchText : "*" + searchText + "*"));
                            crit = new Criteria(Column.getColumn((String)table, (String)attribColumnName), (Object)searchText, criteriaFlag.intValue());
                        }
                        if (!tableNames.contains(table)) {
                            tableNames.add(table);
                        }
                        if (matchingCriteria.equalsIgnoreCase("AND")) {
                            if (andCriteria == null) {
                                andCriteria = crit;
                                continue;
                            }
                            andCriteria = andCriteria.and(crit);
                            continue;
                        }
                        if (!matchingCriteria.equalsIgnoreCase("OR")) continue;
                        if (andCriteria == null) {
                            andCriteria = crit;
                            continue;
                        }
                        andCriteria = andCriteria.or(crit);
                        continue;
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return andCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getResultRows(Long generationId, String baseTableName, String resultTableName, ArrayList tableNames, ArrayList columnList, JSONArray attributeList, ArrayList onClickTextAttributeList, Criteria crit, JSONObject sortAttributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, boolean isRelationTypeExists, String tableKey, Integer reportId, Long loginId, String objectClass) {
        ArrayList resultRows = new ArrayList();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Table baseTable = Table.getTable((String)baseTableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            for (int i = 0; i < tableNames.size(); ++i) {
                String table = (String)tableNames.get(i);
                Join join = new Join(baseTable, new Table(table), new String[]{tableKey}, new String[]{tableKey}, 1);
                query.addJoin(join);
            }
            Column keyColumn = Column.getColumn((String)baseTableName, (String)tableKey);
            if (!columnList.contains(keyColumn)) {
                columnList.add(keyColumn);
            }
            query.addSelectColumns((List)columnList);
            if (crit != null) {
                query.setCriteria(crit);
            }
            SelectQueryImpl subInnerQuery = new SelectQueryImpl(Table.getTable((String)resultTableName));
            subInnerQuery.addSelectColumn(Column.getColumn((String)resultTableName, (String)tableKey));
            Criteria resultTableCriteria = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            subInnerQuery.setCriteria(resultTableCriteria);
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (sortAttributeProp != null && sortAttributeProp.getString("TABLE_NAME") != null) {
                SortColumn sortcolumn = new SortColumn(new Column(sortAttributeProp.getString("TABLE_NAME"), sortAttributeProp.getString("ATTRIB_COLUMN_NAME")), ascending);
                query.addSortColumn(sortcolumn);
            }
            DerivedTable derivedTable = new DerivedTable(resultTableName, (Query)subInnerQuery);
            query.addJoin(new Join(Table.getTable((String)baseTableName), (Table)derivedTable, new String[]{tableKey}, new String[]{tableKey}, 2));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
            ArrayList<Integer> uIValueCases = new ArrayList<Integer>();
            ListenerUtil.fillUIValueCases(attributeList, reportId, uIValueCases);
            while (dataSet.next()) {
                HashMap<String, Object> resultTable = new HashMap<String, Object>();
                ReportResultUtil.fillResult(dataSet, resultTable, attributeList, rb, loginId, uIValueCases);
                Object guid = dataSet.getValue(columnList.indexOf(keyColumn) + 1);
                if (guid != null) {
                    resultTable.put(tableKey, guid);
                }
                if (!objectClass.equals("")) {
                    resultTable.put("OBJECT_CLASS", objectClass);
                }
                if (isRelationTypeExists) {
                    multipleValuesSids.put((String)guid, new Hashtable());
                }
                resultRows.add(resultTable);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return resultRows;
    }

    public static void fillResult(DataSet dataSet, HashMap result, JSONArray attributeList, AdventNetResourceBundle rb, Long loginId, ArrayList<Integer> uIValueCases) {
        if (attributeList != null) {
            for (int i = 0; i < attributeList.length(); ++i) {
                try {
                    JSONObject attributeProperties = (JSONObject)attributeList.get(i);
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    if (relationalType == 1) continue;
                    String columnName = (String)attributeProperties.get("ATTRIB_COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                    if (dataSet.getValue(columnName) == null) continue;
                    Object obj = dataSet.getValue(columnName);
                    HashMap<String, Long> inputMap = new HashMap<String, Long>();
                    inputMap.put("LOGIN_ID", loginId);
                    String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                    HashMap attribMap = FcJSONUtility.JSONObjectToMap((JSONObject)attributeProperties);
                    if (transformerClassName != null && !transformerClassName.equals("TRANSFORMER_CLASS")) {
                        Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        obj = uiTransformer.renderCell(rb, columnName, dataSet.getValue(columnName), attribMap, inputMap, true);
                    }
                    result.put(attributeId, obj.toString());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void getMultipleValues(JSONArray attributeList, Hashtable multipleValuesSids, String tableKey, Criteria criteria, boolean isExport) {
        try {
            ArrayList<String> checkList = new ArrayList<String>();
            for (int i = 0; i < attributeList.length(); ++i) {
                JSONObject attributeProp = attributeList.getJSONObject(i);
                Integer relationalType = (Integer)attributeProp.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(0))) continue;
                String tableName = attributeProp.getString("TABLE_NAME");
                String columnName = attributeProp.getString("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProp.get("ATTRIB_ID");
                if (checkList.contains(tableName)) continue;
                ArrayList tableValues = ReportResultUtil.getTableAttributes(attributeList, tableName);
                SelectQueryImpl sq = new SelectQueryImpl(new Table(tableName));
                Object[] guids = new Object[multipleValuesSids.size()];
                int j = 0;
                Enumeration e = multipleValuesSids.keys();
                while (e.hasMoreElements()) {
                    guids[j] = e.nextElement();
                    ++j;
                }
                Criteria crit = null;
                crit = criteria == null ? new Criteria(new Column(tableName, tableKey), (Object)guids, 8) : criteria.and(new Criteria(new Column(tableName, tableKey), (Object)guids, 8));
                sq.setCriteria(crit);
                sq.addSelectColumn(new Column(tableName, "*"));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                if (!dataObj.isEmpty()) {
                    Iterator it = dataObj.getRows(tableName);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        String s = (String)r.get(tableKey);
                        Hashtable attributeIds = (Hashtable)multipleValuesSids.get(s);
                        for (int k = 0; k < tableValues.size(); ++k) {
                            String value;
                            Properties props = (Properties)tableValues.get(k);
                            Integer attribId = (Integer)props.get("ATTRIB_ID");
                            ArrayList<String> valuesList = (ArrayList<String>)attributeIds.get(attribId);
                            if (valuesList == null) {
                                valuesList = new ArrayList<String>();
                            }
                            if ((value = (String)r.get((String)props.get("COLUMN_NAME"))) == null || value.equalsIgnoreCase("")) continue;
                            if (attribId == 2031) {
                                value = StrUtil.getCanonicalFormDN((String)value);
                            }
                            valuesList.add(value);
                            attributeIds.put(attribId, valuesList);
                        }
                    }
                }
                checkList.add(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getResultRows(Long generationId, String baseTableName, String resultTableName, ArrayList tableNames, ArrayList columnList, JSONArray attributeList, ArrayList onClickTextAttributeList, Criteria crit, JSONObject sortAttributeProp, boolean ascending, int startIndex, int numOfObjects, JSONObject multipleValuesSids, boolean isRelationTypeExists, String tableKey, Integer reportId, Long loginId) {
        JSONArray resultRows = new JSONArray();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Table baseTable = Table.getTable((String)baseTableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            for (int i = 0; i < tableNames.size(); ++i) {
                String table = (String)tableNames.get(i);
                Join join = new Join(baseTable, new Table(table), new String[]{tableKey}, new String[]{tableKey}, 1);
                query.addJoin(join);
            }
            Column keyColumn = Column.getColumn((String)baseTableName, (String)tableKey);
            if (!columnList.contains(keyColumn)) {
                columnList.add(keyColumn);
            }
            query.addSelectColumns((List)columnList);
            if (crit != null) {
                query.setCriteria(crit);
            }
            SelectQueryImpl subInnerQuery = new SelectQueryImpl(Table.getTable((String)resultTableName));
            subInnerQuery.addSelectColumn(Column.getColumn((String)resultTableName, (String)tableKey));
            Criteria resultTableCriteria = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            subInnerQuery.setCriteria(resultTableCriteria);
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (sortAttributeProp != null && sortAttributeProp.getString("TABLE_NAME") != null) {
                SortColumn sortcolumn = new SortColumn(new Column(sortAttributeProp.getString("TABLE_NAME"), sortAttributeProp.getString("ATTRIB_COLUMN_NAME")), ascending);
                query.addSortColumn(sortcolumn);
            }
            DerivedTable derivedTable = new DerivedTable(resultTableName, (Query)subInnerQuery);
            query.addJoin(new Join(Table.getTable((String)baseTableName), (Table)derivedTable, new String[]{tableKey}, new String[]{tableKey}, 2));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
            ArrayList<Integer> uIValueCases = new ArrayList<Integer>();
            ListenerUtil.fillUIValueCases(attributeList, reportId, uIValueCases);
            while (dataSet.next()) {
                JSONObject resultTable = new JSONObject();
                ReportResultUtil.fillResult(dataSet, resultTable, attributeList, rb, loginId, uIValueCases);
                Object guid = dataSet.getValue(columnList.indexOf(keyColumn) + 1);
                if (guid != null) {
                    resultTable.put(tableKey, guid);
                }
                if (isRelationTypeExists) {
                    multipleValuesSids.put((String)guid, (Object)new JSONObject());
                }
                ReportResultUtil.fillResult(dataSet, resultTable, onClickTextAttributeList);
                ReportResultUtil.fillOnClickProp(onClickTextAttributeList, resultTable);
                resultRows.put((Object)resultTable);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return resultRows;
    }

    public static void fillResult(DataSet dataSet, JSONObject result, JSONArray attributeList, AdventNetResourceBundle rb, Long loginId, ArrayList<Integer> uIValueCases) {
        if (attributeList != null) {
            for (int i = 0; i < attributeList.length(); ++i) {
                try {
                    JSONObject attributeProperties = (JSONObject)attributeList.get(i);
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    if (relationalType == 1) continue;
                    String columnName = (String)attributeProperties.get("ATTRIB_COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                    if (dataSet.getValue(columnName) == null) continue;
                    Object obj = dataSet.getValue(columnName);
                    result.put(Integer.toString(attributeId), (Object)ListenerUtil.getUICustomizedValues(obj, uIValueCases.get(i), loginId, rb));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void fillResult(DataSet dataSet, JSONObject result, ArrayList attributeList) {
        if (attributeList != null) {
            for (int i = 0; i < attributeList.size(); ++i) {
                try {
                    Properties attributeProperties = (Properties)attributeList.get(i);
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    if (relationalType == 1) continue;
                    String columnName = (String)attributeProperties.get("ATTRIB_COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                    if (dataSet.getValue(columnName) == null) continue;
                    Object obj = dataSet.getValue(columnName);
                    result.put(Integer.toString(attributeId), (Object)ListenerUtil.getUICustomizedValues(attributeId, obj));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void fillOnClickProp(ArrayList onClickTextAttributeList, JSONObject result) {
        try {
            JSONObject onClickProp = new JSONObject();
            if (onClickTextAttributeList != null) {
                for (int i = 0; i < onClickTextAttributeList.size(); ++i) {
                    Properties attribProp = (Properties)onClickTextAttributeList.get(i);
                    Integer attribId = (Integer)attribProp.get("ATTRIB_ID");
                    onClickProp.put((String)attribProp.get("ATTRIB_COLUMN_NAME"), (Object)((String)result.get(Integer.toString(attribId))));
                }
            }
            result.put("ONCLICK_PARAMS", (Object)onClickProp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getMultipleValues(JSONArray attributeList, JSONObject multipleValuesSids, String tableKey, Criteria criteria) {
        try {
            ArrayList<String> checkList = new ArrayList<String>();
            for (int i = 0; i < attributeList.length(); ++i) {
                JSONObject attributeProp = attributeList.getJSONObject(i);
                Integer relationalType = (Integer)attributeProp.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(0))) continue;
                String tableName = attributeProp.getString("TABLE_NAME");
                String columnName = attributeProp.getString("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProp.get("ATTRIB_ID");
                if (checkList.contains(tableName)) continue;
                ArrayList tableValues = ReportResultUtil.getTableAttributes(attributeList, tableName);
                SelectQueryImpl sq = new SelectQueryImpl(new Table(tableName));
                Object[] guids = new Object[multipleValuesSids.length()];
                Iterator iterator = multipleValuesSids.keys();
                int j = 0;
                while (iterator.hasNext()) {
                    guids[j++] = iterator.next();
                }
                Criteria crit = null;
                crit = criteria == null ? new Criteria(new Column(tableName, tableKey), (Object)guids, 8) : criteria.and(new Criteria(new Column(tableName, tableKey), (Object)guids, 8));
                sq.setCriteria(crit);
                sq.addSelectColumn(new Column(tableName, "*"));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                if (!dataObj.isEmpty()) {
                    Iterator it = dataObj.getRows(tableName);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        String s = (String)r.get(tableKey);
                        JSONObject attributeIds = multipleValuesSids.getJSONObject(s);
                        for (int k = 0; k < tableValues.size(); ++k) {
                            JSONArray valuesList;
                            String value;
                            Properties props = (Properties)tableValues.get(k);
                            String attribIdStr = Integer.toString((Integer)props.get("ATTRIB_ID"));
                            JSONObject values = new JSONObject();
                            values.put("isMoreLinkExists", false);
                            values.put("valuesList", (Object)new JSONArray());
                            values.put("valuesStr", (Object)"");
                            if (attributeIds.has(attribIdStr)) {
                                values = attributeIds.getJSONObject(attribIdStr);
                            }
                            if ((value = (String)r.get((String)props.get("COLUMN_NAME"))) == null || value.equalsIgnoreCase("")) continue;
                            if (attribIdStr.equalsIgnoreCase("2031")) {
                                value = StrUtil.getCanonicalFormDN((String)value);
                            }
                            if ((valuesList = values.getJSONArray("valuesList")).length() < 5) {
                                String valuesStr = values.getString("valuesStr");
                                valuesStr = valuesStr.equalsIgnoreCase("") ? value : valuesStr + "; " + value;
                                values.put("valuesStr", (Object)valuesStr);
                            } else {
                                values.put("isMoreLinkExists", true);
                            }
                            valuesList.put((Object)value);
                            values.put("valuesList", (Object)valuesList);
                            attributeIds.put(attribIdStr, (Object)values);
                        }
                    }
                }
                checkList.add(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getTableAttributes(JSONArray attributeList, String tableName) {
        ArrayList<Properties> tableValues = new ArrayList<Properties>();
        try {
            ArrayList<Integer> attribList = new ArrayList<Integer>();
            for (int i = 0; i < attributeList.length(); ++i) {
                JSONObject attribProp = attributeList.getJSONObject(i);
                Integer attribId = attribProp.getInt("ATTRIB_ID");
                attribList.add(attribId);
            }
            Integer[] attribIds = new Integer[attribList.size()];
            attribIds = attribList.toArray(attribIds);
            String baseTable = "ADSMAttributeDetails";
            SelectQueryImpl sq = new SelectQueryImpl(new Table(baseTable));
            sq.addSelectColumn(new Column(baseTable, "*"));
            Criteria c = new Criteria(new Column(baseTable, "TABLE_NAME"), (Object)tableName, 0);
            c = c.and(new Criteria(new Column(baseTable, "ATTRIB_ID"), (Object)attribIds, 8));
            sq.setCriteria(c);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows(baseTable);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Properties p = new Properties();
                    p.put("ATTRIB_ID", (Integer)r.get("ATTRIB_ID"));
                    p.put("COLUMN_NAME", (String)r.get("ATTRIB_COLUMN_NAME"));
                    tableValues.add(p);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getSharesRows1(ArrayList attributeList, AbstractListener listener, AdventNetResourceBundle rb) {
        Connection connection = null;
        ArrayList resultList = null;
        DataSet dataSet = null;
        try {
            SelectQuery sq = listener.getSelectQuery(attributeList, null, null);
            sq.setRange(new Range(0, 1000));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            resultList = new ArrayList();
            while (dataSet.next()) {
                Hashtable<Integer, String> resultTable = new Hashtable<Integer, String>();
                for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
                    try {
                        Properties attributeProperties = (Properties)attributeList.get(i);
                        String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                        Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                        if (dataSet.getValue(columnName) == null) continue;
                        Object obj = dataSet.getValue(columnName);
                        if (columnName.equalsIgnoreCase("PERMISSIONS")) {
                            resultTable.put(attributeId, ReportResultUtil.splitPermissions(ListenerUtil.getUICustomizedValues(attributeId, obj), rb));
                            continue;
                        }
                        resultTable.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, obj));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                resultList.add(resultTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return resultList;
    }
}

