/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cache4j.CacheException;
import net.sf.cache4j.impl.SynchronizedCache;

public class SIDCacheManager
extends SynchronizedCache {
    private Map unknownSids = new ConcurrentHashMap();
    private String localDomainSID;
    private Hashtable domainSIDs;
    private static boolean isInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDomainSids() {
        Class<SIDCacheManager> clazz = SIDCacheManager.class;
        synchronized (SIDCacheManager.class) {
            if (!isInitialized) {
                this.domainSIDs = DomainInfoCache.getInstance().getDomainSidCache();
                this.localDomainSID = this.getLocalDomainSID();
                isInitialized = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Properties get(String domain, Long loginID, String objId, String lookupServer) throws Exception {
        Properties prop = (Properties)this.get(objId + domain);
        if (prop == null) {
            Properties sidProp = new Properties();
            sidProp.put("domain", domain);
            sidProp.put("loginId", loginID);
            sidProp.put("sid", objId);
            sidProp.put("lookupServer", lookupServer);
            this.unknownSids.put(objId, sidProp);
        }
        return prop;
    }

    public void update() throws CacheException {
        try {
            if (this.unknownSids.size() != 0) {
                this.getImmediately(this.unknownSids);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getImmediately(Map ukSids) throws Exception, CacheException {
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> computers = new ArrayList<String>();
        HashMap usersMap = new HashMap();
        HashMap groupsMap = new HashMap();
        HashMap computersMap = new HashMap();
        HashMap others = new HashMap();
        for (Map.Entry entry : this.domainSIDs.entrySet()) {
            HashMap sDomainSid = new HashMap();
            ArrayList<String> sids = new ArrayList<String>();
            Properties domainProp = (Properties)entry.getValue();
            String domainSID = (String)domainProp.get("DOMAIN_SID");
            String domainName = (String)domainProp.get("DOMAIN_NAME");
            String domainName_sids = CommonUtil.getSIDTableName((String)domainName);
            Iterator it1 = ukSids.entrySet().iterator();
            HashMap objSids = new HashMap();
            while (it1.hasNext()) {
                Map.Entry ent = it1.next();
                Properties objProp = (Properties)ent.getValue();
                String objSID = (String)objProp.get("sid");
                String domain = (String)objProp.get("domain");
                if (this.get(objSID + domain) == null) {
                    if (domainSID.equalsIgnoreCase(this.localDomainSID)) {
                        Long loginId = (Long)objProp.get("loginId");
                        String lookupServer = (String)objProp.get("lookupServer");
                        if (objSID.length() >= 20 && !objSID.contains(this.localDomainSID)) continue;
                        Properties prop = ADHandler.lookupSID((String)domain, (Long)loginId, (String)objSID, (String)lookupServer);
                        ArrayList<String> guid = new ArrayList<String>();
                        guid.add(this.getGuid(CommonUtil.getSIDTableName((String)domain), objSID));
                        prop.put("objectGUID", guid);
                        objSids.put(objSID, ukSids.get(objSID));
                        this.put(objSID + domain, prop);
                        it1.remove();
                        continue;
                    }
                    if (!objSID.contains(domainSID)) continue;
                    sids.add(objSID);
                    sDomainSid.put(objSID, ukSids.remove(objSID));
                    continue;
                }
                it1.remove();
            }
            this.fillDisplayName(objSids);
            SelectQueryImpl selectQuery = new SelectQueryImpl(new Table(domainName_sids));
            selectQuery.addSelectColumn(Column.getColumn((String)domainName_sids, (String)"SID_STRING"));
            selectQuery.addSelectColumn(Column.getColumn((String)domainName_sids, (String)"TYPE_STRING"));
            Criteria c = new Criteria(Column.getColumn((String)domainName_sids, (String)"SID_STRING"), (Object)sids.toArray(new String[sDomainSid.size()]), 8);
            selectQuery.setCriteria(c);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
            Iterator itr = dataObject.getRows(domainName_sids);
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                String type = (String)r.get("TYPE_STRING");
                String sid = (String)r.get("SID_STRING");
                if (type.equals("user")) {
                    users.add(sid);
                    usersMap.put(sid, sDomainSid.remove(sid));
                    continue;
                }
                if (type.equals("computer")) {
                    computers.add(sid);
                    computersMap.put(sid, sDomainSid.remove(sid));
                    continue;
                }
                if (!type.equals("group")) continue;
                groups.add(sid);
                groupsMap.put(sid, sDomainSid.remove(sid));
            }
            others.putAll(sDomainSid);
        }
        others.putAll(ukSids);
        if (users.size() != 0) {
            this.lookupSIDInTable("ADSMUserGeneralDetails", users, usersMap, "user", "COMMON_NAME", others);
        }
        if (computers.size() != 0) {
            this.lookupSIDInTable("ADSMComputerGeneralDetails", computers, computersMap, "computer", "COMPUTER_NAME", others);
        }
        if (groups.size() != 0) {
            this.lookupSIDInTable("ADSMGroupGeneralDetails", groups, groupsMap, "group", "GROUP_NAME", others);
        }
        if (others.size() != 0) {
            this.lookupSidInNative(others);
        }
    }

    private void fillDisplayName(Map objSids) {
        try {
            ArrayList<String> users = new ArrayList<String>();
            ArrayList<String> groups = new ArrayList<String>();
            ArrayList<String> computers = new ArrayList<String>();
            HashMap usersMap = new HashMap();
            HashMap groupsMap = new HashMap();
            HashMap computersMap = new HashMap();
            HashMap<String, ArrayList> domainSidMap = new HashMap<String, ArrayList>();
            for (Map.Entry entry : objSids.entrySet()) {
                Properties sidProp = (Properties)entry.getValue();
                String domainName = (String)sidProp.get("domain");
                String objSID = (String)sidProp.get("sid");
                ArrayList sids = new ArrayList();
                if (domainSidMap.containsKey(domainName)) {
                    sids = (ArrayList)domainSidMap.get(domainName);
                    sids.add(objSID);
                } else {
                    sids.add(objSID);
                }
                domainSidMap.put(domainName, sids);
            }
            for (String domainName : domainSidMap.keySet()) {
                ArrayList sids = (ArrayList)domainSidMap.get(domainName);
                String domainName_sids = CommonUtil.getSIDTableName((String)domainName);
                SelectQueryImpl selectQuery = new SelectQueryImpl(new Table(domainName_sids));
                selectQuery.addSelectColumn(Column.getColumn((String)domainName_sids, (String)"SID_STRING"));
                selectQuery.addSelectColumn(Column.getColumn((String)domainName_sids, (String)"TYPE_STRING"));
                Criteria c = new Criteria(Column.getColumn((String)domainName_sids, (String)"SID_STRING"), (Object)sids.toArray(), 8);
                selectQuery.setCriteria(c);
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
                Iterator itr = dataObject.getRows(domainName_sids);
                while (itr.hasNext()) {
                    Row r = (Row)itr.next();
                    String type = (String)r.get("TYPE_STRING");
                    String sid = (String)r.get("SID_STRING");
                    if (type.equals("user")) {
                        users.add(sid);
                        usersMap.put(sid, objSids.get(sid));
                        continue;
                    }
                    if (type.equals("computer")) {
                        computers.add(sid);
                        computersMap.put(sid, objSids.get(sid));
                        continue;
                    }
                    if (!type.equals("group")) continue;
                    groups.add(sid);
                    groupsMap.put(sid, objSids.get(sid));
                }
                if (users.size() != 0) {
                    this.lookupSIDInTable("ADSMUserGeneralDetails", users, usersMap, "user", "COMMON_NAME", new HashMap(), true);
                }
                if (computers.size() != 0) {
                    this.lookupSIDInTable("ADSMComputerGeneralDetails", computers, computersMap, "computer", "COMPUTER_NAME", new HashMap(), true);
                }
                if (groups.size() == 0) continue;
                this.lookupSIDInTable("ADSMGroupGeneralDetails", groups, groupsMap, "group", "GROUP_NAME", new HashMap(), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lookupSidInNative(Map sids) {
        try {
            for (Map.Entry entry : sids.entrySet()) {
                Properties sidProp = (Properties)entry.getValue();
                String domainName = (String)sidProp.get("domain");
                Long loginId = (Long)sidProp.get("loginId");
                String sid = (String)sidProp.get("sid");
                String lookupServer = (String)sidProp.get("lookupServer");
                Properties prop = ADHandler.lookupSID((String)domainName, (Long)loginId, (String)sid, (String)lookupServer);
                ArrayList<String> guid = new ArrayList<String>();
                guid.add(this.getGuid(CommonUtil.getSIDTableName((String)domainName), sid));
                prop.put("objectGUID", guid);
                this.put(sid + domainName, prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lookupSIDInTable(String tableName, ArrayList objSIDs, Map sidProps, String objType, String objName, Map others) {
        this.lookupSIDInTable(tableName, objSIDs, sidProps, objType, objName, others, false);
    }

    private void lookupSIDInTable(String tableName, ArrayList objSIDs, Map sidProps, String objType, String objName, Map others, boolean isAppendValue) {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(new Table(tableName));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_GUID"));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"SID_STRING"));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)objName));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"));
            if (tableName.equalsIgnoreCase("ADSMUserGeneralDetails")) {
                selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DISPLAY_NAME"));
            }
            Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"SID_STRING"), (Object)objSIDs.toArray(new String[objSIDs.size()]), 8);
            selectQuery.setCriteria(c);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
            Iterator it = dataObject.getRows(tableName);
            if (!it.hasNext()) {
                others.putAll(sidProps);
            }
            while (it.hasNext()) {
                Properties prop = new Properties();
                Row r = (Row)it.next();
                ArrayList<String> domain = new ArrayList<String>();
                String domainName = (String)r.get("DOMAIN_NAME");
                domain.add(domainName);
                prop.put("domain", domain);
                ArrayList<String> trustee = new ArrayList<String>();
                String san = (String)r.get("SAM_ACCOUNT_NAME");
                if (san == null || san.length() == 0) {
                    san = (String)r.get(objName);
                }
                trustee.add(san);
                prop.put("trustee", trustee);
                ArrayList<String> dispNameList = new ArrayList<String>();
                String displayName = "";
                displayName = tableName.equalsIgnoreCase("ADSMUserGeneralDetails") ? (String)r.get("DISPLAY_NAME") : (String)r.get(objName);
                dispNameList.add(displayName);
                prop.put("displayName", dispNameList);
                ArrayList<String> obj = new ArrayList<String>();
                obj.add(objType);
                prop.put("objectType", obj);
                ArrayList<String> guid = new ArrayList<String>();
                guid.add((String)r.get("OBJECT_GUID"));
                prop.put("objectGUID", guid);
                String sidStr = (String)r.get("SID_STRING");
                Properties existingValue = (Properties)this.get(sidStr + domainName);
                if (isAppendValue && existingValue != null) {
                    existingValue.put("displayName", dispNameList);
                    this.put(sidStr + domainName, existingValue);
                } else {
                    this.put(sidStr + domainName, prop);
                }
                sidProps.remove(sidStr);
            }
            if (sidProps.size() > 0) {
                others.putAll(sidProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getGuid(String sidTable, String sid) {
        String objectGUID = "";
        try {
            if (sidTable != null && !sidTable.equalsIgnoreCase("")) {
                Criteria c = new Criteria(Column.getColumn((String)sidTable, (String)"SID_STRING"), (Object)sid, 0);
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(sidTable, c);
                if (!dataObject.isEmpty()) {
                    Row r = dataObject.getFirstRow(sidTable);
                    objectGUID = (String)r.get("OBJECT_GUID");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectGUID;
    }

    private String getLocalDomainSID() {
        String domainSID = "";
        try {
            String localDomain = ADHandler.getLocalDomain();
            Properties domainProp = (Properties)this.domainSIDs.get(localDomain);
            if (domainProp != null) {
                domainSID = (String)domainProp.get("DOMAIN_SID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainSID;
    }

    public boolean isInitialized() {
        return isInitialized;
    }
}

