/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.RecentlyExpiredListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class SoonToExpireListener
extends RecentlyExpiredListener {
    @Override
    public void setDescription(Object[] args, String dataLableText) {
        this.desc = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.next_N_days") || dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.soon_to_expire_users.reportdesc_next_N_days"), args) : MessageFormat.format(this.rb.getString("admp.reports.user_reports.soon_to_expire_users.reportdesc_between_dates"), args);
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
        ADHandler.getSoonToExpireUsers((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (NativeListener)listener, (String)filterString);
    }

    @Override
    public String getFilterString(String startDateVal, String endDateVal, String dataLableText) {
        String filterString = "";
        HashMap datesValueMap = this.getDateInterval(startDateVal, endDateVal, dataLableText);
        long startDate = (Long)datesValueMap.get("startDate");
        long endDate = (Long)datesValueMap.get("endDate");
        filterString = "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(!(accountExpires=0))(!(accountExpires=9223372036854775807))(accountExpires>=" + startDate + ")(accountExpires<=" + endDate + "))";
        return filterString;
    }

    @Override
    public HashMap getDateInterval(String startDateVal, String endDateVal, String dataLableText) {
        HashMap<String, Long> datesValueMap = new HashMap<String, Long>();
        long startDate = 0L;
        long endDate = 0L;
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            Date days = formatter1.parse(startDateVal);
            startDate = DateTimeUtil.getFileTimeFromSystemTime((Long)days.getTime());
            days = formatter1.parse(endDateVal);
            endDate = DateTimeUtil.getFileTimeFromSystemTime((Long)days.getTime());
            datesValueMap.put("startDate", startDate);
            datesValueMap.put("endDate", endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datesValueMap;
    }

    @Override
    public HashMap getScheduleDates(long time) {
        HashMap<String, String> datesMap = new HashMap<String, String>();
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        Date days = new Date(System.currentTimeMillis() + time);
        String endDateVal = formatter1.format(days);
        days = new Date(System.currentTimeMillis());
        String startDateVal = formatter1.format(days);
        datesMap.put("startDate", startDateVal);
        datesMap.put("endDate", endDateVal);
        return datesMap;
    }

    @Override
    public void setDashboardInputParams(Long dashboardReportMapping, HttpServletRequest request, ReportBean bean) {
        ListenerUtil.setDashboardInputParams(dashboardReportMapping, request, bean, 2);
    }
}

