/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.UniqueValueGeneration;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DynamicTableUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class TableUtil {
    public static void createServerTable(String serverTable, String baseTableName) {
        try {
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)serverTable);
            if (tableDef == null) {
                tableDef = new TableDefinition();
                tableDef.setTableName(serverTable);
                ColumnDefinition coldef = new ColumnDefinition();
                coldef.setColumnName("SHARE_ID");
                coldef.setDescription("Indentifier for each share");
                coldef.setDataType("BIGINT");
                coldef.setNullable(false);
                coldef.setUnique(false);
                UniqueValueGeneration generator = new UniqueValueGeneration();
                generator.setGeneratorName(serverTable + ".SHARE_ID");
                coldef.setUniqueValueGeneration(generator);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("LOCATION");
                coldef.setDescription("loaction for each folder.");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(500);
                coldef.setNullable(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("NAME");
                coldef.setDescription("Folder Name.");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(256);
                coldef.setNullable(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("TYPE");
                coldef.setDescription("A unique name for each icon. ");
                coldef.setDataType("CHAR");
                coldef.setMaxLength(100);
                coldef.setNullable(true);
                coldef.setUnique(false);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("CREATION_TIME");
                coldef.setDescription("A unique name for each icon.");
                coldef.setDataType("BIGINT");
                coldef.setMaxLength(100);
                coldef.setNullable(true);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("LAST_ACCESS_TIME");
                coldef.setDescription("A unique name for each icon.");
                coldef.setDataType("BIGINT");
                coldef.setMaxLength(100);
                coldef.setNullable(true);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("LAST_WRITE_TIME");
                coldef.setDescription("A unique name for each icon.");
                coldef.setDataType("BIGINT");
                coldef.setMaxLength(100);
                coldef.setNullable(true);
                tableDef.addColumnDefinition(coldef);
                coldef = new ColumnDefinition();
                coldef.setColumnName("SIZE");
                coldef.setDescription("A unique name for each icon.");
                coldef.setDataType("BIGINT");
                coldef.setMaxLength(100);
                coldef.setNullable(true);
                tableDef.addColumnDefinition(coldef);
                PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
                pkDef.setName(serverTable + "_PK");
                pkDef.addColumnName("SHARE_ID");
                pkDef.setTableName(serverTable);
                tableDef.setPrimaryKey(pkDef);
                DynamicTableUtil.createDynamicTable((TableDefinition)tableDef);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            System.out.println("Exception message :  " + message);
        }
    }

    public static ArrayList getInputDNs(ReportBean bean, Long loginId, String domainName) {
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        ArrayList inputsList = new ArrayList();
        if (inputParams.containsKey("trusteesList")) {
            inputsList.addAll((ArrayList)inputParams.get("trusteesList"));
        }
        ArrayList<String> inputs = new ArrayList<String>();
        ArrayList<String> finalInputs = new ArrayList<String>();
        try {
            Properties prop;
            for (int i = 0; i < inputsList.size(); ++i) {
                Hashtable inputValues = (Hashtable)inputsList.get(i);
                inputs.add((String)inputValues.get("INPUT_OBJECT_ID"));
                finalInputs.add((String)inputValues.get("INPUT_NAME"));
            }
            if (!inputs.isEmpty() && !(prop = ADHandler.getGroupsForUser((String)domainName, (Long)loginId, inputs)).isEmpty()) {
                for (int i = 0; i < inputs.size(); ++i) {
                    ArrayList groupsList = (ArrayList)prop.get((String)inputs.get(i));
                    finalInputs.addAll(groupsList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalInputs;
    }

    public static ArrayList getInputDNs(String inputTable, ReportBean bean) {
        ArrayList totalInputs = (ArrayList)bean.get("totalInputs");
        Long[] inputsArray = new Long[totalInputs.size()];
        ArrayList<String> inputs = new ArrayList<String>();
        ArrayList<String> finalInputs = new ArrayList<String>();
        for (int i = 0; i < totalInputs.size(); ++i) {
            inputsArray[i] = new Long((String)totalInputs.get(i));
        }
        try {
            Criteria crit = new Criteria(new Column(inputTable, "INPUT_ID"), (Object)inputsArray, 8);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(inputTable, crit);
            Iterator it = dataObj.getRows(inputTable);
            while (it.hasNext()) {
                String inputName;
                Row r = (Row)it.next();
                String value = (String)r.get("INPUT_OBJECT_ID");
                if (value != null && !inputs.contains(value)) {
                    inputs.add(value);
                }
                if ((inputName = (String)r.get("INPUT_NAME")) == null || finalInputs.contains(inputName)) continue;
                finalInputs.add(inputName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalInputs;
    }

    public static String getShareLocation(String inputTable, String folderLocation) {
        String location = folderLocation;
        try {
            int start = location.indexOf("\\");
            int end = location.indexOf("\\", start + 2);
            end = location.indexOf("\\", end + 2);
            if (end != -1) {
                String shareName = location.substring(0, end);
                String folderPath = location.substring(end, location.length());
                Criteria crit = new Criteria(new Column(inputTable, "LOCATION"), (Object)shareName, 0);
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(inputTable, crit);
                Row r = dataObj.getFirstRow(inputTable);
                if (r != null) {
                    String localPath = (String)r.get("LOCAL_PATH");
                    localPath = localPath + folderPath;
                    Criteria crit1 = new Criteria(new Column(inputTable, "LOCAL_PATH"), (Object)localPath, 0);
                    DataObject dataObj1 = CommonUtil.getPersistence((boolean[])new boolean[0]).get(inputTable, crit1);
                    if (!dataObj1.isEmpty()) {
                        Row r1 = dataObj1.getFirstRow(inputTable);
                        location = (String)r1.get("LOCATION");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return location;
    }
}

