/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractNTFSReportsListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class TrusteesPermissionListener
extends AbstractNTFSReportsListener {
    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(-1L);
        return categoryId;
    }

    @Override
    public boolean isResultViewOutputFilterAvailable() {
        return true;
    }

    @Override
    public boolean isPermissionColumnIncluded() {
        return true;
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.object_report.text.showing_object_of";
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, String trusteeSID, String permValue, ArrayList attributeList, NativeListener listener) throws Exception {
        ADHandler.getObjectsWithPermission((String)domainName, (Long)loginId, (String)distinguishedName, (String)trusteeSID, (String)permValue, (String)"true", (ArrayList)attributeList, (NativeListener)listener);
    }

    @Override
    public void removeInputParams(ReportBean bean) {
        HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
        if (reportInputParams != null && reportInputParams.containsKey("trusteesList")) {
            reportInputParams.put("trusteesList", new ArrayList());
        }
    }

    @Override
    public void setInputParams(HttpServletRequest request, ReportBean bean) {
        String[] domains;
        String domainName = request.getParameter("domainName");
        if (domainName == null && (domains = (String[])bean.get("domains")).length > 0) {
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            bean.set("domains", new String[]{domains[0]});
        }
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            ArrayList permValue = (ArrayList)reportInputParams.get("permValue");
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            String[] domainList = request.getParameterValues("domains");
            if (permValue != null) {
                Hashtable permValueList = (Hashtable)permValue.get(0);
                this.desc = MessageFormat.format(this.rb.getString("admp.reports.security_reports.objects_access.reportdesc_report_generated_for_domain_with_perm"), dnDomainNameMap.get(domainList[0]), this.rb.getString((String)permValueList.get("INPUT_PROPERTY_VALUE")));
            } else {
                this.desc = MessageFormat.format(this.rb.getString("admp.reports.security_reports.objects_access.reportdesc_report_generated_for_domain"), dnDomainNameMap.get(domainList[0]));
            }
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_OBJECTS_AND_PERMISSION_FOR_USERS.getValue());
            Action action = new Action(loginId, containerList, attributeList, this, dnDomainNameMap, reportInputParams, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        ArrayList trusteesList = (ArrayList)bean.get("trusteesList");
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String[] domainList = (String[])bean.get("domains");
        ArrayList valuesList = new ArrayList();
        for (int i = 0; i < trusteesList.size(); ++i) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            String inputName = CommonUtil.getDisplayName((String)((String)dnDomainNameMap.get(domainList[0])), (String)((String)trusteesList.get(i)));
            inputs.put("INPUT_NAME", inputName);
            String dn = CommonUtil.getDistinguishedName((String)((String)dnDomainNameMap.get(domainList[0])), (String)((String)trusteesList.get(i)));
            inputs.put("DISTINGUISHED_NAME", dn);
            inputs.put("INPUT_OBJECT_ID", (String)trusteesList.get(i));
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private Map inputParams = null;
        private Hashtable excludeChildOUHash = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, NativeListener li, Hashtable map, Map inputParams, Hashtable excludeChildOUHash) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.inputParams = inputParams;
            this.excludeChildOUHash = excludeChildOUHash;
        }

        @Override
        public void run() {
            TrusteesPermissionListener.this.errorMessage = null;
            if (!TrusteesPermissionListener.this.errorList.isEmpty()) {
                TrusteesPermissionListener.this.errorList = new Hashtable();
            }
            Hashtable tableProps = TrusteesPermissionListener.this.getQueueProps();
            ArrayList inputsList = (ArrayList)this.inputParams.get("trusteesList");
            ArrayList permValue = (ArrayList)this.inputParams.get("permValue");
            Hashtable permValueList = (Hashtable)permValue.get(0);
            for (int i = 0; i < this.containerList.size(); ++i) {
                for (int j = 0; j < inputsList.size(); ++j) {
                    Hashtable<String, String> errors;
                    Hashtable inputValues = (Hashtable)inputsList.get(j);
                    if (TrusteesPermissionListener.this.statusController != null) {
                        TrusteesPermissionListener.this.statusController.setTaskObject((Object)((String)inputValues.get("INPUT_NAME")));
                    }
                    try {
                        String dn = (String)this.containerList.get(i);
                        TrusteesPermissionListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                        TrusteesPermissionListener.this.setDomainName(TrusteesPermissionListener.this.domainName);
                        Boolean isExcludeChildOU = Boolean.FALSE;
                        if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                            isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                        }
                        this.listener.setIsExcludeChildOU(isExcludeChildOU);
                        tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                        TrusteesPermissionListener.this.queue.registerForUpdation(TrusteesPermissionListener.this.baseTableName, TrusteesPermissionListener.this.generationId, tableProps);
                        TrusteesPermissionListener.this.doAction(TrusteesPermissionListener.this.domainName, this.loginId, dn, (String)inputValues.get("INPUT_OBJECT_ID"), (String)permValueList.get("INPUT_PROPERTY_VALUE"), this.attributeList, this.listener);
                        TrusteesPermissionListener.this.updateQueue();
                        continue;
                    }
                    catch (LocalizedException e) {
                        e.printStackTrace();
                        TrusteesPermissionListener.this.errorMessage = e.getMessage(TrusteesPermissionListener.this.rb);
                        errors = new Hashtable();
                        errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                        errors.put("ERROR_MESSAGE", TrusteesPermissionListener.this.errorMessage);
                        TrusteesPermissionListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                        TrusteesPermissionListener.this.updateErrorStatus(errors);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        TrusteesPermissionListener.this.errorMessage = e.getMessage();
                        errors = new Hashtable<String, String>();
                        errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                        errors.put("ERROR_MESSAGE", TrusteesPermissionListener.this.errorMessage);
                        TrusteesPermissionListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                        TrusteesPermissionListener.this.updateErrorStatus(errors);
                    }
                }
            }
            TrusteesPermissionListener.this.updatedCount = 0;
            TrusteesPermissionListener.this.totalCount = 0;
            TrusteesPermissionListener.this.completedAction();
        }
    }
}

