/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.reports.RecentlyExpiredListener;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class UnsetPwdListener
extends RecentlyExpiredListener {
    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.pwd_reports.pwd_unchanged.reportdesc_user_pwd_uchanged_in_recent_days"), args);
    }

    @Override
    public void setDescription(Object[] args, String dataLableText) {
        this.desc = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.password_unchanged_users.reportdesc_last_N_days"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.after_a_date") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.password_unchanged_users.reportdesc_after_date"), args) : (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.today") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.password_unchanged_users.reportdesc_for_date"), args) : MessageFormat.format(this.rb.getString("admp.reports.user_reports.password_unchanged_users.reportdesc_between_dates"), args)));
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, String filterString) throws Exception {
        ADHandler.getRecentlyPwdUnChangedUsers((String)domainName, (Long)loginId, (String)distinguishedName, (ArrayList)attributeList, (NativeListener)listener, (String)filterString);
    }

    @Override
    public String getFilterString(String startDateVal, String endDateVal, String dataLableText) {
        String filterString = "";
        HashMap datesValueMap = this.getDateInterval(startDateVal, endDateVal, dataLableText);
        long startDate = (Long)datesValueMap.get("startDate");
        long endDate = (Long)datesValueMap.get("endDate");
        filterString = dataLableText.equalsIgnoreCase("admp.common.matching_criteria.after_a_date") ? "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(!(pwdLastSet=0))(!(pwdLastSet>=" + endDate + ")))" : "(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))(!(pwdLastSet=0))(!(pwdLastSet>=" + startDate + ")))";
        return filterString;
    }

    @Override
    public HashMap getDateInterval(String startDateVal, String endDateVal, String dataLableText) {
        HashMap<String, Long> datesValueMap = new HashMap<String, Long>();
        long startDate = 0L;
        long endDate = 0L;
        try {
            SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            Date days = formatter1.parse(startDateVal);
            startDate = DateTimeUtil.getFileTime((Long)days.getTime());
            days = formatter1.parse(endDateVal);
            endDate = DateTimeUtil.getFileTime((Long)days.getTime());
            days = formatter1.parse(endDateVal);
            Calendar endoftheDay = Calendar.getInstance();
            endoftheDay.setTime(days);
            endoftheDay.set(endoftheDay.get(1), endoftheDay.get(2), endoftheDay.get(5), 23, 59, 59);
            endoftheDay.set(14, 0);
            endDate = DateTimeUtil.getFileTime((Long)endoftheDay.getTimeInMillis());
            if (dataLableText.equalsIgnoreCase("admp.common.matching_criteria.last_N_days")) {
                int lastNDays = DateTimeUtil.daysBetween((Date)formatter1.parse(startDateVal), (Date)formatter1.parse(endDateVal));
                long l = (long)(lastNDays * 24 * 60 * 60) * 1000L;
                startDate = DateTimeUtil.getFileTime((Long)(System.currentTimeMillis() - l));
                endDate = DateTimeUtil.getFileTime((Long)System.currentTimeMillis());
            }
            datesValueMap.put("startDate", startDate);
            datesValueMap.put("endDate", endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datesValueMap;
    }
}

