/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractNTFSReportsListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UserPermissionListener
extends AbstractNTFSReportsListener {
    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(-1L);
        return categoryId;
    }

    @Override
    public void getDescription(Object[] args) {
        this.desc = MessageFormat.format(this.rb.getString("admp.reports.other_reports.user_permissions_objs.reportdesc_access_perm_on_ad_objects_for_user_of_the_domain"), args);
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, String trusteeSID, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        String trustee = request.getParameter("trustee");
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String[] domainList = (String[])bean.get("domains");
        ArrayList valuesList = new ArrayList();
        Hashtable<String, Object> inputs = new Hashtable<String, Object>();
        String inputName = CommonUtil.getDisplayName((String)((String)dnDomainNameMap.get(domainList[0])), (String)trustee);
        inputs.put("INPUT_NAME", inputName);
        String dn = CommonUtil.getDistinguishedName((String)((String)dnDomainNameMap.get(domainList[0])), (String)trustee);
        inputs.put("DISTINGUISHED_NAME", dn);
        inputs.put("INPUT_OBJECT_ID", trustee);
        inputs.put("REPORT_GENERATION_ID", this.generationId);
        ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
        valuesList.add(inputs);
        inputParams.put(key, valuesList);
    }

    @Override
    public void setInputParams(HttpServletRequest request, ReportBean bean) {
        String[] domains;
        String domainName = request.getParameter("domainName");
        if (domainName == null && (domains = (String[])bean.get("domains")).length > 0) {
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            bean.set("domains", new String[]{domains[0]});
        }
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String trusteeSID = request.getParameter("trustee");
            String trusteeName = request.getParameter("trusteeStr");
            String dnName = UserHandler.getUserDN((String)trusteeSID);
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            String[] domainList = request.getParameterValues("domains");
            inputParams.put("domain", ClientUtil.getString(domainList));
            inputParams.put("trustee", trusteeSID);
            String reportDomains = this.getReportDomains(domainList, dnDomainNameMap);
            this.getDescription(new Object[]{trusteeName, reportDomains});
            bean.set("inputParams", inputParams);
            Action action = new Action(loginId, containerList, attributeList, this, dnDomainNameMap, trusteeSID);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            String dnName = "";
            String sidStr = "";
            this.isCompleted = false;
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                if (!admpInput.getIsMultiple().booleanValue()) continue;
                for (FcOption fcOption : admpInput.getMultipleInput()) {
                    if (fcOption.getLabel().equalsIgnoreCase("DISTINGUISHED_NAME")) {
                        dnName = fcOption.getValue();
                        continue;
                    }
                    if (!fcOption.getLabel().equalsIgnoreCase("SID_STRING")) continue;
                    sidStr = fcOption.getValue();
                }
            }
            this.domainName = (String)dnDomainNameMap.get(containerList.get(0));
            String dn = UserHandler.getUserDN((String)this.domainName, (String)sidStr, (Long)this.loginId);
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{dn, schedulerDomains});
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Action action = new Action(1L, containerList, this.getAttributeList(), this, dnDomainNameMap, sidStr);
            action.start();
            while (!this.isCompleted) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private String trusteeSID = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, NativeListener li, Hashtable map, String s) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.trusteeSID = s;
        }

        @Override
        public void run() {
            UserPermissionListener.this.guidList = new ArrayList();
            Hashtable tableProps = UserPermissionListener.this.getQueueProps();
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    UserPermissionListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    UserPermissionListener.this.queue.registerForUpdation(UserPermissionListener.this.baseTableName, UserPermissionListener.this.generationId, tableProps);
                    System.out.println("Datas for the Report ID " + UserPermissionListener.this.reportId + ", Attribute List : " + this.attributeList + ", Trustee : " + this.trusteeSID + " Distinguished Name : " + dn);
                    UserPermissionListener.this.doAction(UserPermissionListener.this.domainName, this.loginId, dn, this.trusteeSID, this.attributeList, this.listener);
                    UserPermissionListener.this.updateQueue();
                    continue;
                }
                catch (LocalizedException excep) {
                    UserPermissionListener.this.errorMessage = excep.getMessage(UserPermissionListener.this.rb);
                    System.out.println("LocalizedException in UserPermissionListener :-" + UserPermissionListener.this.errorMessage);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UserPermissionListener.this.errorMessage = e.getMessage();
                }
            }
            UserPermissionListener.this.updatedCount = 0;
            UserPermissionListener.this.totalCount = 0;
            UserPermissionListener.this.completedAction();
        }
    }
}

