/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UsersForGroupsListener
extends AbstractListener {
    protected ArrayList trusteesListMap = new ArrayList();

    @Override
    public Long getCategoryId() {
        Long categoryId = new Long(1003L);
        return categoryId;
    }

    @Override
    public boolean isResultViewOutputFilterAvailable() {
        return true;
    }

    @Override
    public ArrayList getTrusteesList() {
        return this.trusteesListMap;
    }

    @Override
    public String getOutputFilterLabelText() {
        return "admp.reports.adv_group_report.text.showing_members_of";
    }

    @Override
    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "addOrUpdate");
        return tableProps;
    }

    public void getDescription(Object[] args, Map inputParams) {
        ArrayList isExcludeNestedGroupsList = (ArrayList)inputParams.get("isExcludeNestedGroups");
        Hashtable isExcludeNestedGroupsHash = (Hashtable)isExcludeNestedGroupsList.get(0);
        String isExcludeNestedGroups = (String)isExcludeNestedGroupsHash.get("INPUT_PROPERTY_VALUE");
        this.desc = isExcludeNestedGroups.equalsIgnoreCase("true") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.group_members.reportdesc_group_members_with_exclude_nested_groups"), args) : MessageFormat.format(this.rb.getString("admp.reports.user_reports.group_members.reportdesc_group_members_withOut_exclude_nested_groups"), args);
    }

    public void getDescription(Object[] args, String isExcludeNestedGroups) {
        this.desc = isExcludeNestedGroups.equalsIgnoreCase("true") ? MessageFormat.format(this.rb.getString("admp.reports.user_reports.group_members.reportdesc_group_members_with_exclude_nested_groups"), args) : MessageFormat.format(this.rb.getString("admp.reports.user_reports.group_members.reportdesc_group_members_withOut_exclude_nested_groups"), args);
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
        if (!attributeList.contains("userAccountControl")) {
            attributeList.add("userAccountControl");
        }
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void doAction(String domainName, Long loginId, String distinguishedName, String trustee, ArrayList attributeList, String isExcludeNestedGroups, NativeListener listener) throws Exception {
        ADHandler.getGroupBasedUsers((String)domainName, (Long)loginId, (String)distinguishedName, (String)trustee, (ArrayList)attributeList, (String)isExcludeNestedGroups, (NativeListener)listener);
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, ReportReqParams reqParams, Criteria crit) {
        JSONArray rvcFiltersArray = reqParams.getRvcFilters();
        try {
            String columnName = "INPUT_ID";
            if (rvcFiltersArray != null && rvcFiltersArray.length() > 0) {
                String[] inputFiltervalues = new String[rvcFiltersArray.length()];
                for (int index = 0; index < rvcFiltersArray.length(); ++index) {
                    JSONObject rvcFilterObject = (JSONObject)rvcFiltersArray.get(index);
                    Iterator iterator = rvcFilterObject.keys();
                    while (iterator.hasNext()) {
                        String inputId;
                        inputFiltervalues[index] = inputId = (String)iterator.next();
                        Hashtable errorValues = (Hashtable)this.errorList.get(inputId);
                        if (errorValues == null) continue;
                        if (this.errorMessage == null) {
                            this.errorMessage = (String)errorValues.get("ERROR_MESSAGE");
                            continue;
                        }
                        if (this.errorMessage.contains((String)errorValues.get("ERROR_MESSAGE"))) continue;
                        this.errorMessage = this.errorMessage + "," + (String)errorValues.get("ERROR_MESSAGE");
                    }
                }
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8));
            }
        }
        catch (JSONException jsonEx) {
            jsonEx.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return crit;
    }

    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit) {
        try {
            String columnName = "INPUT_ID";
            ArrayList<String> inputObjects = (ArrayList<String>)bean.get("inputObjects");
            String[] inputFiltervalues = request.getParameterValues("inputs");
            if (inputFiltervalues != null) {
                inputObjects = new ArrayList<String>();
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputFiltervalues, 8));
                for (int i = 0; i < inputFiltervalues.length; ++i) {
                    inputObjects.add(inputFiltervalues[i]);
                    Hashtable errorValues = (Hashtable)this.errorList.get(inputFiltervalues[i]);
                    if (errorValues == null) continue;
                    if (this.errorMessage == null) {
                        this.errorMessage = (String)errorValues.get("ERROR_MESSAGE");
                        continue;
                    }
                    if (this.errorMessage.contains((String)errorValues.get("ERROR_MESSAGE"))) continue;
                    this.errorMessage = this.errorMessage + "," + (String)errorValues.get("ERROR_MESSAGE");
                }
                bean.set("inputObjects", inputObjects);
            } else if (!inputObjects.isEmpty()) {
                String[] inputValues = new String[inputObjects.size()];
                for (int i = 0; i < inputObjects.size(); ++i) {
                    inputValues[i] = (String)inputObjects.get(i);
                }
                crit = crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputValues, 8) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputValues, 8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public Criteria getReportResultFilterCriteria(HttpServletRequest request, DynaValidatorForm bean, Criteria crit, String inputId) {
        try {
            String columnName = "INPUT_ID";
            ArrayList inputObjects = (ArrayList)bean.get("inputObjects");
            crit = !inputObjects.contains(inputId) && inputObjects.size() != 0 ? (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)0L, 0))) : (crit == null ? new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0) : crit.and(new Criteria(new Column(this.resultTableName, columnName), (Object)inputId, 0)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public Criteria getScheduledReportFilterCriteria(Criteria crit, ReportFilterConfig reportFilterConfig, ArrayList tableNames, String inputId) {
        try {
            String columnName = "INPUT_ID";
            crit = crit == null ? new Criteria(Column.getColumn((String)this.resultTableName, (String)columnName), (Object)inputId, 0) : crit.and(new Criteria(Column.getColumn((String)this.resultTableName, (String)columnName), (Object)inputId, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public void start(ArrayList attributeList, HttpServletRequest request, ReportBean bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.checkAttributeList(attributeList);
            ArrayList containerList = this.getContainerList(request, bean);
            HashMap reportInputParams = (HashMap)bean.get("reportInputParams");
            String dn = request.getParameter("domains");
            String domainName = null;
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            if (dn != null) {
                domainName = (String)dnDomainNameMap.get(dn);
            } else {
                Properties domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            }
            this.getDescription(new Object[]{domainName}, reportInputParams);
            this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_GROUP_MEMBERS.getValue());
            String dnName = (String)dnDomainNameMap.get(containerList.get(0));
            if (dnName != null) {
                Action action = new Action(loginId, containerList, reportInputParams, this.getAttributeList(), this, dnDomainNameMap);
                action.start();
            } else {
                System.out.println("Error - the selected OU has been manually moved in AD");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillInputDetails(String inputTable, HttpServletRequest request, ReportBean bean, String key) {
        ArrayList trusteesList = (ArrayList)bean.get("trusteesList");
        HashMap inputParams = (HashMap)bean.get("reportInputParams");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        String[] domainList = (String[])bean.get("domains");
        ArrayList valuesList = new ArrayList();
        for (int i = 0; i < trusteesList.size(); ++i) {
            Hashtable<String, Object> inputs = new Hashtable<String, Object>();
            String inputName = GroupHandler.getDisplayName((String)((String)trusteesList.get(i)), (String)((String)dnDomainNameMap.get(domainList[0])));
            inputs.put("INPUT_NAME", inputName);
            String dn = GroupHandler.getDN((String)((String)trusteesList.get(i)), (String)((String)dnDomainNameMap.get(domainList[0])));
            inputs.put("DISTINGUISHED_NAME", dn);
            inputs.put("INPUT_OBJECT_ID", (String)trusteesList.get(i));
            inputs.put("REPORT_GENERATION_ID", this.generationId);
            ListenerUtil.fillValues(inputTable, this.reportId, inputs, this.generationId);
            valuesList.add(inputs);
        }
        inputParams.put(key, valuesList);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ReportFilterConfig reportFilterConfig) {
        this.executeTask(containerList, dnDomainNameMap, null, null, reportFilterConfig);
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, Hashtable excludedOUList, Hashtable domainVsExcludeChildOU, ReportFilterConfig reportFilterConfig) {
        try {
            String dnName = "";
            this.isCompleted = false;
            String sidStr = "";
            String groupName = "";
            Long i = 0L;
            String isExcludeNestedGroups = "false";
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)this.loginId);
            Long scheduleId = reportFilterConfig.getScheduleId();
            ArrayList inputList = new ArrayList();
            String inputTableName = "ADSMReportObjectDNDetails";
            DataObject dataObject = ListenerUtil.getInputIdForSchedulerReportResult(this.reportId, scheduleId, inputTableName);
            for (AdmpInput admpInput : reportFilterConfig.getInputList()) {
                Long l = i;
                Long l2 = i = Long.valueOf(i + 1L);
                if (admpInput.getIsMultiple().booleanValue()) {
                    for (FcOption fcOption : admpInput.getMultipleInput()) {
                        if (fcOption.getLabel().equalsIgnoreCase("SID_STRING")) {
                            sidStr = fcOption.getValue();
                            continue;
                        }
                        if (!fcOption.getLabel().equalsIgnoreCase("NAME")) continue;
                        groupName = fcOption.getValue();
                    }
                    String distinguishedName = GroupHandler.getDN((String)sidStr, (String)((String)dnDomainNameMap.get(containerList.get(0))));
                    Hashtable<String, Object> inputs = new Hashtable<String, Object>();
                    inputs.put("INPUT_NAME", groupName);
                    inputs.put("DISTINGUISHED_NAME", distinguishedName);
                    Row row = dataObject.getRow(inputTableName, new Criteria(Column.getColumn((String)inputTableName, (String)"SID_STRING"), (Object)sidStr, 0));
                    inputs.put("REPORT_GENERATION_ID", this.generationId);
                    if (row == null) {
                        inputs.put("INPUT_ID", i);
                    } else {
                        inputs.put("INPUT_ID", row.get("UNIQUE_VALUE_MAPPING"));
                    }
                    inputList.add(inputs);
                    continue;
                }
                if (!admpInput.getName().equalsIgnoreCase("isExcludeNestedGroups")) continue;
                isExcludeNestedGroups = admpInput.getValue();
            }
            Hashtable<String, String> isExcludeNestedGroupsHash = new Hashtable<String, String>();
            isExcludeNestedGroupsHash.put("INPUT_PROPERTY_VALUE", isExcludeNestedGroups);
            ArrayList<Hashtable<String, String>> isExcludeNestedGroupsList = new ArrayList<Hashtable<String, String>>();
            isExcludeNestedGroupsList.add(isExcludeNestedGroupsHash);
            HashMap<String, ArrayList<Hashtable<Object, Object>>> reportInputParams = new HashMap<String, ArrayList<Hashtable<Object, Object>>>();
            reportInputParams.put("trusteesList", inputList);
            this.trusteesListMap = inputList;
            reportInputParams.put("isExcludeNestedGroups", isExcludeNestedGroupsList);
            String schedulerDomains = this.getSchedulerDomains(containerList, dnDomainNameMap);
            this.getDescription(new Object[]{schedulerDomains}, isExcludeNestedGroups);
            String domainName = (String)dnDomainNameMap.get(containerList.get(0));
            if (domainName != null) {
                Action action = new Action(1L, containerList, reportInputParams, this.getAttributeList(), this, dnDomainNameMap);
                action.start();
                while (!this.isCompleted) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
            } else {
                System.out.println("Error - Selected OU has been moved in Ad manually");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private Map inputParams = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Long loginId = null;
        private Hashtable dnDomainNameMap = null;

        public Action(Long loginId, ArrayList containerList, Map inputParams, ArrayList attributeList, NativeListener li, Hashtable map) {
            this.loginId = loginId;
            this.containerList = containerList;
            this.inputParams = inputParams;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
        }

        @Override
        public void run() {
            UsersForGroupsListener.this.guidList = new ArrayList();
            Hashtable tableProps = UsersForGroupsListener.this.getQueueProps();
            ArrayList objectIds = UsersForGroupsListener.this.getObjIdList();
            UsersForGroupsListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, UsersForGroupsListener.this.getTableColumns());
            UsersForGroupsListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(UsersForGroupsListener.this.resultTableName);
            ArrayList isExcludeNestedGroupsList = (ArrayList)this.inputParams.get("isExcludeNestedGroups");
            Hashtable isExcludeNestedGroupsHash = (Hashtable)isExcludeNestedGroupsList.get(0);
            String isExcludeNestedGroups = (String)isExcludeNestedGroupsHash.get("INPUT_PROPERTY_VALUE");
            ArrayList inputsList = (ArrayList)this.inputParams.get("trusteesList");
            for (int i = 0; i < inputsList.size(); ++i) {
                Hashtable inputValues = (Hashtable)inputsList.get(i);
                for (int j = 0; j < this.containerList.size(); ++j) {
                    Hashtable<String, String> errors;
                    try {
                        String dn = (String)this.containerList.get(j);
                        UsersForGroupsListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                        UsersForGroupsListener.this.setDomainName(UsersForGroupsListener.this.domainName);
                        if (UsersForGroupsListener.this.statusController != null) {
                            UsersForGroupsListener.this.statusController.setTaskObject((Object)((String)inputValues.get("INPUT_NAME")));
                        }
                        tableProps.put("inputId", (Long)inputValues.get("INPUT_ID"));
                        UsersForGroupsListener.this.addlResultIps.put("INPUT_ID", (Long)inputValues.get("INPUT_ID"));
                        UsersForGroupsListener.this.queue.registerForUpdation(UsersForGroupsListener.this.baseTableName, UsersForGroupsListener.this.generationId, tableProps);
                        UsersForGroupsListener.this.doAction(UsersForGroupsListener.this.domainName, this.loginId, dn, (String)inputValues.get("DISTINGUISHED_NAME"), this.attributeList, isExcludeNestedGroups, this.listener);
                        UsersForGroupsListener.this.updateQueue();
                        continue;
                    }
                    catch (LocalizedException e) {
                        e.printStackTrace();
                        UsersForGroupsListener.this.errorMessage = e.getMessage(UsersForGroupsListener.this.rb);
                        errors = new Hashtable();
                        errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                        errors.put("ERROR_MESSAGE", UsersForGroupsListener.this.errorMessage);
                        UsersForGroupsListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                        UsersForGroupsListener.this.updateErrorStatus(errors);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        UsersForGroupsListener.this.errorMessage = e.getMessage();
                        errors = new Hashtable<String, String>();
                        errors.put("INPUT_NAME", (String)inputValues.get("INPUT_NAME"));
                        errors.put("ERROR_MESSAGE", UsersForGroupsListener.this.errorMessage);
                        UsersForGroupsListener.this.errorList.put(inputValues.get("INPUT_ID").toString(), errors);
                        UsersForGroupsListener.this.updateErrorStatus(errors);
                    }
                }
            }
            UsersForGroupsListener.this.updatedCount = 0;
            UsersForGroupsListener.this.totalCount = 0;
            UsersForGroupsListener.this.completedAction();
        }
    }
}

