/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports.advanced;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCHandler;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCUtil;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.AdvancedReportsInterface;
import com.adventnet.sym.adsm.common.server.reports.DBStringTransformerUtil;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;

public class AbstractAdvancedReportsListener
implements AdvancedReportsInterface {
    protected static Logger reportLogger = Logger.getLogger("ReportLogger");
    protected StatusUpdater statusController = null;
    public AdventNetResourceBundle rb = null;
    protected Long generationId = null;
    protected Long queueRegID = null;
    protected Long resultRegID = null;
    protected Hashtable attributeProps = null;
    protected Hashtable dbProps = null;
    protected String domainName = null;
    protected boolean continueAction = true;
    protected Boolean isCompleted = true;
    protected int totalCount = 0;
    protected boolean isMultiDC = false;
    protected ArrayList authOUList = null;
    protected boolean updateDBOnly = false;
    protected boolean updateResultTable = true;
    protected String objectClass = "";

    public void startNative(String dcName, NativeListener listener, boolean isFirstDC) {
    }

    public void addRow(Properties prop) {
        try {
            String objectClass = this.getObjClass(prop);
            ObjectClass object = DirectoryObjectAPI.getInstance().getObjectClass(objectClass);
            ArrayList objAttribList = object.getNativeMandatoryAttributes();
            Properties dbProp = new Properties();
            Hashtable tableStringMap = DBStringTransformerUtil.getReportRows((Properties)prop, (ArrayList)((ArrayList)this.attributeProps.get(object.getId())), (String)this.domainName, (Properties)dbProp, (Hashtable)this.dbProps, (AdventNetResourceBundle)this.rb);
            String guid = this.getGuid(dbProp, (Integer)objAttribList.get(0));
            if (guid == null) {
                return;
            }
            if (!this.updateDBOnly) {
                this.statusController.updateStatus(dbProp, objectClass, guid);
            }
            ++this.totalCount;
            QueueHandler.getInstance().getQueue(object.getId()).updateData(this.queueRegID, tableStringMap);
            if (this.updateResultTable) {
                ResultDataHandler.getInstance().getProcessor().updateData(this.resultRegID, ResultDataUtil.getDBString((String)"ADSMUserReportResult", (Long)this.generationId, (String)guid));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getObjClass(Properties prop) {
        ArrayList values = (ArrayList)prop.get("objectClass");
        if (values == null) {
            ArrayList<String> a = new ArrayList<String>();
            a.add(this.objectClass);
            prop.put("objectClass", a);
            return this.objectClass;
        }
        return (String)values.get(values.size() - 1);
    }

    public String getGuid(Properties prop, Integer nativeKey) {
        ArrayList guids = (ArrayList)prop.get(nativeKey);
        if (guids == null) {
            return null;
        }
        String guid = (String)guids.get(0);
        return guid;
    }

    public boolean isCompleted() {
        return !this.continueAction;
    }

    public StatusUpdater getStatusController() {
        return this.statusController;
    }

    public void setStatusController(StatusUpdater statusController) {
        this.statusController = statusController;
    }

    public void setGenerationId(Long genId) {
        this.generationId = genId;
    }

    public void start(DataObject cvcDO, StatusUpdater status) {
    }

    public void modifyAction(Integer mgmtReportId, Integer reportId, Long generationID, AdmpInput admpInput, String domainName, Long loginID, String hostId, AdventNetResourceBundle rb) {
        this.rb = rb;
        this.domainName = domainName;
        this.continueAction = true;
        this.isCompleted = false;
        this.statusController.setIsCompleted(false);
        this.loadDomainProps();
        ModifyAction thread = new ModifyAction(mgmtReportId, reportId, generationID, admpInput, domainName, loginID, hostId, rb, (NativeListener)this);
        thread.start();
    }

    protected void completedAction() {
        QueueHandler.getInstance().postNativeData(this.queueRegID);
        QueueHandler.getInstance().deRegister(this.queueRegID);
        ResultDataHandler.getInstance().getProcessor().postNativeData(this.resultRegID, true);
        ResultDataHandler.getInstance().getProcessor().deRegister(this.resultRegID);
        this.isCompleted = true;
        this.statusController.setIsCompleted(this.isCompleted.booleanValue());
        this.totalCount = 0;
    }

    public static Hashtable getTableColumns(ArrayList attributeList) {
        Hashtable hash = new Hashtable();
        String keyColumn = "OBJECT_GUID";
        for (int i = 0; i < attributeList.size(); ++i) {
            Properties attributeProp = (Properties)attributeList.get(i);
            String tableName = attributeProp.getProperty("TABLE_NAME");
            String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
            String ldap = attributeProp.getProperty("ATTRIB_LDAP_NAME");
            if (MultiDCUtil.isSupportedAttribute((String)ldap, null)) continue;
            ArrayList<String> columns = (ArrayList<String>)hash.get(tableName);
            if (columns == null) {
                columns = new ArrayList<String>();
                hash.put(tableName, columns);
            }
            if (columns.contains(columnName)) continue;
            columns.add(columnName);
        }
        Enumeration e = hash.keys();
        while (e.hasMoreElements()) {
            String tableName = (String)e.nextElement();
            ArrayList columns = (ArrayList)hash.get(tableName);
            if (columns.contains(keyColumn)) continue;
            columns.add(keyColumn);
        }
        return hash;
    }

    public ArrayList getAttributeList(ArrayList attribDetailsList) {
        ArrayList<Object> attributeList = new ArrayList<Object>();
        for (int i = 0; i < attribDetailsList.size(); ++i) {
            Properties p = (Properties)attribDetailsList.get(i);
            if (attributeList.contains(p.get("ATTRIB_LDAP_NAME"))) continue;
            attributeList.add(p.get("ATTRIB_LDAP_NAME"));
        }
        if (!attributeList.contains("objectSID")) {
            attributeList.add("objectSID");
        }
        if (!attributeList.contains("objectGUID")) {
            attributeList.add("objectGUID");
        }
        return attributeList;
    }

    public void stopReport() {
        this.continueAction = false;
        if (this.isMultiDC) {
            MultiDCHandler.getInstance().stop(this.queueRegID);
        }
        while (!this.isCompleted.booleanValue()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void loadDomainProps() {
        try {
            this.dbProps = new Hashtable();
            Properties props = PolicyHandler.getPolicies((String)this.domainName, (Long)1L);
            String maxPwdAge = props.getProperty("maxPwdAge");
            this.dbProps.put("maxPwdAge", maxPwdAge);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isExcludeChildOU() {
        return false;
    }

    public void setIsExcludeChildOU(Boolean isExcludeChildOU) {
    }

    public void setNativeError(String domainName, Hashtable errorHash) {
    }

    public void setNativeError(String domainName, String dCName, Hashtable errorHash) {
    }

    public ArrayList getObjectIds() {
        return null;
    }

    public void start(ReportFilterConfig reportFilterConfig, String domainName, String distinguishedName, StatusUpdater statusController) {
    }

    public void setErrorMessageKeys(String error) {
    }

    public String getErrorMessageKeys() {
        return null;
    }

    class ModifyAction
    extends Thread {
        Integer mgmtReportId = 0;
        Integer reportId = 0;
        Long generationID = 0L;
        Long loginID = 0L;
        AdmpInput admpInput = null;
        AdventNetResourceBundle rb = null;
        String domainName;
        String hostId;
        NativeListener callBackListener = null;

        public ModifyAction(Integer mgmtReportId, Integer reportId, Long generationID, AdmpInput admpInput, String domainName, Long loginID, String hostId, AdventNetResourceBundle rb, NativeListener callBackListener) {
            this.mgmtReportId = mgmtReportId;
            this.reportId = reportId;
            this.generationID = generationID;
            this.admpInput = admpInput;
            this.rb = rb;
            this.loginID = loginID;
            this.hostId = hostId;
            this.domainName = domainName;
            this.callBackListener = callBackListener;
        }

        @Override
        public void run() {
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginID, (String)this.hostId, (Integer)this.mgmtReportId, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb);
                ADMPAuthObject authObject = new ADMPAuthObject(this.loginID);
                DataObject obj = ReportHandler.getReportDetails((Integer)this.mgmtReportId);
                Row r = obj.getFirstRow("ADSMReports");
                String className = (String)r.get("CLASS_NAME");
                Class<?> classToInvoke = Class.forName(className.trim());
                ModifyUserListener listener = (ModifyUserListener)classToInvoke.newInstance();
                String resultTableName = (String)r.get("RESULT_TABLE_NAME");
                String baseTableName = (String)r.get("BASE_TABLE_NAME");
                listener.init(r);
                listener.setDomainName(this.domainName);
                listener.setAuthorizedDomainOUHash(authObject.getDomainOUsMap());
                listener.setDomainVsIds(authObject.getDomainActionMap());
                Properties mgmtStatus = null;
                ArrayList attributeList = ReportAttributeHandler.getInstance().getModifiedColumns(this.mgmtReportId);
                attributeList.add(listener.getSIDProps());
                listener.addDNProps(attributeList);
                Properties p = new Properties();
                p.put("TABLE_NAME", resultTableName);
                p.put("ATTRIB_COLUMN_NAME", "OBJECT_GUID");
                Hashtable multipleValuesSids = new Hashtable();
                ArrayList list = ReportResultUtil.getRows(listener, this.generationID, resultTableName, attributeList, p, true, -1, -1, multipleValuesSids, null, null, "OBJECT_GUID", new ArrayList<String>());
                ArrayList<Integer> objectIds = new ArrayList<Integer>();
                ObjectClass objClass = DirectoryObjectAPI.getInstance().getObjectClassFromBaseTableName(baseTableName);
                objectIds.add(objClass.getId());
                AbstractAdvancedReportsListener.this.objectClass = objClass.getObjectClass();
                ArrayList nativeAttributesList = ReportAttributesUtil.getAttributeDetailsList((int)this.reportId, (Integer)objClass.getId());
                AbstractAdvancedReportsListener.this.attributeProps = new Hashtable();
                AbstractAdvancedReportsListener.this.attributeProps.put(objClass.getId(), nativeAttributesList);
                AbstractAdvancedReportsListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, AbstractAdvancedReportsListener.getTableColumns(nativeAttributesList));
                AbstractAdvancedReportsListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(resultTableName);
                AbstractAdvancedReportsListener.this.updateDBOnly = true;
                AbstractAdvancedReportsListener.this.updateResultTable = false;
                HashMap props = new HashMap();
                for (int i = 0; i < list.size() && AbstractAdvancedReportsListener.this.continueAction; ++i) {
                    AbstractAdvancedReportsListener.this.statusController.setProgressTask(7);
                    Hashtable result = (Hashtable)list.get(i);
                    mgmtStatus = new Properties();
                    String objName = listener.getObjectName(result);
                    String guid = (String)result.get("OBJECT_GUID");
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)objName, (String)this.domainName, (DataObject)auditDataObj);
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    audit_info.put("object_id", object_id);
                    String message = "";
                    message = listener.checkAuthorization(this.domainName, this.loginID, guid) ? listener.modifyUser(result, AbstractAdvancedReportsListener.this.getAttributeList(nativeAttributesList), this.admpInput, this.callBackListener, this.domainName, this.loginID, audit_info, auditDataObj) : this.rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.not_authorised_user");
                    mgmtStatus.put("message", message);
                    AbstractAdvancedReportsListener.this.statusController.updateStatus(mgmtStatus, "", guid);
                    ReportHandler.updateSIDMessage((String)resultTableName, (Long)this.generationID, (String)guid, (String)message);
                    audit_info.put("error_msg", message);
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                }
                AbstractAdvancedReportsListener.this.isCompleted = true;
                AbstractAdvancedReportsListener.this.completedAction();
                AbstractAdvancedReportsListener.this.statusController.setIsCompleted(AbstractAdvancedReportsListener.this.isCompleted.booleanValue());
                AbstractAdvancedReportsListener.this.updateResultTable = true;
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

