/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports.advanced;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.cvc.CVCUtil;
import com.adventnet.sym.adsm.common.server.delegation.O365DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.reports.ReportController;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVHandler;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.AdvancedSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.RVColumnUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.util.SchedulerLicenseUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.export.ReportPdfExporter;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ZipUtility;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdvReportTask
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private String reportName = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        reportLogger.log(Level.INFO, "Scheduling the AdvReportTask Task............");
        Row audit_row = taskContext.getAuditRow();
        Long auditId = (Long)audit_row.get("AUDIT_ID");
        System.out.println(" TASK getScheduleID : " + taskContext.getScheduleID() + ", for the Task ID :  " + taskContext.getTaskID() + ", and the ID : " + taskContext.getID() + ", and the audit id is : " + auditId);
        Long scheduleId = taskContext.getScheduleID();
        String storagePath = "";
        try {
            Hashtable reportDetails = AdvancedSchedulerUtil.getAdvancedSchedulerDetails((Long)scheduleId);
            String scheduleName = (String)reportDetails.get("SCHEDULER_NAME");
            Long loginId = (Long)reportDetails.get("LOGIN_ID");
            Long cvcDataId = (Long)reportDetails.get("CVC_DATA_ID");
            Integer reportId = (Integer)reportDetails.get("REPORT_ID");
            String filePath = (String)reportDetails.get("FILE_SERVER_PATH");
            String attachmentType = (String)reportDetails.get("ATTACHMENT_TYPE");
            Boolean overWrite = (Boolean)reportDetails.get("OVERWRITE_FILES");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
            boolean isLicensed = SchedulerLicenseUtil.isSchedulerModuleLicensed((AdventNetResourceBundle)rb);
            Boolean isDemo = CommonUtil.isDemo();
            if (isDemo.booleanValue() || !isLicensed) {
                SchedulerHandler.enableDisableScheduler((Long)scheduleId, (Long)taskContext.getTaskID(), (int)4);
                return;
            }
            DataObject cvcDataDO = CVCDataUtil.getCVCDataDO((Long)cvcDataId, (ArrayList)CVCDataUtil.getComponentsList((Long)CVCUtil.getCVCId((Integer)reportId)));
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId, (DataObject)cvcDataDO);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            statusUpdater.init(rvcDataObject, cvcDataId);
            Long generationId = ReportController.getInstance().generateReport(reportId, loginId, cvcDataDO, statusUpdater, rb);
            reportLogger.log(Level.INFO, "Started the Adv Scheduled Task for the reportId " + reportId + " cvcDataModelId " + cvcDataId + " GenId :: " + generationId);
            if (reportId == 53) {
                while (!statusUpdater.isCompleted()) {
                    try {
                        Thread.sleep(30L);
                    }
                    catch (Exception e) {}
                }
                statusUpdater = ReportController.getInstance().getStatus(generationId);
            }
            while (!statusUpdater.isCompleted()) {
                try {
                    Thread.sleep(30L);
                }
                catch (Exception e) {}
            }
            ReportController.getInstance().removeReportListener(generationId);
            scheduleName = CommonUtil.replaceFolderSplChars((String)scheduleName);
            scheduleName = scheduleName.replaceAll(" ", "_");
            storagePath = SchedulerUtil.makeDirectory((Long)loginId, (Long)scheduleId, (String)scheduleName, (String)filePath, (boolean)overWrite);
            ArrayList mailIds = AdvancedSchedulerUtil.getAdvancedSchedulerMailIds((Long)((Long)reportDetails.get("ADMP_SCHEDULE_ID")));
            Hashtable mailSettings = AdvancedSchedulerUtil.getAdvancedMailSettings((Long)scheduleId, (String)"ADSMAdvancedScheduler");
            ArrayList filesList = this.exportReport(reportDetails, generationId, cvcDataDO, rvcDataObject, storagePath, mailIds.toString());
            String exportedFileName = "admp-reports.zip";
            if (!filesList.isEmpty()) {
                exportedFileName = scheduleName + ".zip";
            }
            String zipPassword = PasswordUtil.getExportFilePassword((Long)loginId);
            ZipUtility.makeZip(storagePath, zipPassword, null, null, exportedFileName);
            System.out.println("Exported File Path : " + exportedFileName + filesList);
            String acKnowledge = "";
            if (mailIds.size() > 0) {
                if (zipPassword != null && !zipPassword.equals("")) {
                    mailSettings.put("ATTACHMENT_TYPE", "ZIP");
                }
                acKnowledge = SendMailAPI.sendAttachedMail((ArrayList)mailIds, (String)scheduleName, (String)storagePath, (String)exportedFileName, (Long)scheduleId, (AdventNetResourceBundle)ResourceBundleMgr.getInstance().getBundle(loginId), (Hashtable)mailSettings);
            }
            SchedulerHandler.updateReportFolderDetails((String)storagePath, (Long)auditId, (String)acKnowledge);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (PrivacyHandler.getInstance().isProtectExportFilesEnabled().booleanValue()) {
                    ReportHandler.deleteExportedFiles((String)storagePath);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private ArrayList exportReport(Hashtable reportDetails, Long generationId, DataObject cvcDataDO, DataObject rvcDataObject, String storagePath, String mailIds) {
        String fileName = null;
        ArrayList filesList = new ArrayList();
        try {
            Long loginId = (Long)reportDetails.get("LOGIN_ID");
            Long cvcDataId = (Long)reportDetails.get("CVC_DATA_ID");
            Integer reportId = (Integer)reportDetails.get("REPORT_ID");
            String exportType = (String)reportDetails.get("MAILING_FORMAT");
            String scheduleDescription = (String)reportDetails.get("DESCRIPTION");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
            ArrayList cvcOutputFilters = CVCUtil.getCVCSelectedInputList((Long)cvcDataId);
            if (cvcOutputFilters.size() == 0) {
                cvcOutputFilters = new ArrayList();
                Hashtable cvcInputDetails = new Hashtable();
                cvcInputDetails.put("objectName", reportDetails.get("SCHEDULER_NAME"));
                cvcOutputFilters.add(cvcInputDetails);
            }
            boolean exportCurrentView = false;
            HashMap<String, String> jrParameterMap = new HashMap<String, String>();
            int iamAppId = RVColumnUtil.getIamAppIdForReportId((Integer)reportId);
            DataObject reportDO = ReportHandler.getReportDetails((Integer)reportId);
            Row row = reportDO.getFirstRow("ADSMReports");
            this.reportName = (String)row.get("REPORT_NAME");
            jrParameterMap.put("REPORT_NAME", rb.getString(this.reportName));
            if (scheduleDescription != null && scheduleDescription.equals("")) {
                scheduleDescription = rb.getString((String)row.get("DESCRIPTION"));
            }
            jrParameterMap.put("DESCRIPTION", scheduleDescription);
            String waadTenantId = CVCDataUtil.getCVCSelectedDomain((DataObject)cvcDataDO);
            jrParameterMap.put("DOMAIN_NAME", waadTenantId);
            Row r = ReportHandler.getGeneratedReportDetails((Long)generationId, (Long)loginId);
            Long time = (Long)r.get("CREATION_TIME");
            jrParameterMap.put("CREATION_TIME", DateTimeUtil.getDateFormat((Long)loginId).format(new Date(time)));
            jrParameterMap.put("DOMAIN_NAME_TEXT", rb.getString("admp.common.attrib_disp_name.dn_domain_name"));
            jrParameterMap.put("DESCRIPTION_TEXT", rb.getString("admp.common.attrib_disp_name.desc"));
            jrParameterMap.put("CREATION_TIME_TEXT", rb.getString("admp.reports.common.reportresult.generated_date_time"));
            RVReqParams reqParams = new RVReqParams();
            reqParams.setReportId(reportId.intValue());
            reqParams.setReportName(this.reportName);
            reqParams.setCvcDataId(cvcDataId.longValue());
            reqParams.setGenerationId(generationId.longValue());
            reqParams.setLoginId(loginId);
            reqParams.setRb(rb);
            if (iamAppId == 3 || iamAppId == 2) {
                reqParams.setDelegatedO365Domains(O365DelegationUtil.getDelegatedIamAppDomains((Long)loginId, (String)waadTenantId));
                boolean applyOURestriction = false;
                if (iamAppId == 3) {
                    ArrayList objectIdList = CVCUtil.getObjectIdList((Long)reqParams.getCvcDataId());
                    applyOURestriction = objectIdList.size() > 0 && (Integer)objectIdList.get(0) == 7 ? O365DelegationUtil.getApplyOURestriction((Long)loginId, (String)waadTenantId, (String)"group").booleanValue() : O365DelegationUtil.getApplyOURestriction((Long)loginId, (String)waadTenantId, (String)"user").booleanValue();
                    reqParams.setApplyOURestriction(Boolean.valueOf(applyOURestriction));
                    if (applyOURestriction) {
                        ArrayList authOUList = O365DelegationUtil.getAuthorizedOUList((Long)loginId, (String)waadTenantId);
                        reqParams.setAuthOUList(authOUList);
                    }
                }
            }
            if (exportType.equalsIgnoreCase("pdf")) {
                ReportPdfExporter pdfExporter = new ReportPdfExporter();
                pdfExporter.init(jrParameterMap, rvcDataObject, reqParams, rb);
                pdfExporter.setExportCurrentViewOnly(exportCurrentView);
                pdfExporter.setIsForScheduler(true);
                fileName = pdfExporter.exportReportAsFile(storagePath);
                filesList.add(fileName);
                if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                    DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)"-", (String)"admp.deleg.hdt_deleg.cre_role.action_name.ad_reports", (String)this.reportName, (Integer)reportId, (String)mailIds, (Boolean)Boolean.FALSE, (String)(this.reportName + ".pdf"), (String)"pdf", (String)storagePath, (Integer)pdfExporter.getExportRowCount());
                }
            } else if (!exportCurrentView) {
                ArrayList exportViewsList = RVHandler.getViewsListForExport((DataObject)rvcDataObject, (AdventNetResourceBundle)rb);
                HashMap<String, Object> exportResult = new HashMap<String, Object>();
                exportResult.put("exportCount", 0);
                exportResult.put("mailIds", mailIds);
                filesList = ReportExportUtil.exportAllConfig(exportViewsList, reqParams, cvcOutputFilters, exportType, rvcDataObject, storagePath, rb, true, exportResult);
            } else {
                System.out.println("Going to export the single view of pdf content without bookmarks");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filesList;
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "DailyReportTask";
    }
}

