/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports.advanced;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.computermanagement.ComputerMgmtHandler;
import com.adventnet.sym.adsm.common.server.csv.ImportCSV;
import com.adventnet.sym.adsm.common.server.csv.ImportCSVUtil;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.cvc.CVCUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.FileReaderModel;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.reports.ReportController;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.ColumnCustomizationHandler;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.reports.advanced.AdvancedReportsUtil;
import com.adventnet.sym.adsm.common.webclient.statusupdater.RVMgmtResultStatusUpdater;
import com.adventnet.sym.adsm.common.webclient.util.CSVReader;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ajax.AjaxUtil;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdvancedReportsAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(AdvancedReportsAction.class.getName());

    public ActionForward loadReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tile = "reportsPage";
        try {
            String reportIdStr = request.getParameter("reportId");
            Integer reportId = Integer.parseInt(reportIdStr);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long cvcId = CVCUtil.getCVCId((Integer)reportId);
            Long cvcDataId = AdvancedReportsUtil.getCVCDataId(reportId, loginId, session.getId());
            request.setAttribute("cvcId", (Object)cvcId);
            request.setAttribute("cvcDataId", (Object)cvcDataId);
            if (!ClientAuthorizationUtil.isAuthorized(request, reportId)) {
                tile = "accessDenied";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    public ActionForward getRecentlyGeneratedReportDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String reportIdStr = request.getParameter("reportId");
            Integer reportId = Integer.parseInt(reportIdStr);
            Long cvcDataModelId = Long.parseLong(request.getParameter("cvcDataId"));
            HttpSession session = request.getSession();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Row generationProps = AdvancedReportsUtil.getGenerationProps(loginId, cvcDataModelId);
            boolean isResultAvailable = false;
            Long generationId = null;
            if (generationProps != null) {
                generationId = (Long)generationProps.get("REPORT_GENERATION_ID");
                Long generationStatus = (Long)generationProps.get("STATUS");
                this.logger.log(Level.FINE, " ReportHandler.getRecentlyGeneratedReports is " + generationId);
                isResultAvailable = AdvancedReportsUtil.isResultAvailableForGenerationId(generationId, reportId);
            }
            if (generationId != null && ((Long)generationProps.get("STATUS") == 0L || isResultAvailable)) {
                DataObject cvcDataDO = CVCDataUtil.getCVCDataDO((Long)cvcDataModelId, (ArrayList)CVCDataUtil.getComponentsList((Long)CVCUtil.getCVCId((Integer)reportId)));
                if (cvcDataDO.containsTable("CVCO365AccountSelectData")) {
                    Row accountSelectionRow = cvcDataDO.getRow("CVCO365AccountSelectData");
                    Long waadDomainId = (Long)accountSelectionRow.get("O365_ACCOUNT_ID");
                    String waadTenantId = O365MgmtHandler.getWaadTenantId((Long)waadDomainId);
                    Hashtable iamAppAccountDetails = authObject.getAuthorizedIamAppAccountDetails();
                    if ((iamAppAccountDetails = (Hashtable)iamAppAccountDetails.get(waadTenantId)) == null || !((Boolean)iamAppAccountDetails.get("isWaadAccountSelected")).booleanValue()) {
                        this.logger.log(Level.INFO, "hdt cannot access recently generated report");
                        return null;
                    }
                }
                DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId, (DataObject)cvcDataDO);
                Row reportToViewMappingrow = rvcDataObject.getRow("ADSMReportToRVCDataMapping");
                Integer rvcDataId = (Integer)reportToViewMappingrow.get("RVC_ID");
                JSONObject rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)reportId, (Integer)rvcDataId, (Long)cvcDataModelId, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)loginId);
                rvcJsonObject.put("generationId", (Object)generationId);
                Long generationStatus = (Long)generationProps.get("STATUS");
                if (generationStatus == 0L) {
                    StatusUpdater statusUpdator = ReportController.getInstance().getStatus(generationId);
                    if (statusUpdator != null) {
                        rvcJsonObject.put("isReportRunning", !statusUpdator.isCompleted());
                    } else {
                        rvcJsonObject.put("isReportRunning", false);
                    }
                } else {
                    rvcJsonObject.put("isReportRunning", false);
                }
                response.setContentType("application/json");
                PrintWriter writer = response.getWriter();
                writer.print(rvcJsonObject.toString());
            } else {
                this.logger.log(Level.INFO, "Geneid is null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward saveReportConfiguration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block3: {
            PrintWriter writer = null;
            String forwardPage = "resultview";
            try {
                String reportIdStr = request.getParameter("reportId");
                Integer reportId = Integer.parseInt(reportIdStr);
                HttpSession session = request.getSession();
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                JSONObject jsonObject = new JSONObject(request.getParameter("CVCData"));
                DataObject cvcDataDO = CVCDataUtil.saveCVCData((JSONObject)jsonObject);
                Row cvcDataRow = cvcDataDO.getFirstRow("CVConfigurationData");
                Long dataModelId = (Long)cvcDataRow.get("CVC_DATA_ID");
                String domainName = CVCDataUtil.getCVCSelectedDomain((DataObject)cvcDataDO);
                if (cvcDataDO.containsTable("CVCDomainSelectData") && !ClientAuthorizationUtil.isAuthorized(request, domainName, reportId)) {
                    return null;
                }
                DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId, (DataObject)cvcDataDO);
                Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
                String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
                StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
                statusUpdater.init(rvcDataObject, dataModelId);
                Long generationId = ReportController.getInstance().generateReport(reportId, loginId, cvcDataDO, statusUpdater, rb);
                CVCUtil.saveDataModelId((String)session.getId(), (Long)loginId, (Integer)reportId, (Long)dataModelId, (Long)generationId);
                ColumnCustomizationHandler.insertViewColumns((DataObject)cvcDataDO, (DataObject)rvcDataObject, (Long)loginId);
                Row reportToViewMappingrow = rvcDataObject.getRow("ADSMReportToRVCDataMapping");
                Integer rvcDataId = (Integer)reportToViewMappingrow.get("RVC_ID");
                JSONObject rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)reportId, (Integer)rvcDataId, (Long)dataModelId, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)loginId);
                rvcJsonObject.put("generationId", (Object)generationId);
                rvcJsonObject.put("isReportRunning", true);
                response.setContentType("application/json");
                writer = response.getWriter();
                writer.print(rvcJsonObject.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (writer == null) break block3;
                writer.close();
            }
        }
        return null;
    }

    public ActionForward getReportSpecificAttributes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block2: {
            PrintWriter writer = null;
            try {
                String reportIdStr = request.getParameter("reportId");
                Integer reportId = Integer.parseInt(reportIdStr);
                JSONArray attributes = ReportAttributesUtil.getUIMandatoryAttribs((Integer)reportId);
                AjaxUtil.writeJsonResponse(response, attributes.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (writer == null) break block2;
                writer.close();
            }
        }
        return null;
    }

    public ActionForward getDynamicUpdateDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = null;
        try {
            JSONObject reqJSONObject = new JSONObject(request.getParameter("params"));
            Long generationId = reqJSONObject.getInt("generationId");
            StatusUpdater dynamicUpdator = ReportController.getInstance().getStatus(generationId);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            if (dynamicUpdator == null) {
                jsonObject = new JSONObject();
                jsonObject.put("isCompleted", true);
            } else {
                jsonObject = dynamicUpdator.getJSONObject(reqJSONObject, rb);
            }
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward stopReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String reportIdStr = request.getParameter("reportId");
            Integer reportId = Integer.parseInt(reportIdStr);
            HttpSession session = request.getSession();
            Long generationId = AdvancedReportsUtil.getGenerationId(session.getId(), reportId);
            StatusUpdater dynamicUpdator = ReportController.getInstance().getStatus(generationId);
            dynamicUpdator.setProgressTask(StatusUpdater.TASKCODE.PROCESS_INTERRUPTED.getValue());
            ReportController.getInstance().stopReport(AdvancedReportsUtil.getGenerationId(session.getId(), reportId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward csvImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONObject csvErr = new JSONObject();
            DiskFileUpload upload = new DiskFileUpload();
            List items = upload.parseRequest(request);
            FileItem file = (FileItem)items.get(0);
            InputStream stream = file.getInputStream();
            String encoding = "UTF-8";
            if (request.getParameter("encoding") != null) {
                encoding = request.getParameter("encoding");
            }
            CSVReader csvReader = new CSVReader(stream, ',', '\"', false, true, true, encoding, rb);
            ArrayList<ObjectClass> objTypes = new ArrayList<ObjectClass>();
            objTypes.add(DirectoryObjectAPI.getInstance().getObjectClass("user"));
            objTypes.add(DirectoryObjectAPI.getInstance().getObjectClass("computer"));
            ImportCSV csvObj = new ImportCSV((FileReaderModel)csvReader, objTypes, rb);
            csvObj.setCustomAttributeHandling(ImportCSVUtil.ALLOW);
            csvObj.setMultiValueAttributeHandling(ImportCSVUtil.IGNORE);
            csvObj.setMultiDCAttributeHandling(ImportCSVUtil.IGNORE);
            csvObj.doImport();
            Long userCreationID = 0L;
            boolean isSuccess = csvObj.isSuccess();
            csvErr.put("status", isSuccess);
            if (isSuccess) {
                ArrayList userDetailsList = csvObj.getUserDetailsList();
                ArrayList customList = csvObj.getCustomAttributesList();
                Hashtable importAttribList = csvObj.getImportedAttributes();
                ArrayList importedAttribDetailsList = csvObj.getImportedAttribList();
                String sessionID = session.getId();
                String domainName = request.getParameter("domainName");
                String containerName = "CN=Users," + domainName;
                userCreationID = AddUserHandler.getInstance().addNewUserList(sessionID, domainName, containerName, null, loginId);
                this.logger.log(Level.INFO, "userCreationID:;" + userCreationID);
                AddUserHandler.getInstance().addObjectsDetailList(userCreationID, userDetailsList, importedAttribDetailsList, customList);
                JSONArray arr = new JSONArray();
                JSONObject objVSAttr = new JSONObject();
                objVSAttr.put("objectID", (Object)"1");
                objVSAttr.put("attribs", (Object)AdvancedReportsUtil.selectCriteria((ArrayList)importAttribList.get(1), false));
                arr.put((Object)objVSAttr);
                ArrayList compAttribList = (ArrayList)importAttribList.get(3);
                objVSAttr = new JSONObject();
                objVSAttr.put("objectID", (Object)"3");
                objVSAttr.put("attribs", (Object)AdvancedReportsUtil.selectCriteria(compAttribList, true));
                arr.put((Object)objVSAttr);
                request.setAttribute("attributes", (Object)arr);
                this.logger.log(Level.FINE, "imported attribs::" + importAttribList);
            } else {
                ArrayList errors = csvObj.getErrorList();
                JSONArray statusJsonArray = new JSONArray();
                statusJsonArray.put(((Hashtable)errors.get(0)).get("ERROR"));
                csvErr.put("errorMsg", (Object)statusJsonArray);
                csvErr.put("extraInfo", ((Hashtable)errors.get(0)).get("SOLUTION"));
            }
            request.setAttribute("statusjson", (Object)csvErr);
            request.setAttribute("userCreationID", (Object)userCreationID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("csvResult");
    }

    public ActionForward getCSVResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String attr = request.getParameter("attribs");
            Long userCreationID = Long.parseLong(request.getParameter("userCreationID"));
            JSONArray attrs = new JSONArray(attr);
            ArrayList<String> prevLDAP = new ArrayList<String>();
            ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
            for (int i = 0; i < attrs.length(); ++i) {
                ArrayList<String> attrLDAP = new ArrayList<String>();
                JSONObject objAttr = (JSONObject)attrs.get(i);
                Integer objectId = Integer.parseInt(objAttr.getString("objectID"));
                JSONArray attribs = (JSONArray)objAttr.get("attribs");
                for (int j = 0; j < attribs.length(); ++j) {
                    String ldap = (String)attribs.get(j);
                    if (prevLDAP.contains(ldap)) continue;
                    attrLDAP.add(ldap);
                    prevLDAP.add(ldap);
                }
                AddUserHandler handler = AddUserHandler.getInstance();
                if (objectId == 3) {
                    handler = ComputerMgmtHandler.getInstance();
                }
                String[] attArr = new String[attrLDAP.size()];
                for (int j = 0; j < attrLDAP.size(); ++j) {
                    Hashtable hash = handler.getAttributeDetails("ATTRIB_LDAP_NAME", attrLDAP.get(j));
                    if (hash.isEmpty() || handler.isCustomAttribute((Integer)hash.get("ATTRIB_ID"))) continue;
                    attributeList.add(hash);
                }
            }
            String nav = request.getParameter("navJson");
            int start = -1;
            int range = 0;
            if (nav != null) {
                JSONObject navJson = new JSONObject(nav);
                start = navJson.getInt("start");
                range = navJson.getInt("range");
            }
            ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(userCreationID, attributeList, start, range, null);
            ArrayList<Long> indexList = new ArrayList<Long>();
            for (int i = 0; i < userDetailsList.size(); ++i) {
                Hashtable userAttributeDetails = (Hashtable)userDetailsList.get(i);
                Long id = (Long)userAttributeDetails.get("USER_INDEX");
                indexList.add(id);
            }
            Hashtable customTable = ImportCSVUtil.getCustomAttributes(indexList);
            HashSet<Object> headers = new HashSet<Object>();
            Hashtable<Long, Properties> valuesTable = new Hashtable<Long, Properties>();
            for (int i = 0; i < userDetailsList.size(); ++i) {
                Hashtable userDetails = (Hashtable)userDetailsList.get(i);
                Long index = (Long)userDetails.get("USER_INDEX");
                Properties properties = (Properties)valuesTable.get(index);
                if (properties == null) {
                    properties = new Properties();
                    valuesTable.put(index, properties);
                }
                ArrayList list = (ArrayList)userDetails.get("USER_VALUES");
                for (Hashtable hashtable : list) {
                    String columnName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                    Object value = hashtable.get("ATTRIB_VALUE");
                    String displayObject = value == null ? "-" : ClientUtil.htmlEscape(value.toString());
                    properties.setProperty(columnName, displayObject);
                    headers.add(columnName);
                }
                Properties prop = (Properties)customTable.get(index);
                if (prop == null || prop.isEmpty()) continue;
                Enumeration<Object> e = prop.keys();
                while (e.hasMoreElements()) {
                    headers.add(e.nextElement());
                }
                properties.putAll((Map<?, ?>)prop);
            }
            Long count = new Long(AddUserHandler.getInstance().getCount(userCreationID).intValue());
            this.logger.log(Level.INFO, "headerList:;" + headers);
            this.logger.log(Level.INFO, "valuesTable:;" + valuesTable);
            request.setAttribute("headers", headers);
            request.setAttribute("valuesTable", valuesTable);
            request.setAttribute("count", (Object)count);
            request.setAttribute("indexList", indexList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("csvResult");
    }

    public ActionForward mgmtAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block4: {
            PrintWriter writer = null;
            String forwardPage = "resultview";
            try {
                Integer reportId = Integer.parseInt(request.getParameter("reportId"));
                Integer mgmtReportId = Integer.parseInt(request.getParameter("mgmtReportId"));
                Long generationId = Long.parseLong(request.getParameter("generationID"));
                HttpSession session = request.getSession();
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                Long cvcDataModelId = Long.parseLong(request.getParameter("cvcDataId"));
                AdmpInput admpInput = null;
                if (request.getParameter("actionInput") != null) {
                    admpInput = new AdmpInput(new JSONObject(request.getParameter("actionInput")));
                } else {
                    admpInput = new AdmpInput();
                    admpInput.setName("mgmtmenuID");
                    admpInput.setValue(request.getParameter("mgmtmenuID"));
                }
                String domainName = request.getParameter("domainName");
                DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId);
                Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
                String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
                RVMgmtResultStatusUpdater statusUpdater = new RVMgmtResultStatusUpdater();
                statusUpdater.init(rvcDataObject);
                String hostId = request.getRemoteHost();
                ReportController.getInstance().mgmtAction(mgmtReportId, reportId, loginId, generationId, admpInput, domainName, (StatusUpdater)statusUpdater, hostId, rb);
                Row reportToViewMappingrow = rvcDataObject.getRow("ADSMReportToRVCDataMapping");
                Integer rvcDataId = (Integer)reportToViewMappingrow.get("RVC_ID");
                JSONObject rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)reportId, (Integer)rvcDataId, (Long)cvcDataModelId, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)loginId);
                rvcJsonObject.put("generationId", (Object)generationId);
                rvcJsonObject.put("isMultiDC", false);
                rvcJsonObject.put("mgmtAction", true);
                rvcJsonObject.put("isReportRunning", true);
                response.setContentType("application/json");
                writer = response.getWriter();
                writer.print(rvcJsonObject.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (writer == null) break block4;
                writer.close();
            }
        }
        return null;
    }

    public ActionForward stopMgmtAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Long generationId = Long.parseLong(request.getParameter("generationID"));
            ReportController.getInstance().stopReport(generationId);
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }
}

