/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports.advanced;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.cvc.CVCUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import com.adventnet.sym.adsm.common.webclient.util.ReportClientUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdvancedReportsUtil {
    private static String[] uniqueAttribs = new String[]{"sAmAccountName", "distinguishedName", "name"};
    private static String[] namingAttribs = new String[]{"givenName", "sn", "mailNickname", "displayName"};

    public static Row getGenerationProps(Long loginId, Long cvcDataId) {
        Row ret = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADMPReportsCVCData", (String)"CVC_DATA_ID"), (Object)cvcDataId, 0));
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMObjectGenerationDetails"));
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"*"));
            sq.addJoin(new Join("ADSMObjectGenerationDetails", "ADMPReportsCVCData", new String[]{"REPORT_GENERATION_ID"}, new String[]{"GENERATION_ID"}, 1));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                ret = dataObj.getFirstRow("ADSMObjectGenerationDetails");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Hashtable getReportDomains(ArrayList domains) {
        Hashtable<String, ReportDomain> reportDomains = new Hashtable<String, ReportDomain>();
        try {
            Hashtable dnDomainNameMap = (Hashtable)HDTDomainHandler.getDomainsAndOUs((Long)CommonUtil.ADMIN_LOGIN_ID).get("dnDomainNameMap");
            for (String container : domains) {
                String domName = (String)dnDomainNameMap.get(container);
                if (domName != null) {
                    ReportDomain domain;
                    if (reportDomains.get(domName) == null) {
                        domain = new ReportDomain();
                        domain.setDomainDetails(domName, CommonUtil.ADMIN_LOGIN_ID, 1);
                        domain.addContainer(container);
                        reportDomains.put(domName, domain);
                        continue;
                    }
                    domain = (ReportDomain)reportDomains.get(domName);
                    domain.addContainer(container);
                    continue;
                }
                System.out.println(" The - " + container + " - might have been moved manually");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportDomains;
    }

    public static Row getGenerationProps(Long generationId) {
        Row ret = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMObjectGenerationDetails"));
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"*"));
            sq.addJoin(new Join("ADSMObjectGenerationDetails", "ADMPReportsCVCData", new String[]{"REPORT_GENERATION_ID"}, new String[]{"GENERATION_ID"}, 1));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                ret = dataObj.getFirstRow("ADSMObjectGenerationDetails");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Long getGenerationId(String sessionId, Integer reportId) {
        Long generationId = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADMPReportsCVCData", (String)"SESSION_ID"), (Object)sessionId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADMPReportsCVCData", (String)"REPORT_ID"), (Object)reportId, 0));
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADMPReportsCVCData"));
            SortColumn sort = new SortColumn(Column.getColumn((String)"ADMPReportsCVCData", (String)"CREATED_TIME"), false);
            sq.addSortColumn(sort);
            sq.addSelectColumn(Column.getColumn((String)"ADMPReportsCVCData", (String)"*"));
            sq.setCriteria(crit);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getFirstRow("ADMPReportsCVCData");
                generationId = (Long)r.get("GENERATION_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return generationId;
    }

    public static Long getCVCDataId(Integer reportId, Long loginId, String sessionId) {
        Long cvcDataId = null;
        try {
            if (!LicenseMgr.getInstance().isFreeEdition() && (cvcDataId = AdvancedReportsUtil.getRecentCVCDataId(reportId, loginId, sessionId)) == null) {
                cvcDataId = AdvancedReportsUtil.getRecentCVCDataId(reportId, loginId, null);
            }
            if (cvcDataId == null) {
                cvcDataId = CVCUtil.getDefaultDataModelId((Integer)reportId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cvcDataId;
    }

    public static Long getRecentCVCDataId(Integer reportId, Long loginId, String sessionId) {
        DataObject dataObj = null;
        Long ret = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADMPReportsCVCData", (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADMPReportsCVCData", (String)"REPORT_ID"), (Object)reportId, 0));
            crit = sessionId != null ? crit.and(new Criteria(Column.getColumn((String)"ADMPReportsCVCData", (String)"SESSION_ID"), (Object)sessionId, 0)) : crit.and(new Criteria(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"STATUS"), (Object)ReportClientUtil.REPORT_RUN_STATUS_SUCCESS, 0));
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMObjectGenerationDetails"));
            sq.setCriteria(crit);
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"ADMPReportsCVCData", (String)"CREATED_TIME"), false));
            sq.addSelectColumn(Column.getColumn((String)"ADMPReportsCVCData", (String)"*"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_GENERATION_ID"));
            sq.addJoin(new Join("ADSMObjectGenerationDetails", "ADMPReportsCVCData", new String[]{"REPORT_GENERATION_ID"}, new String[]{"GENERATION_ID"}, 1));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getFirstRow("ADMPReportsCVCData");
                ret = (Long)row.get("CVC_DATA_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean isResultAvailableForGenerationId(Long generationId, Integer reportId) {
        try {
            DataObject reportDO = ReportHandler.getReportDetails((Integer)reportId);
            Row reportRow = reportDO.getFirstRow("ADSMReports");
            String resultTableName = (String)reportRow.get("RESULT_TABLE_NAME");
            return AdvancedReportsUtil.isResultAvailableForGenerationId(resultTableName, generationId, reportId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean isResultAvailableForGenerationId(String resultTableName, Long generationId, Integer reportId) {
        boolean isResultAvail = false;
        try {
            String colName = "OBJECT_GUID";
            Column countColumn = Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID");
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)resultTableName));
            query.addSelectColumn(countColumn.count());
            query.setCriteria(new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0));
            Integer count = DBUtil.getCount((SelectQuery)query);
            if (count > 0) {
                isResultAvail = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isResultAvail;
    }

    public static ArrayList fillObjectDetails(Vector headerVector, ArrayList<Vector> data, ArrayList<Hashtable> attributeList, ArrayList userDetailsList) {
        HashSet<String> importAttribList = new HashSet<String>();
        int j = 1;
        for (Vector vector : data) {
            try {
                Hashtable userDetails = userDetailsList.size() < j ? new Hashtable() : (Hashtable)userDetailsList.get(j - 1);
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < vector.size(); ++i) {
                    Object object = vector.get(i);
                    String headerObject = (String)headerVector.get(i);
                    for (Hashtable hashtable : attributeList) {
                        String ldapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                        Integer relationalType = (Integer)hashtable.get("RELATIONAL_TYPE");
                        if (relationalType == 1 || !ldapName.equalsIgnoreCase(headerObject)) continue;
                        userDetails.put(hashtable.get("ATTRIB_COLUMN_NAME"), object);
                        importAttribList.add(ldapName);
                    }
                }
                if (userDetails.size() > 0 && userDetailsList.size() < j) {
                    userDetailsList.add(userDetails);
                }
                ++j;
            }
            catch (Exception exception) {
                System.out.println("exception::" + exception);
                exception.printStackTrace();
            }
        }
        return new ArrayList(importAttribList);
    }

    public static void removeUnknownAttributes(Integer objectId, ArrayList ldapList) {
        try {
            ObjectClass objClass = DirectoryObjectAPI.getInstance().getObjectClass(objectId);
            Integer startRange = objClass.getStartRange();
            Integer endRange = objClass.getEndRange();
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)endRange, 6);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)startRange, 4));
            DataObject dataObject = CommonUtil.getCachedPersistence().get("ADSMAttributeDetails", (Criteria)null);
            for (int i = 0; i < ldapList.size(); ++i) {
                String ldapName = (String)ldapList.get(i);
                Iterator it = dataObject.getRows("ADSMAttributeDetails", criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"), (Object)ldapName, 0)));
                if (it.hasNext()) continue;
                ldapList.remove(ldapName);
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONArray selectCriteria(ArrayList ldapList, boolean selected) {
        JSONArray criteria = new JSONArray();
        try {
            for (int i = 0; i < ldapList.size(); ++i) {
                String ldap = (String)ldapList.get(i);
                JSONObject json = new JSONObject();
                json.put("attribname", (Object)ldap);
                criteria.put((Object)json);
                if (selected) continue;
                for (String attrib : uniqueAttribs) {
                    if (!attrib.equalsIgnoreCase(ldap)) continue;
                    json.put("checked", (Object)"checked");
                    selected = true;
                }
                for (String attrib : namingAttribs) {
                    if (!attrib.equalsIgnoreCase(ldap)) continue;
                    json.put("checked", (Object)"checked");
                    selected = true;
                }
            }
            if (!selected) {
                JSONObject json = criteria.getJSONObject(0);
                json.put("checked", (Object)"checked");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return criteria;
    }
}

