/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports.advanced;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.multidc.AbstractMultiDCTask;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCHandler;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCUtil;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.InputsUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.reports.advanced.AbstractAdvancedReportsListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class CSVReportsListener
extends AbstractAdvancedReportsListener {
    private Long loginId = null;
    private Integer reportId = null;
    private String noOfObjects = null;
    private Hashtable resultData = null;
    private String searchString = "";
    private DataObject cvcDO = null;
    private ArrayList multiDCAttributes = null;
    private ArrayList objectIds = null;
    private String keyColumn = "OBJECT_GUID";

    public CSVReportsListener(Integer reportId, Long loginId, AdventNetResourceBundle rb) {
        this.loginId = loginId;
        this.reportId = reportId;
        this.noOfObjects = LicenseMgr.getInstance().getLicenseProperty("ADReports", "NumberOfObjects");
        this.resultData = new Hashtable();
        this.rb = rb;
    }

    @Override
    public void startNative(String dcName, NativeListener listener, boolean isFirstDC) {
        try {
            reportLogger.log(Level.INFO, "MDC search string::" + this.searchString);
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
            for (int index = 0; index < this.authOUList.size(); ++index) {
                String dn = (String)this.authOUList.get(index);
                ADHandler.getSearchObjects((Properties)domainDetails, (String)dn, (String)dcName, (String)this.searchString, (ArrayList)MultiDCUtil.getNativeAttributes((ArrayList)this.multiDCAttributes), (NativeListener)listener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAttributeDetails() {
        try {
            this.attributeProps = new Hashtable();
            ArrayList objectIds = CVCDataUtil.getObjectIds((DataObject)this.cvcDO);
            for (int i = 0; i < objectIds.size(); ++i) {
                Integer objectId = (Integer)objectIds.get(i);
                ArrayList list = ReportAttributesUtil.getAttributeDetailsList((int)this.reportId, (Integer)objectId, (Long)this.loginId);
                this.attributeProps.put(objectId, list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList loadAttributeList() {
        ArrayList<Object> ret = new ArrayList<Object>();
        try {
            ArrayList objectIds = CVCDataUtil.getObjectIds((DataObject)this.cvcDO);
            for (int i = 0; i < objectIds.size(); ++i) {
                Integer objectId = (Integer)objectIds.get(i);
                ArrayList list = (ArrayList)this.attributeProps.get(objectId);
                for (int j = 0; j < list.size(); ++j) {
                    Properties p = (Properties)list.get(j);
                    if (ret.contains(p.get("ATTRIB_LDAP_NAME"))) continue;
                    ret.add(p.get("ATTRIB_LDAP_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private ArrayList loadAttributeDetailsList() {
        ArrayList ret = new ArrayList();
        try {
            ArrayList objectIds = CVCDataUtil.getObjectIds((DataObject)this.cvcDO);
            for (int i = 0; i < objectIds.size(); ++i) {
                Integer objectId = (Integer)objectIds.get(i);
                ArrayList list = (ArrayList)this.attributeProps.get(objectId);
                ret.addAll(list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private Hashtable getTableColumns() {
        Hashtable ret = new Hashtable();
        try {
            ArrayList objectIds = CVCDataUtil.getObjectIds((DataObject)this.cvcDO);
            String keyColumn = "OBJECT_GUID";
            for (int i = 0; i < objectIds.size(); ++i) {
                Integer objectId = (Integer)objectIds.get(i);
                ArrayList list = (ArrayList)this.attributeProps.get(objectId);
                for (int j = 0; j < list.size(); ++j) {
                    Properties p = (Properties)list.get(j);
                    String tableName = p.getProperty("TABLE_NAME");
                    String column = p.getProperty("ATTRIB_COLUMN_NAME");
                    String ldap = p.getProperty("ATTRIB_LDAP_NAME");
                    if (MultiDCUtil.isSupportedAttribute((String)ldap, (String)column)) continue;
                    ArrayList<String> columns = (ArrayList<String>)ret.get(tableName);
                    if (columns == null) {
                        columns = new ArrayList<String>();
                        ret.put(tableName, columns);
                    }
                    if (columns.contains(column)) continue;
                    columns.add(column);
                }
            }
            Enumeration e = ret.keys();
            while (e.hasMoreElements()) {
                String tableName = (String)e.nextElement();
                ArrayList columns = (ArrayList)ret.get(tableName);
                if (columns.contains(keyColumn)) continue;
                columns.add(keyColumn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void initialize() {
        this.loadAttributeDetails();
    }

    @Override
    public void start(DataObject cvcDO, StatusUpdater status) {
        if (!this.isCompleted.booleanValue()) {
            return;
        }
        this.statusController = status;
        this.continueAction = true;
        this.isCompleted = false;
        this.cvcDO = cvcDO;
        this.initialize();
        this.statusController.setIsCompleted(false);
        Action baseThread = new Action(this.loginId, cvcDO, this.statusController, (NativeListener)this, (AbstractMultiDCTask)this);
        baseThread.start();
    }

    private void waitForMultiDCCompletion() {
        try {
            boolean multiDCValues = MultiDCHandler.getInstance().isCompleted(this.queueRegID);
            while (!multiDCValues) {
                this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_MEMBERS_FROM_ALL_DCS.getValue());
                Thread.sleep(100L);
                multiDCValues = MultiDCHandler.getInstance().isCompleted(this.queueRegID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Action
    extends Thread {
        private Long loginId = null;
        private NativeListener listener = null;
        private StatusUpdater statusController = null;
        private AbstractMultiDCTask task = null;

        public Action(Long loginId, DataObject cvcDO, StatusUpdater statusController, NativeListener listener, AbstractMultiDCTask task) {
            this.loginId = loginId;
            this.listener = listener;
            this.statusController = statusController;
            this.task = task;
        }

        @Override
        public void run() {
            try {
                ArrayList domainsList = InputsUtil.getDomainList((DataObject)CSVReportsListener.this.cvcDO);
                ArrayList objectsList = InputsUtil.getObjectsList((DataObject)CSVReportsListener.this.cvcDO);
                ArrayList objectIdList = CVCDataUtil.getObjectIds((DataObject)CSVReportsListener.this.cvcDO);
                ArrayList<String> conditionAttribs = new ArrayList<String>();
                String userString = "";
                String compString = "";
                for (int i = 0; i < objectIdList.size(); ++i) {
                    Integer objID = (Integer)objectIdList.get(i);
                    String searchString = "";
                    String notEQSearchString = "";
                    Hashtable attribVsFilter = InputsUtil.getAttribVsFilterType((DataObject)CSVReportsListener.this.cvcDO, (Integer)objID);
                    AbstractAdvancedReportsListener.reportLogger.log(Level.FINE, "attribVsFilter::" + attribVsFilter);
                    Hashtable valuesTable = InputsUtil.getImportResult((DataObject)CSVReportsListener.this.cvcDO, (Integer)objID);
                    AbstractAdvancedReportsListener.reportLogger.log(Level.FINE, "import values::" + valuesTable);
                    Enumeration e = valuesTable.keys();
                    while (e.hasMoreElements()) {
                        Long index = (Long)e.nextElement();
                        Properties userValues = (Properties)valuesTable.get(index);
                        Enumeration<Object> e1 = userValues.keys();
                        while (e1.hasMoreElements()) {
                            String attributeName = (String)e1.nextElement();
                            if (!attribVsFilter.containsKey(attributeName)) continue;
                            Integer criteriaID = (Integer)attribVsFilter.get(attributeName);
                            String attributeValue = userValues.getProperty(attributeName);
                            boolean emptyValue = false;
                            if (attributeValue == null) continue;
                            if ((attributeValue = CommonUtil.escapeSpecialCharacters((String)attributeValue)).equals("")) {
                                attributeValue = "*";
                                emptyValue = true;
                            }
                            if (criteriaID == 1) {
                                searchString = emptyValue ? searchString + "(!(" + attributeName + "=" + attributeValue + "))" : searchString + "(" + attributeName + "=" + attributeValue + ")";
                            } else if (criteriaID == 3) {
                                notEQSearchString = emptyValue ? notEQSearchString + "(" + attributeName + "=" + attributeValue + ")" : notEQSearchString + "(!(" + attributeName + "=" + attributeValue + "))";
                            }
                            if (conditionAttribs.contains(attributeName)) continue;
                            conditionAttribs.add(attributeName);
                        }
                    }
                    if (objID == 1) {
                        if (!searchString.equals("")) {
                            userString = userString + "(|" + searchString + ")";
                        }
                        if (notEQSearchString.equals("")) continue;
                        userString = userString + "(&" + notEQSearchString + ")";
                        continue;
                    }
                    if (objID != 3) continue;
                    if (!searchString.equals("")) {
                        compString = compString + "(|" + searchString + ")";
                    }
                    if (notEQSearchString.equals("")) continue;
                    compString = compString + "(&" + notEQSearchString + ")";
                }
                if (!userString.equals("")) {
                    userString = "(&(objectClass=user)(objectCategory=user)(!(sAMAccountType=805306370))" + userString + ")";
                }
                if (!compString.equals("")) {
                    compString = "(&(objectClass=computer)(|" + compString + "))";
                }
                if (userString.equals("") && compString.equals("")) {
                    AbstractAdvancedReportsListener.reportLogger.log(Level.INFO, "Search string empty, returning!!!!");
                    return;
                }
                CSVReportsListener.this.searchString = "(|" + userString + compString + ")";
                AbstractAdvancedReportsListener.reportLogger.log(Level.INFO, "CSV report searchString  : : " + CSVReportsListener.this.searchString);
                ArrayList attributeList = MultiDCUtil.getNonMultiDCAttributes((ArrayList)CSVReportsListener.this.loadAttributeList());
                ReportAttributesUtil.addGroupDependencyAttribs((ArrayList)attributeList);
                Hashtable tableColumns = CSVReportsListener.this.getTableColumns();
                this.initializeQueues(objectsList);
                CSVReportsListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(CSVReportsListener.this.objectIds, tableColumns);
                CSVReportsListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate("ADSMUserReportResult");
                for (int i = 0; i < domainsList.size(); ++i) {
                    String domainDn = (String)domainsList.get(i);
                    CSVReportsListener.this.domainName = DomainUtil.getDomainName((String)domainDn);
                    CSVReportsListener.this.loadDomainProps();
                    CSVReportsListener.this.authOUList = HelpdeskUtil.getOUList((String)CSVReportsListener.this.domainName, (Long)this.loginId);
                    if (!CSVReportsListener.this.authOUList.isEmpty()) continue;
                    CSVReportsListener.this.authOUList.add(domainDn);
                }
                CSVReportsListener.this.multiDCAttributes = MultiDCUtil.getMultiDCAttribs((ArrayList)CSVReportsListener.this.loadAttributeDetailsList());
                if (CSVReportsListener.this.multiDCAttributes.size() > 0) {
                    CSVReportsListener.this.isMultiDC = true;
                    MultiDCHandler.getInstance().execute(CSVReportsListener.this.queueRegID, CSVReportsListener.this.multiDCAttributes, CSVReportsListener.this.objectIds, CSVReportsListener.this.domainName, this.loginId, this.task);
                }
                this.statusController.setProgressTask(6);
                for (int index = 0; index < CSVReportsListener.this.authOUList.size(); ++index) {
                    String dn = (String)CSVReportsListener.this.authOUList.get(index);
                    ADHandler.getObjects((String)CSVReportsListener.this.domainName, (Long)this.loginId, (String)dn, (ArrayList)attributeList, (String)CSVReportsListener.this.searchString, (NativeListener)this.listener);
                }
                if (CSVReportsListener.this.isMultiDC) {
                    CSVReportsListener.this.waitForMultiDCCompletion();
                }
                ReportHandler.updateReportGenerationDetails((Long)CSVReportsListener.this.generationId, (int)1, (String)"", (Long)this.loginId);
                CSVReportsListener.this.completedAction();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void initializeQueues(ArrayList objectsList) {
            try {
                CSVReportsListener.this.objectIds = new ArrayList();
                for (int i = 0; i < objectsList.size(); ++i) {
                    String objClass = (String)objectsList.get(i);
                    ObjectClass objDetails = DirectoryObjectAPI.getInstance().getObjectClass(objClass);
                    CSVReportsListener.this.objectIds.add(objDetails.getId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

