/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.reports.customreport;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.adsync.ADSyncUtil;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCHandler;
import com.adventnet.sym.adsm.common.server.multidc.MultiDCUtil;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.DBStringTransformerUtil;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportListener;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.reports.customreport.CustomReportUtil;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomReportListener
implements ReportListener {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    public AdventNetResourceBundle rb = null;
    protected Long loginId = null;
    protected Integer reportId = null;
    protected Long generationId = null;
    protected boolean isCompleted = true;
    protected boolean continueAction = true;
    protected StatusUpdater statusController = null;
    protected Long queueRegID = null;
    protected Long resultRegID = null;
    protected ArrayList objectIds = null;
    private boolean isMultidc = false;
    private boolean isMultiDCAttribExists = false;
    protected String noOfObjects = LicenseMgr.getInstance().getLicenseProperty("ADReports", "NumberOfObjects");
    protected int totalCount = 0;
    protected int updateCount = 0;
    protected boolean isSyncEnabled = false;
    protected Hashtable reportDetails = null;
    protected Hashtable resultData = new Hashtable();
    protected Hashtable attributeProps = null;
    protected Hashtable multiDCAttribsInFilters = null;
    protected ArrayList domains = null;
    protected Hashtable ouSelectedDomains = null;
    protected ArrayList containerList = null;
    protected Hashtable excludeContainerHash = null;
    protected Hashtable dnDomainNameMap = null;
    protected boolean isExcludeChildOU = false;
    protected String domainName = null;
    protected String dcName = null;
    private Hashtable dbProps = null;
    private Hashtable addlResultIps = new Hashtable();
    public String errorMessage = "";
    public ArrayList guidList = null;
    protected Hashtable errorList = null;

    public CustomReportListener() {
        this.ouSelectedDomains = new Hashtable();
        this.containerList = new ArrayList();
        this.excludeContainerHash = new Hashtable();
        this.dnDomainNameMap = new Hashtable();
        this.multiDCAttribsInFilters = new Hashtable();
        this.guidList = new ArrayList();
        this.errorList = new Hashtable();
    }

    public String getObjClass(Properties prop) {
        ArrayList values = (ArrayList)prop.get("objectClass");
        return (String)values.get(values.size() - 1);
    }

    public String getGuid(Properties prop, Integer nativeKey) {
        ArrayList guids = (ArrayList)prop.get(nativeKey);
        if (guids == null) {
            return null;
        }
        String guid = (String)guids.get(0);
        return guid;
    }

    public void addRow(Properties prop) {
        reportLogger.log(Level.INFO, "RESULT FROM NATIVE : " + prop);
        try {
            if (this.noOfObjects == null || this.reportId == null) {
                this.continueAction = false;
                reportLogger.log(Level.INFO, "Number Of Objects exceeded beyond the License Limit");
                return;
            }
            if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
                try {
                    int licensedCount = Integer.parseInt(this.noOfObjects);
                    if (this.reportId < 100 && this.totalCount >= licensedCount || this.totalCount >= licensedCount && licensedCount == 100) {
                        this.continueAction = false;
                        reportLogger.log(Level.INFO, "Number Of Objects exceeded beyond the License Limit");
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++this.totalCount;
            String objectClass = this.getObjClass(prop);
            ObjectClass object = DirectoryObjectAPI.getInstance().getObjectClass(objectClass);
            ArrayList objAttribList = object.getNativeMandatoryAttributes();
            Integer objId = object.getId();
            Properties dbProp = new Properties();
            Hashtable tableStringMap = DBStringTransformerUtil.getReportRows((Properties)prop, (ArrayList)((ArrayList)this.attributeProps.get(object.getId())), (String)this.domainName, (Properties)dbProp, (Hashtable)this.dbProps, (AdventNetResourceBundle)this.rb);
            String guid = this.getGuid(dbProp, (Integer)objAttribList.get(0));
            if (guid == null) {
                return;
            }
            if (!this.guidList.contains(guid)) {
                this.guidList.add(guid);
                this.statusController.updateStatus(dbProp, objectClass, guid);
            }
            QueueHandler.getInstance().getQueue(object.getId()).updateData(this.queueRegID, tableStringMap);
            ResultDataHandler.getInstance().getProcessor().updateData(this.resultRegID, ResultDataUtil.getDBString((String)"ADSMCustomReportResult", (Long)this.generationId, (String)guid, (Hashtable)this.addlResultIps));
            ++this.updateCount;
            if (this.isMultiDCAttribExists) {
                this.updateMultiDCStatus(this.domainName, this.dcName, null, this.updateCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopReport() {
        this.continueAction = false;
        while (!this.isCompleted) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isCompleted() {
        return !this.continueAction;
    }

    public boolean isExcludeChildOU() {
        return this.isExcludeChildOU;
    }

    public void setIsExcludeChildOU(Boolean isExcludeChildOU) {
        this.isExcludeChildOU = isExcludeChildOU;
    }

    public void setNativeError(String domainName, Hashtable errorHash) {
    }

    public void setNativeError(String domainName, String dCName, Hashtable errorHash) {
    }

    private void loadDomainProps() {
        try {
            this.dbProps = new Hashtable();
            Properties props = PolicyHandler.getPolicies((String)this.domainName, (Long)1L);
            String maxPwdAge = props.getProperty("maxPwdAge");
            this.dbProps.put("maxPwdAge", maxPwdAge);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadAttributeDetails() {
        try {
            this.attributeProps = new Hashtable();
            Hashtable objVsAttribIds = (Hashtable)this.reportDetails.get("objVsAttribIds");
            Enumeration e = objVsAttribIds.keys();
            while (e.hasMoreElements()) {
                Integer objectId = (Integer)e.nextElement();
                ArrayList attributeIds = ReportAttributesUtil.getAttributeIds((Hashtable)this.reportDetails, (Integer)objectId);
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMAttributeDetails"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"*"));
                sq.setCriteria(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attributeIds.toArray(), 8));
                SortColumn sortcolumn = new SortColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), true);
                sq.addSortColumn(sortcolumn);
                DataObject attributeDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                Iterator it = attributeDO.getRows("ADSMAttributeDetails");
                ArrayList<Hashtable> list = new ArrayList<Hashtable>();
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String ldapName = (String)r.get("ATTRIB_LDAP_NAME");
                    if (ldapName.equalsIgnoreCase("member")) {
                        this.isSyncEnabled = true;
                        continue;
                    }
                    list.add(MultiDCUtil.getProps((Row)r));
                }
                this.attributeProps.put(objectId, list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadDomains(HttpServletRequest request) {
        this.domains = new ArrayList();
        try {
            Hashtable domainOUList = new Hashtable();
            Hashtable<String, Boolean> excludeChildOUHash = new Hashtable<String, Boolean>();
            Hashtable excludedOUHash = new Hashtable();
            JSONObject domainData = new JSONObject(request.getParameter("domains"));
            JSONArray selectedDomains = domainData.getJSONArray("selectedDomains");
            JSONObject domainVsExcludeChildOU = domainData.getJSONObject("domainVsExcludeChildOU");
            JSONObject domainVsOUList = domainData.getJSONObject("domainVsOUList");
            JSONObject domainVsExcludeOUList = domainData.getJSONObject("domainVsExcludeOUList");
            for (int i = 0; selectedDomains != null && i < selectedDomains.length(); ++i) {
                String domainName = (String)selectedDomains.get(i);
                String domainDN = DomainUtil.getDefaultNamingContext((String)domainName);
                this.domains.add(domainName);
                excludeChildOUHash.put(domainName, (Boolean)domainVsExcludeChildOU.get(domainDN));
                ArrayList<String> ouList = new ArrayList<String>();
                JSONArray ous = domainVsOUList.getJSONArray(domainDN);
                for (int j = 0; j < ous.length(); ++j) {
                    JSONObject ouProp = (JSONObject)ous.get(j);
                    ouList.add((String)ouProp.get("ouDN"));
                }
                domainOUList.put(domainName, ouList);
                ArrayList<String> excludeOuList = new ArrayList<String>();
                ous = domainVsExcludeOUList.getJSONArray(domainDN);
                for (int j = 0; j < ous.length(); ++j) {
                    JSONObject ouProp = (JSONObject)ous.get(j);
                    excludeOuList.add((String)ouProp.get("ouDN"));
                }
                excludedOUHash.put(domainName, excludeOuList);
            }
            this.containerList = ListenerUtil.getContainerList(request, this.domains, domainOUList, excludeChildOUHash, excludedOUHash, this.ouSelectedDomains);
            this.excludeContainerHash = ListenerUtil.constructExcludeContainerHash(this.containerList, excludeChildOUHash, excludedOUHash, this.dnDomainNameMap);
            ListenerUtil.fillDomainDetails(this.generationId, this.domains, domainOUList, excludeChildOUHash, excludedOUHash);
            if (this.containerList.isEmpty()) {
                this.setErrorMessage(this.rb.getString("admp.reports.custom_reports.custom_report.configured_ous_are_not_delegated"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Hashtable getReportDomains(Long loginId, ArrayList containerList, Hashtable dnDomainNameMap) {
        Hashtable<String, ReportDomain> reportDomain = new Hashtable<String, ReportDomain>();
        for (int i = 0; i < containerList.size(); ++i) {
            String container = (String)containerList.get(i);
            String domName = (String)dnDomainNameMap.get(container);
            if (domName != null) {
                ReportDomain domain;
                if (reportDomain.get(domName) == null) {
                    domain = new ReportDomain();
                    domain.setDomainDetails(domName, loginId, 1);
                    domain.addContainer(container);
                    reportDomain.put(domName, domain);
                    continue;
                }
                domain = (ReportDomain)reportDomain.get(domName);
                domain.addContainer(container);
                continue;
            }
            System.out.println(" The - " + container + " - might have been moved manually");
        }
        return reportDomain;
    }

    private ArrayList getMultiDCAttributeProps(Hashtable reportDetails) {
        this.isMultidc = false;
        ArrayList multiDCAttributes = MultiDCUtil.getMultiDCAttributeProps((Hashtable)reportDetails, (Hashtable)this.multiDCAttribsInFilters);
        if (multiDCAttributes.size() > 0) {
            this.isMultidc = true;
        }
        return multiDCAttributes;
    }

    public boolean multiDCAttribExistsInFilters(Hashtable reportDetails) {
        boolean isMultiDCAttribExists = false;
        Hashtable filterDetails = (Hashtable)reportDetails.get("filterDetails");
        Enumeration e = filterDetails.keys();
        while (e.hasMoreElements()) {
            Integer objectId = (Integer)e.nextElement();
            ArrayList filters = (ArrayList)filterDetails.get(objectId);
            ArrayList<Integer> multiDCAttribs = new ArrayList<Integer>();
            for (int i = 0; i < filters.size(); ++i) {
                Hashtable filter = (Hashtable)filters.get(i);
                Integer columnId = (Integer)filter.get("columnId");
                if (CustomReportUtil.multiDCAttribIds.contains(columnId)) {
                    isMultiDCAttribExists = true;
                }
                multiDCAttribs.add(columnId);
            }
            this.multiDCAttribsInFilters.put(objectId, multiDCAttribs);
        }
        return isMultiDCAttribExists;
    }

    public void start(Integer reportId, StatusUpdater statusUpdater, HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            this.dnDomainNameMap = (Hashtable)authObject.getDomainAndOUs().get("dnDomainNameMap");
            this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.reportId = reportId;
            this.statusController = statusUpdater;
            this.rb = ResourceBundleMgr.getInstance().getBundle(request);
            this.continueAction = true;
            this.isCompleted = false;
            this.reportDetails = CustomReportUtil.getReportDetails((Integer)this.reportId);
            this.loadDomains(request);
            this.loadAttributeDetails();
            this.statusController.setIsCompleted(false);
            this.isMultiDCAttribExists = this.multiDCAttribExistsInFilters(this.reportDetails);
            Hashtable reportDomains = new Hashtable();
            if (this.isMultiDCAttribExists) {
                reportDomains = this.getReportDomains(this.loginId, this.containerList, this.dnDomainNameMap);
                this.statusController.init(reportDomains);
                this.statusController.setProgressTask(StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue());
            }
            Action action = new Action(this.loginId, this.domains, reportDomains, this.containerList, this.reportDetails, this, this.dnDomainNameMap, this.excludeContainerHash, this.isSyncEnabled, this.isMultiDCAttribExists);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateStatus(String dcName) {
        if (this.statusController != null) {
            this.statusController.setTaskObject((Object)dcName);
        }
        this.updateMultiDCStatus(this.domainName, dcName, "dc-loading.gif", null);
    }

    public void updateCompletionStatus() {
        this.updateMultiDCStatus(this.domainName, this.dcName, "icn-dc-success", this.updateCount);
    }

    public void updateErrorStatus(Hashtable errors) {
        if (this.statusController != null) {
            this.statusController.updateErrorStatus(errors);
        }
    }

    public void updateMultiDCStatus(String domainName, String dcName, String imageName, Integer count) {
        if (this.statusController != null) {
            JSONObject multiDCDetails = this.statusController.getMultiDCDetails();
            try {
                JSONObject domainNameVsDCProps = multiDCDetails.getJSONObject(domainName);
                JSONObject dcProperies = domainNameVsDCProps.getJSONObject(dcName);
                if (imageName != null) {
                    dcProperies.put("image", (Object)imageName);
                }
                if (count != null) {
                    dcProperies.put("count", (Object)count);
                }
            }
            catch (JSONException jsonEx) {
                System.out.println("JSONException multiDCDetails " + multiDCDetails + " dcName " + dcName + " domainName :: " + domainName);
                jsonEx.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void waitForCompletion() {
        QueueHandler.getInstance().postNativeData(this.queueRegID);
        ResultDataHandler.getInstance().getProcessor().postNativeData(this.resultRegID, true);
        QueueHandler.getInstance().deRegister(this.queueRegID);
        ResultDataHandler.getInstance().getProcessor().deRegister(this.resultRegID);
    }

    private void updateResult() {
        Long resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate("ADSMCustomReportResult");
        Enumeration e = this.resultData.keys();
        while (e.hasMoreElements()) {
            String guid = (String)e.nextElement();
            Hashtable resultProps = (Hashtable)this.resultData.get(guid);
            Hashtable addlResultIps = new Hashtable();
            ResultDataHandler.getInstance().getProcessor().updateData(resultRegID, ResultDataUtil.getDBString((String)"ADSMCustomReportResult", (Long)this.generationId, (String)guid, addlResultIps));
        }
        ResultDataHandler.getInstance().getProcessor().postNativeData(resultRegID, true);
        ResultDataHandler.getInstance().getProcessor().deRegister(resultRegID);
    }

    private String getDescription() {
        String desc = "";
        try {
            DataObject reportDO = ReportHandler.getReportDetails((Integer)this.reportId);
            Row row = reportDO.getFirstRow("ADSMReports");
            if (row.get("DESCRIPTION") != null) {
                desc = this.rb.getString((String)row.get("DESCRIPTION"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (desc.equalsIgnoreCase("")) {
            for (int i = 0; i < this.domains.size(); ++i) {
                if (i != 0) {
                    desc = desc + ", ";
                }
                desc = desc + (String)this.domains.get(i);
            }
            desc = MessageFormat.format(this.rb.getString("admp.reports.common.text.report_generated_for_the_domains"), desc);
        }
        return desc;
    }

    public void setErrorMessage(String error) {
        this.errorMessage = error;
    }

    protected void processMultiDCActions() {
        try {
            boolean multiDCValues = MultiDCHandler.getInstance().isCompleted(this.queueRegID);
            while (!multiDCValues && !this.isCompleted) {
                Thread.sleep(100L);
                multiDCValues = MultiDCHandler.getInstance().isCompleted(this.queueRegID);
            }
            MultiDCHandler.getInstance().finishProcess(this.queueRegID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void completedAction() {
        this.waitForCompletion();
        ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.getDescription(), (Long)this.loginId);
        this.isCompleted = true;
        this.statusController.setIsCompleted(this.isCompleted);
        this.updateCount = 0;
        this.totalCount = 0;
    }

    public void setGenerationId(Long genId) {
        this.generationId = genId;
    }

    public Long getGenerationId() {
        return this.generationId;
    }

    public StatusUpdater getStatusController() {
        return this.statusController;
    }

    public String getErrorMessageKeys() {
        return "";
    }

    public void setErrorMessageKeys(String error) {
    }

    public ArrayList getObjectIds() {
        return new ArrayList();
    }

    public void start(ReportFilterConfig reportFilterConfig, String domainName, String distinguishedName, StatusUpdater statusController) {
    }

    public void start(DataObject cvcDO, StatusUpdater status) {
    }

    public void startNative(String dcName, NativeListener listener, boolean isFirstDC) {
    }

    public void modifyAction(Long mgmtReportId, Long reportId, Long generationId, AdmpInput admpInput) {
    }

    public void setStatusController(StatusUpdater statusController) {
        this.statusController = statusController;
    }

    public void modifyAction(Integer mgmtReportId, Integer reportId, Long generationId, AdmpInput admpInput, String domainName, Long loginID, String hostId, AdventNetResourceBundle rb) {
    }

    public class Action
    extends Thread {
        private Long loginId = null;
        private ArrayList domains = null;
        private Hashtable reportDetails = null;
        protected CustomReportListener listener = null;
        private boolean isSyncEnabled = false;
        private Hashtable dnDomainNameMap = null;
        private Hashtable excludeContainerHash = null;
        private ArrayList containerList = null;
        private Hashtable reportDomains = null;
        private boolean isMultiDCAttribExists = false;

        public Action(Long loginId, ArrayList domains, Hashtable reportDomains, ArrayList containerList, Hashtable reportDetails, CustomReportListener listener, Hashtable dnDomainNameMap, Hashtable excludeContainerHash, boolean isSyncEnabled, boolean isMultiDCAttribExists) {
            this.loginId = loginId;
            this.domains = domains;
            this.reportDetails = reportDetails;
            this.listener = listener;
            this.isSyncEnabled = isSyncEnabled;
            this.dnDomainNameMap = dnDomainNameMap;
            this.excludeContainerHash = excludeContainerHash;
            this.containerList = containerList;
            this.reportDomains = reportDomains;
            this.isMultiDCAttribExists = isMultiDCAttribExists;
        }

        @Override
        public void run() {
            try {
                CustomReportListener.this.objectIds = (ArrayList)this.reportDetails.get("objectIds");
                ArrayList attributeList = MultiDCUtil.getNonMultiDCAttributes(null, (Hashtable)this.reportDetails);
                CustomReportListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate((ArrayList)this.reportDetails.get("objectIds"), MultiDCUtil.getNonMultiDCTableColumns((Hashtable)this.reportDetails));
                CustomReportListener.this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate("ADSMCustomReportResult");
                String searchString = CustomReportUtil.getSearchString((Hashtable)this.reportDetails, (ArrayList)this.domains, (Long)this.loginId, (AdventNetResourceBundle)CustomReportListener.this.rb);
                ArrayList multiDCAttributes = CustomReportListener.this.getMultiDCAttributeProps(this.reportDetails);
                if (CustomReportListener.this.isMultidc) {
                    MultiDCHandler.getInstance().execute(CustomReportListener.this.queueRegID, this.loginId, this.containerList, this.dnDomainNameMap, multiDCAttributes, searchString, CustomReportListener.this.objectIds, this.excludeContainerHash);
                    MultiDCHandler.getInstance().setRemoveGuids(CustomReportListener.this.queueRegID, false);
                }
                String key = "";
                Hashtable<String, String> domainKey = new Hashtable<String, String>();
                if (this.isSyncEnabled) {
                    attributeList = ADSyncUtil.getNonSyncAttributes((ArrayList)attributeList);
                    for (int i = 0; i < this.domains.size(); ++i) {
                        key = DomainHandler.doReportSync((String)((String)this.domains.get(i)), (Long)1L, (String[])new String[]{"user", "group", "computer", "contact", "groupMember", "primaryGroup"});
                        domainKey.put(key, (String)this.domains.get(i));
                    }
                }
                String errStr = null;
                if (this.isMultiDCAttribExists) {
                    String searchStringForMultiDC = CustomReportUtil.getSearchString((Hashtable)this.reportDetails, (ArrayList)this.domains, (Long)this.loginId, (AdventNetResourceBundle)CustomReportListener.this.rb, (boolean)this.isMultiDCAttribExists);
                    Enumeration e = this.reportDomains.keys();
                    while (e.hasMoreElements()) {
                        try {
                            CustomReportListener.this.domainName = (String)e.nextElement();
                            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)CustomReportListener.this.domainName, (Long)this.loginId);
                            ReportDomain reportDomain = (ReportDomain)this.reportDomains.get(CustomReportListener.this.domainName);
                            this.containerList = reportDomain.getContainerList();
                            for (int i = 0; i < this.containerList.size(); ++i) {
                                String dn = (String)this.containerList.get(i);
                                Boolean isExcludeChildOU = Boolean.FALSE;
                                if (this.excludeContainerHash != null && this.excludeContainerHash.containsKey(dn)) {
                                    isExcludeChildOU = (Boolean)this.excludeContainerHash.get(dn);
                                }
                                this.listener.setIsExcludeChildOU(isExcludeChildOU);
                                ArrayList dcList = reportDomain.getDCList();
                                boolean error = true;
                                String ldapQuery = searchString;
                                for (int j = 0; j < dcList.size(); ++j) {
                                    Hashtable hash = (Hashtable)dcList.get(j);
                                    Integer status = (Integer)hash.get("status");
                                    CustomReportListener.this.dcName = (String)hash.get("dcName");
                                    if (status == 0) {
                                        Hashtable<String, String> errors;
                                        try {
                                            CustomReportListener.this.updateStatus(CustomReportListener.this.dcName);
                                            ADHandler.getSearchObjects((Properties)domainDetails, (String)dn, (String)CustomReportListener.this.dcName, (String)ldapQuery, (ArrayList)attributeList, (NativeListener)this.listener);
                                            error = false;
                                            CustomReportListener.this.updateCompletionStatus();
                                        }
                                        catch (LocalizedException exc) {
                                            exc.printStackTrace();
                                            errStr = CustomReportListener.this.rb.getString("client.reports.RealLastLogonListener.error_while_getting_the_reports_from_the_domain") + " " + CustomReportListener.this.domainName + ". " + exc.getMessage(CustomReportListener.this.rb);
                                            errors = new Hashtable();
                                            errors.put("INPUT_NAME", CustomReportListener.this.dcName);
                                            errors.put("ERROR_MESSAGE", errStr);
                                            CustomReportListener.this.errorList.put(CustomReportListener.this.dcName, errors);
                                            CustomReportListener.this.updateErrorStatus(errors);
                                            CustomReportListener.this.updateMultiDCStatus(CustomReportListener.this.domainName, CustomReportListener.this.dcName, "icn-dc-error", null);
                                        }
                                        catch (Exception ex) {
                                            ex.printStackTrace();
                                            errStr = CustomReportListener.this.rb.getString("client.reports.RealLastLogonListener.error_while_getting_the_reports_from_the_domain") + " " + CustomReportListener.this.domainName + ". " + ex.getMessage();
                                            errors = new Hashtable<String, String>();
                                            errors.put("INPUT_NAME", CustomReportListener.this.dcName);
                                            errors.put("ERROR_MESSAGE", errStr);
                                            CustomReportListener.this.errorList.put(CustomReportListener.this.dcName, errors);
                                            CustomReportListener.this.updateErrorStatus(errors);
                                            CustomReportListener.this.updateMultiDCStatus(CustomReportListener.this.domainName, CustomReportListener.this.dcName, "icn-dc-error", null);
                                        }
                                        status = new Integer(1);
                                        CustomReportListener.this.updateCount = 0;
                                        if (!error) {
                                            ldapQuery = searchStringForMultiDC;
                                        }
                                    }
                                    if (error && error && errStr.contains("8007203a")) continue;
                                }
                                if (!error) continue;
                                CustomReportListener.this.errorMessage = errStr;
                            }
                        }
                        catch (Exception exp) {
                            exp.printStackTrace();
                        }
                    }
                } else {
                    for (int i = 0; i < this.containerList.size(); ++i) {
                        Hashtable<String, String> errors;
                        try {
                            String dn = (String)this.containerList.get(i);
                            CustomReportListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                            CustomReportListener.this.loadDomainProps();
                            Boolean isExcludeChildOU = Boolean.FALSE;
                            if (this.excludeContainerHash != null && this.excludeContainerHash.containsKey(dn)) {
                                isExcludeChildOU = (Boolean)this.excludeContainerHash.get(dn);
                            }
                            this.listener.setIsExcludeChildOU(isExcludeChildOU);
                            ADHandler.getObjects((String)CustomReportListener.this.domainName, (Long)this.loginId, (String)dn, (ArrayList)attributeList, (String)searchString, (NativeListener)this.listener);
                            continue;
                        }
                        catch (LocalizedException exc) {
                            exc.printStackTrace();
                            this.listener.setErrorMessage(exc.getMessage(CustomReportListener.this.rb));
                            errStr = CustomReportListener.this.rb.getString("client.reports.RealLastLogonListener.error_while_getting_the_reports_from_the_domain") + " " + CustomReportListener.this.domainName + ". " + exc.getMessage(CustomReportListener.this.rb);
                            errors = new Hashtable();
                            errors.put("INPUT_NAME", CustomReportListener.this.domainName);
                            errors.put("ERROR_MESSAGE", errStr);
                            CustomReportListener.this.errorList.put(CustomReportListener.this.domainName, errors);
                            CustomReportListener.this.updateErrorStatus(errors);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            errStr = CustomReportListener.this.rb.getString("client.reports.RealLastLogonListener.error_while_getting_the_reports_from_the_domain") + " " + CustomReportListener.this.domainName + ". " + ex.getMessage();
                            errors = new Hashtable<String, String>();
                            errors.put("INPUT_NAME", CustomReportListener.this.domainName);
                            errors.put("ERROR_MESSAGE", errStr);
                            CustomReportListener.this.errorList.put(CustomReportListener.this.domainName, errors);
                            CustomReportListener.this.updateErrorStatus(errors);
                        }
                    }
                }
                if (CustomReportListener.this.isMultidc) {
                    CustomReportListener.this.processMultiDCActions();
                }
                if (!domainKey.isEmpty()) {
                    String syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                    while (CustomReportListener.this.continueAction && syncStatus.equalsIgnoreCase("false")) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                    }
                }
                CustomReportListener.this.completedAction();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

